/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.hub;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.astrogrid.samp.Message;
import org.astrogrid.samp.Metadata;
import org.astrogrid.samp.RegInfo;
import org.astrogrid.samp.Response;
import org.astrogrid.samp.SampUtils;
import org.astrogrid.samp.Subscriptions;
import org.astrogrid.samp.hub.BasicClientSet;
import org.astrogrid.samp.hub.ClientSet;
import org.astrogrid.samp.hub.HubClient;
import org.astrogrid.samp.hub.HubReceiver;
import org.astrogrid.samp.hub.HubService;
import org.astrogrid.samp.hub.HubServiceException;
import org.astrogrid.samp.hub.Receiver;

public class BasicHubService
implements HubService {
    private final KeyGenerator keyGen_;
    private final ClientIdGenerator idGen_;
    private final Map waiterMap_;
    private ClientSet clientSet_;
    private HubClient hubClient_;
    private boolean started_;
    private boolean shutdown_;
    private static final char ID_DELIMITER = '_';
    private final Logger logger_ = Logger.getLogger(BasicHubService.class.getName());
    public static int MAX_TIMEOUT;
    public static int MAX_WAITERS;
    static final /* synthetic */ boolean $assertionsDisabled;

    public BasicHubService(Random random) {
        this.keyGen_ = new KeyGenerator("k:", 16, random);
        this.idGen_ = new ClientIdGenerator("c");
        this.waiterMap_ = Collections.synchronizedMap(new HashMap());
    }

    public void start() {
        this.clientSet_ = this.createClientSet();
        this.hubClient_ = this.createClient(this.keyGen_.next(), "hub");
        Metadata meta = new Metadata();
        meta.setName("Hub");
        meta.setIconUrl("http://www.star.bristol.ac.uk/~mbt/plastic/images/hub.png");
        meta.put("author.name", "Mark Taylor");
        meta.put("author.mail", "m.b.taylor@bristol.ac.uk");
        meta.setDescriptionText(this.getClass().getName());
        this.hubClient_.setMetadata(meta);
        HubReceiver hubRec = new HubReceiver(this, this.hubClient_.getPrivateKey());
        this.hubClient_.setReceiver(hubRec);
        this.hubClient_.setSubscriptions(hubRec.getSubscriptions());
        this.clientSet_.add(this.hubClient_);
        Runtime.getRuntime().addShutdownHook(new Thread("HubService shutdown"){

            public void run() {
                BasicHubService.this.shutdown();
            }
        });
        this.started_ = true;
    }

    protected ClientSet createClientSet() {
        return new BasicClientSet(this.getIdComparator()){
            static final /* synthetic */ boolean $assertionsDisabled;

            public void add(HubClient client) {
                if (!$assertionsDisabled && client.getId().indexOf(95) >= 0) {
                    throw new AssertionError();
                }
                super.add(client);
            }

            static {
                $assertionsDisabled = !(class$org$astrogrid$samp$hub$BasicHubService == null ? (class$org$astrogrid$samp$hub$BasicHubService = BasicHubService.class$("org.astrogrid.samp.hub.BasicHubService")) : class$org$astrogrid$samp$hub$BasicHubService).desiredAssertionStatus();
            }
        };
    }

    protected HubClient createClient(String privateKey, String publicId) {
        return new HubClient(privateKey, publicId);
    }

    public Comparator getIdComparator() {
        return this.idGen_.getComparator();
    }

    public ClientSet getClientSet() {
        return this.clientSet_;
    }

    public Map register() throws HubServiceException {
        if (!this.started_) {
            throw new HubServiceException("Not started");
        }
        HubClient client = this.createClient(this.keyGen_.next(), this.idGen_.next());
        this.clientSet_.add(client);
        this.hubEvent(new Message("samp.hub.event.register").addParam("id", client.getId()));
        RegInfo regInfo = new RegInfo();
        regInfo.put("samp.hub-id", this.hubClient_.getId());
        regInfo.put("samp.self-id", client.getId());
        regInfo.put("samp.private-key", String.valueOf(client.getPrivateKey()));
        return regInfo;
    }

    public void unregister(Object callerKey) throws HubServiceException {
        HubClient caller = this.getCaller(callerKey);
        this.clientSet_.remove(caller);
        this.hubEvent(new Message("samp.hub.event.unregister").addParam("id", caller.getId()));
    }

    public void setReceiver(Object callerKey, Receiver receiver) throws HubServiceException {
        HubClient caller = this.getCaller(callerKey);
        caller.setReceiver(receiver);
    }

    public void declareMetadata(Object callerKey, Map meta) throws HubServiceException {
        HubClient caller = this.getCaller(callerKey);
        Metadata.asMetadata(meta).check();
        caller.setMetadata(meta);
        this.hubEvent(new Message("samp.hub.event.metadata").addParam("id", caller.getId()).addParam("metadata", meta));
    }

    public Map getMetadata(Object callerKey, String clientId) throws HubServiceException {
        this.checkCaller(callerKey);
        return this.getClient(clientId).getMetadata();
    }

    public void declareSubscriptions(Object callerKey, Map subscriptions) throws HubServiceException {
        HubClient caller = this.getCaller(callerKey);
        if (!caller.isCallable()) {
            throw new HubServiceException("Client is not callable");
        }
        Subscriptions.asSubscriptions(subscriptions).check();
        caller.setSubscriptions(subscriptions);
        this.hubEvent(new Message("samp.hub.event.subscriptions").addParam("id", caller.getId()).addParam("subscriptions", subscriptions));
    }

    public Map getSubscriptions(Object callerKey, String clientId) throws HubServiceException {
        this.checkCaller(callerKey);
        return this.getClient(clientId).getSubscriptions();
    }

    public List getRegisteredClients(Object callerKey) throws HubServiceException {
        HubClient caller = this.getCaller(callerKey);
        HubClient[] clients = this.clientSet_.getClients();
        ArrayList<String> idList = new ArrayList<String>(clients.length);
        for (int ic = 0; ic < clients.length; ++ic) {
            if (clients[ic].equals(caller)) continue;
            idList.add(clients[ic].getId());
        }
        return idList;
    }

    public Map getSubscribedClients(Object callerKey, String mtype) throws HubServiceException {
        HubClient caller = this.getCaller(callerKey);
        HubClient[] clients = this.clientSet_.getClients();
        TreeMap<String, Map> subMap = new TreeMap<String, Map>();
        for (int ic = 0; ic < clients.length; ++ic) {
            Map sub;
            HubClient client = clients[ic];
            if (client.equals(caller) || (sub = client.getSubscriptions().getSubscription(mtype)) == null) continue;
            subMap.put(client.getId(), sub);
        }
        return subMap;
    }

    public void notify(Object callerKey, String recipientId, Map message) throws HubServiceException {
        HubClient caller = this.getCaller(callerKey);
        Message msg = Message.asMessage(message);
        msg.check();
        String mtype = msg.getMType();
        HubClient recipient = this.getClient(recipientId);
        if (!recipient.getSubscriptions().isSubscribed(mtype)) {
            throw new HubServiceException("Client " + recipient + " not subscribed to " + mtype);
        }
        recipient.getReceiver().receiveNotification(caller.getId(), msg);
    }

    public String call(Object callerKey, String recipientId, String msgTag, Map message) throws HubServiceException {
        HubClient caller = this.getCaller(callerKey);
        Message msg = Message.asMessage(message);
        msg.check();
        String mtype = msg.getMType();
        HubClient recipient = this.getClient(recipientId);
        String msgId = MessageId.encode(caller, msgTag, false);
        if (!recipient.getSubscriptions().isSubscribed(mtype)) {
            throw new HubServiceException("Client " + recipient + " not subscribed to " + mtype);
        }
        recipient.getReceiver().receiveCall(caller.getId(), msgId, msg);
        return msgId;
    }

    public List notifyAll(Object callerKey, Map message) throws HubServiceException {
        HubClient caller = this.getCaller(callerKey);
        Message msg = Message.asMessage(message);
        msg.check();
        String mtype = msg.getMType();
        HubClient[] recipients = this.clientSet_.getClients();
        ArrayList<String> sentList = new ArrayList<String>();
        for (int ic = 0; ic < recipients.length; ++ic) {
            HubClient recipient = recipients[ic];
            if (recipient == caller || !recipient.isSubscribed(mtype)) continue;
            try {
                recipient.getReceiver().receiveNotification(caller.getId(), msg);
                sentList.add(recipient.getId());
                continue;
            }
            catch (HubServiceException e) {
                this.logger_.log(Level.WARNING, "Notification " + caller + " -> " + recipient + " failed: " + e, e);
            }
        }
        return sentList;
    }

    public Map callAll(Object callerKey, String msgTag, Map message) throws HubServiceException {
        HubClient caller = this.getCaller(callerKey);
        Message msg = Message.asMessage(message);
        msg.check();
        String mtype = msg.getMType();
        String msgId = MessageId.encode(caller, msgTag, false);
        HubClient[] recipients = this.clientSet_.getClients();
        HashMap<String, String> sentMap = new HashMap<String, String>();
        for (int ic = 0; ic < recipients.length; ++ic) {
            HubClient recipient = recipients[ic];
            if (recipient == caller || !recipient.isSubscribed(mtype)) continue;
            recipient.getReceiver().receiveCall(caller.getId(), msgId, msg);
            sentMap.put(recipient.getId(), msgId);
        }
        return sentMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reply(Object callerKey, String msgIdStr, Map response) throws HubServiceException {
        HubClient caller = this.getCaller(callerKey);
        Response resp = Response.asResponse(response);
        resp.check();
        MessageId msgId = MessageId.decode(msgIdStr);
        HubClient sender = this.getClient(msgId.getSenderId());
        String senderTag = msgId.getSenderTag();
        if (msgId.isSynch()) {
            Map map = this.waiterMap_;
            synchronized (map) {
                if (this.waiterMap_.containsKey(msgId)) {
                    if (this.waiterMap_.get(msgId) != null) {
                        throw new HubServiceException("Response ignored - you've already sent one");
                    }
                } else {
                    throw new HubServiceException("Response ignored - synchronous call timed out");
                }
                this.waiterMap_.put(msgId, resp);
                this.waiterMap_.notifyAll();
            }
        } else {
            sender.getReceiver().receiveResponse(caller.getId(), senderTag, resp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map callAndWait(Object callerKey, String recipientId, Map message, String timeoutStr) throws HubServiceException {
        int timeout;
        HubClient caller = this.getCaller(callerKey);
        Message msg = Message.asMessage(message);
        msg.check();
        String mtype = msg.getMType();
        HubClient recipient = this.getClient(recipientId);
        MessageId hubMsgId = new MessageId(caller.getId(), this.keyGen_.next(), true);
        try {
            timeout = SampUtils.decodeInt(timeoutStr);
        }
        catch (Exception e) {
            throw new HubServiceException("Bad timeout format (should be SAMP int)", e);
        }
        long start = System.currentTimeMillis();
        if (!recipient.getSubscriptions().isSubscribed(mtype)) {
            throw new HubServiceException("Client " + recipient + " not subscribed to " + mtype);
        }
        Map map = this.waiterMap_;
        synchronized (map) {
            if (MAX_WAITERS > 0 && this.waiterMap_.size() >= MAX_WAITERS) {
                int excess = this.waiterMap_.size() - MAX_WAITERS + 1;
                ArrayList keyList = new ArrayList(this.waiterMap_.keySet());
                Collections.sort(keyList, MessageId.AGE_COMPARATOR);
                this.logger_.warning("Pending synchronous calls exceeds limit " + MAX_WAITERS + " - giving up on " + excess + " oldest");
                for (int ie = 0; ie < excess; ++ie) {
                    Object removed = this.waiterMap_.remove(keyList.get(ie));
                    if (!$assertionsDisabled && removed == null) {
                        throw new AssertionError();
                    }
                }
                this.waiterMap_.notifyAll();
            }
            this.waiterMap_.put(hubMsgId, null);
        }
        recipient.getReceiver().receiveCall(caller.getId(), hubMsgId.toString(), msg);
        timeout = Math.min(Math.max(0, timeout), Math.max(0, MAX_TIMEOUT));
        long finish = timeout > 0 ? System.currentTimeMillis() + (long)(timeout * 1000) : Long.MAX_VALUE;
        Map map2 = this.waiterMap_;
        synchronized (map2) {
            while (this.waiterMap_.containsKey(hubMsgId) && this.waiterMap_.get(hubMsgId) == null && System.currentTimeMillis() < finish) {
                long millis = finish - System.currentTimeMillis();
                if (millis <= 0L) continue;
                try {
                    this.waiterMap_.wait(millis);
                }
                catch (InterruptedException e) {
                    throw new HubServiceException("Wait interrupted", e);
                }
            }
            if (!this.waiterMap_.containsKey(hubMsgId)) {
                throw new HubServiceException("Synchronous call aborted - server load exceeded maximum of " + MAX_WAITERS + "?");
            }
            Response response = (Response)this.waiterMap_.remove(hubMsgId);
            if (response != null) {
                return response;
            }
            if (!$assertionsDisabled && System.currentTimeMillis() < finish) {
                throw new AssertionError();
            }
            String millis = Long.toString(System.currentTimeMillis() - start);
            String emsg = "Synchronous call timeout after " + millis.substring(0, millis.length() - 3) + '.' + millis.substring(millis.length() - 3) + '/' + timeoutStr + " sec";
            throw new HubServiceException(emsg);
        }
    }

    public synchronized void shutdown() {
        if (!this.shutdown_) {
            this.shutdown_ = true;
            this.hubEvent(new Message("samp.hub.event.shutdown"));
        }
    }

    private void hubEvent(Message msg) {
        block2: {
            try {
                this.notifyAll(this.hubClient_.getPrivateKey(), msg);
            }
            catch (HubServiceException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    private void checkCaller(Object callerKey) throws HubServiceException {
        this.getCaller(callerKey);
    }

    public HubClient getCaller(Object callerKey) throws HubServiceException {
        HubClient caller = this.clientSet_.getFromPrivateKey((String)callerKey);
        if (caller != null) {
            return caller;
        }
        throw new HubServiceException("Invalid key " + callerKey + " for caller");
    }

    private HubClient getClient(String id) throws HubServiceException {
        HubClient client = this.clientSet_.getFromPublicId(id);
        if (client != null) {
            return client;
        }
        if (this.idGen_.hasUsed(id)) {
            throw new HubServiceException("Client " + id + " is no longer registered");
        }
        throw new HubServiceException("No registered client with ID \"" + id + "\"");
    }

    static {
        $assertionsDisabled = !BasicHubService.class.desiredAssertionStatus();
        MAX_TIMEOUT = 43200;
        MAX_WAITERS = 100;
    }

    private static class ClientIdGenerator {
        private int iseq_;
        private final String prefix_;
        private final Comparator comparator_;

        public ClientIdGenerator(String prefix) {
            this.prefix_ = prefix;
            this.comparator_ = new Comparator(this){
                private final /* synthetic */ ClientIdGenerator this$0;
                {
                    this.this$0 = this$0;
                }

                public int compare(Object o1, Object o2) {
                    String s1 = o1.toString();
                    String s2 = o2.toString();
                    Integer i1 = ClientIdGenerator.access$200(this.this$0, s1);
                    Integer i2 = ClientIdGenerator.access$200(this.this$0, s2);
                    if (i1 == null && i2 == null) {
                        return s1.compareTo(s2);
                    }
                    if (i1 == null) {
                        return 1;
                    }
                    if (i2 == null) {
                        return -1;
                    }
                    return i1 - i2;
                }
            };
        }

        public synchronized String next() {
            return this.prefix_ + Integer.toString(++this.iseq_);
        }

        public boolean hasUsed(String id) {
            Integer ix = this.getIndex(id);
            return ix != null && ix <= this.iseq_;
        }

        private Integer getIndex(String id) {
            if (id.startsWith(this.prefix_)) {
                try {
                    int iseq = Integer.parseInt(id.substring(this.prefix_.length()));
                    return new Integer(iseq);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            return null;
        }

        public Comparator getComparator() {
            return this.comparator_;
        }

        static /* synthetic */ Integer access$200(ClientIdGenerator x0, String x1) {
            return x0.getIndex(x1);
        }
    }

    private static class KeyGenerator {
        private final String prefix_;
        private final int nchar_;
        private final Random random_;
        private int iseq_;
        private final char unused_;
        static final /* synthetic */ boolean $assertionsDisabled;

        public KeyGenerator(String prefix, int nchar, Random random) {
            this.prefix_ = prefix;
            this.nchar_ = nchar;
            this.random_ = random;
            this.unused_ = (char)95;
        }

        public synchronized String next() {
            StringBuffer sbuf = new StringBuffer();
            sbuf.append(this.prefix_);
            sbuf.append(Integer.toString(++this.iseq_));
            sbuf.append('_');
            for (int i = 0; i < this.nchar_; ++i) {
                char c = (char)(97 + (char)this.random_.nextInt(25));
                if (!$assertionsDisabled && c == '_') {
                    throw new AssertionError();
                }
                sbuf.append(c);
            }
            return sbuf.toString();
        }

        public char getUnusedChar() {
            return this.unused_;
        }

        static {
            $assertionsDisabled = !(class$org$astrogrid$samp$hub$BasicHubService == null ? (class$org$astrogrid$samp$hub$BasicHubService = BasicHubService.class$("org.astrogrid.samp.hub.BasicHubService")) : class$org$astrogrid$samp$hub$BasicHubService).desiredAssertionStatus();
        }
    }

    private static class MessageId {
        private final String senderId_;
        private final String senderTag_;
        private final boolean isSynch_;
        private final long birthday_;
        private static final String T_SYNCH_FLAG = "S";
        private static final String F_SYNCH_FLAG = "A";
        private static final int CHECK_SEED;
        private static final int CHECK_LENG = 4;
        private static final Comparator AGE_COMPARATOR;
        static final /* synthetic */ boolean $assertionsDisabled;

        public MessageId(String senderId, String senderTag, boolean isSynch) {
            this.senderId_ = senderId;
            this.senderTag_ = senderTag;
            this.isSynch_ = isSynch;
            this.birthday_ = System.currentTimeMillis();
        }

        public String getSenderId() {
            return this.senderId_;
        }

        public String getSenderTag() {
            return this.senderTag_;
        }

        public boolean isSynch() {
            return this.isSynch_;
        }

        public int hashCode() {
            return MessageId.checksum(this.senderId_, this.senderTag_, this.isSynch_).hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof MessageId) {
                MessageId other = (MessageId)o;
                return this.senderId_.equals(other.senderId_) && this.senderTag_.equals(other.senderTag_) && this.isSynch_ == other.isSynch_;
            }
            return false;
        }

        public String toString() {
            String checksum = MessageId.checksum(this.senderId_, this.senderTag_, this.isSynch_);
            return this.senderId_ + '_' + (this.isSynch_ ? T_SYNCH_FLAG : F_SYNCH_FLAG) + '_' + checksum + '_' + this.senderTag_;
        }

        /*
         * WARNING - void declaration
         */
        public static MessageId decode(String msgId) throws HubServiceException {
            void var8_8;
            boolean isSynch;
            int delim1 = msgId.indexOf(95);
            int delim2 = msgId.indexOf(95, delim1 + 1);
            int delim3 = msgId.indexOf(95, delim2 + 1);
            if (delim1 < 0 || delim2 < 0 || delim3 < 0) {
                throw new HubServiceException("Badly formed message ID " + msgId);
            }
            String senderId = msgId.substring(0, delim1);
            String synchFlag = msgId.substring(delim1 + 1, delim2);
            String checksum = msgId.substring(delim2 + 1, delim3);
            String senderTag = msgId.substring(delim3 + 1);
            if (T_SYNCH_FLAG.equals(synchFlag)) {
                isSynch = true;
            } else if (F_SYNCH_FLAG.equals(synchFlag)) {
                isSynch = false;
            } else {
                throw new HubServiceException("Badly formed message ID " + msgId + " (synch flag)");
            }
            if (!MessageId.checksum(senderId, senderTag, (boolean)var8_8).equals(checksum)) {
                throw new HubServiceException("Bad message ID checksum");
            }
            MessageId idObj = new MessageId(senderId, senderTag, (boolean)var8_8);
            if (!$assertionsDisabled && !idObj.toString().equals(msgId)) {
                throw new AssertionError();
            }
            return idObj;
        }

        public static String encode(HubClient sender, String senderTag, boolean isSynch) {
            return new MessageId(sender.getId(), senderTag, isSynch).toString();
        }

        private static String checksum(String senderId, String senderTag, boolean isSynch) {
            int sum = CHECK_SEED;
            sum = 23 * sum + senderId.hashCode();
            sum = 23 * sum + senderTag.hashCode();
            sum = 23 * sum + (isSynch ? 3 : 5);
            String check = Integer.toHexString(sum);
            check = check.substring(Math.max(0, check.length() - 4));
            while (check.length() < 4) {
                check = "0" + check;
            }
            if (!$assertionsDisabled && check.length() != 4) {
                throw new AssertionError();
            }
            return check;
        }

        static /* synthetic */ long access$100(MessageId x0) {
            return x0.birthday_;
        }

        static {
            $assertionsDisabled = !(class$org$astrogrid$samp$hub$BasicHubService == null ? (class$org$astrogrid$samp$hub$BasicHubService = BasicHubService.class$("org.astrogrid.samp.hub.BasicHubService")) : class$org$astrogrid$samp$hub$BasicHubService).desiredAssertionStatus();
            CHECK_SEED = (int)System.currentTimeMillis();
            AGE_COMPARATOR = new Comparator(){

                public int compare(Object o1, Object o2) {
                    return (int)(MessageId.access$100((MessageId)o1) - MessageId.access$100((MessageId)o2));
                }
            };
        }
    }
}

