/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.hub;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.astrogrid.samp.hub.ClientSet;
import org.astrogrid.samp.hub.HubClient;

public class BasicClientSet
implements ClientSet {
    private final Map publicIdMap_;
    private final Map privateKeyMap_;

    public BasicClientSet(Comparator clientIdComparator) {
        this.publicIdMap_ = Collections.synchronizedMap(new TreeMap(clientIdComparator));
        this.privateKeyMap_ = Collections.synchronizedMap(new HashMap());
    }

    public synchronized void add(HubClient client) {
        this.publicIdMap_.put(client.getId(), client);
        this.privateKeyMap_.put(client.getPrivateKey(), client);
    }

    public synchronized void remove(HubClient client) {
        this.publicIdMap_.remove(client.getId());
        this.privateKeyMap_.remove(client.getPrivateKey());
    }

    public synchronized HubClient getFromPublicId(String publicId) {
        return (HubClient)this.publicIdMap_.get(publicId);
    }

    public synchronized HubClient getFromPrivateKey(String privateKey) {
        return (HubClient)this.privateKeyMap_.get(privateKey);
    }

    public synchronized HubClient[] getClients() {
        return this.publicIdMap_.values().toArray(new HubClient[0]);
    }
}

