/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.astrogrid.samp.Client;
import org.astrogrid.samp.Message;
import org.astrogrid.samp.Metadata;
import org.astrogrid.samp.Response;
import org.astrogrid.samp.SampUtils;
import org.astrogrid.samp.gui.Transmission;

public class TransmissionPanel
extends JPanel {
    private final JTextField mtypeField_;
    private final JTextField idField_;
    private final JTextField senderField_;
    private final JTextField receiverField_;
    private final JTextField statusField_;
    private final JTextArea messageField_;
    private final JTextArea responseField_;
    private final ChangeListener changeListener_;
    private Transmission trans_;

    public TransmissionPanel() {
        super(new BorderLayout());
        Stack metaPanel = new Stack();
        metaPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.mtypeField_ = metaPanel.addField("MType");
        this.idField_ = metaPanel.addField("Message ID");
        this.senderField_ = metaPanel.addField("Sender");
        this.receiverField_ = metaPanel.addField("Receiver");
        this.statusField_ = metaPanel.addField("Status");
        this.messageField_ = new JTextArea();
        this.messageField_.setEditable(false);
        this.messageField_.setLineWrap(false);
        JPanel messagePanel = new JPanel(new BorderLayout());
        Box messageHeadBox = Box.createHorizontalBox();
        messageHeadBox.add(new JLabel("Message"));
        messageHeadBox.add(Box.createHorizontalGlue());
        messagePanel.add((Component)messageHeadBox, "North");
        messagePanel.add((Component)new JScrollPane(this.messageField_), "Center");
        this.responseField_ = new JTextArea();
        this.responseField_.setEditable(false);
        this.responseField_.setLineWrap(false);
        JPanel responsePanel = new JPanel(new BorderLayout());
        Box responseHeadBox = Box.createHorizontalBox();
        responseHeadBox.add(new JLabel("Response"));
        responseHeadBox.add(Box.createHorizontalGlue());
        responsePanel.add((Component)responseHeadBox, "North");
        responsePanel.add((Component)new JScrollPane(this.responseField_), "Center");
        JSplitPane splitter = new JSplitPane(0);
        splitter.setTopComponent(messagePanel);
        splitter.setBottomComponent(responsePanel);
        splitter.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        splitter.setResizeWeight(0.5);
        this.add((Component)metaPanel, "North");
        this.add((Component)splitter, "Center");
        this.changeListener_ = new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                TransmissionPanel.this.updateState();
            }
        };
    }

    public void setTransmission(Transmission trans) {
        if (this.trans_ != null) {
            this.trans_.removeChangeListener(this.changeListener_);
        }
        this.trans_ = trans;
        if (this.trans_ != null) {
            this.trans_.addChangeListener(this.changeListener_);
        }
        this.updateState();
    }

    public Transmission getTransmission() {
        return this.trans_;
    }

    private void updateState() {
        if (this.trans_ == null) {
            this.mtypeField_.setText(null);
            this.idField_.setText(null);
            this.senderField_.setText(null);
            this.receiverField_.setText(null);
            this.statusField_.setText(null);
            this.messageField_.setText(null);
            this.responseField_.setText(null);
        } else {
            String responseText;
            Message msg = this.trans_.getMessage();
            Response response = this.trans_.getResponse();
            Throwable error = this.trans_.getError();
            this.mtypeField_.setText(msg.getMType());
            this.mtypeField_.setCaretPosition(0);
            this.idField_.setText(TransmissionPanel.formatId(this.trans_));
            this.idField_.setCaretPosition(0);
            this.senderField_.setText(TransmissionPanel.formatClient(this.trans_.getSender()));
            this.senderField_.setCaretPosition(0);
            this.receiverField_.setText(TransmissionPanel.formatClient(this.trans_.getReceiver()));
            this.receiverField_.setCaretPosition(0);
            this.statusField_.setText(this.trans_.getStatus().getText());
            this.statusField_.setCaretPosition(0);
            this.messageField_.setText(SampUtils.formatObject(msg, 2));
            this.messageField_.setCaretPosition(0);
            if (response != null) {
                responseText = SampUtils.formatObject(response, 2);
            } else if (error != null) {
                StringWriter traceWriter = new StringWriter();
                error.printStackTrace(new PrintWriter(traceWriter));
                responseText = traceWriter.toString();
            } else {
                responseText = null;
            }
            this.responseField_.setText(responseText);
            this.responseField_.setCaretPosition(0);
        }
    }

    private static String formatId(Transmission trans) {
        String msgTag = trans.getMessageTag();
        String msgId = trans.getMessageId();
        StringBuffer idBuf = new StringBuffer();
        if (msgTag != null) {
            idBuf.append("Tag: ").append(msgTag);
        }
        if (msgId != null) {
            if (idBuf.length() > 0) {
                idBuf.append("; ");
            }
            idBuf.append("ID: ").append(msgId);
        }
        return idBuf.toString();
    }

    private static String formatClient(Client client) {
        String name;
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(client.getId());
        Metadata meta = client.getMetadata();
        if (meta != null && (name = meta.getName()) != null) {
            sbuf.append(' ').append('(').append(name).append(')');
        }
        return sbuf.toString();
    }

    private class Stack
    extends JPanel {
        private final GridBagLayout layer_ = new GridBagLayout();
        private int line_;

        Stack() {
            this.setLayout(this.layer_);
        }

        JTextField addField(String heading) {
            GridBagConstraints cons = new GridBagConstraints();
            cons.gridy = this.line_++;
            cons.weighty = 1.0;
            cons.insets = new Insets(2, 2, 2, 2);
            cons.gridx = 0;
            cons.fill = 2;
            cons.anchor = 17;
            cons.weightx = 0.0;
            JLabel label = new JLabel(heading + ":");
            JTextField field = new JTextField();
            field.setEditable(false);
            this.layer_.setConstraints(label, cons);
            this.add(label);
            ++cons.gridx;
            cons.weightx = 1.0;
            this.layer_.setConstraints(field, cons);
            this.add(field);
            return field;
        }
    }
}

