/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.Timer;
import org.astrogrid.samp.Client;
import org.astrogrid.samp.ErrInfo;
import org.astrogrid.samp.Message;
import org.astrogrid.samp.Response;
import org.astrogrid.samp.SampUtils;
import org.astrogrid.samp.client.ResultHandler;
import org.astrogrid.samp.gui.ClientPanel;

public class PopupResultHandler
extends JFrame
implements ResultHandler {
    private final Map clientMap_;
    private final int closeDelayMillis_;
    private final JCheckBox autoCloser_;

    public PopupResultHandler(Component parent, String title, final Message msg, Client[] recipients, int closeDelay) {
        super(title);
        this.closeDelayMillis_ = closeDelay * 1000;
        AbstractAction closeAction = new AbstractAction("Close"){

            public void actionPerformed(ActionEvent evt) {
                PopupResultHandler.this.dispose();
            }
        };
        this.autoCloser_ = this.closeDelayMillis_ >= 0 ? new JCheckBox("Auto Close", true) : null;
        this.clientMap_ = new HashMap();
        for (int i = 0; i < recipients.length; ++i) {
            Client client = recipients[i];
            this.clientMap_.put(client, new ClientHandler(client));
        }
        Container content = this.getContentPane();
        content.setLayout(new BorderLayout());
        JPanel main = new JPanel(new BorderLayout());
        content.add(main);
        Box buttonBox = Box.createHorizontalBox();
        buttonBox.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        if (this.closeDelayMillis_ >= 0) {
            buttonBox.add(Box.createHorizontalGlue());
            buttonBox.add(this.autoCloser_);
        }
        buttonBox.add(Box.createHorizontalGlue());
        buttonBox.add(new JButton(closeAction));
        buttonBox.add(Box.createHorizontalGlue());
        main.add((Component)buttonBox, "South");
        Box msgBox = Box.createVerticalBox();
        msgBox.setBorder(ClientPanel.createTitledBorder("Message"));
        Box mtypeLine = Box.createHorizontalBox();
        mtypeLine.add(new JLabel(msg.getMType()));
        mtypeLine.add(Box.createHorizontalStrut(10));
        mtypeLine.add(Box.createHorizontalGlue());
        DetailAction msgDetailAction = new DetailAction("Detail", "Show details of message sent", "Message Sent", "SAMP message sent:"){

            protected Map getSampMap() {
                return msg;
            }
        };
        mtypeLine.add(new JButton(msgDetailAction));
        msgBox.add(mtypeLine);
        main.add((Component)msgBox, "North");
        GridBagLayout layer = new GridBagLayout();
        GridBagConstraints cons = new GridBagConstraints();
        cons.weighty = 1.0;
        cons.gridx = 0;
        cons.gridy = 0;
        cons.insets = new Insets(0, 2, 0, 2);
        JPanel resultBox = new JPanel(layer);
        resultBox.setBorder(ClientPanel.createTitledBorder("Responses"));
        Iterator it = this.clientMap_.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            ClientHandler ch = (ClientHandler)entry.getValue();
            cons.anchor = 17;
            cons.weightx = 0.0;
            cons.fill = 0;
            JLabel nameLabel = ch.nameLabel_;
            layer.setConstraints(nameLabel, cons);
            resultBox.add(nameLabel);
            ++cons.gridx;
            cons.anchor = 10;
            cons.weightx = 1.0;
            cons.fill = 0;
            JLabel statusLabel = ch.statusLabel_;
            layer.setConstraints(statusLabel, cons);
            resultBox.add(statusLabel);
            ++cons.gridx;
            cons.anchor = 17;
            cons.weightx = 0.0;
            cons.fill = 0;
            JButton detailButton = new JButton(ch.responseDetailAction_);
            layer.setConstraints(detailButton, cons);
            resultBox.add(detailButton);
            ++cons.gridy;
            cons.gridx = 0;
        }
        main.add((Component)resultBox, "Center");
        this.pack();
        if (parent != null) {
            this.setLocationRelativeTo(parent);
        }
        this.setVisible(true);
    }

    public void result(Client client, Response response) {
        ClientHandler ch = (ClientHandler)this.clientMap_.get(client);
        if (ch == null) {
            throw new IllegalArgumentException("Shouldn't happen");
        }
        ch.result(response);
    }

    public void done() {
        Iterator it = this.clientMap_.entrySet().iterator();
        while (it.hasNext()) {
            ClientHandler ch = (ClientHandler)it.next().getValue();
            if (ch.response_ != null) continue;
            ch.result(null);
        }
        if (this.isVisible() && this.closeDelayMillis_ >= 0 && this.autoCloser_.isSelected()) {
            if (this.closeDelayMillis_ == 0) {
                this.dispose();
            } else {
                new Timer(this.closeDelayMillis_, new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        if (PopupResultHandler.this.autoCloser_.isSelected()) {
                            PopupResultHandler.this.dispose();
                        }
                    }
                }).start();
            }
        }
    }

    private abstract class DetailAction
    extends AbstractAction {
        private final String popupTitle_;
        private final String heading_;

        DetailAction(String name, String shortDesc, String popupTitle, String heading) {
            super(name);
            this.putValue("ShortDescription", shortDesc);
            this.popupTitle_ = popupTitle;
            this.heading_ = heading;
        }

        protected abstract Map getSampMap();

        public void actionPerformed(ActionEvent evt) {
            PopupResultHandler.this.autoCloser_.setSelected(false);
            JTextArea ta = new JTextArea();
            ta.setLineWrap(false);
            ta.setEditable(false);
            ta.append(SampUtils.formatObject(this.getSampMap(), 3));
            ta.setCaretPosition(0);
            Dimension size = ta.getPreferredSize();
            size.height = Math.min(size.height + 20, 200);
            size.width = Math.min(size.width + 20, 360);
            JScrollPane scroller = new JScrollPane(ta);
            scroller.setPreferredSize(size);
            JDialog dialog = new JDialog(PopupResultHandler.this, this.popupTitle_, false);
            dialog.setDefaultCloseOperation(2);
            JPanel main = new JPanel(new BorderLayout());
            main.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            dialog.getContentPane().add(main);
            AbstractAction closeAction = new AbstractAction(this, "Close", dialog){
                private final /* synthetic */ JDialog val$dialog;
                private final /* synthetic */ DetailAction this$1;
                {
                    this.this$1 = this$1;
                    this.val$dialog = val$dialog;
                    super(x0);
                }

                public void actionPerformed(ActionEvent evt) {
                    this.val$dialog.dispose();
                }
            };
            Box buttonBox = Box.createHorizontalBox();
            buttonBox.add(Box.createHorizontalGlue());
            buttonBox.add(new JButton(closeAction));
            buttonBox.add(Box.createHorizontalGlue());
            Box headBox = Box.createHorizontalBox();
            headBox.add(new JLabel(this.heading_));
            headBox.add(Box.createHorizontalGlue());
            headBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
            buttonBox.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
            main.add((Component)headBox, "North");
            main.add((Component)buttonBox, "South");
            main.add((Component)scroller, "Center");
            dialog.setLocationRelativeTo(PopupResultHandler.this);
            dialog.pack();
            dialog.show();
        }
    }

    private class ClientHandler {
        final JLabel nameLabel_;
        final JLabel statusLabel_;
        final Action responseDetailAction_;
        Response response_;

        ClientHandler(Client client) {
            String cName = client.toString();
            this.nameLabel_ = new JLabel(cName);
            this.statusLabel_ = new JLabel("... Waiting ...");
            this.statusLabel_.setForeground(new Color(64, 64, 64));
            this.responseDetailAction_ = new DetailAction(this, "Detail", "Show details of response", cName + " Response", "SAMP Response from client " + cName + ":", PopupResultHandler.this){
                private final /* synthetic */ PopupResultHandler val$this$0;
                private final /* synthetic */ ClientHandler this$1;
                {
                    this.this$1 = this$1;
                    this.val$this$0 = val$this$0;
                    super(x0, x1, x2, x3);
                }

                protected Map getSampMap() {
                    return this.this$1.response_;
                }
            };
            this.responseDetailAction_.setEnabled(this.response_ != null);
        }

        public void result(Response response) {
            String tip;
            String status;
            boolean success;
            this.response_ = response;
            if (this.response_ == null) {
                success = false;
                status = "Aborted";
                tip = "Interruption in messaging system prevented receipt of response?";
            } else if (response.isOK()) {
                success = true;
                status = "OK";
                tip = "Message processed successfully";
            } else {
                String errtxt;
                success = false;
                status = "Fail";
                ErrInfo errInfo = response.getErrInfo();
                tip = errtxt = errInfo == null ? null : errInfo.getErrortxt();
                if (errtxt != null) {
                    status = status + " (" + errtxt + ")";
                }
            }
            this.statusLabel_.setText(status);
            this.statusLabel_.setForeground(success ? new Color(0, 128, 0) : new Color(128, 0, 0));
            this.statusLabel_.setToolTipText(tip);
            this.responseDetailAction_.setEnabled(this.response_ != null);
        }

        static /* synthetic */ PopupResultHandler access$100(ClientHandler x0) {
            return x0.PopupResultHandler.this;
        }
    }
}

