/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.astrogrid.samp.Client;
import org.astrogrid.samp.Message;
import org.astrogrid.samp.Response;
import org.astrogrid.samp.gui.ClientTransmissionHolder;
import org.astrogrid.samp.gui.GuiClientSet;
import org.astrogrid.samp.gui.GuiHubService;
import org.astrogrid.samp.gui.HubView;
import org.astrogrid.samp.gui.MessageTrackerListCellRenderer;
import org.astrogrid.samp.gui.Transmission;
import org.astrogrid.samp.gui.TransmissionListModel;
import org.astrogrid.samp.gui.TransmissionTableModel;
import org.astrogrid.samp.gui.TransmissionView;
import org.astrogrid.samp.hub.ClientSet;
import org.astrogrid.samp.hub.HubClient;
import org.astrogrid.samp.hub.HubServiceException;
import org.astrogrid.samp.hub.Receiver;

public class MessageTrackerHubService
extends GuiHubService
implements ClientTransmissionHolder {
    private final Map callMap_;
    private final TransmissionTableModel transTableModel_;
    private final int listRemoveDelay_;
    private final int tableRemoveDelay_;
    private final int tableMaxRows_;
    private MessageTrackerClientSet clientSet_;
    static /* synthetic */ Class class$org$astrogrid$samp$gui$MessageTrackerHubService;

    public MessageTrackerHubService(Random random) {
        this(random, 0, 20000, 100);
    }

    public MessageTrackerHubService(Random random, int listRemoveDelay, int tableRemoveDelay, int tableMaxRows) {
        super(random);
        this.listRemoveDelay_ = listRemoveDelay;
        this.tableRemoveDelay_ = tableRemoveDelay;
        this.tableMaxRows_ = tableMaxRows;
        this.callMap_ = new HashMap();
        this.transTableModel_ = new TransmissionTableModel(true, true, this.tableRemoveDelay_, this.tableMaxRows_);
    }

    public void start() {
        super.start();
        this.clientSet_ = (MessageTrackerClientSet)this.getClientSet();
    }

    public ClientSet createClientSet() {
        return new MessageTrackerClientSet(this.getIdComparator());
    }

    public HubClient createClient(String privateKey, String publicId) {
        return new MessageTrackerHubClient(privateKey, publicId);
    }

    public JComponent createHubPanel() {
        JTabbedPane tabber = new JTabbedPane();
        HubView hubView = new HubView();
        hubView.setClientListModel(this.getClientListModel());
        hubView.getClientList().setCellRenderer(new MessageTrackerListCellRenderer(this));
        tabber.add("Clients", hubView);
        tabber.add("Messages", new TransmissionView(this.transTableModel_));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)tabber, "Center");
        return panel;
    }

    public ListModel getTxListModel(Client client) {
        return client instanceof MessageTrackerHubClient ? ((MessageTrackerHubClient)client).txListModel_ : null;
    }

    public ListModel getRxListModel(Client client) {
        return client instanceof MessageTrackerHubClient ? ((MessageTrackerHubClient)client).rxListModel_ : null;
    }

    public void reply(Object callerKey, String msgId, final Map response) throws HubServiceException {
        final Object callKey = MessageTrackerHubService.getCallKey(this.getCaller(callerKey), msgId);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Transmission trans = (Transmission)MessageTrackerHubService.this.callMap_.remove(callKey);
                if (trans != null) {
                    trans.setResponse(Response.asResponse(response));
                }
            }
        });
        super.reply(callerKey, msgId, response);
    }

    private void addTransmission(Transmission trans) {
        ((MessageTrackerHubClient)trans.getSender()).txListModel_.addTransmission(trans);
        ((MessageTrackerHubClient)trans.getReceiver()).rxListModel_.addTransmission(trans);
        this.transTableModel_.addTransmission(trans);
    }

    private static Object getCallKey(Client receiver, String msgId) {
        return msgId + "->" + receiver.getId();
    }

    static /* synthetic */ void access$500(MessageTrackerHubService x0, Transmission x1) {
        x0.addTransmission(x1);
    }

    private class MessageTrackerClientSet
    extends GuiClientSet {
        private final ListDataListener transListener_;

        MessageTrackerClientSet(Comparator clientIdComparator) {
            super(clientIdComparator);
            this.transListener_ = new ListDataListener(this){
                static final /* synthetic */ boolean $assertionsDisabled;
                private final /* synthetic */ MessageTrackerClientSet this$1;
                {
                    this.this$1 = this$1;
                }

                public void contentsChanged(ListDataEvent evt) {
                    this.transmissionChanged(evt);
                }

                public void intervalAdded(ListDataEvent evt) {
                    this.transmissionChanged(evt);
                }

                public void intervalRemoved(ListDataEvent evt) {
                    this.transmissionChanged(evt);
                }

                private void transmissionChanged(ListDataEvent evt) {
                    Object src = evt.getSource();
                    if (!$assertionsDisabled && !(src instanceof Transmission)) {
                        throw new AssertionError();
                    }
                    if (src instanceof Transmission) {
                        Transmission trans = (Transmission)src;
                        int nclient = this.this$1.getSize();
                        for (int ic = 0; ic < nclient; ++ic) {
                            Client client = (Client)this.this$1.getElementAt(ic);
                            if (!trans.getSender().equals(client) && !trans.getReceiver().equals(client)) continue;
                            ListDataEvent clientEvt = new ListDataEvent(trans, 0, ic, ic);
                            this.this$1.fireListDataEvent(clientEvt);
                        }
                    }
                }

                static {
                    $assertionsDisabled = !(class$org$astrogrid$samp$gui$MessageTrackerHubService == null ? (class$org$astrogrid$samp$gui$MessageTrackerHubService = MessageTrackerHubService.class$("org.astrogrid.samp.gui.MessageTrackerHubService")) : class$org$astrogrid$samp$gui$MessageTrackerHubService).desiredAssertionStatus();
                }
            };
        }

        public void add(HubClient client) {
            MessageTrackerHubClient mtClient = (MessageTrackerHubClient)client;
            TransmissionListModel txListModel = mtClient.txListModel_;
            TransmissionListModel rxListModel = mtClient.rxListModel_;
            SwingUtilities.invokeLater(new Runnable(this, txListModel, rxListModel){
                private final /* synthetic */ ListModel val$txListModel;
                private final /* synthetic */ ListModel val$rxListModel;
                private final /* synthetic */ MessageTrackerClientSet this$1;
                {
                    this.this$1 = this$1;
                    this.val$txListModel = val$txListModel;
                    this.val$rxListModel = val$rxListModel;
                }

                public void run() {
                    this.val$txListModel.addListDataListener(MessageTrackerClientSet.access$600(this.this$1));
                    this.val$rxListModel.addListDataListener(MessageTrackerClientSet.access$600(this.this$1));
                }
            });
            super.add(client);
        }

        public void remove(HubClient client) {
            super.remove(client);
            MessageTrackerHubClient mtClient = (MessageTrackerHubClient)client;
            TransmissionListModel txListModel = mtClient.txListModel_;
            TransmissionListModel rxListModel = mtClient.rxListModel_;
            SwingUtilities.invokeLater(new Runnable(this, txListModel, rxListModel){
                private final /* synthetic */ TransmissionListModel val$txListModel;
                private final /* synthetic */ TransmissionListModel val$rxListModel;
                private final /* synthetic */ MessageTrackerClientSet this$1;
                {
                    this.this$1 = this$1;
                    this.val$txListModel = val$txListModel;
                    this.val$rxListModel = val$rxListModel;
                }

                public void run() {
                    int i;
                    for (i = 0; i < this.val$txListModel.getSize(); ++i) {
                        ((Transmission)this.val$txListModel.getElementAt(i)).setSenderUnregistered();
                    }
                    for (i = 0; i < this.val$rxListModel.getSize(); ++i) {
                        ((Transmission)this.val$rxListModel.getElementAt(i)).setReceiverUnregistered();
                    }
                    this.val$txListModel.removeListDataListener(MessageTrackerClientSet.access$600(this.this$1));
                    this.val$rxListModel.removeListDataListener(MessageTrackerClientSet.access$600(this.this$1));
                }
            });
        }

        static /* synthetic */ ListDataListener access$600(MessageTrackerClientSet x0) {
            return x0.transListener_;
        }
    }

    private class MessageTrackerReceiver
    implements Receiver {
        private final Receiver base_;
        private final MessageTrackerHubClient client_;

        MessageTrackerReceiver(Receiver base, MessageTrackerHubClient client) {
            this.base_ = base;
            this.client_ = client;
        }

        public void receiveCall(String senderId, String msgId, Map message) throws HubServiceException {
            Message msg = Message.asMessage(message);
            MessageTrackerHubClient sender = (MessageTrackerHubClient)MessageTrackerHubService.this.clientSet_.getFromPublicId(senderId);
            MessageTrackerHubClient recipient = this.client_;
            Transmission trans = new Transmission(sender, recipient, msg, null, msgId);
            Object callKey = MessageTrackerHubService.getCallKey(recipient, msgId);
            SwingUtilities.invokeLater(new Runnable(this, callKey, trans){
                static final /* synthetic */ boolean $assertionsDisabled;
                private final /* synthetic */ Object val$callKey;
                private final /* synthetic */ Transmission val$trans;
                private final /* synthetic */ MessageTrackerReceiver this$1;
                {
                    this.this$1 = this$1;
                    this.val$callKey = val$callKey;
                    this.val$trans = val$trans;
                }

                public void run() {
                    if (!$assertionsDisabled && MessageTrackerHubService.access$000(MessageTrackerReceiver.access$400(this.this$1)).containsKey(this.val$callKey)) {
                        throw new AssertionError();
                    }
                    MessageTrackerHubService.access$000(MessageTrackerReceiver.access$400(this.this$1)).put(this.val$callKey, this.val$trans);
                    MessageTrackerHubService.access$500(MessageTrackerReceiver.access$400(this.this$1), this.val$trans);
                }

                static {
                    $assertionsDisabled = !(class$org$astrogrid$samp$gui$MessageTrackerHubService == null ? (class$org$astrogrid$samp$gui$MessageTrackerHubService = MessageTrackerHubService.class$("org.astrogrid.samp.gui.MessageTrackerHubService")) : class$org$astrogrid$samp$gui$MessageTrackerHubService).desiredAssertionStatus();
                }
            });
            try {
                this.base_.receiveCall(senderId, msgId, message);
            }
            catch (HubServiceException e) {
                SwingUtilities.invokeLater(new Runnable(this, trans, e){
                    private final /* synthetic */ Transmission val$trans;
                    private final /* synthetic */ HubServiceException val$e;
                    private final /* synthetic */ MessageTrackerReceiver this$1;
                    {
                        this.this$1 = this$1;
                        this.val$trans = val$trans;
                        this.val$e = val$e;
                    }

                    public void run() {
                        this.val$trans.setError(this.val$e);
                    }
                });
            }
        }

        public void receiveNotification(String senderId, Map message) throws HubServiceException {
            HubServiceException error;
            Message msg = Message.asMessage(message);
            MessageTrackerHubClient sender = (MessageTrackerHubClient)MessageTrackerHubService.this.clientSet_.getFromPublicId(senderId);
            MessageTrackerHubClient recipient = this.client_;
            Transmission trans = new Transmission(sender, recipient, msg, null, null);
            SwingUtilities.invokeLater(new Runnable(this, trans){
                private final /* synthetic */ Transmission val$trans;
                private final /* synthetic */ MessageTrackerReceiver this$1;
                {
                    this.this$1 = this$1;
                    this.val$trans = val$trans;
                }

                public void run() {
                    MessageTrackerHubService.access$500(MessageTrackerReceiver.access$400(this.this$1), this.val$trans);
                }
            });
            try {
                this.base_.receiveNotification(senderId, message);
                error = null;
            }
            catch (HubServiceException e) {
                error = e;
            }
            HubServiceException err2 = error;
            SwingUtilities.invokeLater(new Runnable(this, err2, trans){
                private final /* synthetic */ Throwable val$err2;
                private final /* synthetic */ Transmission val$trans;
                private final /* synthetic */ MessageTrackerReceiver this$1;
                {
                    this.this$1 = this$1;
                    this.val$err2 = val$err2;
                    this.val$trans = val$trans;
                }

                public void run() {
                    if (this.val$err2 == null) {
                        this.val$trans.setResponse(null);
                    } else {
                        this.val$trans.setError(this.val$err2);
                    }
                }
            });
        }

        public void receiveResponse(String responderId, String msgTag, Map response) throws HubServiceException {
            this.base_.receiveResponse(responderId, msgTag, response);
        }

        static /* synthetic */ MessageTrackerHubService access$400(MessageTrackerReceiver x0) {
            return x0.MessageTrackerHubService.this;
        }
    }

    private class MessageTrackerHubClient
    extends HubClient {
        final TransmissionListModel rxListModel_;
        final TransmissionListModel txListModel_;

        public MessageTrackerHubClient(String privateKey, String publicId) {
            super(privateKey, publicId);
            this.txListModel_ = new TransmissionListModel(MessageTrackerHubService.this.listRemoveDelay_);
            this.rxListModel_ = new TransmissionListModel(MessageTrackerHubService.this.listRemoveDelay_);
        }

        public void setReceiver(Receiver receiver) {
            super.setReceiver(receiver == null ? null : new MessageTrackerReceiver(receiver, this));
        }
    }
}

