/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.astrogrid.samp.Client;
import org.astrogrid.samp.Message;
import org.astrogrid.samp.Response;
import org.astrogrid.samp.client.HubConnection;
import org.astrogrid.samp.client.LogResultHandler;
import org.astrogrid.samp.client.ResponseHandler;
import org.astrogrid.samp.client.ResultHandler;
import org.astrogrid.samp.gui.ErrorDialog;
import org.astrogrid.samp.gui.GuiHubConnector;
import org.astrogrid.samp.gui.SendActionManager;

public abstract class AbstractCallActionManager
extends SendActionManager {
    private final Component parent_;
    private final GuiHubConnector connector_;
    private final CallResponseHandler responder_;
    private static final Logger logger_ = Logger.getLogger(AbstractCallActionManager.class.getName());

    public AbstractCallActionManager(Component parent, GuiHubConnector connector, ListModel clientListModel) {
        super(connector, clientListModel);
        this.parent_ = parent;
        this.connector_ = connector;
        this.responder_ = new CallResponseHandler();
        this.connector_.addResponseHandler(this.responder_);
        this.connector_.addConnectionListener(this.responder_);
        this.updateState();
    }

    protected abstract Action createBroadcastAction();

    protected ResultHandler createResultHandler(HubConnection connection, Message msg, Client[] recipients) {
        return new LogResultHandler(msg);
    }

    public void dispose() {
        this.connector_.removeResponseHandler(this.responder_);
        this.connector_.removeConnectionListener(this.responder_);
    }

    protected abstract Map createMessage(Client var1) throws Exception;

    protected Action getSendAction(Client client) {
        return new SendAction(client);
    }

    public String createTag() {
        return this.responder_.createTag();
    }

    public void registerHandler(String tag, Client[] recipients, ResultHandler handler) {
        this.responder_.registerHandler(tag, recipients, handler);
    }

    private static class TagInfo {
        final Map recipientMap_ = Collections.synchronizedMap(new HashMap());
        final ResultHandler handler_;

        public TagInfo(Client[] recipients, ResultHandler handler) {
            for (int i = 0; i < recipients.length; ++i) {
                Client recipient = recipients[i];
                this.recipientMap_.put(recipient.getId(), recipient);
            }
            this.handler_ = handler;
        }
    }

    private class CallResponseHandler
    implements ResponseHandler,
    ChangeListener {
        private int iCall_;
        private final Map tagMap_ = Collections.synchronizedMap(new HashMap());

        CallResponseHandler() {
        }

        public synchronized String createTag() {
            String tag = AbstractCallActionManager.this.connector_.createTag(this);
            this.tagMap_.put(tag, null);
            return tag;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void registerHandler(String tag, Client[] recipients, ResultHandler handler) {
            Map map = this.tagMap_;
            synchronized (map) {
                if (handler != null) {
                    this.tagMap_.put(tag, new TagInfo(recipients, handler));
                } else {
                    this.tagMap_.remove(tag);
                }
                this.tagMap_.notifyAll();
            }
        }

        public boolean ownsTag(String tag) {
            return this.tagMap_.containsKey(tag);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void receiveResponse(HubConnection connection, String responderId, String tag, Response response) {
            Map map = this.tagMap_;
            synchronized (map) {
                if (this.tagMap_.containsKey(tag)) {
                    TagInfo info = (TagInfo)this.tagMap_.get(tag);
                    if (info != null) {
                        this.processResponse(tag, info, responderId, response);
                    } else {
                        new Thread(this, "TagWaiter-" + tag, tag, responderId, response){
                            private final /* synthetic */ String val$tag;
                            private final /* synthetic */ String val$responderId;
                            private final /* synthetic */ Response val$response;
                            private final /* synthetic */ CallResponseHandler this$1;
                            {
                                this.this$1 = this$1;
                                this.val$tag = val$tag;
                                this.val$responderId = val$responderId;
                                this.val$response = val$response;
                                super(x0);
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                try {
                                    TagInfo tinfo;
                                    Map map = CallResponseHandler.access$300(this.this$1);
                                    synchronized (map) {
                                        do {
                                            if ((tinfo = (TagInfo)CallResponseHandler.access$300(this.this$1).get(this.val$tag)) != null) continue;
                                            CallResponseHandler.access$300(this.this$1).wait();
                                        } while (tinfo == null);
                                    }
                                    CallResponseHandler.access$400(this.this$1, this.val$tag, tinfo, this.val$responderId, this.val$response);
                                }
                                catch (InterruptedException e) {
                                    AbstractCallActionManager.access$500().warning("Interrupted??");
                                }
                            }
                        }.start();
                    }
                } else {
                    logger_.warning("Receive response for unknown tag " + tag + "??");
                    return;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processResponse(String tag, TagInfo info, String responderId, Response response) {
            ResultHandler handler = info.handler_;
            Map recipientMap = info.recipientMap_;
            Object object = info;
            synchronized (object) {
                Client responder = (Client)recipientMap.remove(responderId);
                if (responder != null) {
                    handler.result(responder, response);
                }
                if (recipientMap.isEmpty()) {
                    handler.done();
                }
            }
            object = this.tagMap_;
            synchronized (object) {
                if (recipientMap.isEmpty()) {
                    this.tagMap_.remove(tag);
                }
            }
        }

        public void stateChanged(ChangeEvent evt) {
            if (!AbstractCallActionManager.this.connector_.isConnected()) {
                this.hubDisconnected();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void hubDisconnected() {
            Map map = this.tagMap_;
            synchronized (map) {
                Iterator it = this.tagMap_.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    String tag = (String)entry.getKey();
                    TagInfo info = (TagInfo)entry.getValue();
                    if (info != null) {
                        info.handler_.done();
                    }
                    it.remove();
                }
            }
        }

        static /* synthetic */ Map access$300(CallResponseHandler x0) {
            return x0.tagMap_;
        }

        static /* synthetic */ void access$400(CallResponseHandler x0, String x1, TagInfo x2, String x3, Response x4) {
            x0.processResponse(x1, x2, x3, x4);
        }
    }

    private class SendAction
    extends AbstractAction {
        private final Client client_;
        private final String cName_;
        static final /* synthetic */ boolean $assertionsDisabled;

        SendAction(Client client) {
            this.client_ = client;
            this.cName_ = client.toString();
            this.putValue("Name", this.cName_);
            this.putValue("ShortDescription", "Transmit to " + this.cName_ + " using SAMP protocol");
        }

        public void actionPerformed(ActionEvent evt) {
            boolean sent = false;
            Message msg = null;
            HubConnection connection = null;
            String tag = null;
            try {
                msg = Message.asMessage(AbstractCallActionManager.this.createMessage(this.client_));
                msg.check();
                connection = AbstractCallActionManager.this.connector_.getConnection();
                if (connection != null) {
                    tag = AbstractCallActionManager.this.responder_.createTag();
                    connection.call(this.client_.getId(), tag, msg);
                    sent = true;
                }
            }
            catch (Exception e) {
                ErrorDialog.showError(AbstractCallActionManager.this.parent_, "Send Error", "Send failure " + e.getMessage(), e);
            }
            if (sent) {
                if (!$assertionsDisabled && connection == null) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && msg == null) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && tag == null) {
                    throw new AssertionError();
                }
                Client[] recipients = new Client[]{this.client_};
                ResultHandler handler = AbstractCallActionManager.this.createResultHandler(connection, msg, recipients);
                AbstractCallActionManager.this.responder_.registerHandler(tag, recipients, handler);
            }
        }

        public boolean equals(Object o) {
            if (o instanceof SendAction) {
                SendAction other = (SendAction)o;
                return this.client_.equals(other.client_) && this.cName_.equals(other.cName_);
            }
            return false;
        }

        public int hashCode() {
            return this.client_.hashCode() * 23 + this.cName_.hashCode();
        }

        static {
            $assertionsDisabled = !(class$org$astrogrid$samp$gui$AbstractCallActionManager == null ? (class$org$astrogrid$samp$gui$AbstractCallActionManager = AbstractCallActionManager.class$("org.astrogrid.samp.gui.AbstractCallActionManager")) : class$org$astrogrid$samp$gui$AbstractCallActionManager).desiredAssertionStatus();
        }
    }
}

