/*
 * Decompiled with CFR 0.152.
 */
package alma.common.sensitivitycalculatorcore.calc;

import alma.common.sensitivitycalculatorcore.calc.ExposureTimeCalculator;
import alma.common.sensitivitycalculatorcore.enumerations.BasicArray;
import alma.common.sensitivitycalculatorcore.enumerations.Polarization;
import alma.common.sensitivitycalculatorcore.exceptions.BeamsizeNotSpecifiedException;
import alma.common.sensitivitycalculatorcore.exceptions.InvalidFrequencyException;
import alma.common.sensitivitycalculatorcore.exceptions.SourceNeverVisibleException;
import alma.common.sensitivitycalculatorcore.lookup.AtmosphereTable;
import alma.common.sensitivitycalculatorcore.lookup.BasicReceiverBand;
import alma.common.sensitivitycalculatorcore.lookup.ReceiverTemperature;
import alma.common.sensitivitycalculatorcore.lookup.WaterVaporColumns;
import java.util.Optional;

public class SensitivityCalculatorEngine {
    public static final double C = 2.99792458E8;
    public static final double GIGAHERTZ_TO_HERTZ = 1.0E9;
    public static final double BEAMSIZE_FACTOR = 1.13;
    private final ArrayParameters array12m;
    private final ArrayParameters array7m;
    private final ArrayParameters arrayTp;
    private double observingFrequencyInGHZ = 345.0;
    private double bandwidth = 0.0;
    private double raDec = 0.0;
    private Polarization polarization = Polarization.DUAL;
    private String waterVapourChoiceType = "Automatic Choice";
    private String waterVapourColumnDensity = null;
    private final double observatoryLatitude = -23.02271113;
    protected Double tsys;
    private BasicReceiverBand receiverBand = null;

    public BasicReceiverBand getReceiverBand() {
        return this.receiverBand;
    }

    public void setReceiverBand(BasicReceiverBand receiverBand) {
        this.receiverBand = receiverBand;
    }

    public SensitivityCalculatorEngine() {
        this.array12m = new ArrayParameters12m();
        this.array7m = new ArrayParameters7m();
        this.arrayTp = new ArrayParametersTP();
    }

    public double getObservingFrequencyInGHZ() {
        return this.observingFrequencyInGHZ;
    }

    public void setObservingFrequencyInGHZ(double ghz) {
        this.observingFrequencyInGHZ = ghz;
    }

    public double getBandwidth() {
        return this.bandwidth;
    }

    public double getRaDec() {
        return this.raDec;
    }

    public void setRaDec(double raDec) {
        this.raDec = raDec;
    }

    public double getEffectiveBandwidth() {
        return this.bandwidth * (double)this.polarization.count;
    }

    public Polarization getPolarization() {
        return this.polarization;
    }

    public void setPolarization(Polarization polarization) {
        this.polarization = polarization;
    }

    public String getWaterVapourChoiceType() {
        return this.waterVapourChoiceType;
    }

    public void setWaterVapourChoiceType(String waterVapourChoiceType) {
        this.waterVapourChoiceType = waterVapourChoiceType;
    }

    public boolean isWaterVapourAutoChoice() {
        return "Automatic Choice".equals(this.waterVapourChoiceType);
    }

    public String gettrueWaterVapourColumnDensity() {
        return this.waterVapourColumnDensity;
    }

    public String getWaterVapourColumnDensity() {
        if (this.isWaterVapourAutoChoice()) {
            this.waterVapourColumnDensity = WaterVaporColumns.getWVIndexLabel(this.getWvIndex());
        }
        return this.waterVapourColumnDensity;
    }

    public void setWaterVapourColumnDensity(String waterVapourColumnDensity) {
        this.waterVapourColumnDensity = waterVapourColumnDensity;
    }

    private double getObservatoryLatitudeInDegrees() {
        return -23.02271113;
    }

    protected int getWvIndex() {
        if (this.isWaterVapourAutoChoice()) {
            int ret = WaterVaporColumns.wvindexSelector(this.observingFrequencyInGHZ, this.raDec, -23.02271113, Optional.ofNullable(this.receiverBand));
            this.setWaterVapourColumnDensity(WaterVaporColumns.getWVIndexLabel(ret));
            return ret;
        }
        return WaterVaporColumns.wvindexSelector(this.gettrueWaterVapourColumnDensity());
    }

    public Double getTsysInKelvin() {
        try {
            return ExposureTimeCalculator.getTsys(this.raDec, this.getObservatoryLatitudeInDegrees(), this.observingFrequencyInGHZ, this.getWvIndex(), Optional.ofNullable(this.receiverBand));
        }
        catch (SourceNeverVisibleException e) {
            return null;
        }
        catch (InvalidFrequencyException e) {
            return null;
        }
    }

    public Double getTskyEl() {
        AtmosphereTable.Data atmdata = this.getAtmData();
        if (atmdata == null) {
            return null;
        }
        double frequencyGHz = this.getObservingFrequencyInGHZ();
        double tsky_p = ExposureTimeCalculator.planck(frequencyGHz, atmdata.getTsky());
        double tsky_zK = ExposureTimeCalculator.tskyElevationCorrection(tsky_p, atmdata.getTau(), this.raDec, this.getObservatoryLatitudeInDegrees());
        return tsky_zK;
    }

    public Double getTrx() {
        try {
            if (this.receiverBand == null) {
                return ReceiverTemperature.getReceiverTemperature(this.observingFrequencyInGHZ);
            }
            return ReceiverTemperature.getReceiverTemperatureForReceiverBand(this.receiverBand);
        }
        catch (InvalidFrequencyException e) {
            return null;
        }
    }

    public AtmosphereTable.Data getAtmData() {
        AtmosphereTable atbl = AtmosphereTable.getInstance();
        Double frequencyGHz = this.observingFrequencyInGHZ;
        AtmosphereTable.Data data = atbl.lookup(frequencyGHz, this.getWvIndex());
        return data;
    }

    public void calc12MIntegrationTime() throws BeamsizeNotSpecifiedException, InvalidFrequencyException, SourceNeverVisibleException {
        this.array12m.calcIntegrationTime();
    }

    public void calc7MIntegrationTime() throws BeamsizeNotSpecifiedException, InvalidFrequencyException, SourceNeverVisibleException {
        this.array7m.calcIntegrationTime();
    }

    public void calcTPIntegrationTime() throws BeamsizeNotSpecifiedException, InvalidFrequencyException, SourceNeverVisibleException {
        this.arrayTp.calcIntegrationTime();
    }

    public double get12MIntegrationTimeInSecs() {
        return this.array12m.getIntegrationTime();
    }

    public double get7MIntegrationTimeInSecs() {
        return this.array7m.getIntegrationTime();
    }

    public double getTPIntegrationTimeInSecs() {
        return this.arrayTp.getIntegrationTime();
    }

    public void set12MIntegrationTimeInSec(double secs) {
        this.array12m.integrationTimeInSecs = secs;
    }

    public void set7MIntegrationTimeInSec(double secs) {
        this.array7m.integrationTimeInSecs = secs;
    }

    public void setTPIntegrationTimeInSec(double secs) {
        this.arrayTp.integrationTimeInSecs = secs;
    }

    public void set12MBeamsizeInArcsecs(double arcsecs) {
        this.array12m.beamsize = arcsecs;
    }

    public void set7MBeamsizeInArcsecs(double arcsecs) {
        this.array7m.beamsize = arcsecs;
    }

    public void setTPBeamsizeInArcsecs(double arcsecs) {
        this.arrayTp.beamsize = arcsecs;
    }

    public void set12MSensitivityUnit(UserSensitivityType unit) {
        this.array12m.setUserSensitivityUnit(unit);
    }

    public void set7MSensitivityUnit(UserSensitivityType unit) {
        this.array7m.setUserSensitivityUnit(unit);
    }

    public void setTPSensitivityUnit(UserSensitivityType unit) {
        this.arrayTp.setUserSensitivityUnit(unit);
    }

    public void setNum12MAntennas(int nAntennas) {
        this.array12m.setNAntennas(nAntennas);
    }

    public void setNum7MAntennas(int nAntennas) {
        this.array7m.setNAntennas(nAntennas);
    }

    public void setNumTPAntennas(int nAntennas) {
        this.arrayTp.setNAntennas(nAntennas);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("f=" + this.observingFrequencyInGHZ).append(", ");
        sb.append("w=" + this.bandwidth).append(", ");
        sb.append("coords=" + this.raDec).append(", ");
        sb.append("poln=" + this.polarization).append(", ");
        sb.append("wvchoice=" + this.waterVapourChoiceType).append(", ");
        sb.append("wv=" + this.waterVapourColumnDensity).append(", ");
        sb.append(this.array12m.toString()).append("\n");
        sb.append(this.array7m.toString()).append("\n");
        sb.append(this.arrayTp.toString());
        return sb.toString();
    }

    public void calcTPSensitivity() throws BeamsizeNotSpecifiedException, InvalidFrequencyException, SourceNeverVisibleException {
        this.arrayTp.calcSensitivity();
    }

    public void calc7MSensitivity() throws BeamsizeNotSpecifiedException, InvalidFrequencyException, SourceNeverVisibleException {
        this.array7m.calcSensitivity();
    }

    public void calc12MSensitivity() throws BeamsizeNotSpecifiedException, InvalidFrequencyException, SourceNeverVisibleException {
        this.array12m.calcSensitivity();
    }

    public int getNum12MAntennas() {
        return this.array12m.getNAntennas();
    }

    public int getNum7MAntennas() {
        return this.array7m.getNAntennas();
    }

    public int getNumTPAntennas() {
        return this.arrayTp.getNAntennas();
    }

    public double get7MBeamsizeInArcsecs() {
        return this.array7m.getBeamsize();
    }

    public double get12MBeamsizeInArcsecs() {
        return this.array12m.getBeamsize();
    }

    public double getTPBeamsizeInArcsecs() {
        return this.arrayTp.getBeamsize();
    }

    public double get12MSensitivityInUserUnit() {
        return this.array12m.getSensitivityInUser();
    }

    public double get7MSensitivityInUserUnit() {
        return this.array7m.getSensitivityInUser();
    }

    public double getTPSensitivityInUserUnit() {
        return this.arrayTp.getSensitivityInUser();
    }

    public double get12MSensitivityInJ() {
        return this.array12m.getSensitivity();
    }

    public double get7MSensitivityInJ() {
        return this.array7m.getSensitivity();
    }

    public double getTPSensitivityInJ() {
        return this.arrayTp.getSensitivity();
    }

    public void set12MSensitivityInJ(double j) {
        this.array12m.sensitivity = j;
    }

    public void set7MSensitivityInJ(double j) {
        this.array7m.sensitivity = j;
    }

    public void setTPSensitivityInJ(double j) {
        this.arrayTp.sensitivity = j;
    }

    public double arcAngle(double arcInM, double baseInM) {
        double angleInRad = arcInM / baseInM;
        return angleInRad;
    }

    public double getWavelengthFromFrequency(double freqInGHZ) {
        double freqInHertz = freqInGHZ * 1.0E9;
        return 2.99792458E8 / freqInHertz;
    }

    public void setBandwidth(double bandwidth) {
        this.bandwidth = bandwidth;
    }

    public Double getTsys() {
        return this.tsys;
    }

    public void setTsys(Double tsys) {
        this.tsys = tsys;
    }

    public void calcSensitivity() throws BeamsizeNotSpecifiedException, SourceNeverVisibleException, InvalidFrequencyException {
        this.calc12MSensitivity();
        this.calc7MSensitivity();
        this.calcTPSensitivity();
    }

    public void calcIntegration() throws BeamsizeNotSpecifiedException, SourceNeverVisibleException, InvalidFrequencyException {
        this.calc12MIntegrationTime();
        this.calc7MIntegrationTime();
        this.calcTPIntegrationTime();
    }

    public class ArrayParametersTP
    extends ArrayParameters {
        ArrayParametersTP() {
            super(BasicArray.ARRAY_TP);
        }

        @Override
        public double getBeamsize() {
            this.array.antenna.getLabel();
            return this.array.antenna.getBeamSize(SensitivityCalculatorEngine.this.observingFrequencyInGHZ);
        }
    }

    public class ArrayParameters7m
    extends ArrayParameters {
        ArrayParameters7m() {
            super(BasicArray.ARRAY_7M);
        }

        @Override
        public double getBeamsize() {
            return this.beamsize;
        }
    }

    public class ArrayParameters12m
    extends ArrayParameters {
        ArrayParameters12m() {
            super(BasicArray.ARRAY_12M);
        }

        @Override
        public double getBeamsize() {
            return this.beamsize;
        }
    }

    public abstract class ArrayParameters {
        protected final BasicArray array;
        protected int numberAntennas;
        protected double corrEfficiency = 0.8448;
        protected double beamsize = 0.0;
        protected double integrationTimeInSecs;
        protected double sensitivity;
        protected UserSensitivityType sensitivityType = UserSensitivityType.JY;

        public UserSensitivityType getUserSensitivityUnit() {
            return this.sensitivityType;
        }

        public void setUserSensitivityUnit(UserSensitivityType userSensitivityUnit) {
            this.sensitivityType = userSensitivityUnit;
        }

        ArrayParameters(BasicArray array) {
            this.array = array;
            this.numberAntennas = array.getNumberAntennas();
        }

        public Double calcSensitivity() throws InvalidFrequencyException, SourceNeverVisibleException, BeamsizeNotSpecifiedException {
            if (this.beamsize <= 0.0 && (this.sensitivityType == UserSensitivityType.K || this.sensitivityType == UserSensitivityType.MK)) {
                String message = "Beamsize must be greater than 0.0 to specify sensitivity in one of the Temperature units, was " + this.beamsize;
                throw new BeamsizeNotSpecifiedException(message);
            }
            Double fluxDensityInJ = SensitivityCalculatorEngine.this.tsys != null ? Double.valueOf(ExposureTimeCalculator.pointSourceSensitivity(this.integrationTimeInSecs, SensitivityCalculatorEngine.this.observingFrequencyInGHZ, SensitivityCalculatorEngine.this.getEffectiveBandwidth(), this.corrEfficiency, SensitivityCalculatorEngine.this.raDec, this.numberAntennas, this.array.antenna.getDiameter(), SensitivityCalculatorEngine.this.getObservatoryLatitudeInDegrees(), SensitivityCalculatorEngine.this.getWvIndex(), this.array.isInterferometry(), SensitivityCalculatorEngine.this.tsys)) : Double.valueOf(ExposureTimeCalculator.pointSourceSensitivity(this.integrationTimeInSecs, SensitivityCalculatorEngine.this.observingFrequencyInGHZ, SensitivityCalculatorEngine.this.getEffectiveBandwidth(), this.corrEfficiency, SensitivityCalculatorEngine.this.raDec, this.numberAntennas, this.array.antenna.getDiameter(), SensitivityCalculatorEngine.this.getObservatoryLatitudeInDegrees(), SensitivityCalculatorEngine.this.getWvIndex(), this.array.isInterferometry(), Optional.ofNullable(SensitivityCalculatorEngine.this.receiverBand)));
            this.sensitivity = fluxDensityInJ;
            return fluxDensityInJ;
        }

        public Double calcIntegrationTime() throws InvalidFrequencyException, SourceNeverVisibleException, BeamsizeNotSpecifiedException {
            if ((this.sensitivityType.equals((Object)UserSensitivityType.MK) || this.sensitivityType.equals((Object)UserSensitivityType.K)) && this.sensitivity <= 0.0) {
                this.integrationTimeInSecs = 0.0;
                String message = "Beamsize must be greater than 0.0 to specify sensitivity in one of the Temperature units, was " + this.sensitivity;
                throw new BeamsizeNotSpecifiedException(message);
            }
            this.integrationTimeInSecs = ExposureTimeCalculator.pointSourceExposureTime(this.sensitivity, SensitivityCalculatorEngine.this.observingFrequencyInGHZ, SensitivityCalculatorEngine.this.getEffectiveBandwidth(), this.corrEfficiency, SensitivityCalculatorEngine.this.raDec, this.numberAntennas, this.array.antenna.getDiameter(), SensitivityCalculatorEngine.this.getObservatoryLatitudeInDegrees(), SensitivityCalculatorEngine.this.getWvIndex(), this.array.isInterferometry(), Optional.ofNullable(SensitivityCalculatorEngine.this.receiverBand));
            return this.integrationTimeInSecs;
        }

        public int getNAntennas() {
            return this.numberAntennas;
        }

        public void setNAntennas(int nAntennas) {
            this.numberAntennas = nAntennas;
        }

        public double getCorrEfficiency() {
            return this.corrEfficiency;
        }

        public void setCorrEfficiency(double value) {
            this.corrEfficiency = value;
        }

        public abstract double getBeamsize();

        public double getIntegrationTime() {
            return this.integrationTimeInSecs;
        }

        public double getSensitivity() {
            return this.sensitivity;
        }

        public double getSensitivityInUser() {
            switch (this.sensitivityType) {
                case UJY: {
                    return this.sensitivity / 100000.0;
                }
                case MJY: {
                    return this.sensitivity / 1000.0;
                }
                case JY: {
                    return this.sensitivity;
                }
            }
            return this.sensitivity;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("type=" + this.array).append(", ");
            sb.append("nAnt=" + this.numberAntennas).append(", ");
            sb.append("corrEff=" + this.corrEfficiency).append(", ");
            sb.append("beam=" + this.beamsize).append(", ");
            sb.append("time=" + this.integrationTimeInSecs).append(", ");
            sb.append("goal=" + this.sensitivity);
            return sb.toString();
        }
    }

    public static enum UserSensitivityType {
        JY,
        MJY,
        K,
        MK,
        UJY;

    }
}

