/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.container;

import alma.ACS.CBlong;
import alma.ACS.OffShoot;
import alma.ACS.OffShootHelper;
import alma.ACS.OffShootOperations;
import alma.ACSErrTypeCommon.wrappers.AcsJBadParameterEx;
import alma.ACSErrTypeCommon.wrappers.AcsJCouldntPerformActionEx;
import alma.ACSErrTypeCommon.wrappers.AcsJIllegalStateEventEx;
import alma.ACSErrTypeCommon.wrappers.AcsJUnexpectedExceptionEx;
import alma.JavaContainerError.wrappers.AcsJContainerEx;
import alma.JavaContainerError.wrappers.AcsJContainerServicesEx;
import alma.acs.alarmsystem.source.AlarmSource;
import alma.acs.callbacks.RequesterUtil;
import alma.acs.callbacks.ResponseReceiver;
import alma.acs.component.ComponentDescriptor;
import alma.acs.component.ComponentQueryDescriptor;
import alma.acs.component.ComponentStateManager;
import alma.acs.component.dynwrapper.ComponentInvocationHandler;
import alma.acs.component.dynwrapper.DynamicProxyFactory;
import alma.acs.container.AcsManagerProxy;
import alma.acs.container.AdvancedContainerServices;
import alma.acs.container.AdvancedContainerServicesImpl;
import alma.acs.container.ContainerSealant;
import alma.acs.container.ContainerServices;
import alma.acs.container.ContainerServicesBase;
import alma.acs.container.archive.Range;
import alma.acs.container.archive.UIDLibrary;
import alma.acs.container.corba.AcsCorba;
import alma.acs.exceptions.AcsJException;
import alma.acs.logging.AcsLogLevel;
import alma.acs.logging.AcsLogger;
import alma.acs.logging.ClientLogManager;
import alma.acs.nc.AcsEventPublisher;
import alma.acs.nc.AcsEventSubscriber;
import alma.alarmsystem.source.ACSAlarmSystemInterfaceFactory;
import alma.entities.commonentity.EntityT;
import alma.maciErrType.wrappers.AcsJComponentDeactivationFailedEx;
import alma.maciErrType.wrappers.AcsJComponentDeactivationUncleanEx;
import alma.maciErrType.wrappers.AcsJNoPermissionEx;
import alma.maciErrType.wrappers.AcsJmaciErrTypeEx;
import alma.xmlstore.Identifier;
import alma.xmlstore.IdentifierHelper;
import alma.xmlstore.IdentifierJ;
import alma.xmlstore.IdentifierOperations;
import com.cosylab.CDB.DAL;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;
import si.ijs.maci.ComponentInfo;
import si.ijs.maci.ComponentSpec;

public class ContainerServicesImpl
implements ContainerServices {
    private AdvancedContainerServicesImpl advancedContainerServices;
    private volatile UIDLibrary uidLibrary;
    private volatile IdentifierJ identifierArchive;
    public static final String PROPERTYNAME_FAKE_UID_FOR_TESTING = "acs.container.fakeUIDsForTesting";
    private final boolean fakeUIDsForTesting = Boolean.getBoolean("acs.container.fakeUIDsForTesting");
    protected final AcsManagerProxy m_acsManagerProxy;
    protected final AcsLogger m_logger;
    private volatile AcsLogger componentLogger;
    private final Map<String, Object> m_usedComponentsMap;
    private final Map<String, Object> m_usedNonStickyComponentsMap;
    private final Map<String, ComponentDescriptor> m_componentDescriptorMap;
    private final int m_componentHandle;
    private final String m_clientName;
    private final AcsCorba acsCorba;
    private final POA m_clientPOA;
    private java.lang.Object m_componentXmlTranslatorProxy;
    private Map<java.lang.Object, Servant> m_activatedOffshootsMap;
    private final ComponentStateManager m_componentStateManager;
    private final ThreadFactory m_threadFactory;
    private volatile String[] methodsExcludedFromInvocationLogging;
    private ContainerServices.ComponentListener compListener;
    private final List<CleanUpCallback> cleanUpCallbacks;
    private final Map<String, AcsEventSubscriber<?>> m_subscribers;
    private final Map<String, AcsEventPublisher<?>> m_publishers;
    private final String CLASSNAME_NC_SUBSCRIBER = "alma.acs.nc.NCSubscriber";
    private final String CLASSNAME_NC_PUBLISHER = "alma.acs.nc.NCPublisher";
    private final java.lang.Object lazyCreationSync = new java.lang.Object();
    private final DAL cdb;

    public ContainerServicesImpl(AcsManagerProxy acsManagerProxy, DAL cdb, POA componentPOA, AcsCorba acsCorba, AcsLogger logger, int componentHandle, String clientCurl, ComponentStateManager componentStateManager, ThreadFactory threadFactory) {
        this.m_acsManagerProxy = acsManagerProxy;
        this.cdb = cdb;
        this.m_clientPOA = componentPOA;
        this.acsCorba = acsCorba;
        this.m_logger = logger;
        this.m_componentHandle = componentHandle;
        this.m_clientName = clientCurl;
        this.m_componentStateManager = componentStateManager;
        this.m_usedComponentsMap = Collections.synchronizedMap(new HashMap());
        this.m_usedNonStickyComponentsMap = Collections.synchronizedMap(new HashMap());
        this.m_componentDescriptorMap = Collections.synchronizedMap(new HashMap());
        this.m_activatedOffshootsMap = Collections.synchronizedMap(new HashMap());
        this.m_subscribers = new HashMap();
        this.m_publishers = new HashMap();
        this.m_threadFactory = threadFactory;
        this.cleanUpCallbacks = new ArrayList<CleanUpCallback>();
        if (this.fakeUIDsForTesting) {
            this.m_logger.warning("Running in test mode where UIDs will be constructed randomly instead of being retrieved from the archive!");
        }
    }

    void setComponentXmlTranslatorProxy(java.lang.Object xmlTranslatorProxy) {
        this.m_componentXmlTranslatorProxy = xmlTranslatorProxy;
    }

    public String getName() {
        return this.m_clientName;
    }

    @Override
    public ComponentStateManager getComponentStateManager() {
        if (this.m_componentStateManager == null) {
            throw new NullPointerException("ComponentStateManager is null!");
        }
        return this.m_componentStateManager;
    }

    public AcsLogger getLogger() {
        if (this.componentLogger == null) {
            this.componentLogger = ClientLogManager.getAcsLogManager().getLoggerForComponent(this.m_clientName);
        }
        return this.componentLogger;
    }

    @Override
    public void registerComponentListener(ContainerServices.ComponentListener listener) {
        this.compListener = listener;
    }

    public void fireComponentsAvailable(List<ComponentDescriptor> compDescs) {
        if (this.compListener == null) {
            return;
        }
        List<ComponentDescriptor> interesting = null;
        if (this.compListener.includeForeignComponents()) {
            interesting = compDescs;
        } else {
            interesting = new Vector<ComponentDescriptor>();
            for (ComponentDescriptor cd : compDescs) {
                if (!this.m_usedComponentsMap.containsKey(cd.getName()) && !this.m_usedNonStickyComponentsMap.containsKey(cd.getName())) continue;
                interesting.add(cd);
            }
        }
        if (interesting.size() > 0) {
            try {
                this.compListener.componentsAvailable(interesting);
            }
            catch (Throwable thr) {
                this.m_logger.log(Level.INFO, "componentsAvailable implementation of client " + this.m_clientName + " failed", thr);
            }
        }
    }

    public void fireComponentsUnavailable(List<String> compNames) {
        if (this.compListener == null) {
            return;
        }
        List<String> interesting = null;
        if (this.compListener.includeForeignComponents()) {
            interesting = compNames;
        } else {
            interesting = new Vector<String>();
            for (String cn : compNames) {
                if (!this.m_usedComponentsMap.containsKey(cn) && !this.m_usedNonStickyComponentsMap.containsKey(cn)) continue;
                interesting.add(cn);
            }
        }
        if (interesting.size() > 0 && this.compListener != null) {
            try {
                this.compListener.componentsUnavailable(interesting);
            }
            catch (Throwable thr) {
                this.m_logger.log(Level.INFO, "componentsUnavailable implementation of client " + this.m_clientName + " failed", thr);
            }
        }
    }

    @Override
    public void assignUniqueEntityId(EntityT entity) throws AcsJContainerServicesEx {
        if (entity == null) {
            AcsJBadParameterEx cause = new AcsJBadParameterEx();
            cause.setParameter("entity");
            cause.setParameterValue("null");
            throw new AcsJContainerServicesEx((Throwable)cause);
        }
        if (this.fakeUIDsForTesting) {
            long localId = new Random(System.currentTimeMillis()).nextLong();
            String uid = Range.generateUID("testArchiveId", "testRangeId", localId);
            entity.setEntityId(uid);
            return;
        }
        try {
            if (this.identifierArchive == null) {
                Identifier identRaw = IdentifierHelper.narrow((Object)this.getDefaultComponent("IDL:alma/xmlstore/Identifier:1.0"));
                this.identifierArchive = this.getTransparentXmlWrapper(IdentifierJ.class, identRaw, IdentifierOperations.class);
            }
            if (this.uidLibrary == null) {
                this.uidLibrary = new UIDLibrary((Logger)this.m_logger);
            }
            this.uidLibrary.assignUniqueEntityId(entity, this.identifierArchive);
        }
        catch (Throwable thr) {
            AcsJContainerServicesEx ex = new AcsJContainerServicesEx(thr);
            java.lang.Object msg = "Failed to assign a UID to entity of type ";
            msg = entity.getEntityTypeName() != null ? (String)msg + entity.getEntityTypeName() : (String)msg + entity.getClass().getSimpleName();
            ex.setContextInfo((String)msg);
            throw ex;
        }
    }

    @Override
    public String[] findComponents(String curlWildcard, String typeWildcard) throws AcsJContainerServicesEx {
        if (curlWildcard == null) {
            curlWildcard = "*";
        }
        if (typeWildcard == null) {
            typeWildcard = "*";
        }
        String msgSpec = "curlWildcard='" + curlWildcard + "' and typeWildcard='" + typeWildcard + "'.";
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.finer("about to call Manager#get_component_info with " + msgSpec);
        }
        ComponentInfo[] components = null;
        try {
            components = this.m_acsManagerProxy.get_component_info(new int[0], curlWildcard, typeWildcard, false);
        }
        catch (AcsJNoPermissionEx ex) {
            this.m_logger.log(Level.FINE, "No permission to find components with " + msgSpec, (Throwable)ex);
            AcsJContainerServicesEx ex2 = new AcsJContainerServicesEx((Throwable)ex);
            ex2.setContextInfo(msgSpec);
            throw ex2;
        }
        catch (Throwable thr) {
            this.m_logger.log(Level.FINE, "Unexpected failure calling 'get_component_info' with " + msgSpec, thr);
            AcsJContainerServicesEx ex = new AcsJContainerServicesEx(thr);
            ex.setContextInfo(msgSpec);
            throw ex;
        }
        ArrayList<String> curls = new ArrayList<String>();
        if (components != null) {
            for (int i = 0; i < components.length; ++i) {
                curls.add(components[i].name);
            }
        }
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.finer("received " + curls.size() + " curls from get_component_info.");
        }
        return curls.toArray(new String[curls.size()]);
    }

    @Override
    public ComponentDescriptor getComponentDescriptor(String curl) throws AcsJContainerServicesEx {
        if (curl == null) {
            AcsJBadParameterEx cause = new AcsJBadParameterEx();
            cause.setParameter("curl");
            cause.setParameterValue("null");
            throw new AcsJContainerServicesEx((Throwable)cause);
        }
        ComponentDescriptor desc = this.m_componentDescriptorMap.get(curl);
        if (desc == null) {
            ComponentInfo[] compInfos;
            try {
                compInfos = this.m_acsManagerProxy.get_component_info(new int[0], curl, "*", false);
            }
            catch (Throwable thr) {
                this.m_logger.log(Level.FINE, "Unexpected failure calling 'get_component_info'.", thr);
                AcsJContainerServicesEx ex = new AcsJContainerServicesEx(thr);
                ex.setContextInfo("CURL=" + curl);
                throw ex;
            }
            if (compInfos.length == 1) {
                desc = new ComponentDescriptor(compInfos[0]);
                this.m_componentDescriptorMap.put(curl, desc);
            } else {
                String msg = "failed to retrieve a unique component descriptor for the component instance " + curl;
                this.m_logger.fine(msg);
                AcsJContainerServicesEx ex = new AcsJContainerServicesEx();
                ex.setContextInfo(msg);
                throw new AcsJContainerServicesEx();
            }
        }
        return desc;
    }

    @Override
    public Object getComponent(String curl) throws AcsJContainerServicesEx {
        if (curl == null) {
            AcsJBadParameterEx cause = new AcsJBadParameterEx();
            cause.setParameter("curl");
            cause.setParameterValue("null");
            throw new AcsJContainerServicesEx((Throwable)cause);
        }
        Object stub = this.m_usedComponentsMap.get(curl);
        if (stub != null) {
            this.m_logger.info("client '" + this.m_clientName + "' attempts to retrieve component '" + curl + "' more than once; will return existing reference.");
        } else {
            this.m_logger.fine("will retrieve remote component '" + curl + "' using ACS Manager#get_component with client handle " + this.getEffectiveClientHandle());
            try {
                stub = this.m_acsManagerProxy.get_component(this.getEffectiveClientHandle(), curl, true);
                this.m_logger.fine("component " + curl + " retrieved successfully.");
                this.m_usedComponentsMap.put(curl, stub);
            }
            catch (AcsJmaciErrTypeEx ex) {
                String msg = "Failed to retrieve component " + curl;
                this.m_logger.log(Level.FINE, msg, (Throwable)ex);
                throw new AcsJContainerServicesEx((Throwable)ex);
            }
            catch (Throwable thr) {
                String msg = "Failed to retrieve component " + curl + " for unexpected reasons.";
                this.m_logger.log(Level.FINE, msg, thr);
                AcsJContainerServicesEx ex = new AcsJContainerServicesEx(thr);
                ex.setContextInfo(msg);
                throw ex;
            }
        }
        return stub;
    }

    @Override
    public Object getComponentNonSticky(String curl) throws AcsJContainerServicesEx {
        if (curl == null) {
            AcsJBadParameterEx cause = new AcsJBadParameterEx();
            cause.setParameter("curl");
            cause.setParameterValue("null");
            throw new AcsJContainerServicesEx((Throwable)cause);
        }
        Object stub = null;
        try {
            stub = this.m_acsManagerProxy.get_component_non_sticky(this.getEffectiveClientHandle(), curl);
            this.m_logger.fine("Non-sticky reference to component '" + curl + "' retrieved successfully.");
            this.m_usedNonStickyComponentsMap.put(curl, stub);
        }
        catch (AcsJmaciErrTypeEx ex) {
            String msg = "Failed to retrieve non-sticky reference to component " + curl;
            this.m_logger.log(Level.FINE, msg, (Throwable)ex);
            throw new AcsJContainerServicesEx((Throwable)ex);
        }
        catch (Throwable thr) {
            String msg = "Failed to retrieve non-sticky reference to component '" + curl + "' for unexpected reasons.";
            this.m_logger.log(Level.FINE, msg, thr);
            AcsJContainerServicesEx ex = new AcsJContainerServicesEx(thr);
            ex.setContextInfo(msg);
            throw ex;
        }
        return stub;
    }

    @Override
    public Object getDefaultComponent(String componentIDLType) throws AcsJContainerServicesEx {
        if (componentIDLType == null) {
            AcsJBadParameterEx cause = new AcsJBadParameterEx();
            cause.setParameter("componentIDLType");
            cause.setParameterValue("null");
            throw new AcsJContainerServicesEx((Throwable)cause);
        }
        ComponentInfo cInfo = null;
        try {
            cInfo = this.m_acsManagerProxy.get_default_component(this.getEffectiveClientHandle(), componentIDLType);
        }
        catch (AcsJmaciErrTypeEx ex) {
            String msg = "failed to retrieve default component for type " + componentIDLType;
            this.m_logger.log(Level.FINE, msg, (Throwable)ex);
            throw new AcsJContainerServicesEx((Throwable)ex);
        }
        catch (Throwable thr) {
            String msg = "failed to retrieve default component for type " + componentIDLType + " for unexpected reasons!";
            this.m_logger.log(Level.FINE, msg, thr);
            AcsJContainerServicesEx ex = new AcsJContainerServicesEx(thr);
            ex.setContextInfo(msg);
            throw ex;
        }
        if (cInfo.reference == null) {
            String msg = "Default component for type '" + componentIDLType + "' could not be accessed. ";
            this.m_logger.info(msg);
            AcsJContainerServicesEx ex = new AcsJContainerServicesEx();
            ex.setContextInfo(msg);
            throw ex;
        }
        this.m_usedComponentsMap.put(cInfo.name, cInfo.reference);
        this.m_componentDescriptorMap.put(cInfo.name, new ComponentDescriptor(cInfo));
        return cInfo.reference;
    }

    @Override
    public Object getCollocatedComponent(String compUrl, String targetCompUrl) throws AcsJContainerServicesEx {
        if (compUrl == null) {
            AcsJBadParameterEx cause = new AcsJBadParameterEx();
            cause.setParameter("compUrl");
            cause.setParameterValue("null");
            throw new AcsJContainerServicesEx((Throwable)cause);
        }
        if (targetCompUrl == null) {
            AcsJBadParameterEx cause = new AcsJBadParameterEx();
            cause.setParameter("targetCompUrl");
            cause.setParameterValue("null");
            throw new AcsJContainerServicesEx((Throwable)cause);
        }
        ComponentQueryDescriptor cqd = new ComponentQueryDescriptor(compUrl, null);
        return this.getCollocatedComponent(cqd, false, targetCompUrl);
    }

    @Override
    public Object getCollocatedComponent(ComponentQueryDescriptor spec, boolean markAsDefaul, String targetCompUrl) throws AcsJContainerServicesEx {
        if (spec == null) {
            AcsJBadParameterEx cause = new AcsJBadParameterEx();
            cause.setParameter("ComponentQueryDescriptor");
            cause.setParameterValue("null");
            throw new AcsJContainerServicesEx((Throwable)cause);
        }
        if (targetCompUrl == null) {
            AcsJBadParameterEx cause = new AcsJBadParameterEx();
            cause.setParameter("targetCompUrl");
            cause.setParameterValue("null");
            throw new AcsJContainerServicesEx((Throwable)cause);
        }
        ComponentInfo cInfo = null;
        try {
            cInfo = this.m_acsManagerProxy.get_collocated_component(this.getEffectiveClientHandle(), spec.toComponentSpec(), false, targetCompUrl);
        }
        catch (AcsJmaciErrTypeEx ex) {
            String msg = "Failed to retrieve component '" + spec.getComponentName() + "' created such that it runs collocated with '" + targetCompUrl + "'.";
            this.m_logger.log(Level.FINE, msg, (Throwable)ex);
            throw new AcsJContainerServicesEx((Throwable)ex);
        }
        catch (Throwable thr) {
            String msg = "Unexpectedly failed to retrieve component '" + spec.getComponentName() + "' created such that it runs collocated with '" + targetCompUrl + "'.";
            this.m_logger.log(Level.FINE, msg, thr);
            AcsJContainerServicesEx ex = new AcsJContainerServicesEx(thr);
            ex.setContextInfo(msg);
            throw ex;
        }
        if (cInfo.reference == null) {
            String msg = "Failed to retrieve component '" + spec.getComponentName() + "' created such that it runs collocated with '" + targetCompUrl + "'.";
            this.m_logger.info(msg);
            AcsJContainerServicesEx ex = new AcsJContainerServicesEx();
            ex.setContextInfo(msg);
            throw ex;
        }
        this.m_usedComponentsMap.put(cInfo.name, cInfo.reference);
        this.m_componentDescriptorMap.put(cInfo.name, new ComponentDescriptor(cInfo));
        return cInfo.reference;
    }

    @Override
    public Object getDynamicComponent(ComponentQueryDescriptor compDesc, boolean markAsDefault) throws AcsJContainerServicesEx {
        return this.getDynamicComponent(compDesc.toComponentSpec(), markAsDefault);
    }

    @Override
    public Object getDynamicComponent(ComponentSpec compSpec, boolean markAsDefault) throws AcsJContainerServicesEx {
        String entryMsg = "getDynamicComponent called with compName=" + compSpec.component_name + " compType=" + compSpec.component_type + " compCode=" + compSpec.component_code + " compContainer=" + compSpec.container_name + " markAsDefault=" + markAsDefault;
        this.m_logger.fine(entryMsg);
        ComponentInfo cInfo = null;
        try {
            cInfo = this.m_acsManagerProxy.get_dynamic_component(this.getEffectiveClientHandle(), compSpec, markAsDefault);
            this.m_usedComponentsMap.put(cInfo.name, cInfo.reference);
            this.m_componentDescriptorMap.put(cInfo.name, new ComponentDescriptor(cInfo));
        }
        catch (AcsJmaciErrTypeEx ex) {
            this.m_logger.log(Level.FINE, "Failed to create dynamic component", (Throwable)ex);
            throw new AcsJContainerServicesEx((Throwable)ex);
        }
        catch (Throwable thr) {
            String msg = "Unexpectedly failed to create dynamic component for unexpected reasons!";
            this.m_logger.log(Level.FINE, msg, thr);
            AcsJContainerServicesEx ex = new AcsJContainerServicesEx(thr);
            ex.setContextInfo(msg);
            throw ex;
        }
        return cInfo.reference;
    }

    @Override
    public Object getReferenceWithCustomClientSideTimeout(Object originalCorbaRef, double timeoutSeconds) throws AcsJContainerServicesEx {
        return this.acsCorba.wrapForRoundtripTimeout(originalCorbaRef, timeoutSeconds);
    }

    public DAL getCDB() throws AcsJContainerServicesEx {
        return this.cdb;
    }

    @Override
    public void releaseComponent(String curl) {
        ContainerServices.ComponentReleaseCallbackWithLogging callback = new ContainerServices.ComponentReleaseCallbackWithLogging((Logger)this.m_logger, (Level)AcsLogLevel.DEBUG);
        this.releaseComponent(curl, callback);
        try {
            callback.awaitComponentRelease(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            this.m_logger.log((Level)AcsLogLevel.DEBUG, "Interrupted while waiting for release of component " + curl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseComponent(String curl, ContainerServices.ComponentReleaseCallback callback) {
        block13: {
            boolean forcibly = false;
            if (curl == null) {
                String msg = "Invalid curl 'null', nothing to release.";
                this.m_logger.log((Level)(callback == null ? AcsLogLevel.INFO : AcsLogLevel.DEBUG), msg);
                if (callback != null) {
                    callback.errorNoPermission(msg);
                    callback.callOver();
                }
                return;
            }
            Object stub = null;
            Map<String, Object> map = this.m_usedComponentsMap;
            synchronized (map) {
                if (!this.m_usedComponentsMap.containsKey(curl)) {
                    String msg = "ignoring request by client '" + this.m_clientName + (this.m_usedNonStickyComponentsMap.containsKey(curl) ? "' to release component '" + curl + "' because the reference is non-sticky and does not need to be released." : "' to release other component with unknown curl='" + curl + "'.");
                    this.m_logger.log((Level)(callback == null ? AcsLogLevel.INFO : AcsLogLevel.DEBUG), msg);
                    if (callback != null) {
                        callback.errorNoPermission(msg);
                        callback.callOver();
                    }
                    return;
                }
                stub = this.m_usedComponentsMap.get(curl);
                this.m_usedComponentsMap.remove(curl);
            }
            this.m_logger.fine("about to release component " + curl);
            try {
                CBlong myCBlong = null;
                if (callback != null) {
                    ComponentReleaseCallbackCorbaHandler callbackCorba = new ComponentReleaseCallbackCorbaHandler(callback, stub);
                    myCBlong = RequesterUtil.giveCBLong((ContainerServicesBase)this, (ResponseReceiver)callbackCorba);
                }
                this.m_acsManagerProxy.release_component(this.getEffectiveClientHandle(), curl, myCBlong);
                this.m_logger.info("client '" + this.m_clientName + "' has successfully delivered a component release request for curl=" + curl);
                if (callback == null) {
                    stub._release();
                }
            }
            catch (AcsJNoPermissionEx ex) {
                AcsLogLevel level = callback == null ? AcsLogLevel.WARNING : AcsLogLevel.DEBUG;
                this.m_logger.log((Level)level, "client '" + this.m_clientName + "' (handle " + this.getEffectiveClientHandle() + ") cannot release  with the manager the component with curl=" + curl, (Throwable)ex);
                if (callback != null) {
                    callback.errorNoPermission(ex.getReason());
                }
            }
            catch (Throwable thr) {
                AcsLogLevel level = callback == null ? AcsLogLevel.WARNING : AcsLogLevel.DEBUG;
                this.m_logger.log((Level)level, "client '" + this.m_clientName + "' (handle " + this.getEffectiveClientHandle() + ") failed to release  with the manager the component with curl=" + curl, thr);
                if (callback == null) break block13;
                callback.errorCommunicationFailure(thr);
            }
        }
    }

    public <T extends Servant> OffShoot activateOffShoot(T servant) throws AcsJContainerServicesEx {
        return this.activateOffShoot(servant, (Class<T>)null);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public <T extends OffShootOperations> OffShoot activateOffShoot(T offshootImpl, Class<T> idlOpInterface) throws AcsJContainerServicesEx {
        servant = null;
        isTie = false;
        haveToInject = false;
        this.checkOffShoot(offshootImpl);
        if (!(offshootImpl instanceof Servant)) {
            if (idlOpInterface == null) {
                throw new AcsJContainerServicesEx((Throwable)new NullPointerException("Received null idlOpInterface when asking to activate XML offshoot"));
            }
            if (!idlOpInterface.isAssignableFrom(offshootImpl.getClass())) {
                ex = new AcsJContainerServicesEx();
                ex.setContextInfo("Received OffShoot of type '" + offshootImpl.getClass().getName() + "' does not inherits from '" + idlOpInterface.getName() + "'");
                throw ex;
            }
            poaTieClassName = null;
            try {
                this.m_logger.fine("Creating POATie servant for offshoot '" + offshootImpl.getClass().getName() + "'");
                baseClassName = idlOpInterface.getName().substring(0, idlOpInterface.getName().length() - 1);
                poaTieClassName = baseClassName + "POATie";
                poaTieClazz = Class.forName(poaTieClassName);
                implGetter = poaTieClazz.getMethod("_delegate", null);
                operationsIF = implGetter.getReturnType();
                proxy = DynamicProxyFactory.getDynamicProxyFactory((Logger)this.m_logger).createServerProxy(operationsIF, offshootImpl, idlOpInterface);
                c = poaTieClazz.getConstructor(new Class[]{operationsIF});
                servant = (Servant)c.newInstance(new java.lang.Object[]{proxy});
                if (this.m_componentXmlTranslatorProxy == null) ** GOTO lbl36
                haveToInject = true;
            }
            catch (ClassNotFoundException e) {
                msg = "Failed to create servant for offshoot " + offshootImpl.getClass().getName() + ": class '" + poaTieClassName + "' cannot be found";
                this.m_logger.log((Level)AcsLogLevel.ERROR, msg, (Throwable)e);
                ex = new AcsJContainerServicesEx();
                ex.setContextInfo(msg);
                throw ex;
            }
            catch (Exception e) {
                throw new AcsJContainerServicesEx((Throwable)e);
            }
        } else {
            this.m_logger.fine("Don't need to create servant for offshoot '" + offshootImpl.getClass().getName() + "'");
            servant = (Servant)offshootImpl;
        }
lbl36:
        // 3 sources

        servantName = servant.getClass().getName();
        if (servantName.endsWith("POATie")) {
            try {
                implGetter = servant.getClass().getMethod("_delegate", null);
                isTie = true;
                operationsIF = implGetter.getReturnType();
                offshootTiedImpl = implGetter.invoke((java.lang.Object)servant, (java.lang.Object[])null);
                qualOffshootName = this.getName() + "/" + operationsIF.getName().substring(0, operationsIF.getName().length() - "Operations".length());
                interceptingOffshootImpl = ContainerSealant.createContainerSealant(operationsIF, offshootTiedImpl, qualOffshootName, true, (Logger)this.m_logger, Thread.currentThread().getContextClassLoader(), this.methodsExcludedFromInvocationLogging);
                implSetter = servant.getClass().getMethod("_delegate", new Class[]{operationsIF});
                implSetter.invoke((java.lang.Object)servant, new java.lang.Object[]{interceptingOffshootImpl});
                this.m_logger.fine("created sealant for offshoot " + qualOffshootName);
            }
            catch (NoSuchMethodException implGetter) {
            }
            catch (Exception e) {
                this.m_logger.log(Level.WARNING, "Failed to create interceptor for offshoot " + servantName, (Throwable)e);
            }
        }
        if (!isTie) {
            // empty if block
        }
        shoot = null;
        try {
            obj = this.acsCorba.activateOffShoot(servant, this.m_clientPOA);
            this.m_activatedOffshootsMap.put(offshootImpl, servant);
            shoot = OffShootHelper.narrow((Object)obj);
        }
        catch (Throwable thr) {
            msg = "failed to activate offshoot object of type '" + servant.getClass().getName() + "' for client '" + this.m_clientName + "'. ";
            if (thr instanceof AcsJContainerServicesEx && thr.getCause() != null) {
                msg = msg + "(" + thr.getMessage() + ")";
                thr = thr.getCause();
            }
            this.m_logger.log(Level.FINE, msg, thr);
            ex = new AcsJContainerServicesEx(thr);
            throw ex;
        }
        if (haveToInject) {
            this.m_logger.fine("Injecting offshoot '" + offshootImpl.getClass().getName() + "' to '" + this.m_clientName + "' component XML binder");
            handler = (ComponentInvocationHandler)Proxy.getInvocationHandler(this.m_componentXmlTranslatorProxy);
            handler.addOffshoot(offshootImpl, shoot);
        }
        this.m_logger.fine("successfully activated offshoot of type " + offshootImpl.getClass().getName());
        return shoot;
    }

    public void deactivateOffShoot(java.lang.Object offshootImpl) throws AcsJContainerServicesEx {
        this.checkOffShoot(offshootImpl);
        try {
            this.acsCorba.deactivateOffShoot(this.m_activatedOffshootsMap.get(offshootImpl), this.m_clientPOA);
            this.m_activatedOffshootsMap.remove(offshootImpl);
            this.m_logger.fine("successfully deactivated offshoot of type " + offshootImpl.getClass().getName());
        }
        catch (AcsJContainerEx e) {
            throw new AcsJContainerServicesEx((Throwable)e);
        }
    }

    private void checkOffShoot(java.lang.Object servant) throws AcsJContainerServicesEx {
        if (servant == null) {
            AcsJBadParameterEx cause = new AcsJBadParameterEx();
            cause.setParameter("servant");
            cause.setParameterValue("null");
            throw new AcsJContainerServicesEx((Throwable)cause);
        }
        if (!(servant instanceof OffShootOperations)) {
            String msg = "invalid offshoot servant provided. Must implement " + OffShootOperations.class.getName();
            this.m_logger.fine(msg);
            AcsJContainerServicesEx ex = new AcsJContainerServicesEx();
            ex.setContextInfo(msg);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized AdvancedContainerServices getAdvancedContainerServices() {
        java.lang.Object object = this.lazyCreationSync;
        synchronized (object) {
            if (this.advancedContainerServices == null) {
                this.advancedContainerServices = new AdvancedContainerServicesImpl(this, (Logger)this.m_logger);
                this.m_logger.info("component '" + this.getName() + "' requested AdvancedContainerServices");
            }
        }
        return this.advancedContainerServices;
    }

    @Override
    public <T, F> T getTransparentXmlWrapper(Class<T> transparentXmlIF, F flatXmlObject, Class<F> flatXmlIF) throws AcsJContainerServicesEx {
        if (this.m_logger.isLoggable(Level.FINEST)) {
            this.m_logger.finest("creating xml binding class aware wrapper around remote object implementing " + flatXmlIF.getName() + "...");
        }
        T wrapper = null;
        try {
            wrapper = DynamicProxyFactory.getDynamicProxyFactory((Logger)this.m_logger).createClientProxy(transparentXmlIF, flatXmlObject, flatXmlIF);
        }
        catch (Throwable thr) {
            String msg = "failed to create XML binding class wrapper for remote object implementing " + flatXmlIF.getName();
            this.m_logger.log(Level.FINE, msg, thr);
            AcsJContainerServicesEx ex2 = new AcsJContainerServicesEx(thr);
            ex2.setContextInfo(msg);
            throw ex2;
        }
        return wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseAllComponents() {
        ArrayList<String> curls = new ArrayList<String>();
        Map<String, Object> map = this.m_usedComponentsMap;
        synchronized (map) {
            curls.addAll(this.m_usedComponentsMap.keySet());
        }
        for (String curl : curls) {
            this.releaseComponent(curl);
        }
    }

    private int getEffectiveClientHandle() {
        return this.m_componentHandle > 0 ? this.m_componentHandle : this.m_acsManagerProxy.getManagerHandle();
    }

    public ThreadFactory getThreadFactory() {
        return this.m_threadFactory;
    }

    AcsCorba getAcsCorba() {
        return this.acsCorba;
    }

    void setMethodsExcludedFromInvocationLogging(String[] methodsExcludedFromInvocationLogging) {
        this.methodsExcludedFromInvocationLogging = methodsExcludedFromInvocationLogging;
    }

    public void cleanUp() {
        String[] tmp2;
        for (CleanUpCallback cleanUpCallback : this.cleanUpCallbacks) {
            try {
                cleanUpCallback.containerServicesCleanUp();
            }
            catch (Throwable thr) {
                this.m_logger.log(Level.WARNING, "Failed to clean up registered client object", thr);
            }
        }
        for (String channel : this.m_subscribers.keySet()) {
            AcsEventSubscriber<?> subscriber = this.m_subscribers.get(channel);
            try {
                subscriber.disconnect();
                tmp2 = channel.split("/");
                this.m_logger.log((Level)AcsLogLevel.NOTICE, "Automatically disconnected subscriber for NC '" + tmp2[tmp2.length - 1] + "'");
            }
            catch (AcsJIllegalStateEventEx tmp2) {
            }
            catch (AcsJCouldntPerformActionEx ex) {
                this.m_logger.log(Level.WARNING, "Failed to disconnect subscriber (which the user should have done before).", (Throwable)ex);
            }
        }
        for (String channel : this.m_publishers.keySet()) {
            AcsEventPublisher<?> publisher = this.m_publishers.get(channel);
            try {
                publisher.disconnect();
                tmp2 = channel.split("/");
                this.m_logger.log((Level)AcsLogLevel.NOTICE, "Automatically disconnected publisher for NC '" + tmp2[tmp2.length - 1] + "'");
            }
            catch (AcsJIllegalStateEventEx acsJIllegalStateEventEx) {}
        }
    }

    @Deprecated
    public void registerCleanUpCallback(CleanUpCallback cb) {
        this.cleanUpCallbacks.add(cb);
    }

    private NamingContext getNameService() throws AcsJContainerServicesEx {
        NamingContext nameService = null;
        try {
            Object nameServiceObj = this.m_acsManagerProxy.get_service("NameService", false);
            nameService = NamingContextHelper.narrow((Object)nameServiceObj);
        }
        catch (AcsJmaciErrTypeEx ex) {
            this.m_logger.log(Level.FINE, "Failed to get the reference to the NameService service", (Throwable)ex);
            throw new AcsJContainerServicesEx((Throwable)ex);
        }
        catch (Throwable thr) {
            String msg = "Unexpectedly failed to get the NameService reference!";
            this.m_logger.log(Level.FINE, msg, thr);
            AcsJContainerServicesEx ex = new AcsJContainerServicesEx(thr);
            ex.setContextInfo(msg);
            throw ex;
        }
        return nameService;
    }

    public <T> AcsEventSubscriber<T> createNotificationChannelSubscriber(String channelName, Class<T> eventType) throws AcsJContainerServicesEx {
        return this.createNotificationChannelSubscriber(channelName, null, eventType);
    }

    public <T> AcsEventSubscriber<T> createNotificationChannelSubscriber(String channelName, String channelNotifyServiceDomainName, Class<T> eventType) throws AcsJContainerServicesEx {
        AcsEventSubscriber subscriber = null;
        try {
            java.lang.Object[] args = new java.lang.Object[]{channelName, channelNotifyServiceDomainName, this, this.getNameService(), this.m_clientName, eventType};
            Class<?> clazz = Class.forName("alma.acs.nc.NCSubscriber");
            Constructor<?> constructor = clazz.getConstructor(String.class, String.class, ContainerServicesBase.class, NamingContext.class, String.class, Class.class);
            subscriber = (AcsEventSubscriber)constructor.newInstance(args);
        }
        catch (ClassNotFoundException e) {
            this.m_logger.log((Level)AcsLogLevel.ERROR, "Cannot create NC subscriber because the 'NCSubscriber' class is not present in the classpath", (Throwable)e);
            AcsJContainerServicesEx ex = new AcsJContainerServicesEx((Throwable)e);
            ex.setContextInfo("'alma.acs.nc.NCSubscriber' class not present in the classpath");
            throw ex;
        }
        catch (ClassCastException e) {
            this.m_logger.log((Level)AcsLogLevel.ERROR, "Cannot create NC subscriber because loaded class is not of type 'AcsEventSubscriber", (Throwable)e);
            AcsJContainerServicesEx ex = new AcsJContainerServicesEx((Throwable)e);
            ex.setContextInfo("'alma.acs.nc.NCSubscriber' class does not extend 'AcsEventSubscriber'");
            throw ex;
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                e = e.getCause();
            }
            this.m_logger.log((Level)AcsLogLevel.ERROR, "Unexpected error while creating new AcsEventSubscriber object", e);
            AcsJContainerServicesEx ex = new AcsJContainerServicesEx(e);
            throw ex;
        }
        this.m_subscribers.put((channelNotifyServiceDomainName == null ? "" : channelNotifyServiceDomainName) + "/" + channelName, subscriber);
        return subscriber;
    }

    public <T> AcsEventPublisher<T> createNotificationChannelPublisher(String channelName, Class<T> eventType) throws AcsJContainerServicesEx {
        return this.createNotificationChannelPublisher(channelName, null, eventType);
    }

    public <T> AcsEventPublisher<T> createNotificationChannelPublisher(String channelName, String channelNotifyServiceDomainName, Class<T> eventType) throws AcsJContainerServicesEx {
        AcsEventPublisher publisher = null;
        try {
            java.lang.Object[] args = new java.lang.Object[]{channelName, channelNotifyServiceDomainName, this, this.getNameService()};
            Class<?> clazz = Class.forName("alma.acs.nc.NCPublisher");
            Constructor<?> constructor = clazz.getConstructor(String.class, String.class, ContainerServicesBase.class, NamingContext.class);
            publisher = (AcsEventPublisher)constructor.newInstance(args);
        }
        catch (ClassNotFoundException e) {
            this.m_logger.log((Level)AcsLogLevel.ERROR, "Cannot create NC publisher because the 'NCPublisher' class is not present in the classpath", (Throwable)e);
            AcsJContainerServicesEx ex = new AcsJContainerServicesEx((Throwable)e);
            ex.setContextInfo("'alma.acs.nc.NCPublisher' class not present in the classpath");
            throw ex;
        }
        catch (ClassCastException e) {
            this.m_logger.log((Level)AcsLogLevel.ERROR, "Cannot create NC publisher because loaded class 'alma.acs.nc.NCPublisher' is not of type 'AcsEventPublisher", (Throwable)e);
            AcsJContainerServicesEx ex = new AcsJContainerServicesEx((Throwable)e);
            ex.setContextInfo("'alma.acs.nc.NCPublisher' class does not extend 'AcsEventPublisher'");
            throw ex;
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                e = e.getCause();
            }
            this.m_logger.log((Level)AcsLogLevel.ERROR, "Unexpected error while creating new AcsEventPublisher object", e);
            AcsJContainerServicesEx ex = new AcsJContainerServicesEx(e);
            throw ex;
        }
        this.m_publishers.put((channelNotifyServiceDomainName == null ? "" : channelNotifyServiceDomainName) + "/" + channelName, publisher);
        if (this.m_publishers.size() > 200) {
            this.m_logger.warning("Component or client '" + this.m_clientName + "' has already created " + this.m_publishers.size() + " event publishers. Developers should check if this is really necessary.");
        }
        return publisher;
    }

    @Override
    public AlarmSource getAlarmSource() {
        return ACSAlarmSystemInterfaceFactory.getAlarmSource((ContainerServicesBase)this);
    }

    @Deprecated
    public static interface CleanUpCallback {
        public void containerServicesCleanUp();
    }

    private class ComponentReleaseCallbackCorbaHandler
    extends ResponseReceiver<Integer> {
        private final ContainerServices.ComponentReleaseCallback delegate;
        private final Object stub;

        ComponentReleaseCallbackCorbaHandler(ContainerServices.ComponentReleaseCallback delegate, Object stub) {
            this.delegate = delegate;
            this.stub = stub;
        }

        public void incomingException(AcsJException ex) {
            try {
                if (ex instanceof AcsJComponentDeactivationUncleanEx) {
                    this.delegate.componentReleased((AcsJComponentDeactivationUncleanEx)ex);
                } else if (ex instanceof AcsJComponentDeactivationFailedEx) {
                    this.delegate.errorComponentReleaseFailed((AcsJComponentDeactivationFailedEx)ex);
                } else if (ex instanceof AcsJUnexpectedExceptionEx) {
                    this.delegate.errorCommunicationFailure((Throwable)ex);
                } else {
                    ContainerServicesImpl.this.m_logger.log(Level.WARNING, "Received unexpected exception from manager#release_component_async, please report to ACS developers.", (Throwable)ex);
                    this.delegate.errorCommunicationFailure((Throwable)ex);
                }
            }
            catch (RuntimeException handlerEx) {
                ContainerServicesImpl.this.m_logger.log(Level.FINE, "User-supplied handler threw an exception.", (Throwable)handlerEx);
            }
            finally {
                this.delegate.callOver();
                this.stub._release();
            }
        }

        public void incomingResponse(Integer numberRemainingClients) {
            try {
                this.delegate.componentReleased(null);
            }
            catch (RuntimeException handlerEx) {
                ContainerServicesImpl.this.m_logger.log(Level.FINE, "User-supplied handler threw an exception.", (Throwable)handlerEx);
            }
            finally {
                this.delegate.callOver();
                this.stub._release();
            }
        }
    }
}

