/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.container;

import alma.ACS.ComponentStates;
import alma.JavaContainerError.wrappers.AcsJContainerEx;
import alma.acs.classloading.AcsComponentClassLoader;
import alma.acs.component.ComponentLifecycle;
import alma.acs.component.ComponentLifecycleException;
import alma.acs.container.AcsManagerProxy;
import alma.acs.container.CleaningDaemonThreadFactory;
import alma.acs.container.ComponentServantManager;
import alma.acs.container.ComponentStateManagerImpl;
import alma.acs.container.ContainerServicesImpl;
import alma.acs.container.corba.AcsCorba;
import alma.acs.logging.AcsLogger;
import alma.maciErrType.wrappers.AcsJComponentDeactivationFailedEx;
import alma.maciErrType.wrappers.AcsJComponentDeactivationUncleanEx;
import com.cosylab.CDB.DAL;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.Object;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;
import si.ijs.maci.ComponentInfo;

public class ComponentAdapter {
    private String m_type;
    private String m_code;
    private Object m_reference;
    private String m_compInstanceName;
    private int[] m_clients;
    private String m_containerName;
    private int m_compHandle;
    private int m_access;
    private String[] m_interfaces;
    private AcsLogger m_containerLogger;
    private ComponentLifecycle m_component;
    private Servant m_servant;
    private POA m_componentPOA;
    private ComponentServantManager compServantManager;
    private final AcsCorba acsCorba;
    private final AcsManagerProxy m_managerProxy;
    private final ClassLoader m_componentClassLoader;
    private final ComponentStateManagerImpl m_componentStateManager;
    private final ContainerServicesImpl m_containerServices;
    private final CleaningDaemonThreadFactory m_threadFactory;

    ComponentAdapter(String compName, String type, String code, int compHandle, String containerName, ComponentLifecycle component, AcsManagerProxy managerProxy, DAL cdb, ClassLoader componentClassLoader, AcsLogger logger, AcsCorba acsCorba) throws AcsJContainerEx {
        this.m_compInstanceName = compName;
        this.m_type = type;
        this.m_code = code;
        this.m_compHandle = compHandle;
        this.m_containerName = containerName;
        this.m_component = component;
        this.m_componentClassLoader = componentClassLoader;
        this.m_containerLogger = logger;
        this.acsCorba = acsCorba;
        this.m_interfaces = new String[0];
        this.m_clients = new int[0];
        this.m_componentPOA = acsCorba.createPOAForComponent(this.m_compInstanceName);
        this.m_componentStateManager = new ComponentStateManagerImpl(this.m_compInstanceName, (Logger)this.m_containerLogger);
        this.m_threadFactory = new CleaningDaemonThreadFactory(compName, (Logger)this.m_containerLogger);
        this.m_threadFactory.setNewThreadContextClassLoader(this.m_componentClassLoader);
        this.m_managerProxy = managerProxy;
        this.m_containerServices = new ContainerServicesImpl(managerProxy, cdb, this.m_componentPOA, acsCorba, this.m_containerLogger, this.m_compHandle, this.m_compInstanceName, this.m_componentStateManager, this.m_threadFactory);
    }

    void setComponentXmlTranslatorProxy(java.lang.Object xmlTranslatorProxy) {
        this.m_containerServices.setComponentXmlTranslatorProxy(xmlTranslatorProxy);
    }

    ContainerServicesImpl getContainerServices() {
        return this.m_containerServices;
    }

    void activateComponent(Servant servant) throws AcsJContainerEx {
        if (this.m_containerLogger.isLoggable(Level.FINER)) {
            this.m_containerLogger.finer("entering ComponentAdapter#activateComponent for " + this.m_compInstanceName);
        }
        this.m_servant = servant;
        try {
            this.compServantManager = this.acsCorba.setServantManagerOnComponentPOA(this.m_componentPOA);
            this.m_reference = this.acsCorba.activateComponent(servant, this.m_compInstanceName, this.m_componentPOA);
        }
        catch (Throwable thr) {
            String msg = "failed to activate component " + this.m_compInstanceName + " of type " + this.m_component.getClass().getName();
            AcsJContainerEx ex = new AcsJContainerEx(thr);
            ex.setContextInfo(msg);
            throw ex;
        }
        this.m_interfaces = this._getInterfaces();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initializeComponent() throws ComponentLifecycleException {
        ClassLoader contCL = Thread.currentThread().getContextClassLoader();
        this.m_componentStateManager.setStateByContainer(ComponentStates.COMPSTATE_INITIALIZING);
        Throwable thr = null;
        Thread.currentThread().setContextClassLoader(this.m_componentClassLoader);
        try {
            this.m_component.initialize(this.m_containerServices);
        }
        catch (Throwable t) {
            thr = t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(contCL);
        }
        if (thr != null) {
            if (thr instanceof ComponentLifecycleException) {
                this.m_componentStateManager.setStateByContainer(ComponentStates.COMPSTATE_ERROR);
                throw (ComponentLifecycleException)thr;
            }
            this.m_componentStateManager.setStateByContainer(ComponentStates.COMPSTATE_ERROR);
            throw new ComponentLifecycleException(thr);
        }
        this.m_componentStateManager.setStateByContainer(ComponentStates.COMPSTATE_INITIALIZED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executeComponent() throws ComponentLifecycleException {
        ClassLoader contCL = Thread.currentThread().getContextClassLoader();
        Throwable thr = null;
        Thread.currentThread().setContextClassLoader(this.m_componentClassLoader);
        try {
            this.m_component.execute();
        }
        catch (Throwable t) {
            thr = t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(contCL);
        }
        if (thr != null) {
            if (thr instanceof ComponentLifecycleException) {
                this.m_componentStateManager.setStateByContainer(ComponentStates.COMPSTATE_ERROR);
                throw (ComponentLifecycleException)thr;
            }
            this.m_componentStateManager.setStateByContainer(ComponentStates.COMPSTATE_ERROR);
            throw new ComponentLifecycleException(thr);
        }
        this.m_componentStateManager.setStateByContainer(ComponentStates.COMPSTATE_OPERATIONAL);
    }

    private String[] _getInterfaces() {
        String[] interfaces = null;
        try {
            interfaces = this.m_servant._all_interfaces(this.m_componentPOA, this.m_compInstanceName.getBytes());
            if (this.m_containerLogger.isLoggable(Level.FINE)) {
                StringBuffer buff = new StringBuffer("");
                for (int i = 0; i < interfaces.length; ++i) {
                    buff.append(interfaces[i]);
                }
                this.m_containerLogger.fine("interfaces of component '" + this.m_compInstanceName + "': " + buff.toString());
            }
        }
        catch (Exception ex) {
            this.m_containerLogger.info("failed to retrieve interface information for component " + this.m_compInstanceName);
        }
        if (interfaces == null) {
            interfaces = new String[]{"IDL:omg.org/CORBA/Object:1.0"};
        }
        return interfaces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deactivateComponent() throws AcsJComponentDeactivationUncleanEx, AcsJComponentDeactivationFailedEx {
        if (this.m_containerLogger.isLoggable(Level.FINER)) {
            this.m_containerLogger.finer("About to deactivate component " + this.m_compInstanceName + " with handle " + this.getHandle());
        }
        AcsJComponentDeactivationUncleanEx deactivationUncleanEx = null;
        AcsJComponentDeactivationFailedEx deactivationFailedEx = null;
        try {
            int deactivateTimeoutMillis = 10000;
            boolean isInactive = this.acsCorba.deactivateComponentPOAManager(this.m_componentPOA, this.m_compInstanceName, deactivateTimeoutMillis);
            if (isInactive && this.m_containerLogger.isLoggable(Level.FINER)) {
                this.m_containerLogger.finer("Now rejecting any calls to component '" + this.m_compInstanceName + "'. Will call cleanUp() next.");
            } else if (!isInactive) {
                String msg = "Component '" + this.m_compInstanceName + "' failed to reject calls within " + deactivateTimeoutMillis + " ms, probably because of pending calls. Will call cleanUp() anyway.";
                this.m_containerLogger.warning(msg);
                deactivationUncleanEx = new AcsJComponentDeactivationUncleanEx();
                deactivationUncleanEx.setCURL(this.m_compInstanceName);
                deactivationUncleanEx.setReason(msg);
            }
            ClassLoader contCL = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.m_componentClassLoader);
            try {
                this.m_component.cleanUp();
            }
            catch (Throwable thr) {
                this.m_containerLogger.log(Level.FINE, "Failure in cleanUp() method of component " + this.m_compInstanceName, thr);
                deactivationUncleanEx = new AcsJComponentDeactivationUncleanEx(thr);
                deactivationUncleanEx.setCURL(this.m_compInstanceName);
            }
            finally {
                Thread.currentThread().setContextClassLoader(contCL);
                try {
                    this.m_componentStateManager.setStateByContainer(ComponentStates.COMPSTATE_DEFUNCT);
                }
                catch (ComponentLifecycleException ex) {
                    if (deactivationUncleanEx == null) {
                        deactivationUncleanEx = new AcsJComponentDeactivationUncleanEx((Throwable)ex);
                        deactivationUncleanEx.setCURL(this.m_compInstanceName);
                    }
                    this.m_containerLogger.log(Level.WARNING, "Failed to set component state DEFUNCT on " + this.m_compInstanceName, (Throwable)ex);
                }
                this.m_containerServices.cleanUp();
                this.m_threadFactory.cleanUp();
            }
            int etherealizeTimeoutMillis = 1000;
            boolean isEtherealized = this.acsCorba.destroyComponentPOA(this.m_componentPOA, this.compServantManager, etherealizeTimeoutMillis);
            if (isEtherealized && this.m_containerLogger.isLoggable(Level.FINER)) {
                this.m_containerLogger.finer("Component '" + this.m_compInstanceName + "' is etherealized.");
            } else if (!isEtherealized) {
                this.m_containerLogger.warning("Component '" + this.m_compInstanceName + "' failed to be etherealized in " + etherealizeTimeoutMillis + " ms, probably because of pending calls.");
                deactivationFailedEx = new AcsJComponentDeactivationFailedEx();
                deactivationFailedEx.setCURL(this.m_compInstanceName);
                deactivationFailedEx.setReason("Component POA etherialization timed out after " + etherealizeTimeoutMillis + " ms.");
                deactivationFailedEx.setIsPermanentFailure(true);
            }
            if (this.m_componentClassLoader instanceof AcsComponentClassLoader) {
                try {
                    ((AcsComponentClassLoader)this.m_componentClassLoader).close();
                }
                catch (IOException ex) {
                    this.m_containerLogger.log(Level.WARNING, "Failed to close component class loader", (Throwable)ex);
                }
            }
        }
        catch (RuntimeException ex) {
            if (deactivationFailedEx == null) {
                deactivationFailedEx = new AcsJComponentDeactivationFailedEx((Throwable)ex);
                deactivationFailedEx.setCURL(this.m_compInstanceName);
                deactivationFailedEx.setReason("Unexpected exception caught during component deactivation.");
            }
            this.m_containerLogger.log(Level.WARNING, "Unexpected exception caught during deactivation of component " + this.m_compInstanceName, (Throwable)ex);
        }
        if (deactivationFailedEx != null) {
            if (this.m_containerLogger.isLoggable(Level.FINER)) {
                this.m_containerLogger.log(Level.FINER, "Deactivation of component " + this.m_compInstanceName + " failed. Will throw AcsJComponentDeactivationFailedEx", (Throwable)deactivationFailedEx);
            }
            throw deactivationFailedEx;
        }
        if (deactivationUncleanEx != null) {
            if (this.m_containerLogger.isLoggable(Level.FINER)) {
                this.m_containerLogger.log(Level.FINER, "Deactivation of component " + this.m_compInstanceName + " finished with problems. Will throw AcsJComponentDeactivationUncleanEx", (Throwable)deactivationUncleanEx);
            }
            throw deactivationUncleanEx;
        }
        if (this.m_containerLogger.isLoggable(Level.FINER)) {
            this.m_containerLogger.finer("Done deactivating component " + this.m_compInstanceName + " with handle " + this.getHandle());
        }
    }

    Runnable getComponentAbortionist(final boolean killComponentPOA) {
        Runnable abortionist = new Runnable(){

            @Override
            public void run() {
                try {
                    ComponentAdapter.this.m_componentStateManager.setStateByContainer(ComponentStates.COMPSTATE_ABORTING);
                    ClassLoader contCL = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(ComponentAdapter.this.m_componentClassLoader);
                    try {
                        ComponentAdapter.this.m_component.aboutToAbort();
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(contCL);
                        ComponentAdapter.this.m_componentStateManager.setStateByContainer(ComponentStates.COMPSTATE_DEFUNCT);
                        ComponentAdapter.this.m_containerServices.cleanUp();
                        ComponentAdapter.this.m_threadFactory.cleanUp();
                        if (killComponentPOA) {
                            ComponentAdapter.this.m_componentPOA.destroy(false, false);
                        }
                    }
                }
                catch (Throwable t) {
                    ComponentAdapter.this.m_containerLogger.log(Level.INFO, "failed to abort component " + ComponentAdapter.this.getName(), t);
                    t.printStackTrace();
                }
            }
        };
        return abortionist;
    }

    ComponentInfo getComponentInfo() {
        ComponentInfo ci = new ComponentInfo(this.m_type, this.m_code, this.m_reference, this.m_compInstanceName, this.m_clients, this.m_managerProxy.getManagerHandle(), this.m_containerName, this.m_compHandle, this.m_access, this.m_interfaces);
        return ci;
    }

    public boolean equals(java.lang.Object obj) {
        if (obj == null || !(obj instanceof ComponentAdapter)) {
            return false;
        }
        ComponentAdapter other = (ComponentAdapter)obj;
        return this.m_compInstanceName.equals(other.getName()) && this.m_compHandle == other.getHandle() && this.m_type == other.getType();
    }

    public int hashCode() {
        return this.m_compInstanceName.hashCode();
    }

    public Object getReference() {
        return this.m_reference;
    }

    public int getHandle() {
        return this.m_compHandle;
    }

    public String getName() {
        return this.m_compInstanceName;
    }

    public String getType() {
        return this.m_type;
    }

    ComponentStateManagerImpl getComponentStateManager() {
        return this.m_componentStateManager;
    }

    protected void finalize() throws Throwable {
        if (this.m_containerLogger.isLoggable(Level.FINEST)) {
            this.m_containerLogger.finest("finalize() called by JVM for impl classes of component " + this.getName() + "(" + this.getHandle() + ")");
        }
        super.finalize();
    }

    void setMethodsExcludedFromInvocationLogging(String[] excludedMethods) {
        this.m_containerServices.setMethodsExcludedFromInvocationLogging(excludedMethods);
    }
}

