/*
 * Decompiled with CFR 0.152.
 */
package jsky.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;

public class FileUtil {
    public static URL makeURL(URL context, String fileOrUrlStr) {
        URL url = null;
        try {
            if (context != null || fileOrUrlStr.startsWith("http:") || fileOrUrlStr.startsWith("file:") || fileOrUrlStr.startsWith("jar:") || fileOrUrlStr.startsWith("ftp:")) {
                url = context != null ? new URL(context, fileOrUrlStr) : new URL(fileOrUrlStr);
            } else {
                File file = new File(fileOrUrlStr);
                url = file.getAbsoluteFile().toURI().toURL();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return url;
    }

    public static InputStream makeURLStream(URL url) {
        try {
            InputStream stream = url.openStream();
            if (!(stream instanceof BufferedInputStream)) {
                stream = new BufferedInputStream(stream);
            }
            return stream;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static InputStream makeURLStream(URL context, String fileOrUrlStr) {
        return FileUtil.makeURLStream(FileUtil.makeURL(context, fileOrUrlStr));
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[8192];
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getURL(URL url) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (InputStream in = FileUtil.makeURLStream(url);){
            FileUtil.copy(in, out);
            String string = out.toString();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContents(File file) throws IOException {
        FileInputStream input = new FileInputStream(file);
        int n = (int)file.length();
        byte[] ar = new byte[n];
        try {
            int count = input.read(ar);
            if (count != n) {
                throw new IOException("Read only " + count + " bytes out of expected " + n);
            }
        }
        finally {
            input.close();
        }
        return new String(ar);
    }

    public static void main(String[] args) {
        System.out.println("test FileUtil.makeURL");
        try {
            URL url = FileUtil.makeURL(new URL("http://testing/"), "/test/passed");
            if (url.toString().equals("http://testing/test/passed")) {
                System.out.println("test passed");
            } else {
                System.out.println("test failed: " + url);
            }
        }
        catch (Exception e) {
            System.out.println("test failed: " + e.getMessage());
        }
    }
}

