/*
 * Decompiled with CFR 0.152.
 */
package alma.sourcecat.dao;

import alma.sourcecat.dao.CatalogueDao;
import alma.sourcecat.dao.MeasurementDao;
import alma.sourcecat.dao.MeasurementResultSetExtractor;
import alma.sourcecat.dao.Position;
import alma.sourcecat.dao.RangeDao;
import alma.sourcecat.dao.SearchParameters;
import alma.sourcecat.dao.SourceCatDaoImpl;
import alma.sourcecat.dao.SourceNameDao;
import alma.sourcecat.dao.TypeDao;
import alma.sourcecat.dao.XmlRpcNullConverter;
import alma.sourcecat.model.Measurement;
import alma.sourcecat.model.Range;
import alma.sourcecat.model.SourceName;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class MeasurementDaoImpl
implements MeasurementDao {
    private static final Log LOG = LogFactory.getLog(MeasurementDaoImpl.class);
    private NamedParameterJdbcTemplate jdbcTmpl;
    private RangeDao rangeDao;
    private SourceNameDao sourceNameDao;
    private TypeDao typeDao;
    private CatalogueDao catalogueDao;
    private String cutoffDate = "01-01-2000";
    private static final double FLOAT_TOLERANCE = 1.0E-10;
    private static final int FETCH_SIZE = 10000;

    public void setDataSource(DataSource dataSource) {
        JdbcTemplate jdbcOperations = new JdbcTemplate(dataSource);
        jdbcOperations.setFetchSize(10000);
        this.jdbcTmpl = new NamedParameterJdbcTemplate((JdbcOperations)jdbcOperations);
    }

    private static Map<Integer, Range> getRangesMap(List<Range> ranges) {
        HashMap<Integer, Range> rangesMap = new HashMap<Integer, Range>(ranges.size());
        for (Range r : ranges) {
            rangesMap.put(r.getId(), r);
        }
        return rangesMap;
    }

    private static SourceCatDaoImpl.FrequencyParameters addFrequency(List<Range> bands, Object[] ranges, Double frequencyLower, Double frequencyUpper) {
        SourceCatDaoImpl.FrequencyParameters parameters = new SourceCatDaoImpl.FrequencyParameters();
        if (frequencyLower != null && frequencyLower > -1.0E-10) {
            parameters.lowerLimit = frequencyLower;
        }
        if (frequencyUpper != null && frequencyUpper > -1.0E-10) {
            parameters.upperLimit = frequencyUpper;
        }
        Map<Integer, Range> rangesMap = MeasurementDaoImpl.getRangesMap(bands);
        for (Object id : ranges) {
            Range range = rangesMap.get((Integer)id);
            parameters.bandNames.add(range.getName());
        }
        return parameters;
    }

    @Override
    public Boolean setMeasurementState(Integer measurementId, Boolean valid) {
        String setValidSql = "UPDATE measurements SET valid = ? WHERE measurement_id = ? AND valid = ?";
        boolean success = false;
        if (measurementId != null && valid != null) {
            success = this.jdbcTmpl.getJdbcOperations().update("UPDATE measurements SET valid = ? WHERE measurement_id = ? AND valid = ?", new Object[]{valid != false ? 1 : 0, measurementId, valid != false ? 0 : 1}) == 1;
        }
        return success;
    }

    @Override
    public Integer addMeasurement(Integer sourceId, Double ra, Double raUncertainty, Double dec, Double decUncertainty, Double frequency, Double flux, Double fluxUncertainty, Double degree, Double degreeUncertainty, Double angle, Double angleUncertainty, Double uvMin, Double uvMax, java.util.Date dateObserved, String origin, Integer catalogueId) {
        String newMeasurementIdSql = "SELECT measurement_id_seq.nextval FROM dual";
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"-> addMeasurement");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("ra: " + ra));
        }
        ra = XmlRpcNullConverter.decode(ra);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("raUncertainty: " + raUncertainty));
        }
        raUncertainty = XmlRpcNullConverter.decode(raUncertainty);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("dec: " + dec));
        }
        dec = XmlRpcNullConverter.decode(dec);
        decUncertainty = XmlRpcNullConverter.decode(decUncertainty);
        frequency = XmlRpcNullConverter.decode(frequency);
        flux = XmlRpcNullConverter.decode(flux);
        fluxUncertainty = XmlRpcNullConverter.decode(fluxUncertainty);
        degree = XmlRpcNullConverter.decode(degree);
        degreeUncertainty = XmlRpcNullConverter.decode(degreeUncertainty);
        angle = XmlRpcNullConverter.decode(angle);
        angleUncertainty = XmlRpcNullConverter.decode(angleUncertainty);
        origin = XmlRpcNullConverter.decode(origin);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"setting uvMin:");
        }
        uvMin = XmlRpcNullConverter.decode(uvMin);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"setting uvMax:");
        }
        uvMax = XmlRpcNullConverter.decode(uvMax);
        int measurementId = (Integer)this.jdbcTmpl.getJdbcOperations().queryForObject("SELECT measurement_id_seq.nextval FROM dual", Integer.class);
        String insertSql = "INSERT INTO measurements (    measurement_id, source_id, ra, ra_uncertainty, dec,     dec_uncertainty, frequency, flux, flux_uncertainty, degree,     degree_uncertainty, angle, angle_uncertainty,     date_observed, origin, catalogue_id, uvmin, uvmax, update_comment) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 'created')";
        int res = 0;
        try {
            Object[] params = new Object[]{measurementId, sourceId, ra, raUncertainty, dec, decUncertainty, frequency, flux, fluxUncertainty, degree, degreeUncertainty, angle, angleUncertainty, dateObserved, origin, catalogueId, uvMin, uvMax};
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("params: " + Arrays.toString(params)));
            }
            int[] types = new int[]{4, 4, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 93, 12, 4, 8, 8};
            res = this.jdbcTmpl.getJdbcOperations().update("INSERT INTO measurements (    measurement_id, source_id, ra, ra_uncertainty, dec,     dec_uncertainty, frequency, flux, flux_uncertainty, degree,     degree_uncertainty, angle, angle_uncertainty,     date_observed, origin, catalogue_id, uvmin, uvmax, update_comment) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 'created')", params, types);
        }
        catch (DataAccessException e) {
            LOG.error((Object)e, (Throwable)e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<- addMeasurement: " + res + "(" + measurementId + ")"));
        }
        return res == 1 ? measurementId : 0;
    }

    @Override
    public List<Measurement> searchMeasurements(SearchParameters queryArguments) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"searchMeasurments");
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("querying for parameters: " + String.valueOf(queryArguments)));
        }
        MapSqlParameterSource sqlParameters = new MapSqlParameterSource();
        String sql = this.generateSql(queryArguments, sqlParameters);
        LinkedList<Measurement> measurements = new LinkedList<Measurement>();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("sql: " + sql));
            for (String key : sqlParameters.getValues().keySet()) {
                LOG.debug((Object)("arg: " + key + ": " + sqlParameters.getValue(key)));
            }
        }
        long startMillis = System.currentTimeMillis();
        this.jdbcTmpl.query(sql, (SqlParameterSource)sqlParameters, (ResultSetExtractor)new MeasurementResultSetExtractor(measurements, sqlParameters));
        LOG.info((Object)("query performed in " + (System.currentTimeMillis() - startMillis) + "ms"));
        if (!measurements.isEmpty()) {
            startMillis = System.currentTimeMillis();
            Map<Integer, String> catalogues = this.catalogueDao.getCatalogues();
            for (Measurement nextMeasurement : measurements) {
                Collection<SourceName> names = this.sourceNameDao.getNamesForSource(nextMeasurement.getSourceId());
                if (names == null) {
                    LOG.error((Object)("no names for source id " + nextMeasurement.getSourceId() + " - refreshing from cache"));
                    names = this.sourceNameDao.getAndCacheNames(nextMeasurement.getSourceId());
                }
                if (names == null) {
                    LOG.error((Object)("no names for source id " + nextMeasurement.getSourceId()));
                } else {
                    for (SourceName nextSourceName : names) {
                        nextMeasurement.addName(nextSourceName);
                    }
                }
                Collection<Integer> typeIds = this.typeDao.getTypesOfSource(nextMeasurement.getSourceId());
                if (typeIds == null) {
                    LOG.error((Object)("no type for source id: " + nextMeasurement.getSourceId()));
                } else {
                    for (Integer nextTypeId : typeIds) {
                        nextMeasurement.addTypeId(nextTypeId);
                    }
                }
                nextMeasurement.setCatalogueName(catalogues.get(nextMeasurement.getCatalogueId()));
            }
            LOG.info((Object)("names added in " + (System.currentTimeMillis() - startMillis) + "ms"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<- searchMeasurements");
        }
        return measurements;
    }

    protected String generateSql(SearchParameters queryArguments, MapSqlParameterSource args) {
        Date to;
        Date from;
        Double spectralIndexMax;
        Double spectralIndexMin;
        Double myuvmax;
        Double myuvmin;
        Double angleMax;
        Double angleMin;
        Double degreeMax;
        Double degreeMin;
        Double fluxMax;
        boolean doConeSearch;
        String name;
        Object[] types;
        Object[] catalogues;
        String selectClause = " SELECT distinct    measurement_id, catalogue_id, m1.source_id,    s.ra_deg, s.ra_deg_uncertainty, s.dec_deg, s.dec_deg_uncertainty,     ra, ra_uncertainty, dec, dec_uncertainty,     frequency, flux, flux_uncertainty, degree,     degree_uncertainty, angle, angle_uncertainty, -1 as extension,     origin, date_observed, date_created, valid,     b.uvmin, b.uvmax, b.spectral_index,     coalesce(r.range_name, 'non-ALMA Band') as bandName";
        String fromClause = " FROM measurements m1  INNER JOIN sources s on s.source_id = m1.source_id    LEFT JOIN source_type t on t.source_id = s.source_id    LEFT JOIN sourcename n on n.source_id = s.source_id    LEFT JOIN ranges r on m1.frequency between r.frequency_min and r.frequency_max    LEFT JOIN source_band b on b.band_id = r.range_id and b.source_id = s.source_id";
        String whereClause = " WHERE (1 = 1)";
        Integer maxSources = queryArguments.getLimit();
        if (maxSources != null) {
            args.addValue("max_sources", (Object)maxSources);
        }
        if (Integer.valueOf(1).equals(queryArguments.getValidCriteria())) {
            whereClause = whereClause + " AND valid = 1";
        }
        if ((catalogues = queryArguments.getCatalogues()).length > 0) {
            whereClause = whereClause + " AND (";
            for (int i = 0; i < catalogues.length; ++i) {
                whereClause = whereClause + "catalogue_id = :cat" + i;
                if (i < catalogues.length - 1) {
                    whereClause = whereClause + " OR ";
                }
                args.addValue("cat" + i, (Object)((Integer)catalogues[i]));
            }
            whereClause = whereClause + " )";
        }
        if ((types = queryArguments.getTypes()).length > 0) {
            whereClause = whereClause + " AND (";
            for (int i = 0; i < types.length; ++i) {
                whereClause = whereClause + "type_id = :type" + i;
                if (i < types.length - 1) {
                    whereClause = whereClause + " OR ";
                }
                args.addValue("type" + i, (Object)((Integer)types[i]));
            }
            whereClause = whereClause + " )";
        }
        if ((name = queryArguments.getName()) != null && !name.trim().isEmpty()) {
            whereClause = whereClause + " AND upper(name) like :name";
            args.addValue("name", (Object)('%' + name.trim().toUpperCase() + '%'));
        }
        Double ra = queryArguments.getRa();
        Double dec = queryArguments.getDec();
        Double radius = queryArguments.getRadius();
        Position.PositionalSearchParameters parameters = Position.calculatePositionalSearchParameters(ra, dec, radius);
        if (parameters.performRaSearch) {
            whereClause = whereClause + " AND ((ra_deg >= :ra_min1 AND ra_deg <= :ra_max1) OR (ra_deg >= :ra_min2 AND ra_deg <= :ra_max2))";
            args.addValue("ra_min1", (Object)parameters.raMin1);
            args.addValue("ra_max1", (Object)parameters.raMax1);
            args.addValue("ra_min2", (Object)parameters.raMin2);
            args.addValue("ra_max2", (Object)parameters.raMax2);
        }
        if (parameters.performDecSearch) {
            whereClause = whereClause + " AND dec_deg >= :dec_min AND dec_deg <= :dec_max";
            args.addValue("dec_min", (Object)parameters.decMin);
            args.addValue("dec_max", (Object)parameters.decMax);
        }
        if (doConeSearch = parameters.performDecSearch) {
            Position.addCone(args, ra, dec, radius);
            whereClause = whereClause + " AND SQRT(      POWER(SIN((:dec - dec_deg * :to_radians) / 2), 2) +      COS(:dec) * COS(dec_deg * :to_radians) *      POWER(SIN((:ra - ra_deg * :to_radians) / 2), 2)   ) <= :radius ";
        }
        Object[] ranges = queryArguments.getRanges();
        Double fLower = queryArguments.getFLower();
        Double fUpper = queryArguments.getFUpper();
        SourceCatDaoImpl.FrequencyParameters frequencyParameters = MeasurementDaoImpl.addFrequency(this.rangeDao.listRanges(), ranges, fLower, fUpper);
        String freeFrequencyClause = "";
        if (frequencyParameters.lowerLimit != null) {
            freeFrequencyClause = freeFrequencyClause + "frequency >= :lower";
            args.addValue("lower", (Object)frequencyParameters.lowerLimit);
            if (frequencyParameters.upperLimit != null) {
                freeFrequencyClause = freeFrequencyClause + " AND ";
            }
        }
        if (frequencyParameters.upperLimit != null) {
            freeFrequencyClause = freeFrequencyClause + "frequency <= :upper";
            args.addValue("upper", (Object)frequencyParameters.upperLimit);
        }
        if (frequencyParameters.bandNames != null && !frequencyParameters.bandNames.isEmpty()) {
            whereClause = whereClause + " AND ((1 = 0)";
            for (int i = 0; i < frequencyParameters.bandNames.size(); ++i) {
                whereClause = whereClause + " OR (r.range_name = :band_name" + i + ")";
                args.addValue("band_name" + i, (Object)frequencyParameters.bandNames.get(i));
            }
            if (!freeFrequencyClause.isEmpty()) {
                whereClause = whereClause + " OR (" + freeFrequencyClause + ")";
            }
            whereClause = whereClause + ")";
        } else if (!freeFrequencyClause.isEmpty()) {
            whereClause = whereClause + " AND (" + freeFrequencyClause + ")";
        }
        Double fluxMin = queryArguments.getFluxMin();
        if (XmlRpcNullConverter.queryValueSupplied(fluxMin)) {
            whereClause = whereClause + " AND flux >= :fluxmin";
            args.addValue("fluxmin", (Object)fluxMin);
        }
        if (XmlRpcNullConverter.queryValueSupplied(fluxMax = queryArguments.getFluxMax())) {
            whereClause = whereClause + " AND flux <= :fluxmax";
            args.addValue("fluxmax", (Object)fluxMax);
        }
        if (XmlRpcNullConverter.queryValueSupplied(degreeMin = queryArguments.getDegreeMin())) {
            whereClause = whereClause + " AND degree >= :degreemin";
            args.addValue("degreemin", (Object)degreeMin);
        }
        if (XmlRpcNullConverter.queryValueSupplied(degreeMax = queryArguments.getDegreeMax())) {
            whereClause = whereClause + " AND degree <= :degreemax";
            args.addValue("degreemax", (Object)degreeMax);
        }
        if (XmlRpcNullConverter.queryAngleValueSupplied(angleMin = queryArguments.getAngleMin())) {
            whereClause = whereClause + " AND angle >= :anglemin";
            args.addValue("anglemin", (Object)angleMin);
        }
        if (XmlRpcNullConverter.queryAngleValueSupplied(angleMax = queryArguments.getAngleMax())) {
            whereClause = whereClause + " AND angle <= :anglemax";
            args.addValue("anglemax", (Object)angleMax);
        }
        if (XmlRpcNullConverter.queryValueSupplied(myuvmin = queryArguments.getUvMin())) {
            whereClause = whereClause + " AND b.uvmax >= :uvmin";
            args.addValue("uvmin", (Object)myuvmin);
        }
        if (XmlRpcNullConverter.queryValueSupplied(myuvmax = queryArguments.getUvMax())) {
            whereClause = whereClause + " AND b.uvmin <= :uvmax AND b.uvmin >= 0.0";
            args.addValue("uvmax", (Object)myuvmax);
        }
        if (XmlRpcNullConverter.queryValueSupplied(spectralIndexMin = queryArguments.getSpectralIndexMin())) {
            whereClause = whereClause + " AND b.spectral_index >= :spectralIndexMin";
            args.addValue("spectralIndexMin", (Object)spectralIndexMin);
        }
        if (XmlRpcNullConverter.queryValueSupplied(spectralIndexMax = queryArguments.getSpectralIndexMax())) {
            whereClause = whereClause + " AND b.spectral_index <= :spectralIndexMax AND b.spectral_index >= 0.0";
            args.addValue("spectralIndexMax", (Object)spectralIndexMax);
        }
        if ((from = queryArguments.getDateFrom()) != null) {
            whereClause = whereClause + " AND date_observed >= :date_from";
            args.addValue("date_from", (Object)from);
        }
        if ((to = queryArguments.getDateTo()) != null) {
            whereClause = whereClause + " AND date_observed <= :date_to";
            args.addValue("date_to", (Object)to);
        }
        String sql = selectClause + fromClause + whereClause;
        sql = this.limitReturnedResults(queryArguments, args, sql);
        sql = this.sortResults(queryArguments, sql);
        return sql;
    }

    private String sortResults(SearchParameters queryArguments, String sql) {
        String sortBy = queryArguments.getSortBy();
        boolean asc = queryArguments.getAsc();
        if (sortBy == null || sortBy.equals("")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"no sort field specified, using flux");
            }
            sortBy = "flux";
            asc = false;
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("order specified is: " + sortBy));
        }
        String sortClause = " ORDER BY " + sortBy + " " + (asc ? "ASC" : "DESC");
        sql = sql + sortClause;
        return sql;
    }

    private String limitReturnedResults(SearchParameters queryArguments, MapSqlParameterSource args, String sql) {
        int sourceBandLimit = queryArguments.getSourceBandMeasurementsLimit();
        if (sourceBandLimit > 0 || this.cutoffDate != null) {
            boolean dateSearch;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("only show latest " + sourceBandLimit + " observation for any (sourceId, bandName)"));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("measurement cutoff date: " + this.cutoffDate));
            }
            boolean bl = dateSearch = queryArguments.getDateFrom() != null || queryArguments.getDateTo() != null;
            if (dateSearch && LOG.isDebugEnabled()) {
                LOG.debug((Object)"search criteria includes observation dates. We will not limit the (sourceName, bandName) pairs");
            }
            String wrapperSql = "select q.*, row_number() over (partition by source_id, bandName order by date_observed desc, measurement_id desc) source_band_rownum from (" + sql + ") q";
            wrapperSql = "select part.* from (" + wrapperSql + ") part where (date_observed > to_date(:cutoff_date, 'DD-MM-YYYY') or ((part.bandName != 'ALMA-Band 3' and part.source_band_rownum <= 1) or (part.bandName = 'ALMA-Band 3' and part.source_band_rownum <= 2)))";
            args.addValue("cutoff_date", (Object)this.cutoffDate);
            if (sourceBandLimit > 0 && !dateSearch) {
                wrapperSql = wrapperSql + " and ((part.bandName != 'ALMA-Band 3' and part.source_band_rownum <= :source_band_limit) or (part.bandName = 'ALMA-Band 3' and part.source_band_rownum <= (:source_band_limit * 2)))";
                args.addValue("source_band_limit", (Object)sourceBandLimit);
            }
            sql = wrapperSql;
        }
        return sql;
    }

    @Override
    public List<Measurement> searchMeasurements(Integer limit, Object[] catalogues, Object[] types, String name, Double ra, Double dec, Double radius, Object[] ranges, Double fLower, Double fUpper, Double fluxMin, Double fluxMax, Double degreeMin, Double degreeMax, Double angleMin, Double angleMax, String sortBy, boolean asc, boolean searchOnDate, Integer dateCriteria, String date) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"-> searchMeasurements()");
        }
        SearchParameters queryArguments = MeasurementDaoImpl.createMinimumArguments(limit, catalogues, types, name, ra, dec, radius, ranges, fLower, fUpper, fluxMin, fluxMax, degreeMin, degreeMax, angleMin, angleMax, sortBy, asc);
        queryArguments.setValidCriteria(new Integer(1));
        MeasurementDaoImpl.addDateParams(queryArguments, searchOnDate, dateCriteria, date);
        XmlRpcNullConverter.decode(queryArguments);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<- searchMeasurements");
        }
        return XmlRpcNullConverter.encodeMeasurements(this.searchMeasurements(queryArguments));
    }

    @Override
    public List<Measurement> searchMeasurementsPlus(Integer limit, Object[] catalogues, Object[] types, String name, Double ra, Double dec, Double radius, Object[] ranges, Double fLower, Double fUpper, Double fluxMin, Double fluxMax, Double degreeMin, Double degreeMax, Double angleMin, Double angleMax, String sortBy, boolean asc, boolean searchOnDate, Integer dateCriteria, String date, boolean onlyValid) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"-> searchMeasurementsPlus");
        }
        SearchParameters queryArguments = new SearchParameters(limit, catalogues, types, name, ra, dec, radius, ranges, fLower, fUpper, fluxMin, fluxMax, degreeMin, degreeMax, angleMin, angleMax, sortBy, asc);
        if (onlyValid) {
            queryArguments.setValidCriteria(new Integer(1));
        } else {
            queryArguments.setValidCriteria(new Integer(0));
        }
        MeasurementDaoImpl.addDateParams(queryArguments, searchOnDate, dateCriteria, date);
        XmlRpcNullConverter.decode(queryArguments);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<- searchMeasurementsPlus");
        }
        return XmlRpcNullConverter.encodeMeasurements(this.searchMeasurements(queryArguments));
    }

    private static void addDateParams(SearchParameters queryArguments, boolean searchOnDate, Integer dateCriteria, String date) {
        if (searchOnDate) {
            try {
                Date d = Date.valueOf(date);
                if (dateCriteria.equals(SearchParameters.BEFORE_DATE_CRITERIA)) {
                    queryArguments.setDateTo(d);
                } else if (dateCriteria.equals(SearchParameters.ON_DATE_CRITERIA)) {
                    queryArguments.setDateTo(d);
                    queryArguments.setDateFrom(d);
                } else if (dateCriteria.equals(SearchParameters.AFTER_DATE_CRITERIA)) {
                    queryArguments.setDateFrom(d);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private static SearchParameters createMinimumArguments(Integer limit, Object[] catalogues, Object[] types, String name, Double ra, Double dec, Double radius, Object[] ranges, Double fLower, Double fUpper, Double fluxMin, Double fluxMax, Double degreeMin, Double degreeMax, Double angleMin, Double angleMax, String sortBy, boolean asc) {
        SearchParameters queryArguments = new SearchParameters();
        queryArguments.setLimit(limit);
        queryArguments.setCatalogues(catalogues);
        queryArguments.setTypes(types);
        queryArguments.setName(name);
        queryArguments.setRa(ra);
        queryArguments.setDec(dec);
        queryArguments.setRadius(radius);
        queryArguments.setRanges(ranges);
        queryArguments.setFLower(fLower);
        queryArguments.setFUpper(fUpper);
        queryArguments.setFluxMin(fluxMin);
        queryArguments.setFluxMax(fluxMax);
        queryArguments.setDegreeMin(degreeMin);
        queryArguments.setDegreeMax(degreeMax);
        queryArguments.setAngleMin(angleMin);
        queryArguments.setAngleMax(angleMax);
        queryArguments.setSortBy(sortBy);
        queryArguments.setAsc(asc);
        return queryArguments;
    }

    @Override
    public List<Measurement> searchMeasurements913(Integer limit, Object[] catalogues, Object[] types, String name, Double ra, Double dec, Double radius, Object[] ranges, Double fLower, Double fUpper, Double fluxMin, Double fluxMax, Double degreeMin, Double degreeMax, Double angleMin, Double angleMax, String sortBy, boolean asc, boolean searchOnDate, Integer dateCriteria, String date, boolean onlyValid, Double uvMin, Double uvMax) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"-> searchMeasurements913");
        }
        SearchParameters queryArguments = new SearchParameters(limit, catalogues, types, name, ra, dec, radius, ranges, fLower, fUpper, fluxMin, fluxMax, degreeMin, degreeMax, angleMin, angleMax, sortBy, asc);
        queryArguments.setUvMin(uvMin);
        queryArguments.setUvMax(uvMax);
        queryArguments.setValidCriteria(onlyValid ? Integer.valueOf(1) : Integer.valueOf(0));
        MeasurementDaoImpl.addDateParams(queryArguments, searchOnDate, dateCriteria, date);
        XmlRpcNullConverter.decode(queryArguments);
        List<Measurement> results = this.searchMeasurements(queryArguments);
        results = XmlRpcNullConverter.encodeMeasurements(results);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<- searchMeasurements913");
        }
        return results;
    }

    @Override
    public List<Measurement> searchMeasurements103(Integer resultsPerSourceBand, Integer limit, Object[] catalogues, Object[] types, String name, Double ra, Double dec, Double radius, Object[] ranges, Double fLower, Double fUpper, Double fluxMin, Double fluxMax, Double degreeMin, Double degreeMax, Double angleMin, Double angleMax, String sortBy, boolean asc, boolean searchOnDate, Integer dateCriteria, String date, boolean onlyValid, Double uvMin, Double uvMax) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"-> searchMeasurements103");
        }
        Integer[] catIds = new Integer[catalogues.length];
        for (int i = 0; i < catalogues.length; ++i) {
            catIds[i] = (Integer)catalogues[i];
        }
        Integer[] typeIds = new Integer[types.length];
        for (int i = 0; i < types.length; ++i) {
            typeIds[i] = (Integer)types[i];
        }
        Integer[] rangeIds = new Integer[ranges.length];
        for (int i = 0; i < ranges.length; ++i) {
            rangeIds[i] = (Integer)ranges[i];
        }
        return this.search(resultsPerSourceBand, limit, catIds, typeIds, name, ra, dec, radius, rangeIds, fLower, fUpper, fluxMin, fluxMax, degreeMin, degreeMax, angleMin, angleMax, null, null, sortBy, asc, searchOnDate, dateCriteria, date, onlyValid, uvMin, uvMax);
    }

    public void setRangeDao(RangeDao rangeDao) {
        this.rangeDao = rangeDao;
    }

    @Override
    public Double[] getLatestPosition(String sourceName) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("-> getLatestPosition(" + sourceName + ")"));
        }
        String sql = "select s.ra_deg, s.ra_deg_uncertainty, s.dec_deg, s.dec_deg_uncertainty from sourcename sn   inner join sources s      on sn.source_id = s.source_id where lower(sn.name) = lower(:source_name)";
        Object[] positionalParameters = new Double[4];
        this.jdbcTmpl.query("select s.ra_deg, s.ra_deg_uncertainty, s.dec_deg, s.dec_deg_uncertainty from sourcename sn   inner join sources s      on sn.source_id = s.source_id where lower(sn.name) = lower(:source_name)", (SqlParameterSource)new MapSqlParameterSource(Collections.singletonMap("source_name", sourceName)), new RowCallbackHandler((Double[])positionalParameters){
            final /* synthetic */ Double[] val$positionalParameters;
            {
                this.val$positionalParameters = doubleArray;
            }

            public void processRow(ResultSet rs) throws SQLException {
                this.val$positionalParameters[0] = rs.getDouble("ra_deg");
                this.val$positionalParameters[1] = rs.getDouble("ra_deg_uncertainty");
                this.val$positionalParameters[2] = rs.getDouble("dec_deg");
                this.val$positionalParameters[3] = rs.getDouble("dec_deg_uncertainty");
            }
        });
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("-> getLatestPosition: " + Arrays.toString(positionalParameters)));
        }
        return positionalParameters[0] == null ? null : positionalParameters;
    }

    @Override
    public Map<String, List<Measurement>> getSourceFluxHistory(String sourceName) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("-> getSourceFluxHistory(" + sourceName + ")"));
        }
        String sql = "select measurement_id, m.source_id, ra, ra_uncertainty, dec, dec_uncertainty,  m.frequency, flux, flux_uncertainty, r.range_name, date_observed from measurements m inner join ranges r on m.frequency between r.frequency_min and r.frequency_max LEFT JOIN sourcename n on n.source_id = m.source_id  where n.name = :sourceName and valid = 1 and catalogue_id = 5 order by r.range_name, date_observed, measurement_id";
        String restrictionSql = "select part.* from (  select q.*,  row_number() over (partition by source_id, range_name order by date_observed desc, measurement_id desc) source_band_rownum  from (select measurement_id, m.source_id, ra, ra_uncertainty, dec, dec_uncertainty,  m.frequency, flux, flux_uncertainty, r.range_name, date_observed from measurements m inner join ranges r on m.frequency between r.frequency_min and r.frequency_max LEFT JOIN sourcename n on n.source_id = m.source_id  where n.name = :sourceName and valid = 1 and catalogue_id = 5 order by r.range_name, date_observed, measurement_id ) q ) part where (date_observed > to_date(:cutoff_date, 'DD-MM-YYYY') or ((part.range_name != 'ALMA-Band 3' and part.source_band_rownum <= 1) or (part.range_name = 'ALMA-Band 3' and part.source_band_rownum <= 2))) order by date_observed, measurement_id";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("sourceName", sourceName);
        parameters.put("cutoff_date", this.cutoffDate);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("fetching flux history for (" + sourceName + ") with cutoff date = " + this.cutoffDate));
        }
        final HashMap<String, List<Measurement>> fluxHistory = new HashMap<String, List<Measurement>>();
        this.jdbcTmpl.query("select part.* from (  select q.*,  row_number() over (partition by source_id, range_name order by date_observed desc, measurement_id desc) source_band_rownum  from (select measurement_id, m.source_id, ra, ra_uncertainty, dec, dec_uncertainty,  m.frequency, flux, flux_uncertainty, r.range_name, date_observed from measurements m inner join ranges r on m.frequency between r.frequency_min and r.frequency_max LEFT JOIN sourcename n on n.source_id = m.source_id  where n.name = :sourceName and valid = 1 and catalogue_id = 5 order by r.range_name, date_observed, measurement_id ) q ) part where (date_observed > to_date(:cutoff_date, 'DD-MM-YYYY') or ((part.range_name != 'ALMA-Band 3' and part.source_band_rownum <= 1) or (part.range_name = 'ALMA-Band 3' and part.source_band_rownum <= 2))) order by date_observed, measurement_id", parameters, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                String bandName = rs.getString("range_name");
                ArrayList<Measurement> measurements = (ArrayList<Measurement>)fluxHistory.get(bandName);
                if (measurements == null) {
                    measurements = new ArrayList<Measurement>();
                    fluxHistory.put(bandName, measurements);
                }
                Measurement m = new Measurement();
                m.setId(rs.getInt("measurement_id"));
                m.setRa(rs.getDouble("ra"));
                m.setRaUncertainty(rs.getString("ra_uncertainty"));
                m.setDec(rs.getDouble("dec"));
                m.setDecUncertainty(rs.getString("dec_uncertainty"));
                m.setFrequency(rs.getDouble("frequency"));
                m.setFlux(rs.getDouble("flux"));
                m.setFluxUncertainty(rs.getString("flux_uncertainty"));
                m.setDateObserved(rs.getDate("date_observed"));
                measurements.add(m);
            }
        });
        for (List nextBand : fluxHistory.values()) {
            for (int i = 0; i < nextBand.size() - 1; ++i) {
                Measurement m1 = (Measurement)nextBand.get(i);
                Measurement m2 = (Measurement)nextBand.get(i + 1);
                if (!m1.getDateObserved().equals(m2.getDateObserved())) continue;
                if (m1.getFlux() > m2.getFlux()) {
                    nextBand.set(i, m2);
                    nextBand.set(i + 1, m1);
                }
                ++i;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<- getSourceFluxHistory: " + fluxHistory.size()));
        }
        return fluxHistory;
    }

    public RangeDao getRangeDao() {
        return this.rangeDao;
    }

    public void setSourceNameDao(SourceNameDao sourceNameDao) {
        this.sourceNameDao = sourceNameDao;
    }

    public void setTypeDao(TypeDao typeDao) {
        this.typeDao = typeDao;
    }

    public void setCatalogueDao(CatalogueDao catalogueDao) {
        this.catalogueDao = catalogueDao;
    }

    public void setCutoffDate(String cutoffDate) {
        this.cutoffDate = cutoffDate;
    }

    @Override
    public Measurement getMeasurement(Integer measurementId) {
        String sql = "select * from measurements where measurement_id = :measurementId";
        MapSqlParameterSource sqlParameters = new MapSqlParameterSource();
        sqlParameters.addValue("measurementId", (Object)measurementId);
        LinkedList<Measurement> measurements = new LinkedList<Measurement>();
        this.jdbcTmpl.query("select * from measurements where measurement_id = :measurementId", (SqlParameterSource)sqlParameters, (ResultSetExtractor)new MeasurementResultSetExtractor(measurements, sqlParameters, true));
        return measurements.isEmpty() ? null : measurements.get(0);
    }

    @Override
    public void update(Measurement measurement) {
        String sql = "update measurements set ra = :ra, ra_uncertainty = :raUncertainty, dec = :dec, dec_uncertainty = :decUncertainty, frequency = :frequency, flux = :flux, flux_uncertainty = :fluxUncertainty, degree = :degree, degree_uncertainty = :degreeUncertainty, angle = :angle, angle_uncertainty = :angleUncertainty, uvmin = :uvMin, uvmax = :uvMax, origin = :origin, update_comment = :updateComment, update_date = sysdate, update_user = :updateUser, valid = :valid where measurement_id = :id";
        BeanPropertySqlParameterSource adapter = new BeanPropertySqlParameterSource((Object)measurement);
        adapter.registerSqlType("valid", 4);
        this.jdbcTmpl.update("update measurements set ra = :ra, ra_uncertainty = :raUncertainty, dec = :dec, dec_uncertainty = :decUncertainty, frequency = :frequency, flux = :flux, flux_uncertainty = :fluxUncertainty, degree = :degree, degree_uncertainty = :degreeUncertainty, angle = :angle, angle_uncertainty = :angleUncertainty, uvmin = :uvMin, uvmax = :uvMax, origin = :origin, update_comment = :updateComment, update_date = sysdate, update_user = :updateUser, valid = :valid where measurement_id = :id", (SqlParameterSource)adapter);
    }

    @Override
    public List<Measurement> search(Integer resultsPerSourceBand, Integer limit, Integer[] catalogues, Integer[] types, String name, Double ra, Double dec, Double radius, Integer[] ranges, Double fLower, Double fUpper, Double fluxMin, Double fluxMax, Double degreeMin, Double degreeMax, Double angleMin, Double angleMax, Double siMin, Double siMax, String sortBy, boolean asc, boolean searchOnDate, Integer dateCriteria, String date, boolean onlyValid, Double uvMin, Double uvMax) {
        SearchParameters queryArguments = new SearchParameters(limit, catalogues, types, name, ra, dec, radius, ranges, fLower, fUpper, fluxMin, fluxMax, degreeMin, degreeMax, angleMin, angleMax, sortBy, asc);
        queryArguments.setUvMin(uvMin);
        queryArguments.setUvMax(uvMax);
        queryArguments.setSpectralIndexMin(siMin);
        queryArguments.setSpectralIndexMax(siMax);
        queryArguments.setValidCriteria(onlyValid ? Integer.valueOf(1) : Integer.valueOf(0));
        queryArguments.setSourceBandMeasurementsLimit(resultsPerSourceBand);
        MeasurementDaoImpl.addDateParams(queryArguments, searchOnDate, dateCriteria, date);
        XmlRpcNullConverter.decode(queryArguments);
        List<Measurement> results = this.searchMeasurements(queryArguments);
        results = XmlRpcNullConverter.encodeMeasurements(results);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<- searchMeasurements103");
        }
        return results;
    }
}

