/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.commandcenter.engine;

import alma.acs.commandcenter.engine.Executor;
import alma.acs.commandcenter.engine.NativeCommand;
import alma.acs.commandcenter.engine.RunModel;
import alma.acs.commandcenter.engine.ToolManager;
import alma.acs.commandcenter.util.MiscUtils;
import alma.acs.util.ACSPorts;
import alma.entity.xmlbinding.acscommandcentertools.Tool;

public class ExecuteAcs {
    public RunModel runModel;

    public ExecuteAcs(RunModel runModel) {
        this.runModel = runModel;
    }

    public String[] startLocalScript(NativeCommand.Listener listener) throws Throwable {
        Tool t = ToolManager.getBuiltinTool("Acs_startLocalScript");
        String command = ToolManager.generateCommand(t, this.runModel);
        Executor.localOutProc(command, true, t.getMaxStartupSeconds() * 1000, t.getExpectedOutput(), listener);
        String acsBasePort = this.runModel.getScriptBase();
        ACSPorts ports = ACSPorts.globalInstance((int)MiscUtils.parseInt(acsBasePort));
        return new String[]{ports.giveIP(), ports.giveManagerPort()};
    }

    public void stopLocalScript(NativeCommand.Listener listener) throws Throwable {
        Tool t = ToolManager.getBuiltinTool("Acs_stopLocalScript");
        String command = ToolManager.generateCommand(t, this.runModel);
        Executor.localOutProc(command, true, t.getMaxStartupSeconds() * 1000, t.getExpectedOutput(), listener);
    }

    public void killLocalScript(NativeCommand.Listener listener) throws Throwable {
        Tool t = ToolManager.getBuiltinTool("Acs_killLocalScript");
        String command = ToolManager.generateCommand(t, this.runModel);
        Executor.localOutProc(command, true, t.getMaxStartupSeconds() * 1000, t.getExpectedOutput(), listener);
    }

    public boolean startRemote(boolean nativeSSH, NativeCommand.Listener listener) throws Throwable {
        String host = this.runModel.getRemoteHost();
        String username = this.runModel.getRemoteAccount();
        String password = this.runModel.getRemotePassword();
        Tool t = ToolManager.getBuiltinTool("Acs_startRemote");
        String command = ToolManager.generateCommand(t, this.runModel);
        return Executor.remote(nativeSSH, username, password, command, t.getExpectedOutput(), listener, host);
    }

    public void stopRemote(boolean nativeSSH, NativeCommand.Listener listener) throws Throwable {
        String host = this.runModel.getRemoteHost();
        String username = this.runModel.getRemoteAccount();
        String password = this.runModel.getRemotePassword();
        Tool t = ToolManager.getBuiltinTool("Acs_stopRemote");
        String command = ToolManager.generateCommand(t, this.runModel);
        Executor.remote(nativeSSH, username, password, command, t.getExpectedOutput(), listener, host);
    }

    public void killRemote(boolean nativeSSH, NativeCommand.Listener listener) throws Throwable {
        String host = this.runModel.getRemoteHost();
        String username = this.runModel.getRemoteAccount();
        String password = this.runModel.getRemotePassword();
        Tool t = ToolManager.getBuiltinTool("Acs_killRemote");
        String command = ToolManager.generateCommand(t, this.runModel);
        Executor.remote(nativeSSH, username, password, command, t.getExpectedOutput(), listener, host);
    }

    public Exception startRemoteDemonic(NativeCommand.Listener listener) {
        String host = this.runModel.getRemoteHost();
        int instance = MiscUtils.parseInt(this.runModel.getScriptBase());
        boolean startStop = true;
        String cmdFlags = "-nowaitifr";
        return Executor.remoteDaemonForServices(host, instance, startStop, cmdFlags, listener);
    }

    public Exception stopRemoteDemonic(NativeCommand.Listener listener) {
        String host = this.runModel.getRemoteHost();
        int instance = MiscUtils.parseInt(this.runModel.getScriptBase());
        boolean startStop = false;
        String cmdFlags = "";
        return Executor.remoteDaemonForServices(host, instance, startStop, cmdFlags, listener);
    }
}

