/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import java.io.IOException;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.WrapperRowSequence;
import uk.ac.starlink.table.join.ProgressIndicator;

public class ProgressRowSequence
extends WrapperRowSequence {
    private final double nrow_;
    private final ProgressIndicator indicator_;
    private boolean closed;
    private long lrow_;

    public ProgressRowSequence(StarTable table, ProgressIndicator indicator, String stage) throws IOException {
        super(table.getRowSequence());
        this.nrow_ = table.getRowCount();
        this.indicator_ = indicator;
        this.indicator_.startStage(stage);
    }

    public boolean nextProgress() throws IOException, InterruptedException {
        double level = this.nrow_ > 0.0 ? (double)this.lrow_ / this.nrow_ : 0.0;
        boolean result = this.next();
        this.indicator_.setLevel(level);
        return result;
    }

    public boolean next() throws IOException {
        boolean result = super.next();
        ++this.lrow_;
        return result;
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.indicator_.endStage();
            this.closed = true;
        }
        super.close();
    }
}

