/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.EmptyRowSequence;
import uk.ac.starlink.table.EmptyStarTable;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.WrapperStarTable;

public class ConcatStarTable
extends WrapperStarTable {
    private final ColumnInfo[] colInfos_;
    private final List tableList_;
    private Iterator tableIt_;
    private Boolean isRandom_;
    private long nrow_ = -1L;
    private static final Logger logger_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ConcatStarTable(StarTable meta, Iterator tableIt) {
        super(meta);
        this.colInfos_ = Tables.getColumnInfos(meta);
        this.tableIt_ = tableIt;
        this.tableList_ = new ArrayList();
    }

    public ConcatStarTable(StarTable meta, StarTable[] tables) throws IOException {
        super(meta);
        this.colInfos_ = Tables.getColumnInfos(meta);
        for (int itab = 0; itab < tables.length; ++itab) {
            this.checkCompatible(tables[itab]);
        }
        this.tableIt_ = null;
        this.tableList_ = Arrays.asList(tables);
        this.gotTables();
    }

    public long getRowCount() {
        return this.nrow_;
    }

    public Object getCell(long irow, int icol) throws IOException {
        if (this.isRandom()) {
            Iterator it = this.tableList_.iterator();
            while (it.hasNext()) {
                StarTable table = (StarTable)it.next();
                long nr = table.getRowCount();
                if (!$assertionsDisabled && nr < 0L) {
                    throw new AssertionError();
                }
                if (irow < nr) {
                    return table.getCell(irow, icol);
                }
                irow -= nr;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        throw new UnsupportedOperationException("No random access");
    }

    public Object[] getRow(long irow) throws IOException {
        if (this.isRandom()) {
            Iterator it = this.tableList_.iterator();
            while (it.hasNext()) {
                StarTable table = (StarTable)it.next();
                long nr = table.getRowCount();
                if (!$assertionsDisabled && nr < 0L) {
                    throw new AssertionError();
                }
                if (irow < nr) {
                    return table.getRow(irow);
                }
                irow -= nr;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        throw new UnsupportedOperationException("No random access");
    }

    public boolean isRandom() {
        return this.isRandom_ != null && this.isRandom_ != false;
    }

    public RowSequence getRowSequence() throws IOException {
        return new ConcatRowSequence(this.getTableIterator());
    }

    private void checkCompatible(StarTable table) throws IOException {
        if (table.getRowCount() == 0L) {
            return;
        }
        int ncol0 = this.colInfos_.length;
        int ncol1 = table.getColumnCount();
        if (ncol1 != ncol0) {
            throw new IOException("Column count mismatch (" + ncol1 + " != " + ncol0 + ")");
        }
        for (int icol = 0; icol < ncol0; ++icol) {
            ColumnInfo info0 = this.colInfos_[icol];
            ColumnInfo info1 = table.getColumnInfo(icol);
            if (info0.getContentClass().isAssignableFrom(info1.getContentClass()) && info0.isArray() == info1.isArray()) continue;
            throw new IOException("Column type mismatch (" + info1 + " not compatible with " + info0);
        }
    }

    private synchronized void gotTables() {
        if (!$assertionsDisabled && this.isRandom_ != null) {
            throw new AssertionError();
        }
        boolean isRand = true;
        long nrow = 0L;
        Iterator it = this.tableList_.iterator();
        while (it.hasNext()) {
            StarTable table = (StarTable)it.next();
            boolean bl = isRand = isRand && table.isRandom();
            if (nrow < 0L) continue;
            long nr = table.getRowCount();
            nrow = nr >= 0L ? nrow + nr : -1L;
        }
        this.isRandom_ = isRand;
        this.nrow_ = nrow;
    }

    private synchronized Iterator getTableIterator() {
        if (this.tableIt_ == null) {
            return this.tableList_.iterator();
        }
        return new Iterator(){
            private int index_;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean hasNext() {
                ConcatStarTable concatStarTable = ConcatStarTable.this;
                synchronized (concatStarTable) {
                    if (this.index_ < ConcatStarTable.this.tableList_.size()) {
                        return true;
                    }
                    if (ConcatStarTable.this.tableIt_ == null) {
                        return false;
                    }
                    if (ConcatStarTable.this.tableIt_.hasNext()) {
                        StarTable table = (StarTable)ConcatStarTable.this.tableIt_.next();
                        try {
                            ConcatStarTable.this.checkCompatible(table);
                        }
                        catch (IOException e) {
                            logger_.warning("Omitting incompatible table #" + ConcatStarTable.this.tableList_.size() + " - " + e.getMessage());
                            table = new EmptyStarTable(table);
                        }
                        ConcatStarTable.this.tableList_.add(table);
                        return true;
                    }
                    ConcatStarTable.this.tableIt_ = null;
                    ConcatStarTable.this.gotTables();
                    return false;
                }
            }

            public Object next() {
                if (this.hasNext()) {
                    return ConcatStarTable.this.tableList_.get(this.index_++);
                }
                throw new IllegalStateException();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    static {
        $assertionsDisabled = !ConcatStarTable.class.desiredAssertionStatus();
        logger_ = Logger.getLogger("uk.ac.starlink.table");
    }

    private class ConcatRowSequence
    implements RowSequence {
        private final Iterator tIt_;
        private RowSequence rseq_;

        ConcatRowSequence(Iterator tableIt) {
            this.tIt_ = tableIt;
            this.rseq_ = EmptyRowSequence.getInstance();
        }

        public boolean next() throws IOException {
            while (!this.rseq_.next()) {
                this.rseq_.close();
                if (this.tIt_.hasNext()) {
                    this.rseq_ = ((StarTable)this.tIt_.next()).getRowSequence();
                    continue;
                }
                return false;
            }
            return true;
        }

        public Object getCell(int icol) throws IOException {
            return this.rseq_.getCell(icol);
        }

        public Object[] getRow() throws IOException {
            return this.rseq_.getRow();
        }

        public void close() throws IOException {
            this.rseq_.close();
        }
    }
}

