/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.matchers;

import java.io.Serializable;
import org.hamcrest.Description;
import org.mockito.ArgumentMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EqualsWithDelta
extends ArgumentMatcher<Number>
implements Serializable {
    private static final long serialVersionUID = 5066980489920383664L;
    private final Number wanted;
    private final Number delta;

    public EqualsWithDelta(Number value, Number delta) {
        this.wanted = value;
        this.delta = delta;
    }

    @Override
    public boolean matches(Object actual) {
        Number actualNumber = (Number)actual;
        return this.wanted.doubleValue() - this.delta.doubleValue() <= actualNumber.doubleValue() && actualNumber.doubleValue() <= this.wanted.doubleValue() + this.delta.doubleValue();
    }

    @Override
    public void describeTo(Description description) {
        description.appendText("eq(" + this.wanted + ", " + this.delta + ")");
    }
}

