/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.invocation;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.invocation.MockitoMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializableMethod
implements Serializable,
MockitoMethod {
    private static final long serialVersionUID = 6005610965006048445L;
    private Class<?> declaringClass;
    private String methodName;
    private Class<?>[] parameterTypes;
    private Class<?> returnType;
    private Class<?>[] exceptionTypes;
    private boolean isVarArgs;

    public SerializableMethod(Method method) {
        this.declaringClass = method.getDeclaringClass();
        this.methodName = method.getName();
        this.parameterTypes = method.getParameterTypes();
        this.returnType = method.getReturnType();
        this.exceptionTypes = method.getExceptionTypes();
        this.isVarArgs = method.isVarArgs();
    }

    @Override
    public String getName() {
        return this.methodName;
    }

    @Override
    public Class<?> getReturnType() {
        return this.returnType;
    }

    @Override
    public Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public Class<?>[] getExceptionTypes() {
        return this.exceptionTypes;
    }

    @Override
    public boolean isVarArgs() {
        return this.isVarArgs;
    }

    @Override
    public Method getJavaMethod() {
        try {
            return this.declaringClass.getDeclaredMethod(this.methodName, this.parameterTypes);
        }
        catch (SecurityException e) {
            String message = String.format("The method %1$s.%2$s is probably private or protected and cannot be mocked.\nPlease report this as a defect with an example of how to reproduce it.", this.declaringClass, this.methodName);
            throw new MockitoException(message, e);
        }
        catch (NoSuchMethodException e) {
            String message = String.format("The method %1$s.%2$s does not exists and you should not get to this point.\nPlease report this as a defect with an example of how to reproduce it.", this.declaringClass, this.methodName);
            throw new MockitoException(message, e);
        }
    }

    public int hashCode() {
        return 1;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SerializableMethod other = (SerializableMethod)obj;
        if (this.declaringClass == null ? other.declaringClass != null : !this.declaringClass.equals(other.declaringClass)) {
            return false;
        }
        if (this.methodName == null ? other.methodName != null : !this.methodName.equals(other.methodName)) {
            return false;
        }
        if (!Arrays.equals(this.parameterTypes, other.parameterTypes)) {
            return false;
        }
        return !(this.returnType == null ? other.returnType != null : !this.returnType.equals(other.returnType));
    }
}

