/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.handler;

import java.util.List;
import org.mockito.internal.InternalMockHandler;
import org.mockito.internal.progress.HandyReturnValues;
import org.mockito.internal.stubbing.InvocationContainer;
import org.mockito.invocation.Invocation;
import org.mockito.mock.MockCreationSettings;
import org.mockito.stubbing.VoidMethodStubbable;

class NullResultGuardian
implements InternalMockHandler {
    private final InternalMockHandler delegate;

    public NullResultGuardian(InternalMockHandler delegate) {
        this.delegate = delegate;
    }

    public Object handle(Invocation invocation) throws Throwable {
        Object result = this.delegate.handle(invocation);
        Class<?> returnType = invocation.getMethod().getReturnType();
        if (result == null && returnType.isPrimitive()) {
            return new HandyReturnValues().returnFor(returnType);
        }
        return result;
    }

    public MockCreationSettings getMockSettings() {
        return this.delegate.getMockSettings();
    }

    public VoidMethodStubbable voidMethodStubbable(Object mock) {
        return this.delegate.voidMethodStubbable(mock);
    }

    public void setAnswersForStubbing(List answers) {
        this.delegate.setAnswersForStubbing(answers);
    }

    public InvocationContainer getInvocationContainer() {
        return this.delegate.getInvocationContainer();
    }
}

