/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.acs.maci.manager.app;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Arrays;

public class RecoveryFilesRemover {
    public static void removeRecoveryFiles(File recoveryDirectory) {
        try {
            long limit = Long.MAX_VALUE;
            File lastSnapshot = RecoveryFilesRemover.removeSnapshots(recoveryDirectory, true, "snapshot", limit);
            limit = lastSnapshot != null ? RecoveryFilesRemover.number(lastSnapshot, "snapshot") : -1L;
            RecoveryFilesRemover.removeSnapshots(recoveryDirectory, false, "commandLog", limit);
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
    }

    public static File removeSnapshots(File recoveryDirectory, boolean leaveLast, String suffix, long limit) throws IOException {
        if (!recoveryDirectory.exists()) {
            return null;
        }
        Object[] snapshots = recoveryDirectory.listFiles(new SnapshotFilter(suffix, limit));
        if (snapshots == null) {
            throw new IOException("Error reading file list from directory " + recoveryDirectory);
        }
        Arrays.sort(snapshots);
        int lastNotToDelete = snapshots.length;
        if (leaveLast) {
            --lastNotToDelete;
        }
        for (int i = 0; i < lastNotToDelete; ++i) {
            ((File)snapshots[i]).delete();
        }
        if (snapshots.length > 0 && lastNotToDelete != snapshots.length) {
            return snapshots[lastNotToDelete];
        }
        return null;
    }

    private static long number(File snapshot, String suffix) throws NumberFormatException {
        String name = snapshot.getName();
        if (!name.endsWith("." + suffix)) {
            throw new NumberFormatException();
        }
        return Long.parseLong(name.substring(0, name.indexOf(46)));
    }

    private static class SnapshotFilter
    implements FileFilter {
        private String suffix;
        private long limit;

        public SnapshotFilter(String suffix, long limit) {
            this.suffix = suffix;
            this.limit = limit;
        }

        @Override
        public boolean accept(File file) {
            try {
                long n = RecoveryFilesRemover.number(file, this.suffix);
                if (n > this.limit) {
                    return false;
                }
            }
            catch (Throwable th) {
                return false;
            }
            return true;
        }
    }
}

