/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.operator;

import java.awt.geom.Rectangle2D;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import javax.media.jai.ROI;
import javax.media.jai.StatisticsOpImage;

class MinMaxOpImage
extends StatisticsOpImage {
    private double ignore;
    private static final String[] opNames = new String[]{"minmax"};

    public MinMaxOpImage(RenderedImage source, ROI roi, Integer xPeriod, Integer yPeriod, Double ignore) {
        super(source, roi, 0, 0, xPeriod.intValue(), yPeriod.intValue());
        this.ignore = ignore;
    }

    protected void accumulateStatistics(String name, Raster source, Object ar) {
        double[] stats = (double[])ar;
        DataBuffer dbuf = source.getDataBuffer();
        Rectangle2D rect = this.roi.getBounds().createIntersection(source.getBounds());
        int x0 = Math.max((int)rect.getX() - source.getMinX(), 0);
        int y0 = Math.max((int)rect.getY() - source.getMinY(), 0);
        int x1 = x0 + (int)rect.getWidth() - 1;
        int y1 = y0 + (int)rect.getHeight() - 1;
        int w = source.getWidth();
        if (this.xPeriod < this.width / 2 && this.yPeriod < this.height / 2) {
            x0 += this.xPeriod;
            y0 += this.yPeriod;
            x1 -= this.xPeriod;
            y1 -= this.yPeriod;
        }
        switch (dbuf.getDataType()) {
            case 0: {
                DataBufferByte dataBuffer = (DataBufferByte)source.getDataBuffer();
                byte[] data = dataBuffer.getData();
                short ignore = (short)this.ignore;
                this.getMinMaxByte(data, ignore, x0, y0, x1, y1, w, stats);
                break;
            }
            case 2: {
                DataBufferShort dataBuffer = (DataBufferShort)source.getDataBuffer();
                short[] data = dataBuffer.getData();
                short ignore = (short)this.ignore;
                this.getMinMaxShort(data, ignore, x0, y0, x1, y1, w, stats);
                break;
            }
            case 1: {
                DataBufferUShort dataBuffer = (DataBufferUShort)source.getDataBuffer();
                short[] data = dataBuffer.getData();
                int ignore = (int)this.ignore;
                this.getMinMaxUShort(data, ignore, x0, y0, x1, y1, w, stats);
                break;
            }
            case 3: {
                DataBufferInt dataBuffer = (DataBufferInt)source.getDataBuffer();
                int[] data = dataBuffer.getData();
                int ignore = (int)this.ignore;
                this.getMinMaxInt(data, ignore, x0, y0, x1, y1, w, stats);
                break;
            }
            case 4: {
                DataBufferFloat dataBuffer = (DataBufferFloat)source.getDataBuffer();
                float[] data = dataBuffer.getData();
                float ignore = (float)this.ignore;
                this.getMinMaxFloat(data, ignore, x0, y0, x1, y1, w, stats);
                break;
            }
            case 5: {
                DataBufferDouble dataBuffer = (DataBufferDouble)source.getDataBuffer();
                double[] data = dataBuffer.getData();
                double ignore = (float)this.ignore;
                this.getMinMaxDouble(data, ignore, x0, y0, x1, y1, w, stats);
                break;
            }
            default: {
                throw new IllegalArgumentException("MinMax not implemented for this data type");
            }
        }
    }

    void getMinMaxByte(byte[] data, short ignore, int x0, int y0, int x1, int y1, int w, double[] stats) {
        int j;
        int i;
        short max;
        short min;
        if (!Double.isNaN(stats[0])) {
            min = (short)stats[0];
            max = (short)stats[1];
        } else {
            min = data[0];
            if (min == ignore) {
                for (i = x0; i <= x1; i += this.xPeriod) {
                    for (j = y0; j <= y1 && (min = (short)data[i * w + j]) == ignore; j += this.yPeriod) {
                    }
                }
            }
            if (min == ignore) {
                min = 0;
            }
            max = min;
        }
        for (i = x0; i <= x1; i += this.xPeriod) {
            for (j = y0; j <= y1; j += this.yPeriod) {
                byte val = data[j * w + i];
                if (val == ignore) continue;
                if (val < min) {
                    min = val;
                    continue;
                }
                if (val <= max) continue;
                max = val;
            }
        }
        stats[0] = min;
        stats[1] = max;
    }

    void getMinMaxShort(short[] data, short ignore, int x0, int y0, int x1, int y1, int w, double[] stats) {
        int j;
        int i;
        short max;
        short min;
        if (!Double.isNaN(stats[0])) {
            min = (short)stats[0];
            max = (short)stats[1];
        } else {
            min = data[0];
            if (min == ignore) {
                for (i = x0; i <= x1; i += this.xPeriod) {
                    for (j = y0; j <= y1 && (min = data[i * w + j]) == ignore; j += this.yPeriod) {
                    }
                }
            }
            if (min == ignore) {
                min = 0;
            }
            max = min;
        }
        for (i = x0; i <= x1; i += this.xPeriod) {
            for (j = y0; j <= y1; j += this.yPeriod) {
                short val = data[j * w + i];
                if (val == ignore) continue;
                if (val < min) {
                    min = val;
                    continue;
                }
                if (val <= max) continue;
                max = val;
            }
        }
        stats[0] = min;
        stats[1] = max;
    }

    void getMinMaxUShort(short[] data, int ignore, int x0, int y0, int x1, int y1, int w, double[] stats) {
        int j;
        int i;
        int max;
        int min;
        if (!Double.isNaN(stats[0])) {
            min = (int)stats[0];
            max = (int)stats[1];
        } else {
            min = data[0] & 0xFFFF;
            if (min == ignore) {
                for (i = x0; i <= x1; i += this.xPeriod) {
                    for (j = y0; j <= y1 && (min = data[i * w + j]) == ignore; j += this.yPeriod) {
                    }
                }
            }
            if (min == ignore) {
                min = 0;
            }
            max = min;
        }
        for (i = x0; i <= x1; i += this.xPeriod) {
            for (j = y0; j <= y1; j += this.yPeriod) {
                int val = data[j * w + i] & 0xFFFF;
                if (val == ignore) continue;
                if (val < min) {
                    min = val;
                    continue;
                }
                if (val <= max) continue;
                max = val;
            }
        }
        stats[0] = min;
        stats[1] = max;
    }

    void getMinMaxInt(int[] data, int ignore, int x0, int y0, int x1, int y1, int w, double[] stats) {
        int j;
        int i;
        int max;
        int min;
        if (!Double.isNaN(stats[0])) {
            min = (int)stats[0];
            max = (int)stats[1];
        } else {
            min = data[0];
            if (min == ignore) {
                for (i = x0; i <= x1; i += this.xPeriod) {
                    for (j = y0; j <= y1 && (min = data[i * w + j]) == ignore; j += this.yPeriod) {
                    }
                }
            }
            if (min == ignore) {
                min = 0;
            }
            max = min;
        }
        for (i = x0; i <= x1; i += this.xPeriod) {
            for (j = y0; j <= y1; j += this.yPeriod) {
                int val = data[j * w + i];
                if (val == ignore) continue;
                if (val < min) {
                    min = val;
                    continue;
                }
                if (val <= max) continue;
                max = val;
            }
        }
        stats[0] = min;
        stats[1] = max;
    }

    void getMinMaxFloat(float[] data, float ignore, int x0, int y0, int x1, int y1, int w, double[] stats) {
        float mean;
        float max;
        float min;
        if (!Double.isNaN(stats[0])) {
            min = (float)stats[0];
            max = (float)stats[1];
            mean = (float)stats[2];
        } else {
            min = data[0];
            if (Float.isNaN(min) || min == ignore) {
                for (int i = x0; i <= x1; i += this.xPeriod) {
                    for (int j = y0; j <= y1 && (Float.isNaN(min = data[i * w + j]) || min == ignore); j += this.yPeriod) {
                    }
                }
            }
            if (Float.isNaN(min) || min == ignore) {
                min = 0.0f;
            }
            max = mean = min;
        }
        double sum = 0.0;
        int count = 0;
        for (int i = x0; i <= x1; i += this.xPeriod) {
            for (int j = y0; j <= y1; j += this.yPeriod) {
                float val = data[j * w + i];
                if (Float.isNaN(val) || val == ignore) continue;
                ++count;
                sum += (double)val;
                if (val < min) {
                    min = val;
                    continue;
                }
                if (!(val > max)) continue;
                max = val;
            }
        }
        stats[0] = min;
        stats[1] = max;
        stats[2] = (sum / (double)count + (double)mean) / 2.0;
    }

    void getMinMaxDouble(double[] data, double ignore, int x0, int y0, int x1, int y1, int w, double[] stats) {
        double mean;
        double max;
        double min;
        if (!Double.isNaN(stats[0])) {
            min = stats[0];
            max = stats[1];
            mean = stats[2];
        } else {
            min = data[0];
            if (Double.isNaN(min) || min == ignore) {
                for (int i = x0; i <= x1; i += this.xPeriod) {
                    for (int j = y0; j <= y1 && (Double.isNaN(min = data[i * w + j]) || min == ignore); j += this.yPeriod) {
                    }
                }
            }
            if (Double.isNaN(min) || min == ignore) {
                min = 0.0;
            }
            max = mean = min;
        }
        double sum = 0.0;
        int count = 0;
        for (int i = x0; i <= x1; i += this.xPeriod) {
            for (int j = y0; j <= y1; j += this.yPeriod) {
                double val = data[j * w + i];
                if (Double.isNaN(val) || val == ignore) continue;
                ++count;
                sum += val;
                if (val < min) {
                    min = val;
                    continue;
                }
                if (!(val > max)) continue;
                max = val;
            }
        }
        stats[0] = min;
        stats[1] = max;
        stats[2] = (sum / (double)count + mean) / 2.0;
    }

    protected Object createStatistics(String name) {
        double[] ar = new double[3];
        ar[2] = Double.NaN;
        ar[1] = Double.NaN;
        ar[0] = Double.NaN;
        return ar;
    }

    protected String[] getStatisticsNames() {
        return opNames;
    }
}

