/*
 * Decompiled with CFR 0.152.
 */
package jsky.interop;

import java.awt.Component;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.ListModel;
import jsky.catalog.Catalog;
import jsky.catalog.QueryResult;
import jsky.catalog.TableQueryResult;
import jsky.catalog.gui.CatalogNavigator;
import jsky.interop.JSkyServer;
import jsky.util.Resources;
import org.astrogrid.samp.Client;
import org.astrogrid.samp.Message;
import org.astrogrid.samp.Subscriptions;
import org.astrogrid.samp.gui.GuiHubConnector;
import org.astrogrid.samp.gui.IndividualCallActionManager;
import org.astrogrid.samp.gui.SubscribedClientListModel;
import org.astrogrid.samp.httpd.ServerResource;
import uk.ac.starlink.fits.FitsTableWriter;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableWriter;
import uk.ac.starlink.votable.VOTableWriter;

public class TableSendActionManager
extends IndividualCallActionManager {
    private static final Sender[] SENDERS = new Sender[]{new Sender("table.load.votable", "text/xml;x-votable", (StarTableWriter)new VOTableWriter(), ".vot"), new Sender("table.load.votable", "spectrum/votable", (StarTableWriter)new VOTableWriter(), ".vot"), new Sender("table.load.fits", "spectrum/fits", (StarTableWriter)new FitsTableWriter(), ".fits"), new Sender("spectrum.load.ssa-generic", "spectrum/votable", (StarTableWriter)new VOTableWriter(), ".vot"), new Sender("spectrum.load.ssa-generic", "spectrum/fits", (StarTableWriter)new FitsTableWriter(), ".fits")};
    private CatalogNavigator _navigator;
    private URL _url;
    private String _format;
    private Map _ucdMap;
    private static int _idCount;
    private static Map<String, String> _idMap;

    static {
        _idMap = new HashMap<String, String>();
    }

    public TableSendActionManager(CatalogNavigator parent, GuiHubConnector connector, URL url, String format, Map ucdMap) {
        super((Component)parent, connector, (ListModel)new SubscribedClientListModel(connector, TableSendActionManager.getSendMtypes()));
        this._navigator = parent;
        this._url = url;
        this._format = format;
        this._ucdMap = ucdMap;
    }

    protected Map createMessage(Client client) throws Exception {
        Sender sender = this.getSender(client, this._format);
        if (sender != null) {
            if (this._url != null) {
                String sampId = this.createSampId();
                return sender.createMessage(this._navigator, this._url, sampId, this._ucdMap);
            }
            String sampId = this.getSampId();
            StarTable table = this._navigator.getStarTable();
            if (table != null) {
                String label = sampId;
                QueryResult queryResult = this._navigator.getQueryResult();
                if (queryResult instanceof Catalog) {
                    label = ((Catalog)queryResult).getTitle();
                }
                return sender.createMessage(this._navigator, table, label, sampId, this._ucdMap);
            }
        }
        return null;
    }

    private String getSampId() {
        String tableId;
        QueryResult queryResult = this._navigator.getQueryResult();
        if (queryResult instanceof TableQueryResult && (tableId = ((TableQueryResult)queryResult).getId()) != null) {
            String sampId = _idMap.get(tableId);
            if (sampId != null) {
                return sampId;
            }
            sampId = this.createSampId();
            _idMap.put(tableId, sampId);
            return sampId;
        }
        return this.createSampId();
    }

    private String createSampId() {
        return "jsky" + Integer.toString(System.identityHashCode((Object)this) & 0xFFFF, 16) + "-" + ++_idCount;
    }

    static String getSampId(String tableId) {
        String sampId;
        if (tableId != null && (sampId = _idMap.get(tableId)) != null) {
            return sampId;
        }
        return null;
    }

    private Sender getSender(Client client, String format) {
        Subscriptions subs = client.getSubscriptions();
        Sender[] senderArray = SENDERS;
        int n = SENDERS.length;
        int n2 = 0;
        while (n2 < n) {
            Sender sender = senderArray[n2];
            if (subs.isSubscribed(sender.getMtype()) && (format == null || format.equals(sender.getFormat()))) {
                return sender;
            }
            ++n2;
        }
        return null;
    }

    public JMenu createSendMenu() {
        JMenu menu = super.createSendMenu("Send Table to...");
        menu.setToolTipText("Send table to a single other registered client using SAMP");
        menu.setIcon(Resources.getIcon((String)"phone2.gif"));
        return menu;
    }

    private static String[] getSendMtypes() {
        String[] mtypes = new String[SENDERS.length];
        int i = 0;
        while (i < SENDERS.length) {
            mtypes[i] = SENDERS[i].getMtype();
            ++i;
        }
        return mtypes;
    }

    private static class Sender {
        private final String _mtype;
        private final String _format;
        private final StarTableWriter _writer;
        private final String _extension;

        Sender(String mtype, String format, StarTableWriter writer, String extension) {
            this._mtype = mtype;
            this._format = format;
            this._writer = writer;
            this._extension = extension;
        }

        public String getMtype() {
            return this._mtype;
        }

        public String getFormat() {
            return this._format;
        }

        protected Message createMessage(CatalogNavigator navigator, StarTable table, String label, String sampId, Map ucdMap) throws IOException {
            String name = "t" + sampId + this._extension;
            URL turl = JSkyServer.getInstance().addResource(name, this.createResource(table));
            navigator.registerTable(turl, sampId);
            if (this._mtype.startsWith("spectrum")) {
                return new Message(this._mtype).addParam("url", (Object)turl.toString()).addParam("id", (Object)sampId).addParam("meta", (Object)ucdMap);
            }
            return new Message(this._mtype).addParam("url", (Object)turl.toString()).addParam("table-id", (Object)sampId).addParam("name", (Object)label);
        }

        protected Message createMessage(CatalogNavigator navigator, URL url, String sampId, Map ucdMap) throws IOException {
            navigator.registerTable(url, sampId);
            if (this._mtype.startsWith("spectrum")) {
                return new Message(this._mtype).addParam("url", (Object)url.toString()).addParam("id", (Object)sampId).addParam("meta", (Object)ucdMap);
            }
            return new Message(this._mtype).addParam("url", (Object)url.toString()).addParam("table-id", (Object)sampId).addParam("name", (Object)sampId);
        }

        private ServerResource createResource(final StarTable table) {
            return new ServerResource(){

                public long getContentLength() {
                    return -1L;
                }

                public String getContentType() {
                    return _writer.getMimeType();
                }

                public void writeBody(OutputStream out) throws IOException {
                    _writer.writeStarTable(table, out);
                }
            };
        }

        public String toString() {
            return this._mtype;
        }
    }
}

