/*
 * Decompiled with CFR 0.152.
 */
package jsky.interop;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import jsky.util.Resources;
import org.astrogrid.samp.client.ClientProfile;
import org.astrogrid.samp.httpd.HttpServer;
import org.astrogrid.samp.httpd.ServerResource;
import org.astrogrid.samp.xmlrpc.SampXmlRpcClientFactory;
import org.astrogrid.samp.xmlrpc.SampXmlRpcServer;
import org.astrogrid.samp.xmlrpc.SampXmlRpcServerFactory;
import org.astrogrid.samp.xmlrpc.StandardClientProfile;
import org.astrogrid.samp.xmlrpc.internal.InternalClientFactory;
import org.astrogrid.samp.xmlrpc.internal.InternalServer;

public class JSkyServer {
    private final HttpServer httpServer_ = new HttpServer();
    private final ResourceHandler resourceHandler_;
    private final SampXmlRpcServerFactory xServerFactory_;
    private final SampXmlRpcClientFactory xClientFactory_;
    private final ClientProfile profile_;
    private final URL pkgUrl_;
    private boolean started_;
    private static JSkyServer instance_;
    private static Logger logger_;
    private static final int BUFSIZ = 16384;

    static {
        logger_ = Logger.getLogger(JSkyServer.class.getName());
    }

    private JSkyServer() throws IOException {
        this.httpServer_.setDaemon(true);
        this.resourceHandler_ = new ResourceHandler(this.httpServer_, "/dynamic");
        this.httpServer_.addHandler((HttpServer.Handler)this.resourceHandler_);
        URL url = Resources.getResource((String)"images");
        this.httpServer_.addHandler((HttpServer.Handler)new ClassLoaderHandler(url, "/"));
        this.pkgUrl_ = new URL(this.httpServer_.getBaseUrl(), "");
        this.xClientFactory_ = new InternalClientFactory();
        InternalServer xServer = new InternalServer(this.httpServer_, "/xmlrpc");
        this.xServerFactory_ = new SampXmlRpcServerFactory((SampXmlRpcServer)xServer){
            private final /* synthetic */ SampXmlRpcServer val$xServer;
            {
                this.val$xServer = sampXmlRpcServer;
            }

            public SampXmlRpcServer getServer() {
                JSkyServer.this.checkStarted();
                return this.val$xServer;
            }
        };
        this.profile_ = new StandardClientProfile(this.xClientFactory_, this.xServerFactory_);
    }

    public ClientProfile getProfile() {
        return this.profile_;
    }

    public SampXmlRpcClientFactory getSampClientFactory() {
        return this.xClientFactory_;
    }

    public SampXmlRpcServerFactory getSampServerFactory() {
        return this.xServerFactory_;
    }

    public URL addResource(String name, ServerResource resource) {
        this.checkStarted();
        return this.resourceHandler_.addResource(name == null ? "" : name, resource);
    }

    public void expireResource(URL url) {
        this.resourceHandler_.expireResource(url);
    }

    public URL getJSkyPackageUrl() {
        return this.pkgUrl_;
    }

    public boolean isFound(URL url) {
        this.checkStarted();
        try {
            URLConnection connection = url.openConnection();
            if (connection instanceof HttpURLConnection) {
                HttpURLConnection hconn = (HttpURLConnection)connection;
                hconn.setRequestMethod("HEAD");
                hconn.setDoOutput(false);
                hconn.connect();
                InputStream in = connection.getInputStream();
                byte[] buf = new byte[16384];
                while (in.read(buf) >= 0) {
                }
                in.close();
                return hconn.getResponseCode() == 200;
            }
            connection.connect();
            InputStream in = connection.getInputStream();
            byte[] buf = new byte[16384];
            while (in.read(buf) >= 0) {
            }
            in.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkStarted() {
        if (!this.started_) {
            HttpServer httpServer = this.httpServer_;
            synchronized (httpServer) {
                if (!this.started_) {
                    this.started_ = true;
                    this.httpServer_.start();
                }
            }
        }
    }

    public static JSkyServer getInstance() throws IOException {
        if (instance_ == null) {
            instance_ = new JSkyServer();
        }
        return instance_;
    }

    private static class ClassLoaderHandler
    implements HttpServer.Handler {
        private final URL baseResource_;
        private final String basePath_;

        ClassLoaderHandler(URL baseResource, String basePath) {
            this.baseResource_ = baseResource;
            this.basePath_ = basePath;
        }

        public HttpServer.Response serveRequest(HttpServer.Request request) {
            URLConnection conn;
            String path = request.getUrl();
            if (!path.startsWith(this.basePath_)) {
                return null;
            }
            String method = request.getMethod();
            String relPath = path.substring(this.basePath_.length());
            try {
                URL resource = new URL(this.baseResource_, relPath);
                conn = resource.openConnection();
                conn.connect();
            }
            catch (IOException e) {
                return HttpServer.createErrorResponse((int)404, (String)"Not found", (Throwable)e);
            }
            try {
                String contentEncoding;
                int contentLength;
                HashMap<String, String> hdrMap = new HashMap<String, String>();
                String contentType = conn.getContentType();
                if (contentType != null) {
                    hdrMap.put("Content-Type", contentType);
                }
                if ((contentLength = conn.getContentLength()) >= 0) {
                    hdrMap.put("Content-Length", Integer.toString(contentLength));
                }
                if ((contentEncoding = conn.getContentEncoding()) != null) {
                    hdrMap.put("Content-Encoding", contentEncoding);
                }
                if ("GET".equals(method)) {
                    return new HttpServer.Response(200, "OK", hdrMap){

                        public void writeBody(OutputStream out) throws IOException {
                            byte[] buf = new byte[16384];
                            try (InputStream in = conn.getInputStream();){
                                int nb;
                                while ((nb = in.read(buf)) >= 0) {
                                    out.write(buf, 0, nb);
                                }
                                out.flush();
                            }
                        }
                    };
                }
                if ("HEAD".equals(method)) {
                    return new HttpServer.Response(200, "OK", hdrMap){

                        public void writeBody(OutputStream out) {
                        }
                    };
                }
                return HttpServer.createErrorResponse((int)405, (String)"Unsupported method");
            }
            catch (Exception e) {
                return HttpServer.createErrorResponse((int)500, (String)"Internal server error", (Throwable)e);
            }
        }
    }

    private static class ResourceHandler
    implements HttpServer.Handler {
        private final String basePath_;
        private final URL serverUrl_;
        private final Map<String, ServerResource> resourceMap_;
        private int iRes_;
        private static final ServerResource EXPIRED = new ServerResource(){

            public String getContentType() {
                throw new AssertionError();
            }

            public long getContentLength() {
                throw new AssertionError();
            }

            public void writeBody(OutputStream out) {
                throw new AssertionError();
            }
        };

        public ResourceHandler(HttpServer server, String basePath) {
            if (!basePath.startsWith("/")) {
                basePath = "/" + basePath;
            }
            if (!basePath.endsWith("/")) {
                basePath = String.valueOf(basePath) + "/";
            }
            this.basePath_ = basePath;
            this.serverUrl_ = server.getBaseUrl();
            this.resourceMap_ = new HashMap<String, ServerResource>();
        }

        public synchronized URL addResource(String name, ServerResource resource) {
            String path = String.valueOf(this.basePath_) + Integer.toString(++this.iRes_) + "/";
            if (name != null) {
                path = String.valueOf(path) + name;
            }
            this.resourceMap_.put(path, resource);
            try {
                URL url = new URL(this.serverUrl_, path);
                logger_.info("Resource added: " + url);
                return new URL(this.serverUrl_, path);
            }
            catch (MalformedURLException e) {
                throw new AssertionError((Object)"Unknown protocol http??");
            }
        }

        public synchronized void expireResource(URL url) {
            String path = url.getPath();
            if (!this.resourceMap_.containsKey(path)) {
                throw new IllegalArgumentException("Unknown URL to expire: " + url);
            }
            logger_.info("Resource expired: " + url);
            this.resourceMap_.put(path, EXPIRED);
        }

        public HttpServer.Response serveRequest(HttpServer.Request request) {
            String path = request.getUrl();
            if (!path.startsWith(this.basePath_)) {
                return null;
            }
            final ServerResource resource = this.resourceMap_.get(path);
            if (resource == EXPIRED) {
                return HttpServer.createErrorResponse((int)410, (String)"Gone");
            }
            if (resource != null) {
                String method;
                HashMap<String, String> hdrMap = new HashMap<String, String>();
                hdrMap.put("Content-Type", resource.getContentType());
                long contentLength = resource.getContentLength();
                if (contentLength >= 0L) {
                    hdrMap.put("Content-Length", Long.toString(contentLength));
                }
                if ((method = request.getMethod()).equals("HEAD")) {
                    return new HttpServer.Response(200, "OK", hdrMap){

                        public void writeBody(OutputStream out) {
                        }
                    };
                }
                if (method.equals("GET")) {
                    return new HttpServer.Response(200, "OK", hdrMap){

                        public void writeBody(OutputStream out) throws IOException {
                            resource.writeBody(out);
                        }
                    };
                }
                return HttpServer.createErrorResponse((int)405, (String)"Unsupported method");
            }
            return HttpServer.createErrorResponse((int)404, (String)"Not found");
        }
    }
}

