/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog.gui.html;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import jsky.catalog.gui.html.HTMLViewer;
import jsky.util.Preferences;
import jsky.util.gui.GenericToolBar;

public class HTMLViewerMenuBar
extends JMenuBar {
    protected HTMLViewer htmlViewer;
    protected GenericToolBar toolBar;
    protected JMenu fileMenu;
    protected JMenu viewMenu;
    protected JMenu goMenu;
    protected static HTMLViewer currentHTMLViewer;

    public HTMLViewerMenuBar(final HTMLViewer htmlViewer, GenericToolBar toolBar) {
        this.htmlViewer = htmlViewer;
        this.toolBar = toolBar;
        this.fileMenu = this.createFileMenu();
        this.add(this.fileMenu);
        this.viewMenu = this.createViewMenu();
        this.add(this.viewMenu);
        this.goMenu = this.createGoMenu(null);
        this.add(this.goMenu);
        this.goMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                currentHTMLViewer = htmlViewer;
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        htmlViewer.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                HTMLViewerMenuBar.this.goMenu.removeAll();
                HTMLViewerMenuBar.this.createGoMenu(HTMLViewerMenuBar.this.goMenu);
            }
        });
    }

    public static HTMLViewer getCurrentHTMLViewer() {
        return currentHTMLViewer;
    }

    public static void setCurrentHTMLViewer(HTMLViewer htmlViewer) {
        currentHTMLViewer = htmlViewer;
    }

    protected JMenu createFileMenu() {
        JMenu menu = new JMenu("File");
        menu.add(this.htmlViewer.getOpenAction());
        menu.addSeparator();
        menu.add(this.createFileOpenURLMenuItem());
        menu.addSeparator();
        menu.add(this.createFileCloseMenuItem());
        return menu;
    }

    protected JMenuItem createFileOpenURLMenuItem() {
        JMenuItem menuItem = new JMenuItem("Open URL...");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                HTMLViewerMenuBar.this.htmlViewer.openURL();
            }
        });
        return menuItem;
    }

    protected JMenuItem createFileCloseMenuItem() {
        JMenuItem menuItem = new JMenuItem("Close");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                HTMLViewerMenuBar.this.htmlViewer.close();
            }
        });
        return menuItem;
    }

    protected JMenu createViewMenu() {
        JMenu menu = new JMenu("View");
        menu.add(this.createViewToolBarMenuItem());
        menu.add(this.createViewShowToolBarAsMenu());
        return menu;
    }

    protected JCheckBoxMenuItem createViewToolBarMenuItem() {
        JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem("Toolbar");
        final String prefName = String.valueOf(this.getClass().getName()) + ".ShowToolBar";
        menuItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JCheckBoxMenuItem rb = (JCheckBoxMenuItem)e.getSource();
                HTMLViewerMenuBar.this.toolBar.setVisible(rb.getState());
                if (rb.getState()) {
                    Preferences.set((String)prefName, (String)"true");
                } else {
                    Preferences.set((String)prefName, (String)"false");
                }
            }
        });
        String pref = Preferences.get((String)prefName);
        if (pref != null) {
            menuItem.setState(pref.equals("true"));
        } else {
            menuItem.setState(true);
        }
        return menuItem;
    }

    protected JMenu createViewShowToolBarAsMenu() {
        JMenu menu = new JMenu("Show Toolbar As");
        JRadioButtonMenuItem b1 = new JRadioButtonMenuItem("Pictures and Text");
        JRadioButtonMenuItem b2 = new JRadioButtonMenuItem("Pictures Only");
        JRadioButtonMenuItem b3 = new JRadioButtonMenuItem("Text Only");
        b1.setSelected(true);
        this.toolBar.setShowPictures(true);
        this.toolBar.setShowText(true);
        menu.add(b1);
        menu.add(b2);
        menu.add(b3);
        ButtonGroup group = new ButtonGroup();
        group.add(b1);
        group.add(b2);
        group.add(b3);
        final String prefName = String.valueOf(this.getClass().getName()) + ".ShowToolBarAs";
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JRadioButtonMenuItem rb = (JRadioButtonMenuItem)e.getSource();
                if (rb.isSelected()) {
                    if (rb.getText().equals("Pictures and Text")) {
                        HTMLViewerMenuBar.this.toolBar.setShowPictures(true);
                        HTMLViewerMenuBar.this.toolBar.setShowText(true);
                        Preferences.set((String)prefName, (String)"1");
                    } else if (rb.getText().equals("Pictures Only")) {
                        HTMLViewerMenuBar.this.toolBar.setShowPictures(true);
                        HTMLViewerMenuBar.this.toolBar.setShowText(false);
                        Preferences.set((String)prefName, (String)"2");
                    } else if (rb.getText().equals("Text Only")) {
                        HTMLViewerMenuBar.this.toolBar.setShowPictures(false);
                        HTMLViewerMenuBar.this.toolBar.setShowText(true);
                        Preferences.set((String)prefName, (String)"3");
                    }
                }
            }
        };
        b1.addItemListener(itemListener);
        b2.addItemListener(itemListener);
        b3.addItemListener(itemListener);
        String pref = Preferences.get((String)prefName);
        if (pref != null) {
            JRadioButtonMenuItem[] jRadioButtonMenuItemArray = new JRadioButtonMenuItem[4];
            jRadioButtonMenuItemArray[1] = b1;
            jRadioButtonMenuItemArray[2] = b2;
            jRadioButtonMenuItemArray[3] = b3;
            JRadioButtonMenuItem[] ar = jRadioButtonMenuItemArray;
            try {
                ar[Integer.parseInt(pref)].setSelected(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return menu;
    }

    protected JMenu createGoMenu(JMenu menu) {
        if (menu == null) {
            menu = new JMenu("Go");
        }
        menu.add(this.htmlViewer.getBackAction());
        menu.add(this.htmlViewer.getForwAction());
        menu.addSeparator();
        this.htmlViewer.addHistoryMenuItems(menu);
        menu.addSeparator();
        menu.add(this.createGoClearHistoryMenuItem());
        return menu;
    }

    protected JMenuItem createGoClearHistoryMenuItem() {
        JMenuItem menuItem = new JMenuItem("Clear History");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                HTMLViewerMenuBar.this.htmlViewer.clearHistory();
                HTMLViewerMenuBar.this.goMenu.removeAll();
                HTMLViewerMenuBar.this.createGoMenu(HTMLViewerMenuBar.this.goMenu);
            }
        });
        return menuItem;
    }

    public JMenu getFileMenu() {
        return this.fileMenu;
    }

    public JMenu getViewMenu() {
        return this.viewMenu;
    }

    public JMenu getGoMenu() {
        return this.goMenu;
    }
}

