/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import jsky.catalog.TableQueryResult;
import jsky.catalog.gui.TableDisplay;
import jsky.util.I18N;
import jsky.util.gui.JTextAreaCellEditor;
import jsky.util.gui.JTextAreaCellRenderer;
import jsky.util.gui.TableUtil;

public class TableColumnConfigPanel
extends JPanel {
    private static final I18N _I18N = I18N.getInstance(TableColumnConfigPanel.class);
    private static final int SHOW_COL = 0;
    private static final int DESCRIPTION_COL = 3;
    private TableDisplay _tableDisplay;
    private JTable _table;
    private Vector<String> _columnNames;

    public TableColumnConfigPanel(TableDisplay tableDisplay) {
        this._tableDisplay = tableDisplay;
        this._table = new JTable();
        this._table.setRowSelectionAllowed(true);
        this._table.setColumnSelectionAllowed(false);
        this._table.setRowHeight(20);
        this._table.setGridColor(Color.gray);
        this._table.setShowGrid(true);
        this._table.setAutoResizeMode(0);
        JTableHeader header = this._table.getTableHeader();
        header.setUpdateTableInRealTime(false);
        header.setFont(header.getFont().deriveFont(1));
        this._columnNames = new Vector(4);
        this._columnNames.add(_I18N.getString("showQM"));
        this._columnNames.add(_I18N.getString("colName"));
        this._columnNames.add("UCD");
        this._columnNames.add(_I18N.getString("description"));
        this.setModel(this._tableDisplay.getTableQueryResult());
        this.setLayout(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane(this._table, 20, 30);
        this.add((Component)scrollPane, "Center");
    }

    public void setModel(TableQueryResult model) {
        String[] columnIdentifiers = this._getColumnIdentifiers(model);
        boolean[] show = this._tableDisplay.getShow();
        Vector data = new Vector(columnIdentifiers.length);
        if (show != null && show.length != columnIdentifiers.length) {
            show = null;
        }
        int i = 0;
        while (i < columnIdentifiers.length) {
            Vector<Object> row = new Vector<Object>(4);
            row.add(show != null ? show[i] : Boolean.TRUE);
            row.add(columnIdentifiers[i]);
            row.add(model.getColumnDesc(i).getUCD());
            row.add(model.getColumnDesc(i).getDescription());
            data.add(row);
            ++i;
        }
        this._table.setModel(new DefaultTableModel(data, this._columnNames){

            public Class getColumnClass(int columnIndex) {
                if (columnIndex == 0) {
                    return Boolean.class;
                }
                return String.class;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return true;
            }
        });
        TableColumn col = this._table.getColumnModel().getColumn(3);
        col.setCellRenderer((TableCellRenderer)new JTextAreaCellRenderer());
        col.setCellEditor((TableCellEditor)new JTextAreaCellEditor(this._table));
        col.setPreferredWidth(500);
        col.setMinWidth(500);
        TableUtil.initColumnSizes((JTable)this._table, (boolean[])show);
    }

    private String[] _getColumnIdentifiers(TableQueryResult model) {
        String[] ar = new String[model.getColumnCount()];
        int i = 0;
        while (i < ar.length) {
            ar[i] = model.getColumnName(i);
            ++i;
        }
        return ar;
    }

    public void apply() {
        DefaultTableModel model = (DefaultTableModel)this._table.getModel();
        Vector<Vector> data = model.getDataVector();
        int numCols = data.size();
        boolean[] show = new boolean[numCols];
        int i = 0;
        while (i < numCols) {
            Vector row = data.get(i);
            show[i] = (Boolean)row.get(0);
            ++i;
        }
        this._tableDisplay.setShow(show);
        this._tableDisplay.reorderColumns();
    }

    public void cancel() {
        this.setModel(this._tableDisplay.getTableQueryResult());
    }
}

