/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import jsky.catalog.BasicQueryArgs;
import jsky.catalog.Catalog;
import jsky.catalog.FieldDesc;
import jsky.catalog.FieldFormat;
import jsky.catalog.QueryArgs;
import jsky.catalog.TableQueryResult;
import jsky.util.Storeable;
import jsky.util.gui.GridBagUtil;

public class CatalogQueryPanel
extends JPanel
implements ActionListener,
Storeable {
    protected static final Insets LABEL_INSETS = new Insets(6, 6, 0, 0);
    protected static final Insets VALUE_INSETS = new Insets(6, 6, 0, 3);
    private Catalog _catalog;
    private JLabel[] _labels;
    private JComponent[] _components;
    private EventListenerList _actionListenerList = new EventListenerList();
    private EventListenerList _changeListenerList = new EventListenerList();
    protected NumberFormat nf = NumberFormat.getInstance(Locale.US);
    private GridBagUtil _layout = new GridBagUtil((Container)this);
    private int _numCols;
    protected static final Dimension MIN_COMPONENT_SIZE = new Dimension(80, 21);

    public CatalogQueryPanel(Catalog catalog, int numCols) {
        this._catalog = catalog;
        this._numCols = numCols;
        this.nf.setGroupingUsed(false);
        this.makePanelItems();
        this.doGridBagLayout(this._layout);
    }

    public CatalogQueryPanel(Catalog catalog) {
        this(catalog, 2);
    }

    protected CatalogQueryPanel(Catalog catalog, int numCols, boolean doLayout) {
        this._catalog = catalog;
        this._numCols = numCols;
        this.nf.setGroupingUsed(false);
        if (doLayout) {
            this.makePanelItems();
            this.doGridBagLayout(this._layout);
        }
    }

    protected int getNumCols() {
        return this._numCols;
    }

    public void update() {
        QueryArgs queryArgs = this.getQueryArgs();
        this.removePanelItems();
        this.makePanelItems();
        this.doGridBagLayout(this._layout);
        this.setQueryArgs(queryArgs);
        this.revalidate();
        this.repaint();
    }

    public void addActionListener(ActionListener l) {
        this._actionListenerList.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        this._actionListenerList.remove(ActionListener.class, l);
    }

    protected void fireActionEvent() {
        Object[] listeners = this._actionListenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ActionListener.class) {
                ((ActionListener)listeners[i + 1]).actionPerformed(new ActionEvent(this, 0, null));
            }
            i -= 2;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.fireActionEvent();
    }

    public void addChangeListener(ChangeListener l) {
        this._changeListenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this._changeListenerList.remove(ChangeListener.class, l);
    }

    protected void fireChange(JComponent c) {
        Object[] listeners = this._changeListenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ChangeListener.class) {
                ((ChangeListener)listeners[i + 1]).stateChanged(new ChangeEvent(c));
            }
            i -= 2;
        }
    }

    protected JLabel makeLabel(String s, String tip) {
        if (s == null) {
            return null;
        }
        JLabel label = new JLabel(s, 2);
        if (tip != null && tip.length() != 0) {
            label.setToolTipText(tip);
        }
        return label;
    }

    public Catalog getCatalog() {
        return this._catalog;
    }

    protected JComponent makeComponent(FieldDesc p, String tip) {
        JComponent result;
        if (p.getNumOptions() > 0) {
            result = this.makeComboBox(p);
        } else {
            JTextField tf = this.makeTextField(10);
            Object o = p.getDefaultValue();
            if (o != null) {
                tf.setText(o.toString());
            }
            result = tf;
        }
        if (tip != null && tip.length() != 0) {
            result.setToolTipText(tip);
        }
        return result;
    }

    protected JTextField makeTextField(int width) {
        JTextField tf = new JTextField(width);
        tf.addActionListener(this);
        return tf;
    }

    protected JCheckBox makeCheckBox() {
        return new JCheckBox();
    }

    protected JComponent makeComboBox(FieldDesc p) {
        int def;
        int n = p.getNumOptions();
        final JComboBox<String> cb = new JComboBox<String>();
        String s = p.getDescription();
        if (s != null) {
            cb.setToolTipText(s);
        }
        if ((def = p.getDefaultOptionIndex()) == -1) {
            cb.addItem("");
        }
        int i = 0;
        while (i < n) {
            cb.addItem(p.getOptionName(i));
            ++i;
        }
        cb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CatalogQueryPanel.this.fireChange(cb);
            }
        });
        cb.setPreferredSize(MIN_COMPONENT_SIZE);
        return cb;
    }

    protected void makePanelItems() {
        int n = this._catalog.getNumParams();
        this._labels = new JLabel[n];
        this._components = new JComponent[n];
        int i = 0;
        while (i < n) {
            FieldDesc p = this._catalog.getParamDesc(i);
            if (p == null || "hidden".equals(p.getType())) {
                this._labels[i] = null;
                this._components[i] = null;
            } else {
                String tip;
                String s = p.getDisplayName();
                if (s == null) {
                    s = "Field" + (i + 1);
                }
                if ((tip = p.getDescription()) != null && tip.length() != 0) {
                    tip = "<html>" + tip.replace(". ", ".<br>") + "</html>";
                }
                this._labels[i] = this.makeLabel(s, tip);
                this._components[i] = this.makeComponent(p, tip);
            }
            ++i;
        }
    }

    protected void removePanelItems() {
        int i = 0;
        while (i < this._labels.length) {
            if (this._labels[i] != null) {
                this.remove(this._labels[i]);
            }
            if (this._components[i] != null) {
                this.remove(this._components[i]);
            }
            ++i;
        }
    }

    public String getLabelForComponent(JComponent c) {
        int i = 0;
        while (i < this._labels.length) {
            if (this._components[i] == c) {
                return this._labels[i].getText();
            }
            ++i;
        }
        return null;
    }

    public JComponent getComponentForLabel(String s) {
        int i = 0;
        while (i < this._labels.length) {
            if (this._labels[i].getText().equals(s)) {
                return this._components[i];
            }
            ++i;
        }
        return null;
    }

    protected int doGridBagLayout(GridBagUtil layout) {
        String desc;
        int row = 0;
        int col = 0;
        int n = this._catalog.getNumParams();
        int i = 0;
        while (i < n) {
            if (this._labels[i] != null || this._components[i] != null) {
                if (this._labels[i] != null) {
                    layout.add((Component)this._labels[i], col, row, 1, 1, 0.0, 0.0, 0, 17, LABEL_INSETS);
                }
                ++col;
                if (this._components[i] != null) {
                    layout.add((Component)this._components[i], col, row, 1, 1, 1.0, 0.0, 2, 17, VALUE_INSETS);
                }
                if (++col >= this._numCols) {
                    col = 0;
                    ++row;
                }
            }
            ++i;
        }
        if (col != 0) {
            col = 0;
            ++row;
        }
        if ((desc = this._catalog.getDescription()) != null) {
            JLabel label = new JLabel(desc);
            layout.add((Component)label, col, row, this._numCols, 1, 1.0, 0.0, 2, 17, LABEL_INSETS);
            ++row;
        }
        return row;
    }

    public void initQueryArgs(QueryArgs queryArgs) {
        int n = Math.min(this._components.length, this._catalog.getNumParams());
        int i = 0;
        while (i < n) {
            if (this._components[i] != null) {
                queryArgs.setParamValue(i, this.getValue(i));
            }
            ++i;
        }
    }

    public QueryArgs getQueryArgs() {
        BasicQueryArgs queryArgs = new BasicQueryArgs(this._catalog);
        this.initQueryArgs((QueryArgs)queryArgs);
        return queryArgs;
    }

    public void setQueryArgs(QueryArgs queryArgs) {
        int n = Math.min(this._components.length, this._catalog.getNumParams());
        int i = 0;
        while (i < n) {
            Object value = queryArgs.getParamValue(i);
            if (value != null) {
                this.setValue(i, value);
            }
            ++i;
        }
    }

    protected Object getValue(FieldDesc p, JComponent c) {
        if (p.getNumOptions() > 0) {
            JComboBox cb = (JComboBox)c;
            String s = (String)cb.getSelectedItem();
            if (s != null && s.length() != 0) {
                int n = p.getNumOptions();
                int j = 0;
                while (j < n) {
                    if (p.getOptionName(j).equals(s)) {
                        return p.getOptionValue(j);
                    }
                    ++j;
                }
            }
            return null;
        }
        String s = ((JTextField)c).getText();
        if (s == null || s.length() == 0) {
            return null;
        }
        if (this._catalog instanceof TableQueryResult) {
            return FieldFormat.getValueRange((FieldDesc)p, (String)s);
        }
        return FieldFormat.getValue((FieldDesc)p, (String)s);
    }

    protected Object getValue(int i) {
        return this.getValue(this._catalog.getParamDesc(i), this._components[i]);
    }

    protected void setValue(int i, Object value) {
        this.setValue(this._components[i], value);
    }

    protected void setValue(String label, Object value) {
        int n = this._catalog.getNumParams();
        int i = 0;
        while (i < n) {
            FieldDesc param = this._catalog.getParamDesc(i);
            if (param != null) {
                String name = param.getName();
                String id = param.getId();
                if (id != null && id.equalsIgnoreCase(label) || name != null && name.equalsIgnoreCase(label)) {
                    this.setValue(i, value);
                    return;
                }
            }
            ++i;
        }
    }

    protected void setValue(JComponent c, Object value) {
        if (c instanceof JTextField) {
            String s = value instanceof Double ? this.nf.format((Double)value) : value.toString();
            ((JTextField)c).setText(s);
        } else if (c instanceof JComboBox) {
            ((JComboBox)c).setSelectedItem(value);
            c.repaint();
        }
    }

    public Object storeSettings() {
        Hashtable<String, Object> map = new Hashtable<String, Object>();
        int n = Math.min(this._components.length, this._catalog.getNumParams());
        int i = 0;
        while (i < n) {
            if (this._components[i] != null) {
                String name = this._catalog.getParamDesc(i).getName();
                Object value = this.getValue(i);
                if (name != null && value instanceof Serializable) {
                    map.put(name, value);
                }
            }
            ++i;
        }
        return map;
    }

    public boolean restoreSettings(Object obj) {
        if (obj instanceof Hashtable) {
            Hashtable map = (Hashtable)obj;
            Enumeration e = map.keys();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                Object value = map.get(name);
                this.setValue(name, value);
            }
            return true;
        }
        return false;
    }
}

