/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.util.debug;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.Entity;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.bo.Referring;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.ot.persistence.Apdm_to_BO;
import alma.obsprep.util.MiscUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;

public class ModelDebugger
extends JPanel {
    Apdm_to_BO.BoBundle content;
    JPanel treeControls;
    JTree tree;
    TreeModel tm;
    TreeRenderer tr;
    TreeListener tl;
    JTextArea text;
    JLabel lblTableInfo = new JLabel();
    TableTools pnlTableTools;
    TableSearchPanel pnlTableSearch;
    TableSaveToFile pnlTableSave;
    JTextArea rowDetails;
    BusinessObject.TracingInterface traceIF = new BusinessObject.TracingInterface(){
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");

        public void structureChanged(boolean bl, BusinessObject businessObject, IBusinessObject iBusinessObject, Referring.By by) {
            this.append(iBusinessObject, bl ? "added" : "removed", by, businessObject);
        }

        public void propertyChanged(Object object, String string, Object object2) {
            String string2 = string.substring(string.lastIndexOf(46) + 1);
            this.append(object, "changed", string2, object2);
        }

        private void append(Object object, String string, Object object2, Object object3) {
            final Object[] objectArray = new Object[7];
            objectArray[0] = this.sdf.format(new Date());
            objectArray[1] = System.identityHashCode(object);
            objectArray[2] = object.getClass().getSimpleName();
            objectArray[3] = string;
            objectArray[4] = object2;
            objectArray[5] = object3;
            if (ModelDebugger.this.pnlRecordStackTraces.accept(objectArray)) {
                objectArray[6] = new Exception().getStackTrace();
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ModelDebugger.this.tableM.addRow(objectArray);
                    ModelDebugger.this.lblTableInfo.setText(ModelDebugger.this.tableM.getRowCount() + " rows");
                }
            });
        }
    };
    TableModel tableM;
    JTable table;
    List<Integer> rowsToHighlight = new ArrayList<Integer>();
    TableRenderer tableRenderer = new TableRenderer();
    TableListener tableListener = new TableListener();
    RecordStackTraces pnlRecordStackTraces;
    AbstractAction actRefreshTree = new AbstractAction("Refresh below selected Node"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TreePath treePath = ModelDebugger.this.tree.getSelectionPath();
            if (treePath != null) {
                Node node = (Node)treePath.getLastPathComponent();
                node.clearCache();
                ModelDebugger.this.tm.valueForPathChanged(treePath, node);
            }
        }
    };

    public ModelDebugger(Apdm_to_BO.BoBundle boBundle) {
        this.content = boBundle;
        this.buildGui();
        new Thread(boBundle).start();
    }

    void stop() {
        this.enableTracing(false);
    }

    void buildGui() {
        this.tm = new TreeModel();
        this.tree = new JTree(this.tm);
        this.tr = new TreeRenderer();
        this.tree.setCellRenderer(this.tr);
        this.tl = new TreeListener();
        this.tree.addTreeSelectionListener(this.tl);
        this.treeControls = new JPanel();
        this.treeControls.add(new JButton(this.actRefreshTree));
        this.text = new JTextArea(5, 50);
        this.tableM = new TableModel();
        this.tableM.addColumn("stack record");
        this.table = new JTable(this.tableM);
        this.table.setDefaultRenderer(Object.class, this.tableRenderer);
        this.table.getSelectionModel().addListSelectionListener(this.tableListener);
        this.rowDetails = new JTextArea(80, 20);
        this.pnlTableTools = new TableTools();
        this.pnlTableSearch = new TableSearchPanel();
        this.pnlTableSave = new TableSaveToFile();
        this.pnlRecordStackTraces = new RecordStackTraces();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.treeControls, "North");
        jPanel.add((Component)new JScrollPane(this.tree), "Center");
        jPanel.add((Component)new JScrollPane(this.text), "South");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JComponent jComponent = new JPanel(new BorderLayout());
        JComponent jComponent2 = Box.createVerticalBox();
        jComponent2.add(this.pnlTableTools);
        jComponent2.add(this.pnlTableSearch);
        jComponent2.add(this.pnlTableSave);
        jComponent2.add(this.lblTableInfo);
        jComponent.add((Component)jComponent2, "North");
        jComponent.add((Component)new JScrollPane(this.table), "Center");
        jComponent2 = new JPanel(new BorderLayout());
        JComponent jComponent3 = new JPanel(new GridLayout(0, 1));
        jComponent3.add(this.pnlRecordStackTraces);
        jComponent2.add((Component)jComponent3, "North");
        jComponent2.add((Component)new JScrollPane(this.rowDetails), "Center");
        jComponent.setBorder(new TitledBorder("Change-Event Log"));
        jComponent2.setBorder(new TitledBorder("Stacktrace Recording"));
        jComponent3 = new JSplitPane(1, jComponent, jComponent2);
        jPanel2.add((Component)jComponent3, "Center");
        this.setLayout(new BorderLayout());
        jPanel.setBorder(new TitledBorder("Data Model Browser"));
        jComponent = new JSplitPane(1, jPanel, jPanel2);
        ((JSplitPane)jComponent).setResizeWeight(0.5);
        ((JSplitPane)jComponent).setDividerLocation(600);
        this.add((Component)jComponent, "Center");
    }

    public void showFrame() {
        JFrame jFrame = new JFrame(this.getClass().getSimpleName());
        jFrame.getContentPane().add((Component)this, "Center");
        jFrame.setDefaultCloseOperation(2);
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ModelDebugger.this.stop();
            }
        });
        jFrame.setSize(1200, 800);
        jFrame.setVisible(true);
        jFrame.validate();
    }

    void enableTracing(boolean bl) {
        BusinessObject.tracingIF = bl ? this.traceIF : null;
    }

    class Thread
    extends java.lang.Thread {
        Apdm_to_BO.BoBundle datamodel;

        Thread(Apdm_to_BO.BoBundle boBundle) {
            super(ModelDebugger.class.getSimpleName());
            this.setDaemon(true);
            this.datamodel = boBundle;
        }

        @Override
        public void run() {
            try {
                while (true) {
                    Thread.sleep(5000L);
                    this.accessDataModel();
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }

        protected void accessDataModel() {
            Apdm_to_BO.BoBundle boBundle = ModelDebugger.this.content;
            boBundle.hashCode();
        }
    }

    class TreeListener
    implements TreeSelectionListener {
        TreeListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            TreePath treePath = treeSelectionEvent.getNewLeadSelectionPath();
            if (treePath != null) {
                Object object = treePath.getLastPathComponent();
                Node node = (Node)object;
                ModelDebugger.this.text.setText(String.valueOf(node.obj));
            }
        }
    }

    class TreeRenderer
    extends DefaultTreeCellRenderer {
        TreeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Node node = (Node)object;
            super.getTreeCellRendererComponent(jTree, node.obj, bl, bl2, bl3, n, bl4);
            String string = node.by;
            String string2 = node.objName;
            String string3 = MiscUtils.packageClassnameHash(node.obj);
            if (node.obj == "A link to one or more entities") {
                string3 = "<i>skipped</i>";
            }
            String string4 = "<html><i>" + string + "</i> <b>" + string2 + "</b> " + string3;
            this.setText(string4);
            this.setIcon(null);
            return this;
        }
    }

    class TreeModel
    implements javax.swing.tree.TreeModel {
        BusinessObject rootBo = new RootBo();
        Node root = new Node("", "Bundle", this.rootBo);
        private Comparator<Node> childrenSorter = new Comparator<Node>(){

            @Override
            public int compare(Node node, Node node2) {
                int n = node.by.compareTo(node2.by);
                if (n == 0) {
                    n = node.objName.compareTo(node2.objName);
                }
                return n;
            }
        };
        private List<TreeModelListener> modelListeners = Collections.synchronizedList(new ArrayList());

        TreeModel() {
        }

        @Override
        public Object getRoot() {
            return this.root;
        }

        private List<Node> getChildren(Object object) {
            Node node = (Node)object;
            if (node.children == null) {
                node.children = new ArrayList<Node>();
                if (node.bo != null) {
                    Method[] methodArray;
                    for (Method method : methodArray = node.bo.getClass().getMethods()) {
                        if (!method.getName().startsWith("gettrue")) continue;
                        if (method.getParameterTypes().length == 0) {
                            String string = method.getName().substring("gettrue".length());
                            if (Arrays.asList(method.getExceptionTypes()).contains(UnknownEntityException.class)) {
                                this.addToCollection(node.children, "ent", string, "A link to one or more entities");
                                continue;
                            }
                            try {
                                Object object2 = method.invoke((Object)node.bo, new Object[0]);
                                this.addToCollection(node.children, "", string, object2);
                            }
                            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                                System.err.println(this + ": invoking getter failed: " + node.bo + "#" + method + " due to " + exception);
                            }
                            continue;
                        }
                        System.err.println(this + ": ignoring this strange getter: " + node.bo + "#" + method);
                    }
                    Collections.sort(node.children, this.childrenSorter);
                }
            }
            return node.children;
        }

        protected void addToCollection(Collection<Node> collection, String string, String string2, Object objectArray) {
            if (objectArray instanceof Collection) {
                objectArray = ((Collection)objectArray).toArray();
            }
            if (objectArray instanceof Object[]) {
                Object[] objectArray2 = objectArray;
                for (int i = 0; i < objectArray2.length; ++i) {
                    this.addToCollection(collection, string, string2 + "[" + i + "]", objectArray2[i]);
                }
            } else {
                collection.add(new Node(string, string2, objectArray));
            }
        }

        @Override
        public Object getChild(Object object, int n) {
            return this.getChildren(object).get(n);
        }

        @Override
        public int getIndexOfChild(Object object, Object object2) {
            return this.getChildren(object).indexOf(object2);
        }

        @Override
        public int getChildCount(Object object) {
            return this.getChildren(object).size();
        }

        @Override
        public boolean isLeaf(Object object) {
            return this.getChildCount(object) == 0;
        }

        @Override
        public void addTreeModelListener(TreeModelListener treeModelListener) {
            this.modelListeners.add(treeModelListener);
        }

        @Override
        public void removeTreeModelListener(TreeModelListener treeModelListener) {
            this.modelListeners.remove(treeModelListener);
        }

        @Override
        public void valueForPathChanged(TreePath treePath, Object object) {
            TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath);
            for (TreeModelListener treeModelListener : this.modelListeners) {
                treeModelListener.treeStructureChanged(treeModelEvent);
            }
        }

        class RootBo
        extends BusinessObject {
            RootBo() {
                super((Object)ModelDebugger.this.content);
            }

            public Object getCastorObject() {
                return this.storageObject;
            }

            public List<Entity> gettrueEntity() {
                return ModelDebugger.this.content.entities();
            }
        }
    }

    class Node {
        String by;
        String objName;
        Object obj;
        BusinessObject bo;
        static final String ENTITYREF = "A link to one or more entities";
        List<Node> children;

        Node(String string, String string2, Object object) {
            this.by = string;
            this.objName = string2;
            this.obj = object;
            if (object instanceof BusinessObject) {
                this.bo = (BusinessObject)object;
            }
        }

        void clearCache() {
            this.children = null;
        }
    }

    class TableSearchPanel
    extends JPanel {
        JTextField txtSearch = new JTextField(20);
        JLabel lblInfo = new JLabel();
        JButton btnFind;
        JButton btnFwd;
        JButton btnBkw;
        List<Integer> matchingRows = new ArrayList<Integer>();
        AbstractAction actFind = new AbstractAction("Find"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableSearchPanel.this.matchingRows = TableSearchPanel.this.findAll(TableSearchPanel.this.txtSearch.getText());
                TableSearchPanel.this.lblInfo.setText(TableSearchPanel.this.matchingRows.size() + " rows matching");
                ModelDebugger.this.rowsToHighlight = TableSearchPanel.this.matchingRows;
                ModelDebugger.this.table.repaint();
            }
        };
        AbstractAction actBackward = new AbstractAction("<"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = ModelDebugger.this.table.getSelectedRow();
                for (int i = TableSearchPanel.this.matchingRows.size() - 1; i >= 0; --i) {
                    int n2 = TableSearchPanel.this.matchingRows.get(i);
                    if (n2 >= n) continue;
                    ModelDebugger.this.table.setRowSelectionInterval(n2, n2);
                    ModelDebugger.this.table.scrollRectToVisible(new Rectangle(ModelDebugger.this.table.getCellRect(n2, 0, true)));
                    break;
                }
            }
        };
        AbstractAction actForward = new AbstractAction(">"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = ModelDebugger.this.table.getSelectedRow();
                int n2 = TableSearchPanel.this.matchingRows.size();
                for (int i = 0; i < n2; ++i) {
                    int n3 = TableSearchPanel.this.matchingRows.get(i);
                    if (n3 <= n) continue;
                    ModelDebugger.this.table.setRowSelectionInterval(n3, n3);
                    ModelDebugger.this.table.scrollRectToVisible(new Rectangle(ModelDebugger.this.table.getCellRect(n3, 0, true)));
                    break;
                }
            }
        };

        TableSearchPanel() {
            this.btnFind = new JButton(this.actFind);
            this.btnBkw = new JButton(this.actBackward);
            this.btnFwd = new JButton(this.actForward);
            this.setLayout(new BoxLayout(this, 0));
            this.add(this.txtSearch);
            this.add(this.lblInfo);
            this.add(this.btnFind);
            this.add(this.btnBkw);
            this.add(this.btnFwd);
        }

        List<Integer> findAll(String string) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            int n = ModelDebugger.this.tableM.getColumnCount();
            int n2 = ModelDebugger.this.tableM.getRowCount();
            for (int i = 0; i != n; ++i) {
                for (int j = 0; j != n2; ++j) {
                    Object object = ModelDebugger.this.tableM.getValueAt(j, i);
                    if (!String.valueOf(object).contains(string)) continue;
                    arrayList.add(j);
                }
            }
            return arrayList;
        }
    }

    class TableSaveToFile
    extends JPanel {
        JLabel lblSaveToFile = new JLabel(" ");
        JTextField txtSaveToFile = new JTextField(20);
        JButton btnSaveToFile;
        AbstractAction actSaveToFile = new AbstractAction("as tab-csv"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableSaveToFile.this.lblSaveToFile.setText("Saving...");
                int[] nArray = ModelDebugger.this.table.getSelectedRows();
                if (nArray.length > 0) {
                    String string = TableSaveToFile.this.txtSaveToFile.getText();
                    try (FileWriter fileWriter = new FileWriter(string);){
                        int n = ModelDebugger.this.table.getRowCount();
                        for (int i = 0; i < n; ++i) {
                            int n2 = ModelDebugger.this.table.getColumnCount();
                            for (int j = 0; j < n2; ++j) {
                                if (j != 0) {
                                    fileWriter.write("\t");
                                }
                                fileWriter.write(String.valueOf(ModelDebugger.this.table.getValueAt(i, j)));
                            }
                            fileWriter.write("\n");
                        }
                    }
                    catch (IOException iOException) {
                        TableSaveToFile.this.lblSaveToFile.setText("Saving failed: " + iOException.toString());
                    }
                    TableSaveToFile.this.lblSaveToFile.setText("Saved to " + string);
                } else {
                    TableSaveToFile.this.lblSaveToFile.setText("Can't save: No rows selected");
                }
            }
        };

        TableSaveToFile() {
            this.btnSaveToFile = new JButton(this.actSaveToFile);
            Box box = Box.createHorizontalBox();
            box.add(new JLabel("Save selected rows to"));
            box.add(this.txtSaveToFile);
            box.add(this.btnSaveToFile);
            Box box2 = Box.createHorizontalBox();
            box2.add(this.lblSaveToFile);
            this.setLayout(new GridLayout(2, 0));
            this.add(box);
            this.add(box2);
        }
    }

    class RecordStackTraces
    extends JPanel {
        JCheckBox chkRecordStackTraces = new JCheckBox("<html>For events that look like below, record their stack traces");
        TableModel queryByExampleModel;
        JTable queryByExample;
        AbstractAction actMore = new AbstractAction("more"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RecordStackTraces.this.queryByExampleModel.addRow(new Object[0]);
            }
        };
        AbstractAction actLess = new AbstractAction("less"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (RecordStackTraces.this.queryByExampleModel.getRowCount() > 0) {
                    RecordStackTraces.this.queryByExampleModel.removeRow(RecordStackTraces.this.queryByExampleModel.getRowCount() - 1);
                }
            }
        };
        Object[] temp;

        RecordStackTraces() {
            this.queryByExampleModel = new TableModel();
            this.queryByExample = new JTable(this.queryByExampleModel);
            Box box = Box.createHorizontalBox();
            box.add(this.chkRecordStackTraces);
            box.add(Box.createGlue());
            box.add(new JButton(this.actLess));
            box.add(new JButton(this.actMore));
            this.setLayout(new BoxLayout(this, 1));
            this.add(box);
            this.add(new JScrollPane(this.queryByExample));
            this.queryByExample.getParent().setPreferredSize(new Dimension(50, 70));
            this.queryByExampleModel.addRow(new Object[0]);
        }

        boolean accept(Object[] objectArray) {
            if (this.temp == null) {
                this.temp = new Object[this.queryByExampleModel.getColumnCount()];
            }
            if (this.chkRecordStackTraces.isSelected()) {
                int n = this.queryByExampleModel.getRowCount();
                for (int i = 0; i < n; ++i) {
                    Vector<Object> vector = this.queryByExampleModel.getRow(i);
                    vector.copyInto(this.temp);
                    if (!this.matches(objectArray, this.temp)) continue;
                    return true;
                }
            }
            return false;
        }

        boolean matches(Object[] objectArray, Object[] objectArray2) {
            int n = objectArray2.length;
            for (int i = 0; i < n; ++i) {
                if (objectArray2[i] == null || "".equals(objectArray2[i]) || objectArray2[i].equals(String.valueOf(objectArray[i]))) continue;
                return false;
            }
            return true;
        }
    }

    class TableTools
    extends JPanel {
        JCheckBox chkEnableTracing = new JCheckBox("Enable Change-Event Log");

        TableTools() {
            this.setLayout(new BoxLayout(this, 0));
            this.add(this.chkEnableTracing);
            this.chkEnableTracing.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    boolean bl = itemEvent.getStateChange() == 1;
                    ModelDebugger.this.enableTracing(bl);
                }
            });
        }
    }

    class TableListener
    implements ListSelectionListener {
        TableListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            int n = listSelectionModel.getLeadSelectionIndex();
            String string = this.readStackTraceFromRow(n);
            ModelDebugger.this.rowDetails.setText(string);
        }

        String readStackTraceFromRow(int n) {
            StringBuilder stringBuilder = new StringBuilder();
            Object object = ModelDebugger.this.tableM.getValueAt(n, 6);
            if (object instanceof StackTraceElement[]) {
                StackTraceElement[] stackTraceElementArray = (StackTraceElement[])object;
                int n2 = 20;
                for (int i = 3; i < n2; ++i) {
                    StackTraceElement stackTraceElement = stackTraceElementArray[i];
                    stringBuilder.append(stackTraceElement.getClassName()).append(".").append(stackTraceElement.getMethodName());
                    stringBuilder.append("(").append(stackTraceElement.getFileName()).append(":").append(stackTraceElement.getLineNumber());
                    stringBuilder.append(")\n");
                }
                stringBuilder.append(stackTraceElementArray.length - n2).append(" more...");
                return stringBuilder.toString();
            }
            return "stacktrace was not recorded";
        }
    }

    class TableRenderer
    extends DefaultTableCellRenderer {
        TableRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            boolean bl3 = ModelDebugger.this.rowsToHighlight.contains(n);
            this.setBackground(bl3 ? Color.CYAN : null);
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            return this;
        }
    }

    class TableModel
    extends DefaultTableModel {
        TableModel() {
            this.addColumn("timestamp");
            this.addColumn("object idhash");
            this.addColumn("object class");
            this.addColumn("change-kind");
            this.addColumn("member name");
            this.addColumn("member value");
        }

        Vector<Object> getRow(int n) {
            return this.getDataVector().get(n);
        }
    }
}

