/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.util;

import alma.common.horizonsparser.HorizonParser;
import alma.obsprep.util.OTLoggerAdapter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Calendar;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class OTHorizonParser
extends HorizonParser {
    public OTHorizonParser(OTLoggerAdapter oTLoggerAdapter, String string) throws IOException, HorizonParser.UnableToParseEphemerisDataException {
        super((Logger)oTLoggerAdapter, string);
    }

    public OTHorizonParser(OTLoggerAdapter oTLoggerAdapter, String string, double d, Calendar calendar) throws HorizonParser.UnableToParseEphemerisDataException, IOException {
        super((Logger)oTLoggerAdapter, string, d, calendar);
    }

    public OTHorizonParser(OTLoggerAdapter oTLoggerAdapter) {
        super((Logger)oTLoggerAdapter);
    }

    public boolean isEphemerisElevationCutOffSpecified(String string) throws HorizonParser.UnableToParseEphemerisDataException, IOException {
        if (StringUtils.isBlank((CharSequence)string)) {
            throw new HorizonParser.UnableToParseEphemerisDataException("Ephemeris has not been specified.");
        }
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        Pattern pattern = Pattern.compile("^Table[ ]+cut-offs[ ]+[\\d]+:.*?Elevation[ ]\\([ ]*[\\d]+\\.[\\d]+deg=YES.*?", 2);
        String string2 = bufferedReader.readLine();
        while (string2 != null) {
            Matcher matcher = pattern.matcher(string2);
            if (matcher.find()) {
                bufferedReader.close();
                return true;
            }
            string2 = bufferedReader.readLine();
        }
        bufferedReader.close();
        return false;
    }

    public String getSourceName(String string) throws HorizonParser.UnableToParseEphemerisDataException {
        if (string == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: sourceEphemeris");
        }
        if (StringUtils.isEmpty((CharSequence)string)) {
            throw new HorizonParser.UnableToParseEphemerisDataException("Source ephemeris is empty");
        }
        Pattern pattern = Pattern.compile("^Target[ ]+body[ ]+name:[ ]+(.*?)\\{.*?\\}");
        try {
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string.trim()));
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                Matcher matcher = pattern.matcher(string2);
                if (matcher.find()) {
                    bufferedReader.close();
                    return StringUtils.trim((String)matcher.group(1));
                }
                string2 = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            throw new HorizonParser.UnableToParseEphemerisDataException(exception.getMessage());
        }
        return StringUtils.trim((String)super.getSourceName(string));
    }
}

