/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.summaryfeedback;

import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.services.summaryfeedback.ScienceGoalSummaryParameters;
import alma.obsprep.services.summaryfeedback.SensitivityTableData;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.Sensitivity;
import alma.valuetypes.UserFrequency;
import javax.swing.table.AbstractTableModel;

public class SgControlTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -3753533123686363956L;
    private ScienceGoalSummaryParameters document;
    private final String[] longValues = new String[]{"0.988xx - 0.0033xx", "50-90\"", " 1111.111 mJy, 284 uK-693.1 mK ", " 9999.00 KM/S 9999.99 GHz  ", " 999.999999 GHz ", " xxx.xxx mJy, xxx.xxx K -xxx.x mk ", "xxx.xxx GHz", " XX,YY,XY,YX "};

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public int getColumnCount() {
        return SgControlCols.getColumnCount();
    }

    @Override
    public int getRowCount() {
        return 1;
    }

    @Override
    public String getColumnName(int n) {
        SgControlCols sgControlCols = SgControlCols.getColumnDescriptor(n);
        return sgControlCols.getColumnName();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        ScienceGoalSummaryParameters scienceGoalSummaryParameters = this.getParameters();
        if (scienceGoalSummaryParameters == null) {
            return null;
        }
        SgControlCols sgControlCols = SgControlCols.getColumnDescriptor(n2);
        ScienceGoal scienceGoal = scienceGoalSummaryParameters.getScienceGoal();
        switch (sgControlCols) {
            case RESOLUTION: {
                return scienceGoal;
            }
            case LARGESTSTRUCTURE: {
                return scienceGoalSummaryParameters.desiredLargestStructure;
            }
            case SENSITIVITY: {
                SensitivityTableData.Builder builder = new SensitivityTableData.Builder();
                builder.scienceGoal(scienceGoal).sensitivity(scienceGoal.getPerformanceParameters().getDesiredSensitivity());
                return builder.build();
            }
            case REPFREQUENCY: {
                return scienceGoalSummaryParameters.representativeFrequencyRest;
            }
            case REFERENCEWIDTH: {
                return scienceGoalSummaryParameters.sensitivityFrequencyWidth;
            }
            case POLARIZATION: {
                return scienceGoalSummaryParameters.poln.polnProducts;
            }
            case CONTRMS: {
                SensitivityTableData.Builder builder = new SensitivityTableData.Builder();
                builder.scienceGoal(scienceGoal).sensitivity(scienceGoalSummaryParameters.continuumRms);
                return builder.build();
            }
            case CONTBANDWIDTH: {
                return scienceGoalSummaryParameters.continuumBandwidthPerPoln;
            }
        }
        return null;
    }

    public ScienceGoalSummaryParameters getParameters() {
        return this.document;
    }

    public void setDocument(ScienceGoalSummaryParameters scienceGoalSummaryParameters) {
        this.document = scienceGoalSummaryParameters;
    }

    public String[] getLongValues() {
        return this.longValues;
    }

    public static enum SgControlCols {
        RESOLUTION(" Ang.Res. ", Angle.class),
        LARGESTSTRUCTURE(" LAS ", Angle.class),
        SENSITIVITY(" Requested RMS ", Sensitivity.class),
        REFERENCEWIDTH(" RMS Bandwidth ", UserFrequency.class),
        REPFREQUENCY(" Rep.Freq. ", Frequency.class),
        CONTRMS(" Cont. RMS ", Sensitivity.class),
        CONTBANDWIDTH(" Cont. Bandwidth ", Frequency.class),
        POLARIZATION(" Poln.Prod. ", String.class);

        public final String colName;
        public final Class<?> colClass;

        protected static int getColumnCount() {
            return SgControlCols.values().length;
        }

        protected static SgControlCols getColumnDescriptor(int n) {
            return SgControlCols.values()[n];
        }

        protected String getColumnName() {
            return this.colName;
        }

        private SgControlCols(String string2, Class<?> clazz) {
            this.colName = string2;
            this.colClass = clazz;
        }
    }
}

