/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.summaryfeedback;

import alma.hla.runtime.obsprep.bo.Entity;
import alma.hla.runtime.obsprep.bo.EntityIDFactory;
import alma.hla.runtime.obsprep.bo.EntityPart;
import alma.hla.runtime.obsprep.util.CannotAssignIdException;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.persistence.ImpexFactory;
import alma.obsprep.services.summaryfeedback.AllScienceGoalsExporter;
import alma.obsprep.services.summaryfeedback.DefaultPdfExporter;
import alma.obsprep.services.summaryfeedback.ProposalCoverSheetExporter;
import alma.obsprep.services.summaryfeedback.ProposalSummaryModel;
import alma.obsprep.services.summaryfeedback.ProposalSummaryParameters;
import alma.obsprep.services.summaryfeedback.ProposalSummaryView;
import alma.obsprep.services.summaryfeedback.ScienceGoalSummaryModel;
import alma.obsprep.services.summaryfeedback.ScienceGoalSummaryParameters;
import alma.obsprep.services.summaryfeedback.ScienceGoalSummaryView;
import alma.obsprep.util.LogLoggerProviderImpl;
import alma.obsprep.util.UnitMapConfigurator;
import com.itextpdf.text.Document;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.File;
import java.net.URL;
import java.util.Random;
import javax.swing.SwingUtilities;

public class CompleteProposalExporter
extends DefaultPdfExporter {
    protected ObsProposal proposal;
    private final DefaultPdfExporter proposalExporter;
    private final AllScienceGoalsExporter allSgExporter;

    protected CompleteProposalExporter(ProposalSummaryView proposalSummaryView, ScienceGoalSummaryView scienceGoalSummaryView) {
        this.proposalExporter = new ProposalCoverSheetExporter(proposalSummaryView);
        this.allSgExporter = new AllScienceGoalsExporter(scienceGoalSummaryView);
    }

    protected void setObsProposal(ObsProposal obsProposal) {
        this.proposal = obsProposal;
        this.allSgExporter.setObsProposal(obsProposal);
    }

    @Override
    public void exportToPdf(File file) {
        if (this.proposal == null) {
            return;
        }
        super.exportToPdf(file);
    }

    @Override
    protected void exportToPdfPage(Document document, PdfWriter pdfWriter, Rectangle rectangle) {
        this.proposalExporter.exportToPdfPage(document, pdfWriter, rectangle);
        document.newPage();
        this.allSgExporter.exportToPdfPage(document, pdfWriter, rectangle);
    }

    public static void main(String[] stringArray) {
        System.setProperty("java.awt.headless", "true");
        UnitMapConfigurator.configureUnitMaps();
        ObservingToolController.getMyInstance();
        Log.setRuntimeImplementation((Log.LoggerProvider)new LogLoggerProviderImpl());
        final Random random = new Random();
        EntityIDFactory.setRuntimeImplementation((EntityIDFactory)new EntityIDFactory(){

            public String assignUniqueEntityId(Entity entity) {
                return "entityId-" + random.nextInt();
            }

            public void destroy() {
            }

            public String assignEntityPartId(EntityPart entityPart) throws CannotAssignIdException {
                return "entityPartId-" + random.nextInt();
            }
        });
        SwingUtilities.invokeLater(() -> {
            ObsProposal obsProposal = null;
            try {
                InitServices.init();
                obsProposal = ImpexFactory.getInstance().importObsProject(new URL("file://" + new File(stringArray[0]).getAbsolutePath())).getObsProposal();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
            ProposalSummaryParameters proposalSummaryParameters = new ProposalSummaryParameters(obsProposal);
            ProposalSummaryModel proposalSummaryModel = new ProposalSummaryModel();
            proposalSummaryParameters.collectInfo();
            proposalSummaryModel.setDocument(proposalSummaryParameters);
            ScienceGoalSummaryParameters scienceGoalSummaryParameters = new ScienceGoalSummaryParameters();
            ScienceGoalSummaryModel scienceGoalSummaryModel = new ScienceGoalSummaryModel();
            scienceGoalSummaryModel.setDocument(scienceGoalSummaryParameters);
            ProposalSummaryView proposalSummaryView = new ProposalSummaryView(proposalSummaryModel);
            ScienceGoalSummaryView scienceGoalSummaryView = new ScienceGoalSummaryView(scienceGoalSummaryModel);
            CompleteProposalExporter completeProposalExporter = new CompleteProposalExporter(proposalSummaryView, scienceGoalSummaryView);
            completeProposalExporter.setObsProposal(obsProposal);
            completeProposalExporter.exportToPdf(new File(stringArray[1]));
        });
    }
}

