/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.targetcreator;

import alma.obsprep.bo.obsproject.CalibrationTargetParameters;
import alma.obsprep.bo.obsproject.CalibrationTargetProperties;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.Reference;
import alma.obsprep.bo.schedblock.SourceProperty;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.services.generator.refactored.ObsType;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.targetcreator.CalibratorFieldSourceWorker;
import alma.obsprep.services.generator.refactored.targetcreator.FieldSourceWorkerUtils;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Velocity;

class CalibrationTargetParametersFieldSourceWorker
extends CalibratorFieldSourceWorker {
    CalibrationTargetParametersFieldSourceWorker() {
    }

    public static FieldSource getFieldSource(CalibrationTargetParameters calibrationTargetParameters, RequestedArray requestedArray, SpectralSpec spectralSpec) {
        String string = calibrationTargetParameters.getIntendedUse();
        FieldSource fieldSource = CalibrationTargetParametersFieldSourceWorker.createCalibratorFieldSource();
        fieldSource.setIsQuery(false);
        fieldSource.setName(string + " calibrator");
        CalibrationTargetParametersFieldSourceWorker.setupFieldSource(calibrationTargetParameters, fieldSource);
        if (RequestedArray.TP.equals((Object)requestedArray) && ObsType.AMPLITUDE.equals((Object)calibrationTargetParameters.getObsType())) {
            CalibrationTargetParametersFieldSourceWorker.setUpTPAmplitudeRasterScan(fieldSource, spectralSpec);
        }
        Reference reference = FieldSourceWorkerUtils.getAtmosphericReference(spectralSpec, fieldSource);
        fieldSource.addReference(reference);
        return fieldSource;
    }

    private static void setupFieldSource(CalibrationTargetParameters calibrationTargetParameters, FieldSource fieldSource) {
        Object object = calibrationTargetParameters.gettrueSourceCoordinates();
        if (object != null) {
            fieldSource.setSourceCoordinates((SkyCoordinates)object.deepCopy());
        }
        fieldSource.setNonSiderealMotion(calibrationTargetParameters.gettrueNonSiderealMotion());
        if (calibrationTargetParameters.getNonSiderealMotion()) {
            fieldSource.setSolarSystemObject(calibrationTargetParameters.getSolarSystemObject());
            fieldSource.setSourceName(calibrationTargetParameters.getSolarSystemObject());
        } else {
            fieldSource.setSourceName(calibrationTargetParameters.gettrueSourceName());
        }
        object = calibrationTargetParameters.gettrueSourceVelocity();
        if (object != null) {
            fieldSource.setSourceVelocity((Velocity)object.deepCopy());
        }
        for (CalibrationTargetProperties calibrationTargetProperties : calibrationTargetParameters.getCalibrationTargetProperties()) {
            SourceProperty sourceProperty = SourceProperty.createSourceProperty();
            sourceProperty.setSourceFluxI(calibrationTargetProperties.getFlux().deepCopy());
            sourceProperty.setSourceFrequency(calibrationTargetProperties.getFrequency().deepCopy());
            fieldSource.addSourceProperty(sourceProperty);
        }
    }
}

