/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.spectralspec;

import alma.obsprep.bo.annotations.ObservingFrequency;
import alma.obsprep.bo.annotations.SpectralWindowI;
import alma.obsprep.bo.enumerations.CorrPolarization;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralSetupFactory;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.schedblock.AbstractBaseBandConfig;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.services.generator.refactored.spectralspec.SpectralSpecWorker;
import alma.valuetypes.Frequency;
import alma.valuetypes.Velocity;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.NonNull;

public abstract class DGCB2BReferenceSpectralSpecBuilderBase {
    @NonNull
    private Optional<SBGenerationContext> sbGenerationContext;
    private static final Map<ReceiverBand, List<Frequency>> spwCentres = ImmutableMap.of((Object)ReceiverBand.getReceiverBand(3), (Object)ImmutableList.of((Object)((Object)Frequency.createFrequencyGHZ(90.5)), (Object)((Object)Frequency.createFrequencyGHZ(92.5)), (Object)((Object)Frequency.createFrequencyGHZ(102.5)), (Object)((Object)Frequency.createFrequencyGHZ(104.5))));

    protected abstract void mergeSpectralSpecs(@NonNull SpectralSpec var1, @NonNull SpectralSpec var2);

    private SpectralSetupParameters buildB2BContinuumSSP(@NonNull ReceiverBand receiverBand) {
        if (receiverBand == null) {
            throw new NullPointerException("receiverBand is marked non-null but is null");
        }
        SpectralSetupParameters spectralSetupParameters = SpectralSetupParameters.createSpectralSetupParameters();
        spectralSetupParameters.setSpectralType(SpectralSetupParameters.SpectralSetupTypeChoice.SINGLECONTINUUM);
        spectralSetupParameters.setPolarisation(SpectralSetupParameters.POLARISATION_DOUBLE);
        spectralSetupParameters.setRepresentativeFrequency(Frequency.createFrequencyGHZ(104.5));
        spectralSetupParameters.setSingleContinuumFrequency(Frequency.createFrequencyGHZ(97.5));
        spectralSetupParameters.updateSingleContinuumWindows(Frequency.createFrequencyGHZ(97.5), Velocity.createVelocity(), ObservingFrequency.FrequencyType.SKY_FREQUENCY, CorrPolarization.DOUBLE);
        if (!spwCentres.containsKey(receiverBand)) {
            throw new WizardSBGenerationException("No SPW centre frequencies found for " + receiverBand + " when creating a DGC reference spectral spec");
        }
        SpectralSetupFactory.createB2BWindows(Optional.of(spectralSetupParameters), spwCentres.get(receiverBand));
        return spectralSetupParameters;
    }

    public SpectralSpec createDGCReferenceB2BSpectralSpec(@NonNull SpectralSpec spectralSpec, SpectralSetupParameters spectralSetupParameters, SpectralSpecWorker spectralSpecWorker) {
        if (spectralSpec == null) {
            throw new NullPointerException("scienceSpectralSpec is marked non-null but is null");
        }
        ScienceGoal scienceGoal = spectralSetupParameters.getScienceGoal().deepCopy();
        SpectralSetupParameters spectralSetupParameters2 = this.buildB2BContinuumSSP(ReceiverBand.getReceiverBand(3));
        spectralSetupParameters2.setDerivedForDGCCalibrator(true);
        scienceGoal.setSpectralSetupParameters(spectralSetupParameters2);
        SpectralSpec spectralSpec2 = spectralSpec.isBLSpectralSpec() ? SpectralSpec.createSpectralSpecWithBLCorrelatorConfiguration(this.sbGenerationContext) : SpectralSpec.createSpectralSpecWithACACorrelatorConfiguration(this.sbGenerationContext);
        spectralSpecWorker.setupScienceSpectralSpec(spectralSpec2, spectralSetupParameters2, true);
        Velocity velocity = Velocity.createVelocity();
        velocity.setReferenceSystem(Velocity.REFERENCESYSTEM_TOPO);
        spectralSpec2.setSourceVelocity(velocity);
        ReceiverBand receiverBand = spectralSpec2.getReceiverBand();
        spectralSpec2.setName("B" + receiverBand.getNumber() + " B2B Cal Setup");
        spectralSpec2.calculateCorrelatorSetup(velocity.deepCopy());
        spectralSpec2.getCorrelatorConfiguration().updateSideband();
        this.mergeSpectralSpecs(spectralSpec2, spectralSpec);
        for (AbstractBaseBandConfig abstractBaseBandConfig : spectralSpec2.getBaseBandConfig()) {
            for (SpectralWindowI spectralWindowI : abstractBaseBandConfig.getSpectralWindow()) {
                spectralWindowI.updateSideband();
            }
        }
        return spectralSpec2;
    }

    public DGCB2BReferenceSpectralSpecBuilderBase(@NonNull Optional<SBGenerationContext> optional) {
        if (optional == null) {
            throw new NullPointerException("sbGenerationContext is marked non-null but is null");
        }
        this.sbGenerationContext = optional;
    }

    public String toString() {
        return "DGCB2BReferenceSpectralSpecBuilderBase(sbGenerationContext=" + this.sbGenerationContext + ")";
    }
}

