/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.intermediatetarget;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetWithIntent;
import alma.obsprep.bo.schedblock.CalibratorParameters;
import alma.obsprep.bo.schedblock.ObservingParameters;
import alma.obsprep.bo.schedblock.OrderedTarget;
import alma.obsprep.bo.schedblock.Reference;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.services.generator.refactored.MinTuningsCalculator;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.ScienceGoalSchedBlockGenerator;
import alma.obsprep.services.generator.refactored.intermediatetarget.IntegrationTimeResolverInterface;
import alma.obsprep.services.generator.refactored.intermediatetarget.IntermediateTarget;
import alma.obsprep.services.generator.refactored.intermediatetarget.ObservingGroupManager;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.valuetypes.Time;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import lombok.NonNull;

public abstract class AbstractIntermediateTarget
implements IntermediateTarget,
IntegrationTimeResolverInterface {
    SBGenerationContext sbContext;
    protected Log.Logger logger = Log.logger((Object)this);
    private ObservingGroupManager observingGroupManager;
    protected EnumSet<SBGeneratorTemplate.SBGenerationSchema> schemaToUseForSBGeneration;
    private String groupName = null;
    protected final Collection<IntermediateTarget> children = new ArrayList<IntermediateTarget>();
    protected final List<Target> targets = new ArrayList<Target>();
    protected final List<OrderedTarget> orderedTargets = new ArrayList<OrderedTarget>();
    protected int targetPriority = 99;
    protected String type = "";

    public abstract void assignMultipleVelocitySourceTargetsToObservingGroups(TargetWithIntent var1, SpectralSetupParameters var2, RequestedArray var3, ObservingGroupManager var4, Integer var5);

    @Override
    @Deprecated
    public int getGroupIndex() {
        int n;
        try {
            n = this.observingGroupManager.getObservingGroupIndex(this.getGroupName());
        }
        catch (ObservingGroupManager.ObservingGroupNotFoundException observingGroupNotFoundException) {
            throw new IllegalArgumentException(observingGroupNotFoundException);
        }
        return n;
    }

    @Override
    public int getTargetPriority() {
        return this.targetPriority;
    }

    @Override
    public List<Target> getTargets() {
        ArrayList<Target> arrayList = new ArrayList<Target>();
        arrayList.addAll(this.targets);
        for (Target object : this.targets) {
            this.adjustCalibratorSubscanDurations(object);
        }
        for (IntermediateTarget intermediateTarget : this.children) {
            arrayList.addAll(intermediateTarget.getTargets());
        }
        return arrayList;
    }

    @Override
    public List<OrderedTarget> getOrderedTargets() {
        ArrayList<OrderedTarget> arrayList = new ArrayList<OrderedTarget>();
        arrayList.addAll(this.orderedTargets);
        for (IntermediateTarget intermediateTarget : this.children) {
            arrayList.addAll(intermediateTarget.getOrderedTargets());
        }
        return arrayList;
    }

    @Override
    public Target getRepresentativeTarget() {
        return null;
    }

    protected void setTargetPriority(int n) {
        this.targetPriority = n;
    }

    protected void adjustCalibratorSubscanDurations(Target target) {
        Time time = target.getSpectralSpec().getAbstractCorrelatorConfiguration().getIntegrationDuration();
        for (ObservingParameters observingParameters : target.getObservingParameters()) {
            if (!(observingParameters instanceof CalibratorParameters)) {
                return;
            }
            CalibratorParameters calibratorParameters = (CalibratorParameters)((Object)observingParameters);
            Time time2 = calibratorParameters.getSubScanDuration().adjustToIntegerMultipleOf(time);
            calibratorParameters.setSubScanDuration(time2);
        }
        int n = target.getFieldSource().getReferenceCount();
        if (n < 1) {
            return;
        }
        Reference reference = target.getFieldSource().getReference(0);
        Time time3 = reference.getSubScanDuration().adjustToIntegerMultipleOf(time);
        reference.setSubScanDuration(time3);
    }

    @Override
    @Deprecated
    public void setGroupName(String string) {
        this.groupName = string;
    }

    @Override
    @Deprecated
    public final String getGroupName() {
        throw new RuntimeException("This should not be getting called, get the group name via the Targets in the IntermediateTargets");
    }

    public ObservingGroupManager getObservingGroupManager() {
        return this.observingGroupManager;
    }

    public void setObservingGroupManager(ObservingGroupManager observingGroupManager) {
        this.observingGroupManager = observingGroupManager;
    }

    public Boolean isMultipleTuningScienceGoal(SpectralSetupParameters spectralSetupParameters) throws MinTuningsCalculator.UnableToCalculateMinNumberOfTunings {
        if (spectralSetupParameters.isSpectralScan()) {
            return false;
        }
        if (spectralSetupParameters.getParent() == null || !(spectralSetupParameters.getParent() instanceof ScienceGoal)) {
            return false;
        }
        ScienceGoal scienceGoal = (ScienceGoal)spectralSetupParameters.getParent();
        List<MinTuningsCalculator.TuningResult> list = MinTuningsCalculator.getLO1Tunings(scienceGoal);
        return list.size() > 1;
    }

    protected Collection<ScienceGoal> getSplitTunings(SpectralSetupParameters spectralSetupParameters) throws UnableToGetSplitTuningsException {
        if (spectralSetupParameters == null || !(spectralSetupParameters.getParent() instanceof ScienceGoal)) {
            throw new UnableToGetSplitTuningsException("Unable to establish the science goal parent of the SSP BO");
        }
        List<ScienceGoal> list = null;
        try {
            list = ScienceGoalSchedBlockGenerator.splitByTuning((ScienceGoal)spectralSetupParameters.getParent());
        }
        catch (MinTuningsCalculator.UnableToCalculateMinNumberOfTunings | IndexOutOfBoundsException exception) {
            Log.logger(AbstractIntermediateTarget.class).warning("Unable to derive split tunings" + exception.getMessage());
            throw new UnableToGetSplitTuningsException((Throwable)exception);
        }
        assert (list != null);
        return list;
    }

    @Override
    public final Time determineIntegrationTimes(Boolean bl, SpectralSetupParameters spectralSetupParameters, RequestedArray requestedArray) throws IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException {
        if (bl.booleanValue()) {
            return this.determineFDMIntegrationTimes(spectralSetupParameters, requestedArray);
        }
        return this.determineTDMIntegrationTimes(spectralSetupParameters, requestedArray);
    }

    @Override
    public final Time determineFDMIntegrationTimes(SpectralSetupParameters spectralSetupParameters, RequestedArray requestedArray) throws IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException {
        Time time = Time.createTimeSec(0.0);
        switch (requestedArray.getArray()) {
            case ARRAY_12M: {
                time = this.get12mFDMIntegrationTimes(spectralSetupParameters);
                break;
            }
            case ARRAY_7M: {
                time = this.get7mFDMIntegrationTimes(spectralSetupParameters);
                break;
            }
            case ARRAY_TP: {
                time = this.getTPFDMIntegrationTimes(spectralSetupParameters);
                break;
            }
            default: {
                throw new IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException("Unknown array detected");
            }
        }
        return time;
    }

    @Override
    public final Time determineTDMIntegrationTimes(SpectralSetupParameters spectralSetupParameters, RequestedArray requestedArray) throws IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException {
        Time time = Time.createTimeSec(0.0);
        switch (requestedArray.getArray()) {
            case ARRAY_12M: {
                time = this.get12mTDMIntegrationTimes(spectralSetupParameters);
                break;
            }
            case ARRAY_7M: {
                time = this.get7mTDMIntegrationTimes(spectralSetupParameters);
                break;
            }
            case ARRAY_TP: {
                time = this.getTPTDMIntegrationTimes(spectralSetupParameters);
                break;
            }
            default: {
                throw new IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException("Unknown array detected");
            }
        }
        return time;
    }

    @Override
    public Time getTPFDMIntegrationTimes(SpectralSetupParameters spectralSetupParameters) throws IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException {
        throw new IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException("Not implemented for this calibration type");
    }

    @Override
    public Time get7mFDMIntegrationTimes(SpectralSetupParameters spectralSetupParameters) throws IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException {
        throw new IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException("Not implemented for this calibration type");
    }

    @Override
    public Time get12mFDMIntegrationTimes(SpectralSetupParameters spectralSetupParameters) throws IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException {
        throw new IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException("Not implemented for this calibration type");
    }

    @Override
    public Time getTPTDMIntegrationTimes(SpectralSetupParameters spectralSetupParameters) throws IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException {
        throw new IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException("Not implemented for this calibration type");
    }

    @Override
    public Time get7mTDMIntegrationTimes(SpectralSetupParameters spectralSetupParameters) throws IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException {
        throw new IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException("Not implemented for this calibration type");
    }

    @Override
    public Time get12mTDMIntegrationTimes(SpectralSetupParameters spectralSetupParameters) throws IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException {
        throw new IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException("Not implemented for this calibration type");
    }

    public void addOrderedTarget(@NonNull Target target) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        OrderedTarget orderedTarget = OrderedTarget.createOrderedTarget();
        orderedTarget.setTarget(target);
        this.orderedTargets.add(orderedTarget);
    }

    public class UnableToGetSplitTuningsException
    extends Exception {
        public UnableToGetSplitTuningsException() {
        }

        public UnableToGetSplitTuningsException(String string) {
            super(string);
        }

        public UnableToGetSplitTuningsException(Throwable throwable) {
            super(throwable);
        }

        public UnableToGetSplitTuningsException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }
}

