/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.schedblock.FieldPattern;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.ObservingGroup;
import alma.obsprep.bo.schedblock.ObservingParameters;
import alma.obsprep.bo.schedblock.RectanglePattern;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.services.calibration.SBTimeEstimateHelper;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.sbbuilder.RepresentativeTargetCalculator;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.obsprep.services.generator.refactored.sbbuilder.TotalPowerSBGenerator;
import alma.valuetypes.Time;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;

class TotalPowerSBScienceTargetDistributor {
    private final SchedBlock schedBlock;
    private static final double tpMaxTOSPerSB_s = AlmaPolicies.getInstance().getTpMaxTOSPerSB().getSecs();

    public TotalPowerSBScienceTargetDistributor(@NonNull SchedBlock schedBlock) {
        if (schedBlock == null) {
            throw new NullPointerException("schedBlock is marked non-null but is null");
        }
        if (!schedBlock.isTotalPowerScienceSB()) {
            throw new IllegalArgumentException("The SB provided should be a TP science SB");
        }
        this.schedBlock = schedBlock;
    }

    public List<SchedBlock> ensureAllSourcesObservableWithinTPSBExecutionTOS() throws UnknownEntityException {
        ArrayList<SchedBlock> arrayList = new ArrayList<SchedBlock>();
        if (this.isRasteringAllSourcesInSameTPSBExecutionPossible(this.schedBlock)) {
            return ImmutableList.of((Object)this.schedBlock);
        }
        List<Map<FieldSource, Time>> list = this.createSBExecutionTimeCompliantSourceGroupings(this.schedBlock);
        assert (list != null && list.size() > 0) : "It is expected that there should be more than a single subgroup";
        arrayList.add(this.schedBlock);
        for (Map<FieldSource, Time> map2 : list.subList(1, list.size())) {
            SchedBlock schedBlock2 = this.schedBlock.deepCopy();
            schedBlock2.getSbGenerationContext().setSB(schedBlock2);
            List list2 = map2.keySet().stream().map(fieldSource -> fieldSource.getSourceName()).collect(Collectors.toList());
            List<Target> list3 = schedBlock2.getAllTargets(ScienceParameters.scienceParametersFilter);
            List list4 = list3.stream().filter(target -> !list2.contains(target.getFieldSource().getSourceName())).collect(Collectors.toList());
            list4.stream().forEach(target -> schedBlock2.removeTarget((Target)target));
            List list5 = list3.stream().filter(target -> !list2.contains(target.getFieldSource().getSourceName())).map(target -> target.getFieldSource()).collect(Collectors.toList());
            list5.stream().forEach(fieldSource -> schedBlock2.removeFieldSource((FieldSource)fieldSource));
            arrayList.add(schedBlock2);
        }
        List<Target> list6 = this.schedBlock.getAllTargets(ScienceParameters.scienceParametersFilter);
        list.subList(1, list.size()).stream().forEach(map -> map.entrySet().stream().forEach(entry -> {
            List list2 = map.keySet().stream().map(fieldSource -> fieldSource.getSourceName()).collect(Collectors.toList());
            this.schedBlock.removeFieldSource((FieldSource)entry.getKey());
            List list3 = list6.stream().filter(target -> list2.contains(target.getFieldSource().getSourceName())).collect(Collectors.toList());
            list3.stream().forEach(target -> this.schedBlock.removeTarget((Target)target));
        }));
        this.reassignRepresentativeTargetsInSBs(arrayList);
        arrayList.stream().forEach(schedBlock -> this.setObservingGroupDopplerTarget((SchedBlock)schedBlock));
        this.recalculateSpectralSpecsUsingReassignedDopplerTargets(arrayList);
        arrayList.stream().forEach(schedBlock -> this.removeUnusedScienceParameters((SchedBlock)schedBlock));
        return arrayList;
    }

    private void recalculateSpectralSpecsUsingReassignedDopplerTargets(List<SchedBlock> list) {
        for (SchedBlock schedBlock : list) {
            ScienceGoal scienceGoal = this.generateSGWithSBScienceTargetsOnly(schedBlock);
            TotalPowerSBGenerator totalPowerSBGenerator = new TotalPowerSBGenerator();
            Collection<Collection<SchedBlock>> collection = totalPowerSBGenerator.getSchedBlocks(scienceGoal);
            this.updateTPSubgroupSBSpectralSpecsForNewDopplerTarget(collection, schedBlock);
            Log.logger(TotalPowerSBScienceTargetDistributor.class).fine("New TP SBs have been generated");
        }
    }

    private void updateTPSubgroupSBSpectralSpecsForNewDopplerTarget(Collection<Collection<SchedBlock>> collection, SchedBlock schedBlock) {
        Set set = Arrays.stream(schedBlock.getFieldSource()).map(fieldSource -> fieldSource.getSourceName()).collect(Collectors.toSet());
        for (Collection<SchedBlock> collection2 : collection) {
            for (SchedBlock schedBlock2 : collection2) {
                Set set2 = Arrays.stream(schedBlock2.getFieldSource()).map(fieldSource -> fieldSource.getSourceName()).collect(Collectors.toSet());
                if (!set2.containsAll(set) || !set.containsAll(set2)) continue;
                this.reviseSpectralSpecUsingNewDopplerTarget(schedBlock2, schedBlock);
            }
        }
    }

    private void reviseSpectralSpecUsingNewDopplerTarget(SchedBlock schedBlock, SchedBlock schedBlock2) {
        HashSet hashSet = new HashSet();
        List<Target> list = schedBlock2.getAllTargets(ScienceParameters.scienceParametersFilter);
        for (Target target2 : list) {
            if (hashSet.contains(target2)) continue;
            String string = target2.getFieldSource().getSourceName();
            Target target3 = schedBlock.getAllTargets(ScienceParameters.scienceParametersFilter).stream().filter(target -> target.getFieldSource().getSourceName().equals(string)).findFirst().get();
            assert (target3.getFieldSource().getSourceName().equals(string));
            SpectralSpec spectralSpec = target2.getSpectralSpec();
            SpectralSpec spectralSpec2 = target3.getSpectralSpec();
            schedBlock2.addSpectralSpec(spectralSpec2);
            list.stream().filter(target -> target.getSpectralSpec().equals(spectralSpec)).forEach(target -> {
                target.setSpectralSpec(spectralSpec2);
                hashSet.add(target);
            });
            schedBlock2.removeSpectralSpec(spectralSpec);
        }
    }

    private ScienceGoal generateSGWithSBScienceTargetsOnly(@NonNull SchedBlock schedBlock) {
        if (schedBlock == null) {
            throw new NullPointerException("subgroupSB is marked non-null but is null");
        }
        ScienceGoal scienceGoal = schedBlock.getSbGenerationContext().getGoal().deepCopy();
        assert (scienceGoal != null);
        List<Target> list = schedBlock.getAllTargets(ScienceParameters.scienceParametersFilter);
        List<TargetParameters> list2 = Arrays.asList(scienceGoal.getTargetParameters());
        List list3 = list2.stream().filter(targetParameters -> !this.isTargetParameterInSB((TargetParameters)targetParameters, list)).collect(Collectors.toList());
        list3.stream().forEach(targetParameters -> scienceGoal.removeTargetParameters((TargetParameters)targetParameters));
        Log.logger(TotalPowerSBScienceTargetDistributor.class).fine("Target parameters in science goal " + scienceGoal.getKeyTargetParameters());
        return scienceGoal;
    }

    private boolean isTargetParameterInSB(TargetParameters targetParameters, List<Target> list) {
        return list.stream().filter(target -> target.getFieldSource().getTargetParameters().getSourceName().equals(targetParameters.getSourceName())).findFirst().isPresent();
    }

    private void removeUnusedScienceParameters(@NonNull SchedBlock schedBlock) {
        if (schedBlock == null) {
            throw new NullPointerException("schedBlock is marked non-null but is null");
        }
        Set set = schedBlock.getAllTargets(ScienceParameters.scienceParametersFilter).stream().map(target -> target.getFirstScienceParameters().get()).collect(Collectors.toSet());
        HashSet<ScienceParameters> hashSet = new HashSet<ScienceParameters>(Arrays.asList(schedBlock.getObservingParametersScienceParameters()));
        set.stream().forEach(scienceParameters -> hashSet.remove(scienceParameters));
        hashSet.stream().forEach(scienceParameters -> schedBlock.removeObservingParameters((ObservingParameters)((Object)scienceParameters)));
    }

    private void reassignRepresentativeTargetsInSBs(@NonNull List<SchedBlock> list) {
        if (list == null) {
            throw new NullPointerException("tpSBSubgroups is marked non-null but is null");
        }
        if (list.isEmpty()) {
            throw new IllegalArgumentException("Illegal argument: tpSBSubgroups.isEmpty() (" + list.isEmpty() + ") did not pass the test: tpSBSubgroups.isEmpty() test");
        }
        for (SchedBlock schedBlock : list) {
            List<Target> list2 = schedBlock.getAllTargets(ScienceParameters.scienceParametersFilter);
            if (list2.isEmpty()) continue;
            schedBlock.getSchedulingConstraints().setRepresentativeTarget(list2.get(0));
        }
    }

    private List<Map<FieldSource, Time>> createSBExecutionTimeCompliantSourceGroupings(@NonNull SchedBlock schedBlock) throws UnknownEntityException {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        Map<FieldSource, Time> map = this.getRasterScanTimesForSources(this.schedBlock);
        ArrayList<Map<FieldSource, Time>> arrayList = new ArrayList<Map<FieldSource, Time>>();
        double d = 0.0;
        LinkedHashMap<FieldSource, Time> linkedHashMap = new LinkedHashMap<FieldSource, Time>();
        for (Map.Entry<FieldSource, Time> entry : map.entrySet()) {
            double d2 = entry.getValue().getSecs();
            if (d2 + d <= tpMaxTOSPerSB_s) {
                linkedHashMap.put(entry.getKey(), entry.getValue());
            } else {
                arrayList.add(linkedHashMap);
                linkedHashMap = new LinkedHashMap();
                linkedHashMap.put(entry.getKey(), entry.getValue());
                d = 0.0;
            }
            d += d2;
        }
        if (!linkedHashMap.isEmpty()) {
            arrayList.add(linkedHashMap);
        }
        this.spreadSourcesEvenlyAcrossSubgroups(arrayList);
        return arrayList;
    }

    private List<Map<FieldSource, Time>> spreadSourcesEvenlyAcrossSubgroups(@NonNull List<Map<FieldSource, Time>> list) {
        if (list == null) {
            throw new NullPointerException("fieldSourceSubgroups is marked non-null but is null");
        }
        int n = list.size();
        int n2 = list.stream().mapToInt(map -> map.size()).sum();
        int n3 = n2 / n;
        Comparator comparator = (map, map2) -> Integer.valueOf(map.size()).compareTo(map2.size());
        Comparator comparator2 = (map, map2) -> Integer.valueOf(map2.size()).compareTo(map.size());
        List list2 = list.stream().sorted(comparator).collect(Collectors.toList());
        List list3 = list.stream().sorted(comparator2).collect(Collectors.toList());
        block0: for (Map map3 : list3) {
            for (Map map4 : list2) {
                boolean bl = false;
                do {
                    Map.Entry entry3;
                    bl = false;
                    if (map3.size() <= n3 || map4.size() >= n3 || map3.size() <= map4.size()) continue block0;
                    if (map3 == map4) break block0;
                    Comparator comparator3 = (entry, entry2) -> {
                        Integer n = (int)((Time)entry.getValue()).getSecs();
                        Integer n2 = (int)((Time)entry2.getValue()).getSecs();
                        return n.compareTo(n2);
                    };
                    Optional optional = map3.entrySet().stream().min(comparator3);
                    double d = map4.entrySet().stream().mapToDouble(entry -> ((Time)entry.getValue()).getSecs()).sum();
                    if (!(d + ((Time)(entry3 = (Map.Entry)optional.orElseThrow(() -> new WizardSBGenerationException("Failed to get smallest t_rect"))).getValue()).getSecs() <= tpMaxTOSPerSB_s)) continue;
                    map4.put((FieldSource)entry3.getKey(), (Time)entry3.getValue());
                    map3.remove(entry3.getKey());
                    bl = true;
                } while (bl);
            }
        }
        return list;
    }

    private Map<FieldSource, Time> getRasterScanTimesForSources(@NonNull SchedBlock schedBlock) throws UnknownEntityException {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        boolean bl = schedBlock.getSbGenerationContext().getGoal().isSolarScienceGoal();
        Time time3 = AlmaPolicies.getInstance().getItosForSolarSource();
        HashMap<FieldSource, Time> hashMap = new HashMap<FieldSource, Time>();
        for (Target target : schedBlock.getAllTargets(ScienceParameters.scienceParametersFilter)) {
            FieldSource fieldSource = target.getFieldSource();
            if (!fieldSource.getFieldPatternType().equals(FieldPattern.FieldPatternType.RECTANGLE.getLabel())) {
                throw new RuntimeException("Unexpected field type found in TP science TP: " + fieldSource.getFieldPatternType());
            }
            RectanglePattern rectanglePattern = (RectanglePattern)((Object)fieldSource.getFieldPattern());
            Time time4 = target.getFirstScienceParameters().orElseThrow(() -> new WizardSBGenerationException("Unable to get science parameters")).getSubScanDuration();
            Time time5 = bl ? time3.deepCopy() : Time.createTimeSec(time4.getSecs() * (double)rectanglePattern.getRowCount());
            hashMap.put(fieldSource, time5);
        }
        Map map = hashMap.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.naturalOrder())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (time, time2) -> time, LinkedHashMap::new));
        return map;
    }

    private boolean isRasteringAllSourcesInSameTPSBExecutionPossible(@NonNull SchedBlock schedBlock) {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        double d = 0.0;
        for (Target target : schedBlock.getAllTargets(ScienceParameters.scienceParametersFilter)) {
            ScienceParameters scienceParameters = target.getFirstScienceParameters().orElseThrow(() -> new WizardSBGenerationException("Unable to find science parameters when expected"));
            double d2 = scienceParameters.getTPRasterData().orElseThrow(() -> new WizardSBGenerationException("No TP raster data found when expected")).getT_rect().getSecs();
            d += d2;
        }
        return d <= tpMaxTOSPerSB_s;
    }

    private void setObservingGroupDopplerTarget(@NonNull SchedBlock schedBlock) {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        for (ObservingGroup observingGroup : schedBlock.getObservingGroup()) {
            String string = observingGroup.getName();
            assert (string != null);
            try {
                if (!SBTimeEstimateHelper.GroupType.SCIENCE.equals((Object)SBTimeEstimateHelper.GroupType.getGroupType(string))) continue;
                RepresentativeTargetCalculator representativeTargetCalculator = new RepresentativeTargetCalculator();
                Target target = representativeTargetCalculator.getRepresentativeScienceTargetInObservingGroup(observingGroup, schedBlock, schedBlock.getSbGenerationContext());
                observingGroup.setMainTarget(target);
                Log.logger(SBGeneratorTemplate.class).fine(String.format("Rep. target for observing group %s is %s", observingGroup.getName(), target.getFieldSource().getSourceName()));
            }
            catch (SchedBlock.UnableToFindParentScienceGoalException | SBTimeEstimateHelper.UnknownObservingGroupTypeException | RepresentativeTargetCalculator.UnableToDetermineRepTargetForObservingGroupException exception) {
                throw new WizardSBGenerationException("Unable to set the doppler target for the observing group: " + string + " " + exception.getMessage());
            }
        }
    }
}

