/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.annotations.ObsUnitSetComponent;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.SchedulingConstraints;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.OUSStructureBuilder;
import alma.obsprep.services.generator.refactored.OUSStructureBuilderInterface;
import alma.obsprep.services.generator.refactored.SchedBlockPostProcessor;
import alma.obsprep.services.generator.refactored.SchedBlockWorker;
import alma.obsprep.services.generator.refactored.StandardOUSStructureBuilder;
import alma.obsprep.services.generator.refactored.ousgenerator.OUSGenerator;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Optional;
import lombok.NonNull;

public class Simultaneous12mAndACAOUSStructureBuilder
extends OUSStructureBuilder
implements OUSStructureBuilderInterface {
    public Simultaneous12mAndACAOUSStructureBuilder(OUSGenerator oUSGenerator, ObsUnitSet obsUnitSet, ScienceGoal scienceGoal) {
        super(oUSGenerator, obsUnitSet, scienceGoal);
    }

    @Override
    public void createOUSStructure(SchedBlockPostProcessor schedBlockPostProcessor, Collection<ScienceGoal> collection, Integer n, Boolean bl, Boolean bl2) {
        PerformanceParameters performanceParameters = this.userDefinedScienceGoal.getPerformanceParameters();
        for (int i = 0; i < n; ++i) {
            for (ScienceGoal scienceGoal : collection) {
                Collection<Collection<SchedBlock>> collection2;
                try {
                    collection2 = this.getSchedBlocks(scienceGoal);
                }
                catch (UnknownEntityException | WizardSBGenerationException throwable) {
                    throw new WizardSBGenerationException(throwable);
                }
                this.bundleTPSBsInSameOUSGroup(collection2);
                for (Collection<SchedBlock> collection3 : collection2) {
                    for (ObsUnitSetComponent obsUnitSetComponent : collection3) {
                        for (Collection<SchedBlock> collection4 : collection2) {
                            for (SchedBlock schedBlock : collection4) {
                                if (obsUnitSetComponent.equals(schedBlock) || schedBlock.isTotalPowerAmpcalSB() || ((SchedBlock)obsUnitSetComponent).isTotalPowerAmpcalSB()) continue;
                                Log.logger(Simultaneous12mAndACAOUSStructureBuilder.class).info("SB " + (SchedBlock)obsUnitSetComponent + " to be simultaneously observed with " + schedBlock);
                                SchedulingConstraints schedulingConstraints = obsUnitSetComponent.getSchedulingConstraints();
                                schedulingConstraints.setIsSimultaneous(true);
                                schedulingConstraints.addSimultaneousSbUid(schedBlock.getEntityID());
                            }
                        }
                    }
                }
                LinkedHashMap linkedHashMap = new LinkedHashMap();
                for (Collection<SchedBlock> collection5 : collection2) {
                    ObsUnitSetComponent obsUnitSetComponent;
                    if (collection5.isEmpty()) continue;
                    obsUnitSetComponent = this.ousGenerator.getGroupOUS();
                    this.rootOUS.addObsUnitSet((ObsUnitSet)obsUnitSetComponent);
                    this.addSBsToOUSes(n, performanceParameters, bl, i, scienceGoal, (ObsUnitSet)obsUnitSetComponent, collection5);
                    linkedHashMap.put(obsUnitSetComponent, collection5);
                }
                for (ObsUnitSet obsUnitSet : linkedHashMap.keySet()) {
                    schedBlockPostProcessor.postProcessSBGroup(n, performanceParameters, bl, i, scienceGoal, obsUnitSet, (Collection<Collection<SchedBlock>>)ImmutableList.of((Object)((Collection)linkedHashMap.get(obsUnitSet))), Optional.of(linkedHashMap));
                }
            }
            try {
                SchedBlockWorker.appendTuningIndicatorToSpectralSpecs(this.rootOUS);
                continue;
            }
            catch (UnknownEntityException unknownEntityException) {
                Log.logger(StandardOUSStructureBuilder.class).warning("Unable to re-label the spectral specs ");
            }
        }
    }

    private void bundleTPSBsInSameOUSGroup(@NonNull Collection<Collection<SchedBlock>> collection) {
        if (collection == null) {
            throw new NullPointerException("schedBlocksForSG is marked non-null but is null");
        }
        ArrayList<Collection<SchedBlock>> arrayList = new ArrayList<Collection<SchedBlock>>();
        Collection<SchedBlock> collection2 = null;
        for (Collection<SchedBlock> collection3 : collection) {
            for (SchedBlock schedBlock : collection3) {
                if (!schedBlock.isTotalPowerAmpcalSB() && !schedBlock.isTotalPowerScienceSB()) continue;
                if (collection2 == null) {
                    collection2 = collection3;
                    continue;
                }
                collection2.add(schedBlock);
                arrayList.add(collection3);
            }
        }
        collection.removeAll(arrayList);
    }
}

