/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.entity.xmlbinding.obsproject.types.ControlBlockTArrayRequestedType;
import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.annotations.ObsUnitSetComponent;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.obsproject.ExpectedPropertiesElements;
import alma.obsprep.bo.obsproject.OUSLocator;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproject.UnableToFindSolutionException;
import alma.obsprep.bo.obsproposal.ExecutiveFraction;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.obsproposal.ProposalFeedback;
import alma.obsprep.bo.obsproposal.TimeAllocationBreakdown;
import alma.obsprep.bo.schedblock.CheckSourceCalParameters;
import alma.obsprep.bo.schedblock.ObservingGroup;
import alma.obsprep.bo.schedblock.OrderedTarget;
import alma.obsprep.bo.schedblock.PolarizationCalParameters;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.SchedBlockControl;
import alma.obsprep.bo.schedblock.SchedulingConstraints;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.ot.models.sciencegoals.TechnicalJustificationModel;
import alma.obsprep.services.calibration.SBTimeEstimateHelper;
import alma.obsprep.services.etc.ObservingTimeCalculator;
import alma.obsprep.services.etc.SolarExecutionTimeCalculator;
import alma.obsprep.services.etc.SourceNeverVisibleException;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.experts.ConfigurationSet;
import alma.obsprep.services.experts.InvalidFrequencyException;
import alma.obsprep.services.experts.SchedBlockExpert;
import alma.obsprep.services.experts.ScienceGoalConfigurations;
import alma.obsprep.services.experts.VLBIExpert;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.ArraySBGroupPostProcessorFactory;
import alma.obsprep.services.generator.refactored.DGCPostProcessor;
import alma.obsprep.services.generator.refactored.IntegerMosaicEnforcerFactory;
import alma.obsprep.services.generator.refactored.IntegerMosaicEnforcerInterface;
import alma.obsprep.services.generator.refactored.ObsType;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.SchedBlockWorker;
import alma.obsprep.services.generator.refactored.ScienceGoalSchedBlockGenerator;
import alma.obsprep.services.generator.refactored.ScienceParametersSensitivityCalculator;
import alma.obsprep.services.generator.refactored.SolarSBConfigurator;
import alma.obsprep.services.generator.refactored.SpectralLineSBPostProcessor;
import alma.obsprep.services.generator.refactored.StaleSBDetector;
import alma.obsprep.services.generator.refactored.StandardOUSStructureAssemblerFactory;
import alma.obsprep.services.generator.refactored.TargetCache;
import alma.obsprep.services.generator.refactored.TotalPowerIntegrationTimeCalculator;
import alma.obsprep.services.generator.refactored.intermediatetarget.PhaseCalIntermediateTarget;
import alma.obsprep.services.generator.refactored.obsparams.AbstractObservingParametersFactory;
import alma.obsprep.services.generator.refactored.obsparams.CalibrationTimerInterface;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.obsprep.services.generator.refactored.spectralspec.SpectralSpecFactory;
import alma.obsprep.services.generator.refactored.spectralspec.Walsh90DegConfiguratorFactory;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.IntTimeSource;
import alma.valuetypes.Sensitivity;
import alma.valuetypes.Time;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Sets;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class SchedBlockPostProcessor {
    private final SpectralLineSBPostProcessor spectralLineSBPostProcessor = new SpectralLineSBPostProcessor();
    private final Log.Logger logger = Log.logger((Object)this);
    private final boolean isSBGenerationUserInitiated;
    private final ScienceGoal piDefinedScienceGoal;
    private final ObsUnitSet rootOUS;

    public void postProcessSBGroup(Integer n, PerformanceParameters performanceParameters, Boolean bl, int n2, ScienceGoal scienceGoal, ObsUnitSet obsUnitSet, Collection<Collection<SchedBlock>> collection, Optional<Map<ObsUnitSet, Collection<SchedBlock>>> optional) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        this.enforceMinimumExecutionTimes(bl, n2, obsUnitSet, scienceGoal);
        for (Collection<SchedBlock> collection2 : collection) {
            for (SchedBlock schedBlock : collection2) {
                try {
                    this.postProcessSB(scienceGoal, schedBlock);
                }
                catch (Exception exception) {
                    throw new WizardSBGenerationException(exception);
                }
            }
            ArraySBGroupPostProcessorFactory.getSBGroupPostProcessor(collection2).ifPresent(arraySBGroupPostProcessorInterface -> arraySBGroupPostProcessorInterface.postProcessSBArrayGroup(collection2, scienceGoal));
        }
        this.setSBSchedulingConstraintsDynamicRange(collection, scienceGoal, optional);
        stopwatch.stop();
        Log.logger(ScienceGoalSchedBlockGenerator.class).fine("Time to post process SB group " + stopwatch.toString());
    }

    private void setSBSchedulingConstraintsDynamicRange(@NonNull Collection<Collection<SchedBlock>> collection, @NonNull ScienceGoal scienceGoal, @NonNull Optional<Map<ObsUnitSet, Collection<SchedBlock>>> optional) {
        if (collection == null) {
            throw new NullPointerException("schedblockGroups is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("clusteredScienceGoal is marked non-null but is null");
        }
        if (optional == null) {
            throw new NullPointerException("ousesToBeProcessed is marked non-null but is null");
        }
        if (scienceGoal.getPerformanceParameters().isSimultaneous12and7Observation()) {
            this.setDynamicRangeForSim12m7mSGs(collection, optional);
        } else {
            Optional<SchedBlock> optional2 = Optional.empty();
            block0: for (Collection<SchedBlock> collection2 : collection) {
                for (SchedBlock schedBlock : collection2) {
                    if (!(scienceGoal.isStandAloneACA() ? schedBlock.isACA7mArraySB() : schedBlock.is12mExtendedArraySB())) continue;
                    optional2 = Optional.of(schedBlock);
                    continue block0;
                }
            }
            for (Collection<SchedBlock> collection2 : collection) {
                for (SchedBlock schedBlock : collection2) {
                    this.setDynamicRangeAttributes(collection, schedBlock, optional2);
                }
            }
        }
    }

    private void setDynamicRangeForSim12m7mSGs(@NonNull Collection<Collection<SchedBlock>> collection, @NonNull Optional<Map<ObsUnitSet, Collection<SchedBlock>>> optional) {
        if (collection == null) {
            throw new NullPointerException("schedblockGroups is marked non-null but is null");
        }
        if (optional == null) {
            throw new NullPointerException("ousesToBeProcessed is marked non-null but is null");
        }
        Optional<SchedBlock> optional2 = Optional.empty();
        for (Collection<SchedBlock> collection2 : collection) {
            for (SchedBlock schedBlock : collection2) {
                if (schedBlock.is12mCompactArraySB() || schedBlock.isACA7mArraySB()) {
                    String[] stringArray = schedBlock.getSchedulingConstraints().getSimultaneousSbUid();
                    block2: for (Collection<SchedBlock> collection3 : optional.orElseThrow(() -> new WizardSBGenerationException("No OUSes provided for sim12+7m")).values()) {
                        for (SchedBlock schedBlock2 : collection3) {
                            boolean bl = Stream.of(stringArray).anyMatch(string -> schedBlock2.getEntityID().equals(string) && schedBlock2.is12mExtendedArraySB());
                            if (!bl) continue;
                            optional2 = Optional.of(schedBlock2);
                            break block2;
                        }
                    }
                }
                this.setDynamicRangeAttributes(collection, schedBlock, optional2);
            }
        }
    }

    private void enforceMinimumExecutionTimes(Boolean bl, int n, ObsUnitSet obsUnitSet, ScienceGoal scienceGoal) {
        boolean bl2 = scienceGoal.isStandAloneACA();
        ObsUnitSet obsUnitSet2 = null;
        Integer n2 = null;
        SBGeneratorTemplate.SchedBlockType schedBlockType = null;
        if (bl2) {
            n2 = 1;
            schedBlockType = SBGeneratorTemplate.SchedBlockType.ACA7M;
        } else {
            schedBlockType = SBGeneratorTemplate.SchedBlockType.TWELVEMEXTENDEDCONFIGURATION;
            try {
                n2 = scienceGoal.getNumberOf12MAntennaConfigurations();
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                this.logger.warning("Unable to determine number of 12m antenna configurations");
                throw new WizardSBGenerationException(invalidObsProgramParametersException);
            }
        }
        assert (n2 != null && schedBlockType != null);
        try {
            obsUnitSet2 = this.findOUS(obsUnitSet, schedBlockType);
        }
        catch (UnknownEntityException unknownEntityException) {
            this.logger.warning("Unable to find SBs in OUS structure");
            throw new WizardSBGenerationException(unknownEntityException);
        }
        finally {
            if (obsUnitSet2 == null) {
                return;
            }
        }
        if (bl.booleanValue()) {
            this.enforceSBExecutionTimesForContinuousMonitoring(n, obsUnitSet2, scienceGoal);
        } else if (n2 > 1) {
            ObsUnitSet obsUnitSet3 = null;
            try {
                obsUnitSet3 = this.findOUS(obsUnitSet, SBGeneratorTemplate.SchedBlockType.TWELVEMCOMPACTCONFIGURATION);
            }
            catch (UnknownEntityException unknownEntityException) {
                this.logger.warning("Unable to find SBs in OUS structure");
                throw new WizardSBGenerationException(unknownEntityException);
            }
            finally {
                if (obsUnitSet3 == null) {
                    throw new WizardSBGenerationException("Unable to find 12m compact array SBs in OUS structure");
                }
            }
            this.enforceSBExecutionTimesForMultiple12mConfigurations(obsUnitSet3, obsUnitSet2, scienceGoal);
        } else if (scienceGoal.getPerformanceParameters().getNeedsMoreTime()) {
            this.enforceSBExecutionTimeForTimeOverrides(obsUnitSet2, scienceGoal);
        } else if (scienceGoal.isPolarizationObservation()) {
            this.enforcePolarizationTime(scienceGoal, obsUnitSet);
        }
    }

    private void enforcePolarizationTime(@NonNull ScienceGoal scienceGoal, ObsUnitSet obsUnitSet) {
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        List<SchedBlock> list = new ArrayList<SchedBlock>();
        SchedBlockWorker.findSBsUnderOUS(list, obsUnitSet);
        list = list.stream().filter(schedBlock -> schedBlock.is12mCompactArraySB() || schedBlock.is12mExtendedArraySB()).collect(Collectors.toList());
        assert (list != null);
        if (!list.isEmpty()) {
            Time time = AlmaPolicies.getInstance().getMinTimeForPolarisationSB();
            this.enforceMinSBExecutionTime(time, list, scienceGoal);
        }
    }

    private void enforceSBExecutionTimeForTimeOverrides(ObsUnitSet obsUnitSet, ScienceGoal scienceGoal) {
        Time time = AlmaPolicies.getInstance().getMinTimeForPolarisationSB();
        Time time2 = scienceGoal.getPerformanceParameters().getDesiredTime().deepCopy();
        if (time2 == null || time2.isZero()) {
            throw new WizardSBGenerationException("Time override requested is either not specified or zero");
        }
        if (scienceGoal.isPolarizationObservation()) {
            this.enforceProjectExecutionTime(Time.max(time2, time), obsUnitSet, scienceGoal);
        } else {
            this.enforceProjectExecutionTime(time2, obsUnitSet, scienceGoal);
        }
    }

    private void enforceSBExecutionTimesForMultiple12mConfigurations(ObsUnitSet obsUnitSet, ObsUnitSet obsUnitSet2, ScienceGoal scienceGoal) {
        assert (obsUnitSet != null);
        assert (obsUnitSet2 != null);
        Time time = AlmaPolicies.getInstance().getMinTimeForPolarisationSB();
        boolean bl = scienceGoal.getPerformanceParameters().getNeedsMoreTime();
        Time time2 = null;
        if (bl) {
            Time time3 = scienceGoal.getPerformanceParameters().getDesiredTime().deepCopy();
            if (time3 == null || time3.isZero()) {
                throw new WizardSBGenerationException("Time override requested is either not specified or zero");
            }
            Time time4 = null;
            try {
                time4 = (Time)time3.multiply(Configuration.getArrayTimeMultiplier(Configuration.MultiplierEnumType.COMPACT12M, scienceGoal));
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                throw new WizardSBGenerationException("Unable to determine 12m compact array time multiplier: " + invalidObsProgramParametersException.getMessage());
            }
            assert (time4 != null);
            Time time5 = null;
            Time time6 = null;
            if (scienceGoal.isPolarizationObservation()) {
                time6 = Time.max(time3, time);
                time5 = Time.max(time4, time);
            } else {
                time5 = time4;
                time6 = time3;
            }
            assert (time5 != null);
            assert (time6 != null);
            this.enforceProjectExecutionTime(time6, obsUnitSet2, scienceGoal);
            this.enforceProjectExecutionTime(time5, obsUnitSet, scienceGoal);
        } else if (scienceGoal.isPolarizationObservation()) {
            this.enforcePolarizationTime(scienceGoal, obsUnitSet);
            this.enforcePolarizationTime(scienceGoal, obsUnitSet2);
        } else {
            try {
                for (SchedBlock schedBlock : obsUnitSet2.getSchedBlock()) {
                    if (!schedBlock.is12mExtendedArraySB()) continue;
                    time2 = (Time)ObservingTimeCalculator.getExecutionTimeForSB(schedBlock, scienceGoal).multiply(Configuration.getArrayTimeMultiplier(Configuration.MultiplierEnumType.COMPACT12M, scienceGoal));
                }
            }
            catch (Exception exception) {
                this.logger.warning("Unable to determine execution time 12m extended array");
                throw new WizardSBGenerationException(exception);
            }
            finally {
                if (time2 == null) {
                    this.logger.warning("Unable to determine the minimum execution time for the 12m compact array");
                    throw new WizardSBGenerationException("Unable to determine the minimum execution time for the 12m compact array");
                }
            }
            assert (time2 != null);
            this.enforceProjectExecutionTime(time2, obsUnitSet, scienceGoal);
        }
    }

    private void enforceSBExecutionTimesForContinuousMonitoring(int n, ObsUnitSet obsUnitSet, ScienceGoal scienceGoal) {
        Time time = AlmaPolicies.getInstance().getMinTimeForPolarisationSB();
        Time time2 = scienceGoal.getPerformanceParameters().getMonitoringConstraint(n).getMonitoringLength();
        Time time3 = scienceGoal.isPolarizationObservation() ? (time2.isGreaterThan((AbstractDoubleWithUnit)time) ? time2 : time) : time2;
        this.enforceProjectExecutionTime(time3, obsUnitSet, scienceGoal);
    }

    private void enforceProjectExecutionTime(Time time, ObsUnitSet obsUnitSet, ScienceGoal scienceGoal) {
        Time time2;
        if (time == null) {
            this.logger.warning("The minimum project time is not set");
            return;
        }
        try {
            time2 = SchedBlockPostProcessor.determineOUSExecutionTime(obsUnitSet, scienceGoal);
        }
        catch (Exception exception) {
            this.logger.warning("Unable to determine the project execution time : " + exception.getMessage());
            throw new WizardSBGenerationException(exception);
        }
        this.logger.fine("Minimum execution time : " + time + " project time " + time2 + " for OUS " + obsUnitSet.getName());
        if (time2.isLessThan((AbstractDoubleWithUnit)time)) {
            try {
                this.adjustTOSInSBsToMatchRequestedMinimumExecutionTime(time2, time, obsUnitSet, scienceGoal);
            }
            catch (Exception exception) {
                this.logger.warning("Unable to increase the TOS in the science parameters : " + exception.getMessage());
                throw new WizardSBGenerationException(exception);
            }
            if (this.logger.isLoggable(Level.FINE)) {
                try {
                    Time time3 = SchedBlockPostProcessor.determineOUSExecutionTime(obsUnitSet, scienceGoal);
                    this.logger.fine("Revised project time : " + time3.getContentInUnits(Time.UNIT_MIN) + " mins ");
                }
                catch (Exception exception) {
                    this.logger.warning("Unable to determine the project execution time : " + exception.getMessage());
                }
            }
        }
    }

    private void enforceMinSBExecutionTime(Time time, @NonNull List<SchedBlock> list, @NonNull ScienceGoal scienceGoal) {
        if (list == null) {
            throw new NullPointerException("schedBlocks is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        if (time == null) {
            this.logger.warning("The minimum SB execution time is not set");
            return;
        }
        for (SchedBlock schedBlock : list) {
            try {
                this.adjustTOSInSBToMatchRequestedMinimumExecutionTime(time, schedBlock, scienceGoal);
            }
            catch (Exception exception) {
                this.logger.warning("Unable to increase the TOS in the science parameters : " + exception.getMessage());
                throw new WizardSBGenerationException(exception);
            }
            if (!this.logger.isLoggable(Level.FINE)) continue;
            try {
                Time time2 = ObservingTimeCalculator.getExecutionTimeForSB(schedBlock, scienceGoal);
                this.logger.fine("Revised SB execution time : " + time2.getContentInUnits(Time.UNIT_MIN) + " mins  for SB " + schedBlock.getName() + " minimum time required was " + time.getContentInUnits(Time.UNIT_MIN));
            }
            catch (Exception exception) {
                this.logger.warning("Unable to determine the SB execution time : " + exception.getMessage());
            }
        }
    }

    public static Time determineOUSExecutionTime(ObsUnitSet obsUnitSet, ScienceGoal scienceGoal) throws InvalidObsProgramParametersException, SBTimeEstimateHelper.UnknownObservingGroupTypeException, UnknownEntityException {
        Time time = Time.createTimeSec(0.0);
        for (ObsUnitSet obsUnitSetComponent : obsUnitSet.getObsUnitSet()) {
            time.aggregate(SchedBlockPostProcessor.determineOUSExecutionTime(obsUnitSetComponent, scienceGoal));
        }
        for (ObsUnitSetComponent obsUnitSetComponent : obsUnitSet.getSchedBlock()) {
            time.aggregate(ObservingTimeCalculator.getExecutionTimeForSB((SchedBlock)obsUnitSetComponent, scienceGoal));
        }
        return time;
    }

    private void postProcessSB(@NonNull ScienceGoal scienceGoal, @NonNull SchedBlock schedBlock) throws WizardSBGenerationException, Exception {
        boolean bl;
        Object object;
        EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet;
        List<ObsUnitSet> list;
        Object object2;
        boolean bl2;
        Object object3;
        boolean bl3;
        if (scienceGoal == null) {
            throw new NullPointerException("clusteredSG is marked non-null but is null");
        }
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        SBGenerationContext sBGenerationContext = schedBlock.getSbGenerationContext();
        if (sBGenerationContext.is7mSB() && !scienceGoal.isStandAloneACA()) {
            this.baseACA7mScienceParameterTimingsBasedOnTMTimings(schedBlock, scienceGoal);
        }
        if (!VLBIExpert.isScienceGoalLegalVLBISpectralLine(scienceGoal)) {
            this.spectralLineSBPostProcessor.performRestLinePostProcessing(scienceGoal, schedBlock);
        }
        if (bl3 = scienceGoal.isSolarScienceGoal()) {
            SolarExecutionTimeCalculator solarExecutionTimeCalculator = new SolarExecutionTimeCalculator();
            int n = schedBlock.getAllTargets(ScienceParameters.scienceParametersFilter).size();
            SolarExecutionTimeCalculator.SolarExecutionTimeResult solarExecutionTimeResult = solarExecutionTimeCalculator.calculateSolarIntegrationTimes(scienceGoal.getPerformanceParameters().getDesiredTime(), scienceGoal.getReceiverBand().getNumber(), n);
            object3 = new SolarSBConfigurator(schedBlock, solarExecutionTimeResult);
            ((SolarSBConfigurator)object3).configureSBForSolar();
        }
        if (bl2 = sBGenerationContext.getGoal().getSpectralSetupParameters().isWalshSwitching()) {
            this.walshSwitching90DegreePostProcessing(schedBlock);
        } else {
            this.setCorrelatorTimingsToTDMDefaults();
        }
        boolean bl4 = scienceGoal.getPerformanceParameters().isSimultaneous12and7Observation();
        try {
            object3 = new OUSLocator.Builder();
            ((OUSLocator.Builder)object3).rootOUS(this.rootOUS).scienceGoal(scienceGoal).simultaneousArrayOperation(bl4);
            object2 = new OUSLocator((OUSLocator.Builder)object3);
            list = ((OUSLocator)object2).locateOUS();
        }
        catch (OUSLocator.UnableToLocateObsUnitSetException unableToLocateObsUnitSetException) {
            throw new WizardSBGenerationException(unableToLocateObsUnitSetException);
        }
        object3 = StandardOUSStructureAssemblerFactory.getStandardOUSStructureAssembler(bl4 ? StandardOUSStructureAssemblerFactory.OUSStructureFormat.SIMULTANEOUS_12M_ACA : StandardOUSStructureAssemblerFactory.OUSStructureFormat.STANDARD_FORMAT);
        object2 = object3.assembleStandardOUSStructure(list);
        ObservingTimeCalculator.Builder builder = new ObservingTimeCalculator.Builder();
        builder.noSBGeneration(true).obsUnitSet((ObsUnitSet)object2).scienceGoal(scienceGoal);
        ObservingTimeCalculator observingTimeCalculator = new ObservingTimeCalculator(builder);
        try {
            enumSet = SBGeneratorTemplate.determineSBGenerationSchema(scienceGoal, schedBlock.getObsUnitControl().getArrayRequested());
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(ScienceGoalSchedBlockGenerator.class).info("Unable to post-process SBs : " + unknownEntityException.getMessage());
            throw new WizardSBGenerationException(unknownEntityException);
        }
        RequestedArray requestedArray = RequestedArray.valueOf(ControlBlockTArrayRequestedType.valueOf((String)schedBlock.getObsUnitControl().getArrayRequested()));
        boolean bl5 = this.isLongbaselineConfigurationScheduled(scienceGoal, schedBlock, bl3, requestedArray);
        if (!bl3) {
            if (schedBlock.isTotalPowerScienceSB()) {
                this.setupNonSolarTPSB(scienceGoal, schedBlock, list, observingTimeCalculator);
            } else {
                this.quantizeParametersInInterferometricSBs(schedBlock, requestedArray, enumSet, bl5);
            }
        }
        this.setupPolarizationCalibratorSubscanDurations(scienceGoal, schedBlock);
        try {
            SchedBlockPostProcessor.reviseCheckSourceObservingParameters(schedBlock, scienceGoal);
        }
        catch (SchedBlock.UnableToFindParentScienceGoalException unableToFindParentScienceGoalException) {
            this.logger.warning("Unable to adjust check source cycle: " + unableToFindParentScienceGoalException);
        }
        this.setEstimatedTimeForSBInOUS(schedBlock, observingTimeCalculator, requestedArray);
        try {
            object = new ScienceParametersSensitivityCalculator();
            ((ScienceParametersSensitivityCalculator)object).setScienceParametersSensitivity(schedBlock, requestedArray, observingTimeCalculator, scienceGoal, this.piDefinedScienceGoal);
        }
        catch (ScienceGoalSchedBlockGenerator.UnableToDetermineSensitivityException unableToDetermineSensitivityException) {
            Log.logger(ScienceGoalSchedBlockGenerator.class).warning("Error when determining the sensitivity: " + unableToDetermineSensitivityException.getMessage());
        }
        this.copyExecutiveSharesIntoSB(scienceGoal, schedBlock);
        if (this.isSBGenerationUserInitiated) {
            StaleSBDetector.getInstance().setSBInSyncWithGeneratingSG(schedBlock, this.piDefinedScienceGoal);
        }
        object = sBGenerationContext.getSchemaToUseForSBGeneration();
        boolean bl6 = bl = !schedBlock.isTP() && ((AbstractCollection)object).contains((Object)SBGeneratorTemplate.SBGenerationSchema.DGC) && !this.piDefinedScienceGoal.getCalibrationSetupParameters().getIsDGCOverride();
        if (schedBlock.is12mCompactArraySB() || schedBlock.isACA7mArraySB()) {
            bl &= !Sets.intersection((Set)object, EnumSet.of(SBGeneratorTemplate.SBGenerationSchema.DGC_BWSW)).isEmpty();
        }
        if (bl) {
            new DGCPostProcessor(schedBlock).postProcessDGCTargets();
        }
        this.removeUnusedP2Components(schedBlock);
        object3.resetOUSStructure();
    }

    private void setDynamicRangeAttributes(@NonNull Collection<Collection<SchedBlock>> collection, @NonNull SchedBlock schedBlock, @NonNull Optional<SchedBlock> optional) {
        if (collection == null) {
            throw new NullPointerException("schedblockGroups is marked non-null but is null");
        }
        if (schedBlock == null) {
            throw new NullPointerException("sbToProcess is marked non-null but is null");
        }
        if (optional == null) {
            throw new NullPointerException("principalArray is marked non-null but is null");
        }
        SBGenerationContext sBGenerationContext = schedBlock.getSbGenerationContext();
        ScienceGoal scienceGoal = sBGenerationContext.getGoal();
        boolean bl = false;
        try {
            bl = scienceGoal.isSolarScienceGoal() || scienceGoal.getObsProposal().isVLBIorPhasedArray();
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(SchedBlockPostProcessor.class).warning("Unable to determine if solar/VLBI: " + unknownEntityException.getMessage());
        }
        SchedulingConstraints schedulingConstraints = schedBlock.getSchedulingConstraints();
        if (schedBlock.isTP() || bl) {
            schedulingConstraints.setSpectralDynamicRange(0.0);
            schedulingConstraints.setDynamicRange(0.0);
            schedulingConstraints.setSpectralDynamicRangeBandwidth(Frequency.createFrequencyMHZ(0.0));
        } else {
            boolean bl2;
            boolean bl3 = bl2 = !scienceGoal.isStandAloneACA() && (schedBlock.is12mCompactArraySB() || schedBlock.isACA7mArraySB());
            if (bl2) {
                ExpectedPropertiesElements expectedPropertiesElements = scienceGoal.getConsolidatedExpectedProperties(SchedBlockWorker.createTargetParametersSBMap(optional.orElseThrow(WizardSBGenerationException::new)));
                this.scaleDRForSmallerArray(schedBlock, expectedPropertiesElements, collection);
                schedulingConstraints.setSpectralDynamicRangeBandwidth((Frequency)((Object)expectedPropertiesElements.getBandwidthForSpectralDynamicRange().deepCopy()));
            } else {
                ExpectedPropertiesElements expectedPropertiesElements = scienceGoal.getConsolidatedExpectedProperties(SchedBlockWorker.createTargetParametersSBMap(schedBlock));
                schedulingConstraints.setSpectralDynamicRange(expectedPropertiesElements.getSpectralDynamicRange());
                schedulingConstraints.setDynamicRange(expectedPropertiesElements.getImagingDynamicRange());
                schedulingConstraints.setSpectralDynamicRangeBandwidth((Frequency)((Object)expectedPropertiesElements.getBandwidthForSpectralDynamicRange().deepCopy()));
            }
        }
    }

    private void scaleDRForSmallerArray(@NonNull SchedBlock schedBlock, @NonNull ExpectedPropertiesElements expectedPropertiesElements, @NonNull Collection<Collection<SchedBlock>> collection) {
        double d;
        Sensitivity sensitivity;
        Target target2;
        SensitivityArrayCounterparts sensitivityArrayCounterparts;
        if (schedBlock == null) {
            throw new NullPointerException("sbToProcess is marked non-null but is null");
        }
        if (expectedPropertiesElements == null) {
            throw new NullPointerException("consolidatedExpectedProperties is marked non-null but is null");
        }
        if (collection == null) {
            throw new NullPointerException("schedblockGroups is marked non-null but is null");
        }
        @NonNull TargetParameters targetParameters = expectedPropertiesElements.getTargetUsedForImagingDynamicRange();
        @NonNull TargetParameters targetParameters2 = expectedPropertiesElements.getTargetUsedForSpectralDynamicRange();
        if (StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{targetParameters.getSourceName()}) || StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{targetParameters2.getSourceName()})) {
            throw new WizardSBGenerationException("A source has been defined in the field setup without a source name");
        }
        try {
            sensitivityArrayCounterparts = this.findSensitivityGoalForCorrespondingTargetInTM1SB(expectedPropertiesElements, collection);
        }
        catch (UnableToFindCounterPartSensitivityException unableToFindCounterPartSensitivityException) {
            Log.logger(SchedBlockPostProcessor.class).warning("Unable to scale dynamic range for the smaller array");
            return;
        }
        List<Target> list = schedBlock.getAllTargets(ScienceParameters.scienceParametersFilter);
        Optional<Target> optional = list.stream().filter(target -> target.getFieldSource().getSourceName().equals(targetParameters2.getSourceName())).findFirst();
        Optional<Target> optional2 = list.stream().filter(target -> target.getFieldSource().getSourceName().equals(targetParameters2.getSourceName())).findFirst();
        SchedulingConstraints schedulingConstraints = schedBlock.getSchedulingConstraints();
        if (optional.isPresent()) {
            target2 = optional.get();
            sensitivity = target2.getFirstScienceParameters().orElseThrow(WizardSBGenerationException::new).getSensitivityGoal();
            d = expectedPropertiesElements.getSpectralDynamicRange() * sensitivityArrayCounterparts.getSpectralSensitivity().getContentInUnits(TechnicalJustificationModel.FLUX_CALC_UNIT) / sensitivity.getContentInUnits(TechnicalJustificationModel.FLUX_CALC_UNIT);
            Log.logger(SchedBlockPostProcessor.class).fine("spectral DR is " + d + " using " + target2.getFieldSource().getSourceName() + " for array " + schedBlock.getSbGenerationContext().getSBType());
            schedulingConstraints.setSpectralDynamicRange(d);
        }
        if (optional2.isPresent()) {
            target2 = optional2.get();
            sensitivity = target2.getFirstScienceParameters().orElseThrow(WizardSBGenerationException::new).getSensitivityGoal();
            d = expectedPropertiesElements.getImagingDynamicRange() * sensitivityArrayCounterparts.getImagingSensitivity().getContentInUnits(TechnicalJustificationModel.FLUX_CALC_UNIT) / sensitivity.getContentInUnits(TechnicalJustificationModel.FLUX_CALC_UNIT);
            Log.logger(SchedBlockPostProcessor.class).fine("imaging DR is " + d + " using " + target2.getFieldSource().getSourceName() + " for array " + schedBlock.getSbGenerationContext().getSBType());
            schedulingConstraints.setDynamicRange(d);
        }
    }

    private SensitivityArrayCounterparts findSensitivityGoalForCorrespondingTargetInTM1SB(@NonNull ExpectedPropertiesElements expectedPropertiesElements, @NonNull Collection<Collection<SchedBlock>> collection) throws UnableToFindCounterPartSensitivityException {
        Object object;
        Object object2;
        if (expectedPropertiesElements == null) {
            throw new NullPointerException("consolidatedExpectedProperties is marked non-null but is null");
        }
        if (collection == null) {
            throw new NullPointerException("schedblockGroups is marked non-null but is null");
        }
        @NonNull TargetParameters targetParameters = expectedPropertiesElements.getTargetUsedForImagingDynamicRange();
        @NonNull TargetParameters targetParameters2 = expectedPropertiesElements.getTargetUsedForSpectralDynamicRange();
        Sensitivity sensitivity = null;
        block0: for (Collection<SchedBlock> object5 : collection) {
            for (Object object3 : object5) {
                if (!((SchedBlock)object3).is12mExtendedArraySB()) continue;
                Object object4 = ((SchedBlock)object3).getAllTargets(ScienceParameters.scienceParametersFilter);
                object2 = targetParameters2.getSourceName();
                if (StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{object2})) {
                    throw new WizardSBGenerationException("A source name has not been defined in the field setup");
                }
                object = object4.stream().filter(arg_0 -> SchedBlockPostProcessor.lambda$findSensitivityGoalForCorrespondingTargetInTM1SB$6((String)object2, arg_0)).findFirst();
                if (!((Optional)object).isPresent()) continue;
                sensitivity = ((Target)((Optional)object).get()).getFirstScienceParameters().get().getSensitivityGoal();
                break block0;
            }
        }
        Object object7 = null;
        block2: for (Collection<SchedBlock> collection2 : collection) {
            for (Object object4 : collection2) {
                if (!((SchedBlock)object4).is12mExtendedArraySB()) continue;
                object2 = ((SchedBlock)object4).getAllTargets(ScienceParameters.scienceParametersFilter);
                object = targetParameters2.getSourceName();
                if (StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{object})) {
                    throw new WizardSBGenerationException("A source name has not been defined in the field setup");
                }
                Optional<Target> optional = object2.stream().filter(arg_0 -> SchedBlockPostProcessor.lambda$findSensitivityGoalForCorrespondingTargetInTM1SB$6((String)object, arg_0)).findFirst();
                if (!optional.isPresent()) continue;
                object7 = optional.get().getFirstScienceParameters().get().getSensitivityGoal();
                break block2;
            }
        }
        if (object7 == null || sensitivity == null) {
            throw new UnableToFindCounterPartSensitivityException();
        }
        return new SensitivityArrayCounterparts((Sensitivity)((Object)object7), sensitivity);
    }

    private void removeUnusedP2Components(@NonNull SchedBlock schedBlock) {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        List<Target> list = schedBlock.getAllTargets(Optional.empty());
        List list2 = Stream.of(schedBlock.getSpectralSpec()).filter(spectralSpec -> !list.stream().filter(target -> target.getSpectralSpec().equals(spectralSpec)).findFirst().isPresent()).collect(Collectors.toList());
        list2.stream().forEach(spectralSpec -> schedBlock.removeSpectralSpec((SpectralSpec)spectralSpec));
    }

    private void setupPolarizationCalibratorSubscanDurations(@NonNull ScienceGoal scienceGoal, @NonNull SchedBlock schedBlock) {
        if (scienceGoal == null) {
            throw new NullPointerException("clusteredSG is marked non-null but is null");
        }
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        SBGenerationContext sBGenerationContext = schedBlock.getSbGenerationContext();
        for (Target target : schedBlock.getTargets(ObsType.POLARIZATION)) {
            CalibrationTimerInterface calibrationTimerInterface = AbstractObservingParametersFactory.CalibrationTimerFactory.getCalibrationTimer(scienceGoal, target.getSpectralSpec(), ObsType.POLARIZATION, sBGenerationContext.getArray(), sBGenerationContext);
            PolarizationCalParameters polarizationCalParameters = target.getPolarizationCalParametersList()[0];
            polarizationCalParameters.setSubScanDuration(calibrationTimerInterface.getScanDuration(polarizationCalParameters.getDefaultIntegrationTime()));
        }
    }

    private void baseACA7mScienceParameterTimingsBasedOnTMTimings(SchedBlock schedBlock, ScienceGoal scienceGoal) throws TargetCache.TargetNotFoundException {
        if (scienceGoal.isStandAloneACA()) {
            return;
        }
        TargetCache targetCache = TargetCache.getInstance();
        HashSet<ScienceParameters> hashSet = new HashSet<ScienceParameters>();
        for (Target object : schedBlock.getAllTargets(ScienceParameters.scienceParametersFilter)) {
            Target target = targetCache.getTarget(object, SBGeneratorTemplate.SchedBlockType.TWELVEMEXTENDEDCONFIGURATION);
            ScienceParameters scienceParameters = object.getFirstScienceParameters().orElseThrow(WizardSBGenerationException::new);
            if (hashSet.contains((Object)scienceParameters)) continue;
            ScienceParameters scienceParameters2 = target.getFirstScienceParameters().orElseThrow(WizardSBGenerationException::new);
            SchedBlock schedBlock2 = (SchedBlock)scienceParameters2.getParent();
            int n = schedBlock2.getSchedBlockControl().getExecutionCount();
            IntTimeSource intTimeSource = (IntTimeSource)((IntTimeSource)scienceParameters2.getIntegrationTime().multiply(schedBlock.getSbGenerationContext().getAntennaRelatedTOSTimeMultiplier())).multiply(n);
            scienceParameters.setIntegrationTime(intTimeSource);
            hashSet.add(scienceParameters);
        }
        try {
            SchedBlockExpert schedBlockExpert = SchedBlockExpert.getInstance(scienceGoal);
            SchedBlockControl schedBlockControl = schedBlock.getSchedBlockControl();
            SchedBlockWorker.setupSchedBlockControl(schedBlockExpert, schedBlockControl, RequestedArray.SEVEN_M, schedBlock.getSbGenerationContext().getSchemaToUseForSBGeneration());
            SchedBlockWorker.quantizeScienceIntegrationTimes(schedBlock, schedBlock.getSbGenerationContext().getSchemaToUseForSBGeneration());
        }
        catch (UnableToFindSolutionException | SourceNeverVisibleException | InvalidFrequencyException exception) {
            Log.logger(SchedBlockPostProcessor.class).warning("Unable to revise the ACA 7-m SB " + exception.getMessage());
            throw new WizardSBGenerationException(exception);
        }
    }

    private boolean isLongbaselineConfigurationScheduled(ScienceGoal scienceGoal, SchedBlock schedBlock, boolean bl, RequestedArray requestedArray) throws InvalidObsProgramParametersException {
        boolean bl2 = false;
        if (requestedArray.equals((Object)RequestedArray.TWELVE_M) && !scienceGoal.isStandAloneACA() && !bl) {
            ScienceGoalConfigurations<ConfigurationSet> scienceGoalConfigurations = Configuration.getConfigurationsToBeScheduled(scienceGoal);
            if (scienceGoalConfigurations.isEmpty()) {
                throw new WizardSBGenerationException("Unable to determine configurations");
            }
            Optional<Configuration> optional = schedBlock.is12mCompactArraySB() ? ((ConfigurationSet)scienceGoalConfigurations.get(0)).getTM2Configuration() : ((ConfigurationSet)scienceGoalConfigurations.get(0)).getTM1Configuration();
            bl2 = Configuration.isLongBaselineConfiguration(optional.orElse(Configuration.NO_CONFIG));
        }
        return bl2;
    }

    private void quantizeParametersInInterferometricSBs(@NonNull SchedBlock schedBlock, @NonNull RequestedArray requestedArray, @NonNull EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet, boolean bl) throws UnknownEntityException, InvalidObsProgramParametersException {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        if (requestedArray == null) {
            throw new NullPointerException("arrayRequested is marked non-null but is null");
        }
        if (enumSet == null) {
            throw new NullPointerException("sbGenerationSchema is marked non-null but is null");
        }
        boolean bl2 = bl;
        IntegerMosaicEnforcerInterface integerMosaicEnforcerInterface = IntegerMosaicEnforcerFactory.getIntegerMosaicEnforcer(bl2 ? IntegerMosaicEnforcerFactory.MosaicEnforcer.FIXED_SUBSCAN_MOSAIC_ENFORCER : IntegerMosaicEnforcerFactory.MosaicEnforcer.VARIABLE_SUBSCAN_MOSAIC_ENFORCER);
        if (!integerMosaicEnforcerInterface.enforceCompleteMosaicScansPerSBExec(schedBlock, requestedArray, enumSet)) {
            try {
                SchedBlockWorker.quantizeIntegrationTimesOnSourceBySubscanDuration(schedBlock, enumSet);
            }
            catch (SchedBlockWorker.UnableToQuantizeIntegrationTimeException unableToQuantizeIntegrationTimeException) {
                Log.logger(ScienceGoalSchedBlockGenerator.class).fine("Unable to quantize integration time");
            }
        }
    }

    private void setupNonSolarTPSB(ScienceGoal scienceGoal, SchedBlock schedBlock2, List<ObsUnitSet> list, ObservingTimeCalculator observingTimeCalculator) throws UnknownEntityException, Exception {
        double d;
        Time time;
        if (scienceGoal.isSolarScienceGoal()) {
            throw new IllegalArgumentException("Logic error: this method should not be run with a solar science goal");
        }
        try {
            time = observingTimeCalculator.getTotalArraySBScienceIntegrationTime(true, Array.ARRAY_7M);
        }
        catch (UnknownEntityException | InvalidObsProgramParametersException throwable) {
            Log.logger(ScienceGoalSchedBlockGenerator.class).info("Unable to post-process SBs : " + throwable.getMessage());
            throw new WizardSBGenerationException(throwable);
        }
        try {
            d = Configuration.getArrayTimeMultiplier(Configuration.MultiplierEnumType.ACATP, scienceGoal);
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            throw new WizardSBGenerationException(invalidObsProgramParametersException);
        }
        List<SchedBlock> list2 = new ArrayList<SchedBlock>();
        SchedBlockWorker.findSBsUnderOUS(list2, list);
        list2 = list2.stream().filter(schedBlock -> schedBlock.isACA7mArraySB()).collect(Collectors.toList());
        assert (list2.size() == 1);
        TotalPowerIntegrationTimeCalculator.calculateSourceRasterTimes(schedBlock2, (Time)time.multiply(d), list2.get(0));
        SBGeneratorTemplate.enforceMinimumOnSourceTimePerSB(schedBlock2);
        int n = TotalPowerIntegrationTimeCalculator.getTPSBExecutionCount(schedBlock2, time, scienceGoal, list, list2.get(0));
        schedBlock2.getSchedBlockControl().setExecutionCount(n);
    }

    private void copyExecutiveSharesIntoSB(ScienceGoal scienceGoal, SchedBlock schedBlock) {
        try {
            ObsProposal obsProposal = scienceGoal.getObsProposal();
            this.copyExecutiveSharesIntoSBs(schedBlock, obsProposal);
        }
        catch (UnknownEntityException unknownEntityException) {
            String string = "Unable to copy across executive fractions to SB : " + unknownEntityException.getMessage();
            Log.logger(ScienceGoalSchedBlockGenerator.class).warning(string);
            throw new WizardSBGenerationException(string);
        }
        this.copyPhase1ParametersToSB(schedBlock, scienceGoal);
    }

    public void setEstimatedTimeForSBInOUS(SchedBlock schedBlock, ObservingTimeCalculator observingTimeCalculator, RequestedArray requestedArray) {
        Time time = null;
        try {
            time = schedBlock.isTotalPowerAmpcalSB() ? Time.createTime((double)45.0, (String)Time.UNIT_MIN) : observingTimeCalculator.getTotalRequestedTime(requestedArray.getArray(), true, schedBlock.is12mCompactArraySB(), true);
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            Log.logger(ScienceGoalSchedBlockGenerator.class).info("Unable to post-process SBs : " + invalidObsProgramParametersException.getMessage());
            throw new WizardSBGenerationException(invalidObsProgramParametersException.getMessage());
        }
        schedBlock.getObsUnitControl().getEstimatedExecutionTime().setContentAndUnit((ValueUnitPair)time.convertToFriendlyUnit());
    }

    private void copyPhase1ParametersToSB(SchedBlock schedBlock, ScienceGoal scienceGoal) {
        Object object;
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        SchedulingConstraints schedulingConstraints = schedBlock.getSchedulingConstraints();
        if (schedBlock.getSbGenerationContext().isVLBI()) {
            schedulingConstraints.setScienceGoalLargestAngularScale(Angle.createAngle((double)1.0, (String)Angle.UNIT_MAS));
            schedulingConstraints.setScienceGoalDesiredResolution(Angle.createAngle((double)0.0, (String)Angle.UNIT_ARCSEC));
        } else {
            object = Angle.createAngle((double)performanceParameters.getDesiredLargestScale().getContentInUnits(Angle.UNIT_ARCSEC), (String)Angle.UNIT_ARCSEC);
            schedulingConstraints.setScienceGoalLargestAngularScale((Angle)((Object)object));
            Angle angle = Angle.createAngle((double)performanceParameters.getDesiredAngularResolution().getContentInUnits(Angle.UNIT_ARCSEC), (String)Angle.UNIT_ARCSEC);
            schedulingConstraints.setScienceGoalDesiredResolution(angle);
        }
        if (schedBlock.isTotalPowerAmpcalSB() || schedBlock.isTotalPowerScienceSB()) {
            schedulingConstraints.addNominalConfiguration("TP");
        } else if (schedBlock.isACA7mArraySB()) {
            schedulingConstraints.addNominalConfiguration("7M");
        } else if (schedBlock.is12mCompactArraySB() || schedBlock.is12mExtendedArraySB()) {
            object = null;
            try {
                object = Configuration.getConfigurationsToBeScheduled(scienceGoal);
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                String string = "Unable to determine configurations : " + invalidObsProgramParametersException.getMessage();
                Log.logger(ScienceGoalSchedBlockGenerator.class).info(string);
                throw new WizardSBGenerationException(string);
            }
            assert (object != null);
            Collections.sort(object);
            if (schedBlock.is12mCompactArraySB()) {
                object.stream().forEach(configurationSet -> configurationSet.getTM2Configuration().ifPresent(configuration -> schedulingConstraints.addNominalConfiguration(configuration.getName())));
            } else {
                object.stream().forEach(configurationSet -> configurationSet.getTM1Configuration().ifPresent(configuration -> schedulingConstraints.addNominalConfiguration(configuration.getName())));
            }
            double d = Configuration.determineAverageDeclination(scienceGoal.getTargetParameters()).getDegs();
            schedulingConstraints.setMaxAllowedBeamAxialRatio(SchedulingConstraints.calculateMaxExpectedAxialRatio(d));
        } else {
            throw new WizardSBGenerationException("Unable to determine type of SB");
        }
    }

    private void copyExecutiveSharesIntoSBs(@NonNull SchedBlock schedBlock, @NonNull ObsProposal obsProposal) {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        if (obsProposal == null) {
            throw new NullPointerException("obsProposal is marked non-null but is null");
        }
        ProposalFeedback proposalFeedback = obsProposal.getProposalFeedback();
        if (proposalFeedback != null) {
            TimeAllocationBreakdown timeAllocationBreakdown = schedBlock.getTimeAllocationBreakdown();
            timeAllocationBreakdown.clearExecutiveFraction();
            for (String string : ExecutiveFraction.getKnownNameList()) {
                ExecutiveFraction executiveFraction = proposalFeedback.getTimeAllocationBreakdown().getExecutiveFraction(string);
                timeAllocationBreakdown.addExecutiveFraction(executiveFraction.deepCopy());
            }
        }
    }

    public static void reviseCheckSourceObservingParameters(SchedBlock schedBlock, ScienceGoal scienceGoal) throws SchedBlock.UnableToFindParentScienceGoalException {
        if (schedBlock.isTotalPowerAmpcalSB() || schedBlock.isTotalPowerScienceSB()) {
            return;
        }
        if (PhaseCalIntermediateTarget.HIGHBANDS.contains(scienceGoal.getSpectralSetupParameters().getReceiverBand())) {
            return;
        }
        for (ObservingGroup observingGroup : schedBlock.getObservingGroup()) {
            Time time = Time.createTime();
            Time time2 = null;
            Time time3 = null;
            Target target = null;
            for (OrderedTarget orderedTarget : observingGroup.getOrderedTarget()) {
                Target target2 = orderedTarget.getTarget();
                for (ScienceParameters scienceParameters : target2.getScienceParametersList()) {
                    time.aggregate(scienceParameters.getIntegrationTime().getTime());
                }
                if (target2.hasPhaseCalParameters()) {
                    time2 = target2.getPhaseCalParametersList()[0].getCycleTime();
                    time3 = target2.getPhaseCalParametersList()[0].getSubScanDuration();
                }
                if (!target2.hasCheckSourceCalParameters()) continue;
                target = target2;
            }
            if (time.isZero() || time2 == null || target == null) continue;
            time = (Time)time.multiply(0.3333333333333333);
            Time time4 = (Time)((Time)((Time)time2.plus((AbstractDoubleWithUnit)Time.createTimeSec(7.0))).plus((AbstractDoubleWithUnit)time3)).multiply(3.0);
            CheckSourceCalParameters checkSourceCalParameters = target.getCheckSourceCalParametersList()[0];
            if (time4.isGreaterThan((AbstractDoubleWithUnit)time)) {
                checkSourceCalParameters.setCycleTime(time4);
                continue;
            }
            checkSourceCalParameters.setCycleTime(time);
        }
    }

    private ObsUnitSet findOUS(ObsUnitSet obsUnitSet, SBGeneratorTemplate.SchedBlockType schedBlockType) throws UnknownEntityException {
        ObsUnitSetComponent obsUnitSetComponent2;
        if (SBGeneratorTemplate.SchedBlockType.TPSCIENCE.equals((Object)schedBlockType)) {
            throw new RuntimeException("There can be multiple TP science SBs: this method cannot support that");
        }
        ObsUnitSet obsUnitSet2 = null;
        for (ObsUnitSetComponent obsUnitSetComponent2 : obsUnitSet.getSchedBlock()) {
            if (!obsUnitSetComponent2.getSbGenerationContext().getSBType().equals((Object)schedBlockType)) continue;
            return obsUnitSet;
        }
        ObsUnitSetComponent[] obsUnitSetComponentArray = obsUnitSet.getObsUnitSet();
        int n = obsUnitSetComponentArray.length;
        for (int i = 0; i < n && (obsUnitSet2 = this.findOUS((ObsUnitSet)(obsUnitSetComponent2 = obsUnitSetComponentArray[i]), schedBlockType)) == null; ++i) {
        }
        return obsUnitSet2;
    }

    void setCorrelatorTimingsToTDMDefaults() {
        if (this.piDefinedScienceGoal == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: scienceGoal");
        }
        if (this.rootOUS == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: obsUnitSet");
        }
        SpectralSetupParameters spectralSetupParameters = this.piDefinedScienceGoal.getSpectralSetupParameters();
        if (!spectralSetupParameters.isSpectralLine()) {
            return;
        }
        boolean bl = true;
        for (ScienceSpectralWindow targetArray : spectralSetupParameters.getScienceSpectralWindow()) {
            if (targetArray.isModeFilterTDM()) continue;
            bl = false;
            break;
        }
        if (bl) {
            ArrayList arrayList = new ArrayList();
            SchedBlockWorker.findSBsUnderOUS((List<SchedBlock>)arrayList, this.rootOUS);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                SchedBlock schedBlock = (SchedBlock)iterator.next();
                if (schedBlock.isTotalPowerAmpcalSB() || schedBlock.isTotalPowerScienceSB()) continue;
                for (Target target : schedBlock.getTarget()) {
                    if (!target.hasScienceParameters()) continue;
                    SpectralSpecFactory.calculateTDMTimeAndDurations(true, target.getSpectralSpec(), schedBlock.getSbGenerationContext());
                }
            }
        }
    }

    public synchronized void adjustTOSInSBsToMatchRequestedMinimumExecutionTime(Time time, Time time2, ObsUnitSet obsUnitSet, ScienceGoal scienceGoal) throws UnknownEntityException, InvalidObsProgramParametersException, SBTimeEstimateHelper.UnknownObservingGroupTypeException {
        Log.logger(SchedBlockWorker.class).fine("ObsUnit : " + obsUnitSet + " project execution time : ");
        Time time3 = (Time)time2.minus((AbstractDoubleWithUnit)time);
        for (SchedBlock schedBlock : obsUnitSet.getSchedBlock()) {
            Object object;
            Object object22;
            Object object32;
            RequestedArray requestedArray;
            EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet = SBGeneratorTemplate.determineSBGenerationSchema(scienceGoal, schedBlock.getObsUnitControl().getArrayRequested());
            Time time4 = ObservingTimeCalculator.getExecutionTimeForSB(schedBlock, scienceGoal);
            RequestedArray requestedArray2 = requestedArray = scienceGoal.isStandAloneACA() ? RequestedArray.SEVEN_M : RequestedArray.TWELVE_M;
            if (!schedBlock.getObsUnitControl().getArrayRequested().equals(requestedArray.getType())) continue;
            Integer scienceParametersArray = 0;
            IntTimeSource intTimeSource = IntTimeSource.createIntTimeSource();
            Log.logger(SchedBlockWorker.class).fine("Re-adjusting the execution time of the SB : " + schedBlock.getEntityID());
            HashMap<String, ScienceParameters> hashMap = new HashMap<String, ScienceParameters>();
            for (ObservingGroup observingGroup : schedBlock.getObservingGroup()) {
                for (Object object32 : observingGroup.getOrderedTarget()) {
                    Target target = object32.getTarget();
                    if (!target.hasScienceParameters() || !((ScienceParameters)((Object)(object22 = target.getScienceParametersList()[0]))).isIntegrationTimeChangeable()) continue;
                    Integer n = scienceParametersArray;
                    Integer n2 = scienceParametersArray = Integer.valueOf(scienceParametersArray + 1);
                    for (ScienceParameters scienceParameters : target.getScienceParametersList()) {
                        intTimeSource = (IntTimeSource)intTimeSource.plus((AbstractDoubleWithUnit)scienceParameters.getIntegrationTime());
                        if (hashMap.containsKey(scienceParameters.getEntityPartId())) continue;
                        hashMap.put(scienceParameters.getEntityPartId(), scienceParameters);
                    }
                }
            }
            boolean bl = true;
            if (scienceParametersArray > 0) {
                this.apportionAdditionalTOSToScienceParameters(enumSet, scienceParametersArray, intTimeSource, hashMap);
            } else {
                bl = false;
            }
            int n = schedBlock.getSchedBlockControl().getExecutionCount();
            Time time5 = ObservingTimeCalculator.getExecutionTimeForSB(schedBlock, scienceGoal);
            Time object52 = (Time)time5.minus((AbstractDoubleWithUnit)time4);
            if (object52.isLessThan((AbstractDoubleWithUnit)time3)) {
                object = (Time)time3.minus((AbstractDoubleWithUnit)object52);
                int n3 = (int)Math.ceil(((Time)object).getContentInUnits(Time.UNIT_S) / (time5.getContentInUnits(Time.UNIT_S) / (double)n));
                schedBlock.getSchedBlockControl().setExecutionCount(n + n3);
                if (!bl) continue;
                Time time6 = (Time)Time.createTimeSec(30.0).divide(hashMap.size());
                object32 = Time.createTimeSec(0.0);
                boolean bl2 = false;
                block4: while (!bl2 && SchedBlockPostProcessor.determineOUSExecutionTime(obsUnitSet, scienceGoal).isGreaterThan((AbstractDoubleWithUnit)time2)) {
                    object22 = hashMap.keySet().iterator();
                    while (object22.hasNext()) {
                        String string = (String)object22.next();
                        ScienceParameters scienceParameters = (ScienceParameters)((Object)hashMap.get(string));
                        Time time7 = (Time)scienceParameters.getIntegrationTime().getTime().deepCopy().minus((AbstractDoubleWithUnit)time6);
                        if (time7.isGreaterThan((AbstractDoubleWithUnit)object32)) {
                            scienceParameters.setIntegrationTime(IntTimeSource.createIntTimeSource((double)time7.getContentInUnits(Time.UNIT_S), (String)Time.UNIT_S));
                            continue;
                        }
                        bl2 = true;
                        continue block4;
                    }
                }
                continue;
            }
            if (!bl) continue;
            object = (Time)Time.createTimeSec(30.0).divide(hashMap.size());
            Time time8 = Time.createTimeSec(0.0);
            int n4 = 0;
            object32 = new HashMap();
            block6: while (n4 == 0 && SchedBlockPostProcessor.determineOUSExecutionTime(obsUnitSet, scienceGoal).isGreaterThan((AbstractDoubleWithUnit)time2)) {
                for (Object object22 : hashMap.keySet()) {
                    ScienceParameters scienceParameters = (ScienceParameters)((Object)hashMap.get(object22));
                    Time time9 = (Time)scienceParameters.getIntegrationTime().getTime().minus((AbstractDoubleWithUnit)object);
                    if (time9.isGreaterThan((AbstractDoubleWithUnit)time8)) {
                        object32.put(object22, scienceParameters.getIntegrationTime());
                        scienceParameters.setIntegrationTime(IntTimeSource.createIntTimeSource((double)time9.getContentInUnits(Time.UNIT_S), (String)Time.UNIT_S));
                        continue;
                    }
                    n4 = 1;
                    continue block6;
                }
            }
            if (!SchedBlockPostProcessor.determineOUSExecutionTime(obsUnitSet, scienceGoal).isLessThan((AbstractDoubleWithUnit)time2)) continue;
            assert (object32.size() != 0);
            for (Object object22 : hashMap.keySet()) {
                ScienceParameters scienceParameters = (ScienceParameters)((Object)hashMap.get(object22));
                scienceParameters.setIntegrationTime((IntTimeSource)((Object)object32.get(object22)));
            }
        }
    }

    private void apportionAdditionalTOSToScienceParameters(EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet, Integer n, IntTimeSource intTimeSource, Map<String, ScienceParameters> map) {
        double d = SchedBlockExpert.getNominalExecutionTimeToTOSRatio(enumSet);
        Time time = (Time)((Time)SchedBlockExpert.NOMINAL_SB_LENGTH.divide(d)).minus((AbstractDoubleWithUnit)intTimeSource.getTime());
        Time time2 = (Time)time.divide(n.intValue());
        for (String string : map.keySet()) {
            ScienceParameters scienceParameters = map.get(string);
            Time time3 = (Time)scienceParameters.getIntegrationTime().getTime().plus((AbstractDoubleWithUnit)time2);
            scienceParameters.setIntegrationTime(IntTimeSource.createIntTimeSource((double)time3.getContentInUnits(Time.UNIT_S), (String)Time.UNIT_S));
        }
    }

    public synchronized void adjustTOSInSBToMatchRequestedMinimumExecutionTime(Time time, SchedBlock schedBlock, ScienceGoal scienceGoal) throws UnknownEntityException, InvalidObsProgramParametersException, SBTimeEstimateHelper.UnknownObservingGroupTypeException {
        RequestedArray requestedArray;
        Time time2 = ObservingTimeCalculator.getExecutionTimeForSB(schedBlock, scienceGoal);
        if (time2.isGreaterThanOrEqualTo((AbstractDoubleWithUnit)time)) {
            return;
        }
        Time time3 = (Time)time.minus((AbstractDoubleWithUnit)time2);
        EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet = SBGeneratorTemplate.determineSBGenerationSchema(scienceGoal, schedBlock.getObsUnitControl().getArrayRequested());
        RequestedArray requestedArray2 = requestedArray = scienceGoal.isStandAloneACA() ? RequestedArray.SEVEN_M : RequestedArray.TWELVE_M;
        if (schedBlock.getObsUnitControl().getArrayRequested().equals(requestedArray.getType())) {
            Time time4;
            Object object;
            Object object2;
            int n = 0;
            IntTimeSource intTimeSource = IntTimeSource.createIntTimeSource();
            Log.logger(SchedBlockWorker.class).fine("Re-adjusting the execution time of the SB : " + schedBlock.getEntityID());
            HashMap<String, ScienceParameters> hashMap = new HashMap<String, ScienceParameters>();
            for (Target object32 : schedBlock.getAllTargets(ScienceParameters.scienceParametersFilter)) {
                object2 = object32.getScienceParametersList()[0];
                if (!object2.isIntegrationTimeChangeable()) continue;
                ++n;
                for (Object object3 : object32.getScienceParametersList()) {
                    intTimeSource = (IntTimeSource)intTimeSource.plus((AbstractDoubleWithUnit)object3.getIntegrationTime());
                    if (hashMap.containsKey(object3.getEntityPartId())) continue;
                    hashMap.put(object3.getEntityPartId(), (ScienceParameters)((Object)object3));
                }
            }
            boolean bl = true;
            if (n > 0) {
                this.apportionAdditionalTOSToScienceParameters(enumSet, n, intTimeSource, hashMap);
            } else {
                bl = false;
            }
            Time time5 = ObservingTimeCalculator.getExecutionTimeForSB(schedBlock, scienceGoal);
            object2 = (Time)time5.minus((AbstractDoubleWithUnit)time2);
            HashMap hashMap2 = new HashMap();
            Time time6 = Time.createTime((double)10.0, (String)Time.UNIT_MIN);
            if (object2.isLessThan((AbstractDoubleWithUnit)time3)) {
                SchedBlockControl schedBlockControl = schedBlock.getSchedBlockControl();
                int n2 = schedBlockControl.getExecutionCount();
                object = (Time)time3.minus((AbstractDoubleWithUnit)object2);
                int n3 = (int)Math.ceil(object.getContentInUnits(Time.UNIT_S) / (time5.getContentInUnits(Time.UNIT_S) / (double)n2));
                schedBlockControl.setExecutionCount(n2 + n3);
                Time time7 = ObservingTimeCalculator.getExecutionTimeForSB(schedBlock, scienceGoal);
                if (time7.isLessThan((AbstractDoubleWithUnit)time)) {
                    schedBlockControl.setExecutionCount(schedBlockControl.getExecutionCount() + 1);
                }
                if (bl) {
                    Object object4 = Time.createTimeSec(0.0);
                    boolean bl2 = false;
                    time4 = ObservingTimeCalculator.getExecutionTimeForSB(schedBlock, scienceGoal);
                    Time time8 = Time.createTimeSec(30.0);
                    Time time9 = Time.createTimeSec(10.0);
                    while (!bl2 && time4.isGreaterThan((AbstractDoubleWithUnit)time)) {
                        boolean bl3 = ((Time)time4.minus((AbstractDoubleWithUnit)time)).isGreaterThan((AbstractDoubleWithUnit)time6);
                        Time time10 = (Time)(bl3 ? time8 : time9).divide(hashMap.size());
                        for (String string : hashMap.keySet()) {
                            ScienceParameters scienceParameters = (ScienceParameters)((Object)hashMap.get(string));
                            Time time11 = (Time)scienceParameters.getIntegrationTime().getTime().minus((AbstractDoubleWithUnit)time10);
                            if (time11.isGreaterThan((AbstractDoubleWithUnit)object4)) {
                                hashMap2.put(string, scienceParameters.getIntegrationTime());
                                scienceParameters.setIntegrationTime(IntTimeSource.createIntTimeSource((double)time11.getContentInUnits(Time.UNIT_S), (String)Time.UNIT_S));
                                continue;
                            }
                            bl2 = true;
                            break;
                        }
                        time4 = ObservingTimeCalculator.getExecutionTimeForSB(schedBlock, scienceGoal);
                    }
                }
            } else if (bl) {
                Object object3;
                Time time12 = (Time)Time.createTimeSec(30.0).divide(hashMap.size());
                object3 = Time.createTimeSec(0.0);
                boolean bl4 = false;
                block4: while (!bl4 && ObservingTimeCalculator.getExecutionTimeForSB(schedBlock, scienceGoal).isGreaterThan((AbstractDoubleWithUnit)time)) {
                    for (Object object4 : hashMap.keySet()) {
                        ScienceParameters scienceParameters = (ScienceParameters)((Object)hashMap.get(object4));
                        time4 = (Time)scienceParameters.getIntegrationTime().getTime().minus((AbstractDoubleWithUnit)time12);
                        if (time4.isGreaterThan((AbstractDoubleWithUnit)object3)) {
                            hashMap2.put(object4, scienceParameters.getIntegrationTime());
                            scienceParameters.setIntegrationTime(IntTimeSource.createIntTimeSource((double)time4.getContentInUnits(Time.UNIT_S), (String)Time.UNIT_S));
                            continue;
                        }
                        bl4 = true;
                        continue block4;
                    }
                }
            }
            if (ObservingTimeCalculator.getExecutionTimeForSB(schedBlock, scienceGoal).isLessThan((AbstractDoubleWithUnit)time)) {
                assert (hashMap2.size() != 0);
                for (String string : hashMap.keySet()) {
                    object = (ScienceParameters)((Object)hashMap.get(string));
                    object.setIntegrationTime((IntTimeSource)((Object)hashMap2.get(string)));
                }
            }
        }
    }

    private void walshSwitching90DegreePostProcessing(@NonNull SchedBlock schedBlock) {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        if (schedBlock.isTotalPowerAmpcalSB() || schedBlock.isTotalPowerScienceSB()) {
            return;
        }
        SBGenerationContext sBGenerationContext = schedBlock.getSbGenerationContext();
        if (!sBGenerationContext.getGoal().getSpectralSetupParameters().isWalshSwitching()) {
            return;
        }
        Walsh90DegConfiguratorFactory.Walsh90DegSpectralSpecConfigurator walsh90DegSpectralSpecConfigurator = null;
        HashSet<SpectralSpec> hashSet = new HashSet<SpectralSpec>();
        for (Target target : schedBlock.getAllTargets(ScienceParameters.scienceParametersFilter)) {
            SpectralSpec spectralSpec = target.getSpectralSpec();
            if (!spectralSpec.getAbstractCorrelatorConfiguration().getEnable90DegreeWalshFunction()) continue;
            hashSet.add(spectralSpec);
        }
        for (Target target : schedBlock.getAllTargets(Optional.empty())) {
            if (walsh90DegSpectralSpecConfigurator == null) {
                walsh90DegSpectralSpecConfigurator = Walsh90DegConfiguratorFactory.getConfigurator(target.getSpectralSpec().getAbstractCorrelatorConfiguration());
            }
            walsh90DegSpectralSpecConfigurator.configureObservingParameters(target, sBGenerationContext);
            if (!hashSet.contains(target.getSpectralSpec())) continue;
            walsh90DegSpectralSpecConfigurator.configureFieldSource(target, sBGenerationContext);
        }
    }

    private SchedBlockPostProcessor(Builder builder) {
        this.isSBGenerationUserInitiated = builder.isSBGenerationUserInitiated;
        this.piDefinedScienceGoal = builder.userDefinedScienceGoal;
        this.rootOUS = builder.rootOUS;
    }

    private static /* synthetic */ boolean lambda$findSensitivityGoalForCorrespondingTargetInTM1SB$6(String string, Target target) {
        return target.getFieldSource().getSourceName().equals(string);
    }

    public static class Builder {
        private boolean isSBGenerationUserInitiated;
        private ScienceGoal userDefinedScienceGoal;
        private ObsUnitSet rootOUS;

        public Builder isSBGenerationUserInitiated(boolean bl) {
            this.isSBGenerationUserInitiated = bl;
            return this;
        }

        public Builder userDefinedScienceGoal(ScienceGoal scienceGoal) {
            this.userDefinedScienceGoal = scienceGoal;
            return this;
        }

        public Builder rootOUS(ObsUnitSet obsUnitSet) {
            this.rootOUS = obsUnitSet;
            return this;
        }

        public SchedBlockPostProcessor build() {
            return new SchedBlockPostProcessor(this);
        }
    }

    public class UnableToFindCounterPartSensitivityException
    extends Exception {
    }

    private static class SensitivityArrayCounterparts {
        private Sensitivity imagingSensitivity;
        private Sensitivity spectralSensitivity;

        public SensitivityArrayCounterparts(Sensitivity sensitivity, Sensitivity sensitivity2) {
            this.imagingSensitivity = sensitivity;
            this.spectralSensitivity = sensitivity2;
        }

        public Sensitivity getImagingSensitivity() {
            return this.imagingSensitivity;
        }

        public Sensitivity getSpectralSensitivity() {
            return this.spectralSensitivity;
        }

        public void setImagingSensitivity(Sensitivity sensitivity) {
            this.imagingSensitivity = sensitivity;
        }

        public void setSpectralSensitivity(Sensitivity sensitivity) {
            this.spectralSensitivity = sensitivity;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof SensitivityArrayCounterparts)) {
                return false;
            }
            SensitivityArrayCounterparts sensitivityArrayCounterparts = (SensitivityArrayCounterparts)object;
            if (!sensitivityArrayCounterparts.canEqual(this)) {
                return false;
            }
            Sensitivity sensitivity = this.getImagingSensitivity();
            Sensitivity sensitivity2 = sensitivityArrayCounterparts.getImagingSensitivity();
            if (sensitivity == null ? sensitivity2 != null : !((Object)((Object)sensitivity)).equals((Object)sensitivity2)) {
                return false;
            }
            Sensitivity sensitivity3 = this.getSpectralSensitivity();
            Sensitivity sensitivity4 = sensitivityArrayCounterparts.getSpectralSensitivity();
            return !(sensitivity3 == null ? sensitivity4 != null : !((Object)((Object)sensitivity3)).equals((Object)sensitivity4));
        }

        protected boolean canEqual(Object object) {
            return object instanceof SensitivityArrayCounterparts;
        }

        public int hashCode() {
            int n = 1;
            Sensitivity sensitivity = this.getImagingSensitivity();
            n = n * 59 + (sensitivity == null ? 43 : ((Object)((Object)sensitivity)).hashCode());
            Sensitivity sensitivity2 = this.getSpectralSensitivity();
            n = n * 59 + (sensitivity2 == null ? 43 : ((Object)((Object)sensitivity2)).hashCode());
            return n;
        }

        public String toString() {
            return "SchedBlockPostProcessor.SensitivityArrayCounterparts(imagingSensitivity=" + this.getImagingSensitivity() + ", spectralSensitivity=" + this.getSpectralSensitivity() + ")";
        }
    }
}

