/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts.spectralline.gui;

import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.ot.gui.resources.Icons;
import alma.obsprep.ot.gui.toplevel.GuiFactory;
import alma.obsprep.ot.gui.widgets.RangeSlider;
import alma.obsprep.services.experts.spectralline.SpectralLine;
import alma.obsprep.services.experts.spectralline.SpectralLineCatalogue;
import alma.obsprep.services.experts.spectralline.gui.FilteredCatalogue;
import alma.obsprep.services.experts.spectralline.gui.IntegerToDoubleConverter;
import alma.obsprep.services.experts.spectralline.gui.LineSelectorDialog;
import alma.obsprep.services.experts.spectralline.gui.MaxFrequencyToBandConverter;
import alma.obsprep.services.experts.spectralline.gui.MinFrequencyToBandConverter;
import alma.obsprep.services.experts.spectralline.gui.MultiLineSelectorDialog;
import alma.obsprep.services.experts.spectralline.gui.NonObservableLinesFilterMethodInterface;
import alma.obsprep.services.experts.spectralline.gui.RestFrequencyMultiLineSelectorDialog;
import alma.obsprep.services.experts.spectralline.gui.SearchDialog;
import alma.obsprep.services.experts.spectralline.gui.SingleLineSelectorDialog;
import alma.obsprep.services.experts.spectralline.gui.UndeletableSuffixNavigationFilter;
import alma.obsprep.services.experts.spectralline.gui.filters.FlagsMatcherEditor;
import alma.obsprep.services.experts.spectralline.gui.filters.MaximumFrequencyMatcherEditor;
import alma.obsprep.services.experts.spectralline.gui.filters.MinimumFrequencyMatcherEditor;
import alma.obsprep.services.experts.spectralline.gui.filters.SidebandMatcherEditor;
import alma.obsprep.services.experts.spectralline.gui.filters.TransitionTitleAndDescriptionFilterator;
import alma.obsprep.services.experts.spectralline.gui.filters.TransitionTitleFilterator;
import alma.obsprep.services.experts.spectralline.gui.filters.UpperStateEnergyMatcherEditor;
import alma.valuetypes.Frequency;
import alma.valuetypes.Velocity;
import ca.odell.glazedlists.TextFilterator;
import ca.odell.glazedlists.matchers.MatcherEditor;
import ca.odell.glazedlists.matchers.TextMatcherEditor;
import ca.odell.glazedlists.swing.EventTableModel;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.accessibility.Accessible;
import javax.swing.AbstractSpinnerModel;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import javax.swing.text.View;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Converter;
import org.jdesktop.beansbinding.Property;

public class FilteredCatalogueControlPanel
extends JPanel
implements NonObservableLinesFilterMethodInterface,
ChangeListener {
    private static final long serialVersionUID = -2396569356718146246L;
    public static final int UPPER_STATE_ENERGY_MAX = 100;
    public static final int UPPER_STATE_ENERGY_INF = 110;
    private static FilteredCatalogueControlPanel instance;
    private SearchDialog dialog = null;
    private final String metacharacters = Pattern.quote("([{\\^-$|]})?+.");
    private Velocity velocity = Velocity.createVelocity();
    private final int nonRegexMode = 1;
    private final TextMatcherEditor<SpectralLine> filterMatcher = new TextMatcherEditor((TextFilterator)new TransitionTitleFilterator());
    private final SidebandMatcherEditor sidebandMatcherEditor = new SidebandMatcherEditor(this.velocity, this);
    private final BindingGroup bindingGroup = new BindingGroup();
    private final JTextField speciesFilterTextField = new JTextField();
    private final JCheckBox searchDescriptionCheckBox = new JCheckBox();
    private final RangeSlider almaBandRangeSlider = new RangeSlider();
    private final RangeSlider frequencyRangeSlider = new RangeSlider();
    private final JSpinner maxFrequencySpinner = new JSpinner();
    private final JSpinner minFrequencySpinner = new JSpinner();
    private final JSpinner minUpperStateEnergySpinner = new JSpinner();
    private final JSpinner maxUpperStateEnergySpinner = new JSpinner();
    private final JComboBox environmentComboBox = new JComboBox<FlagsMatcherEditor.Filter>(new DefaultComboBoxModel<FlagsMatcherEditor.Filter>(FlagsMatcherEditor.Filter.ALL_FILTERS_ARRAY));
    private final JButton searchOnlineServerButton = new JButton();
    private final JButton resetFiltersButton = new JButton();
    private final ButtonGroup lineFilterButtonGroup = new ButtonGroup();
    private final JRadioButton potentiallySelectableLinesRadioButton = new JRadioButton("Potentially selectable lines", false);
    private final JRadioButton allLinesRadioButton = new JRadioButton("All lines", true);
    private final JRadioButton linesInDefinedSPWsRadioButton = new JRadioButton("Lines in defined spws", false);
    private final JLabel autoFilterActive = new JLabel("Filtering unobservable lines");
    private final JLabel upperStateEnergyActive = new JLabel("");
    private final JButton loadButton = new JButton();
    private final JLabel almaBandLabel = new JLabel();
    private final JLabel frequencyTitle = new JLabel();
    private final JLabel maxFrequencyLabel = new JLabel();
    private final JLabel minFrequencyLabel = new JLabel();
    private final JLabel maxUpperStateEnergyLabel = new JLabel("Max");
    private final JLabel minUpperStateEnergyLabel = new JLabel("Min");
    private final MinimumFrequencyMatcherEditor minFreqMatcher = new MinimumFrequencyMatcherEditor(this.minFrequencySpinner, this.velocity);
    private final MaximumFrequencyMatcherEditor maxFreqMatcher = new MaximumFrequencyMatcherEditor(this.maxFrequencySpinner, this.velocity);
    private FilteredCatalogue catalogue;
    private LineSelectorDialog lineSelectorDialog;
    private Optional<SpectralSetupParameters> ssp;
    private boolean isFilteringOnSPWsAllowed;

    public static FilteredCatalogueControlPanel getInstance() {
        if (instance == null) {
            instance = new FilteredCatalogueControlPanel();
            instance.reset();
        }
        return instance;
    }

    public void setVelocity(Velocity velocity) {
        if (velocity != null) {
            this.velocity.getCenterVelocity().setContentAndUnit((ValueUnitPair)velocity.getCenterVelocity());
            this.velocity.setDopplerCalcType(velocity.getDopplerCalcType());
            this.velocity.setReferenceSystem(velocity.getReferenceSystem());
        }
    }

    private FilteredCatalogueControlPanel() {
        this.initComponents();
        if (!this.searchDescriptionCheckBox.isSelected()) {
            this.searchDescriptionCheckBox.doClick();
        }
    }

    private boolean isValidRegex(String string) {
        try {
            Pattern.compile(string);
            return true;
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return false;
        }
    }

    private boolean isRegex(String string) {
        return string.contains("*");
    }

    private String convertToRegex(String string) {
        Object object = string.replaceAll("([" + this.metacharacters + "])", "\\\\$1");
        object = ((String)object).replaceAll("\\*", "\\.\\*");
        object = "(?i)" + (String)object + ".*";
        return object;
    }

    private String[] getFilterInput(String string) {
        if (this.filterMatcher.getMode() == 2) {
            return new String[]{this.convertToRegex(string)};
        }
        return new String[]{string};
    }

    private void setFilterMatcher() {
        if (this.searchDescriptionCheckBox.isSelected()) {
            this.filterMatcher.setFilterator((TextFilterator)new TransitionTitleAndDescriptionFilterator());
        } else {
            this.filterMatcher.setFilterator((TextFilterator)new TransitionTitleFilterator());
        }
    }

    public void controlCatalogue(FilteredCatalogue filteredCatalogue) {
        this.catalogue = filteredCatalogue;
        this.speciesFilterTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.updateMatcherEditorFilters();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.updateMatcherEditorFilters();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.updateMatcherEditorFilters();
            }

            private void updateMatcherEditorFilters() {
                String string = FilteredCatalogueControlPanel.this.speciesFilterTextField.getText();
                if (FilteredCatalogueControlPanel.this.filterMatcher.getMode() != 2 && FilteredCatalogueControlPanel.this.isRegex(string) && FilteredCatalogueControlPanel.this.isValidRegex(FilteredCatalogueControlPanel.this.convertToRegex(string))) {
                    FilteredCatalogueControlPanel.this.filterMatcher.setMode(2);
                }
                String[] stringArray = FilteredCatalogueControlPanel.this.getFilterInput(FilteredCatalogueControlPanel.this.speciesFilterTextField.getText());
                FilteredCatalogueControlPanel.this.filterMatcher.setFilterText(stringArray);
            }
        });
        this.filterMatcher.setMode(1);
        this.setFilterMatcher();
        filteredCatalogue.addMatcherEditor((MatcherEditor<SpectralLine>)this.filterMatcher);
        UpperStateEnergyMatcherEditor upperStateEnergyMatcherEditor = new UpperStateEnergyMatcherEditor(this.minUpperStateEnergySpinner, this.maxUpperStateEnergySpinner);
        filteredCatalogue.addMatcherEditor((MatcherEditor<SpectralLine>)upperStateEnergyMatcherEditor);
        FlagsMatcherEditor flagsMatcherEditor = new FlagsMatcherEditor(this.environmentComboBox);
        filteredCatalogue.addMatcherEditor((MatcherEditor<SpectralLine>)flagsMatcherEditor);
        filteredCatalogue.addMatcherEditor((MatcherEditor<SpectralLine>)this.sidebandMatcherEditor);
        this.sidebandMatcherEditor.addMatcherEditorListener((MatcherEditor.Listener)new MatcherEditor.Listener<SpectralLine>(){

            public void changedMatcher(MatcherEditor.Event<SpectralLine> event) {
                FilteredCatalogueControlPanel.this.setFrequencyFiltersActive(FilteredCatalogueControlPanel.this.sidebandMatcherEditor.isActive());
            }
        });
        this.allLinesRadioButton.addActionListener(this::lineFilterButtonPushEventProcessor);
        this.potentiallySelectableLinesRadioButton.addActionListener(this::lineFilterButtonPushEventProcessor);
        this.linesInDefinedSPWsRadioButton.addActionListener(this::lineFilterButtonPushEventProcessor);
        this.lineFilterButtonGroup.add(this.allLinesRadioButton);
        this.lineFilterButtonGroup.add(this.potentiallySelectableLinesRadioButton);
        this.lineFilterButtonGroup.add(this.linesInDefinedSPWsRadioButton);
        flagsMatcherEditor.actionPerformed(null);
        this.minFreqMatcher.stateChanged(null);
        this.maxFreqMatcher.stateChanged(null);
        upperStateEnergyMatcherEditor.stateChanged(null);
        this.sidebandMatcherEditor.setLines(null);
        this.sidebandMatcherEditor.setLinesInOtherBasebands(null);
        this.speciesFilterTextField.setText(this.speciesFilterTextField.getText());
    }

    public ObservableLineFilter getObservableFilterSelected(Component component) {
        if (component.equals(this.allLinesRadioButton)) {
            return ObservableLineFilter.AllLinesFilter;
        }
        if (component.equals(this.linesInDefinedSPWsRadioButton)) {
            return ObservableLineFilter.LinesDefinedInSPWFilter;
        }
        if (component.equals(this.potentiallySelectableLinesRadioButton)) {
            return ObservableLineFilter.PotentiallySelectableLinesFilter;
        }
        throw new RuntimeException("Unknown filter component specified ");
    }

    private void lineFilterButtonPushEventProcessor(ActionEvent actionEvent) {
        boolean bl = this.allLinesRadioButton.isSelected();
        this.sidebandMatcherEditor.setLines();
        this.sidebandMatcherEditor.setLinesInOtherBasebands();
        this.sidebandMatcherEditor.setEnabled(!bl);
        this.setFrequencyFiltersActive(this.sidebandMatcherEditor.isActive());
        this.setToolTips();
    }

    private void setFrequencyFiltersActive(boolean bl) {
        boolean bl2 = bl && (this.potentiallySelectableLinesRadioButton.isSelected() || this.linesInDefinedSPWsRadioButton.isSelected());
        Icon icon = bl2 ? Icons.filterEnabled : Icons.filterDisabled;
        this.autoFilterActive.setEnabled(bl2);
        this.autoFilterActive.setIcon(icon);
        this.almaBandLabel.setEnabled(!bl2);
        this.almaBandRangeSlider.setEnabled(!bl2);
        this.frequencyTitle.setEnabled(!bl2);
        this.frequencyRangeSlider.setEnabled(!bl2);
        this.minFrequencyLabel.setEnabled(!bl2);
        this.minFrequencySpinner.setEnabled(!bl2);
        this.maxFrequencyLabel.setEnabled(!bl2);
        this.maxFrequencySpinner.setEnabled(!bl2);
        if (this.catalogue != null) {
            if (bl2) {
                this.catalogue.removeMatcherEditor((MatcherEditor<SpectralLine>)this.minFreqMatcher);
                this.catalogue.removeMatcherEditor((MatcherEditor<SpectralLine>)this.maxFreqMatcher);
            } else {
                this.catalogue.addMatcherEditor((MatcherEditor<SpectralLine>)this.minFreqMatcher);
                this.catalogue.addMatcherEditor((MatcherEditor<SpectralLine>)this.maxFreqMatcher);
            }
        }
    }

    public void setAlmaBandRange(int n, int n2) {
        SwingUtilities.invokeLater(() -> {
            if (!this.autoFilterActive.isEnabled()) {
                this.almaBandRangeSlider.setValue(n);
                this.almaBandRangeSlider.setUpperValue(n2);
            }
        });
    }

    public void setFrequencyRange(double d, double d2) {
        SwingUtilities.invokeLater(() -> {
            if (!this.autoFilterActive.isEnabled()) {
                if (d > (Double)this.maxFrequencySpinner.getValue()) {
                    this.maxFrequencySpinner.setValue(d2);
                    this.minFrequencySpinner.setValue(d);
                } else {
                    this.minFrequencySpinner.setValue(d);
                    this.maxFrequencySpinner.setValue(d2);
                }
            }
        });
    }

    public void setFilter(String string) {
        SwingUtilities.invokeLater(() -> this.speciesFilterTextField.setText(string));
    }

    public void reset() {
        this.minFrequencySpinner.setValue(31.3);
        this.maxFrequencySpinner.setValue(950.0);
        this.maxUpperStateEnergySpinner.setValue(0.0);
        this.minUpperStateEnergySpinner.setValue(0.0);
        this.setFilter("*");
        this.environmentComboBox.setSelectedItem((Object)FlagsMatcherEditor.Filter.ALL);
        this.setHideObservableLineFilterEnabled(false);
    }

    private void initComponents() {
        Serializable serializable;
        Object object2;
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel();
        JLabel jLabel5 = new JLabel();
        JLabel jLabel6 = new JLabel();
        JLabel jLabel7 = new JLabel();
        JLabel jLabel8 = new JLabel();
        JLabel jLabel9 = new JLabel("e.g. CO*2-1* or *oxide*");
        jLabel7.setFont(jLabel7.getFont().deriveFont(jLabel7.getFont().getStyle() | 1));
        jLabel7.setLabelFor(this.speciesFilterTextField);
        jLabel7.setText("Transition Filter");
        this.speciesFilterTextField.setToolTipText("Enter a search term to filter the available lines. Wildcards can be entered with an asterisk.");
        this.speciesFilterTextField.setNavigationFilter(new UndeletableSuffixNavigationFilter(0, 1, this.speciesFilterTextField));
        jLabel9.setFont(new Font("Helvetica", 2, 10));
        ((AbstractDocument)this.speciesFilterTextField.getDocument()).setDocumentFilter(new RegexDocumentFilter());
        this.speciesFilterTextField.setText(" ");
        this.searchDescriptionCheckBox.addActionListener(actionEvent -> this.setFilterMatcher());
        jLabel6.setText("Include description");
        jLabel6.setLabelFor(this.searchDescriptionCheckBox);
        jLabel6.setToolTipText("Check to match the description in addition to the transition formula");
        this.searchDescriptionCheckBox.setToolTipText("Check to match the description in addition to the transition formula");
        jLabel4.setFont(jLabel4.getFont().deriveFont(jLabel4.getFont().getStyle() | 1));
        jLabel4.setText("Frequency Filters");
        this.almaBandLabel.setFont(this.almaBandLabel.getFont().deriveFont(this.almaBandLabel.getFont().getStyle() | 1));
        this.almaBandLabel.setLabelFor(this.almaBandRangeSlider);
        this.almaBandLabel.setText("ALMA Band");
        this.almaBandRangeSlider.setMajorTickSpacing(1);
        this.almaBandRangeSlider.setMaximum(10);
        this.almaBandRangeSlider.setMinimum(1);
        this.almaBandRangeSlider.setPaintLabels(true);
        this.almaBandRangeSlider.setPaintTicks(true);
        this.almaBandRangeSlider.setSnapToTicks(true);
        this.almaBandRangeSlider.setToolTipText("Set the frequency range thresholds to an ALMA band");
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        ((Dictionary)hashtable).put(new Integer(1), new JLabel("1"));
        ((Dictionary)hashtable).put(new Integer(2), new JLabel("2"));
        ((Dictionary)hashtable).put(new Integer(3), new JLabel("3"));
        ((Dictionary)hashtable).put(new Integer(4), new JLabel("4"));
        ((Dictionary)hashtable).put(new Integer(5), new JLabel("5"));
        ((Dictionary)hashtable).put(new Integer(6), new JLabel("6"));
        ((Dictionary)hashtable).put(new Integer(7), new JLabel("7"));
        ((Dictionary)hashtable).put(new Integer(8), new JLabel("8"));
        ((Dictionary)hashtable).put(new Integer(9), new JLabel("9"));
        ((Dictionary)hashtable).put(new Integer(10), new JLabel("10"));
        Enumeration enumeration = ((Dictionary)hashtable).elements();
        while (enumeration.hasMoreElements()) {
            object2 = (JLabel)enumeration.nextElement();
            ((JComponent)object2).setForeground(SystemColor.lightGray);
        }
        for (ReceiverBand object3 : ReceiverBand.getKnownReceiverBands()) {
            serializable = (JLabel)((Dictionary)hashtable).get(object3.getNumber());
            ((JComponent)serializable).setForeground(SystemColor.textText);
        }
        this.almaBandRangeSlider.setLabelTable(hashtable);
        jLabel.setFont(jLabel.getFont().deriveFont(jLabel.getFont().getStyle() | 1));
        jLabel.setText("Receiver/Back End Configuration");
        this.frequencyTitle.setFont(this.frequencyTitle.getFont().deriveFont(this.frequencyTitle.getFont().getStyle() | 1));
        this.frequencyTitle.setLabelFor(this.frequencyRangeSlider);
        this.frequencyTitle.setText("Sky Frequency (GHz)");
        this.frequencyRangeSlider.setMajorTickSpacing(100);
        this.frequencyRangeSlider.setMaximum(1000);
        this.frequencyRangeSlider.setMinimum(10);
        this.frequencyRangeSlider.setMinorTickSpacing(50);
        this.frequencyRangeSlider.setPaintTicks(true);
        this.frequencyRangeSlider.setToolTipText("Set the threshold of the frequency range filter");
        this.minFrequencyLabel.setLabelFor(this.minFrequencySpinner);
        this.minFrequencyLabel.setText("Min");
        this.minFrequencySpinner.setModel(new SpinnerNumberModel(10.0, 10.0, 1000.0, 1.0));
        this.minFrequencySpinner.setToolTipText("Fine-tune the threshold of the minimum frequency filter");
        this.maxFrequencySpinner.setModel(new SpinnerNumberModel(1000.0, 10.0, 1000.0, 1.0));
        this.maxFrequencySpinner.setToolTipText("Fine-tune the threshold of the maximum frequency filter");
        this.maxFrequencyLabel.setLabelFor(this.maxFrequencySpinner);
        this.maxFrequencyLabel.setText("Max");
        this.autoFilterActive.setIcon(Icons.filterDisabled);
        this.autoFilterActive.setFont(this.autoFilterActive.getFont().deriveFont(1));
        this.autoFilterActive.setEnabled(false);
        this.autoFilterActive.setIconTextGap(12);
        this.upperStateEnergyActive.setIcon(Icons.filterDisabled);
        this.upperStateEnergyActive.setFont(this.upperStateEnergyActive.getFont().deriveFont(1));
        this.upperStateEnergyActive.setEnabled(false);
        this.upperStateEnergyActive.setIconTextGap(12);
        this.allLinesRadioButton.setIconTextGap(12);
        this.allLinesRadioButton.setToolTipText("Show all lines according to above frequency limits");
        this.potentiallySelectableLinesRadioButton.setIconTextGap(12);
        this.potentiallySelectableLinesRadioButton.setToolTipText("Show lines which could be added in new or existing spws");
        this.linesInDefinedSPWsRadioButton.setIconTextGap(12);
        this.linesInDefinedSPWsRadioButton.setToolTipText("Only show lines within the currently defined spws");
        jLabel8.setFont(jLabel8.getFont().deriveFont(jLabel8.getFont().getStyle() | 1));
        jLabel8.setLabelFor(this.minUpperStateEnergySpinner);
        jLabel8.setText("Upper-state Energy (K)");
        object2 = this.minUpperStateEnergySpinner.getEditor();
        JFormattedTextField jFormattedTextField = ((JSpinner.NumberEditor)object2).getTextField();
        jFormattedTextField.setColumns(10);
        object2 = this.maxUpperStateEnergySpinner.getEditor();
        JFormattedTextField jFormattedTextField2 = ((JSpinner.NumberEditor)object2).getTextField();
        jFormattedTextField2.setColumns(10);
        serializable = new SpinnerNumberModel(0.0, 0.0, 10000.0, 1.0);
        ((AbstractSpinnerModel)serializable).addChangeListener(this);
        this.minUpperStateEnergySpinner.setModel((SpinnerModel)((Object)serializable));
        this.minUpperStateEnergySpinner.setToolTipText("Sets the minimum threshold of the upper-state energy filter");
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(1000.0, 0.0, 10000.0, 1.0);
        spinnerNumberModel.addChangeListener(this);
        this.maxUpperStateEnergySpinner.setModel(spinnerNumberModel);
        this.maxUpperStateEnergySpinner.setToolTipText("Sets the maximum threshold of the upper-state energy filter");
        hashtable = new Hashtable();
        ((Dictionary)hashtable).put(new Integer(0), new JLabel("O"));
        ((Dictionary)hashtable).put(new Integer(20), new JLabel("20"));
        ((Dictionary)hashtable).put(new Integer(40), new JLabel("40"));
        ((Dictionary)hashtable).put(new Integer(60), new JLabel("60"));
        ((Dictionary)hashtable).put(new Integer(80), new JLabel("80"));
        ((Dictionary)hashtable).put(new Integer(100), new JLabel("100"));
        ((Dictionary)hashtable).put(new Integer(110), new JLabel("\u221e"));
        this.searchOnlineServerButton.setText("Search Online");
        this.searchOnlineServerButton.setToolTipText("Search online for transitions matching your criteria.");
        this.searchOnlineServerButton.addActionListener(actionEvent -> this.searchOnlineServerButtonActionPerformed(actionEvent));
        this.resetFiltersButton.setText("Reset Filters");
        this.resetFiltersButton.setToolTipText("Reset all filters to their initial state");
        this.resetFiltersButton.addActionListener(actionEvent -> this.resetButtonActionPerformed(actionEvent));
        this.loadButton.setText("Load Catalogue...");
        this.loadButton.setToolTipText("Load new catalogue from disk");
        this.loadButton.addActionListener(actionEvent -> this.loadButtonActionPerformed(actionEvent));
        jLabel3.setFont(jLabel3.getFont().deriveFont(jLabel3.getFont().getStyle() | 1));
        jLabel3.setLabelFor(this.environmentComboBox);
        jLabel3.setText("Molecule Filter / Environment");
        jLabel2.setLabelFor(this.environmentComboBox);
        jLabel2.setText("Show");
        this.environmentComboBox.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                JComboBox jComboBox = (JComboBox)popupMenuEvent.getSource();
                Accessible accessible = jComboBox.getUI().getAccessibleChild(jComboBox, 0);
                if (!(accessible instanceof JPopupMenu)) {
                    return;
                }
                JPopupMenu jPopupMenu = (JPopupMenu)accessible;
                JComponent jComponent = (JComponent)jPopupMenu.getComponent(0);
                BasicComboPopup basicComboPopup = (BasicComboPopup)accessible;
                Dimension dimension = basicComboPopup.getList().getPreferredSize();
                Dimension dimension2 = jComponent.getPreferredSize();
                dimension2.width = Math.max(dimension2.width, dimension.width);
                if (jComponent instanceof JScrollPane) {
                    JScrollPane jScrollPane = (JScrollPane)jComponent;
                    jScrollPane.setVerticalScrollBarPolicy(20);
                    int n = jScrollPane.getVerticalScrollBar().getPreferredSize().width;
                    dimension2.width += n;
                }
                jComponent.setPreferredSize(dimension2);
                jComponent.setMaximumSize(dimension2);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        });
        this.environmentComboBox.setToolTipText("Filter transitions based on where their originating molecules have been detected");
        this.environmentComboBox.setPrototypeDisplayValue("a");
        JSeparator jSeparator = new JSeparator(0);
        JSeparator jSeparator2 = new JSeparator(0);
        JSeparator jSeparator3 = new JSeparator(0);
        JSeparator jSeparator4 = new JSeparator(0);
        JSeparator jSeparator5 = new JSeparator(0);
        JSeparator jSeparator6 = new JSeparator(0);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jLabel7).addComponent(jSeparator).addComponent(jSeparator2).addComponent(jSeparator3).addComponent(jSeparator4).addComponent(jSeparator5).addComponent(jSeparator6).addComponent(this.almaBandLabel).addComponent(jLabel4).addComponent(this.frequencyTitle).addComponent(jLabel).addComponent(this.autoFilterActive).addComponent(this.allLinesRadioButton).addComponent(this.potentiallySelectableLinesRadioButton).addComponent(this.linesInDefinedSPWsRadioButton).addComponent(this.frequencyRangeSlider, -1, -1, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.minFrequencyLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.minFrequencySpinner, -2, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.maxFrequencyLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maxFrequencySpinner, -2, -2, -2)).addComponent(this.almaBandRangeSlider, -1, -1, Short.MAX_VALUE).addComponent(this.speciesFilterTextField, -1, -1, Short.MAX_VALUE).addComponent(jLabel9, -1, -1, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.searchDescriptionCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel6)).addComponent(jLabel8).addGroup(groupLayout.createSequentialGroup().addComponent(this.upperStateEnergyActive).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.minUpperStateEnergyLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.minUpperStateEnergySpinner, -2, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.maxUpperStateEnergyLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maxUpperStateEnergySpinner, -2, -2, -2)).addComponent(jLabel3).addGroup(groupLayout.createSequentialGroup().addComponent(jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.environmentComboBox)).addComponent(jLabel5).addComponent(this.searchOnlineServerButton, GroupLayout.Alignment.TRAILING, -1, 166, Short.MAX_VALUE).addComponent(this.resetFiltersButton, GroupLayout.Alignment.TRAILING, -1, 166, Short.MAX_VALUE).addComponent(this.loadButton, GroupLayout.Alignment.TRAILING, -1, 166, Short.MAX_VALUE));
        groupLayout.linkSize(0, this.maxFrequencySpinner, this.minFrequencySpinner);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.speciesFilterTextField, -2, -1, -2).addComponent(jLabel9, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.searchDescriptionCheckBox).addComponent(jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jSeparator).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.almaBandLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.almaBandRangeSlider, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.frequencyTitle).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.frequencyRangeSlider, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.minFrequencyLabel).addComponent(this.minFrequencySpinner, -2, -1, -2).addComponent(this.maxFrequencyLabel).addComponent(this.maxFrequencySpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.allLinesRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.potentiallySelectableLinesRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.linesInDefinedSPWsRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.autoFilterActive).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jSeparator2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.upperStateEnergyActive).addComponent(this.minUpperStateEnergyLabel).addComponent(this.minUpperStateEnergySpinner, -2, -1, -2).addComponent(this.maxUpperStateEnergyLabel).addComponent(this.maxUpperStateEnergySpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jSeparator3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(jLabel2).addComponent(this.environmentComboBox)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jSeparator4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchOnlineServerButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jSeparator5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.resetFiltersButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jSeparator6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.loadButton)));
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.minFrequencySpinner, (Property)BeanProperty.create((String)"value"), (Object)this.almaBandRangeSlider, (Property)BeanProperty.create((String)"value"));
        autoBinding.setConverter((Converter)new MinFrequencyToBandConverter());
        this.bindingGroup.addBinding((Binding)autoBinding);
        autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.maxFrequencySpinner, (Property)BeanProperty.create((String)"value"), (Object)this.almaBandRangeSlider, (Property)BeanProperty.create((String)"upperValue"));
        autoBinding.setConverter((Converter)new MaxFrequencyToBandConverter());
        this.bindingGroup.addBinding((Binding)autoBinding);
        autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.frequencyRangeSlider, (Property)BeanProperty.create((String)"value"), (Object)this.minFrequencySpinner, (Property)BeanProperty.create((String)"value"));
        autoBinding.setConverter((Converter)new IntegerToDoubleConverter());
        this.bindingGroup.addBinding((Binding)autoBinding);
        autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.frequencyRangeSlider, (Property)BeanProperty.create((String)"upperValue"), (Object)this.maxFrequencySpinner, (Property)BeanProperty.create((String)"value"));
        autoBinding.setConverter((Converter)new IntegerToDoubleConverter());
        this.bindingGroup.addBinding((Binding)autoBinding);
        this.bindingGroup.bind();
        jLabel5.setText("<html>Can't find the transition you're looking for in the offline pool? Find more in the online Splatalogue.</html>");
        jLabel5.setPreferredSize(this.getPreferredSize(jLabel5.getText(), true, this.almaBandRangeSlider.getPreferredSize().width));
        jLabel.setName("FilteredCatalogueControlPanel.autoFilterTitle");
        jLabel2.setName("FilteredCatalogueControlPanel.lineTypeLabel");
        jLabel3.setName("FilteredCatalogueControlPanel.lineTypeTitle");
        jLabel4.setName("FilteredCatalogueControlPanel.frequencySectionLabel");
        jLabel5.setName("FilteredCatalogueControlPanel.help");
        jLabel7.setName("FilteredCatalogueControlPanel.speciesFilterLabel");
        jLabel6.setName("FilteredCatalogueControlPanel.searchDescriptionLabel");
        jLabel7.setName("FilteredCatalogueControlPanel.speciesFilterTitle");
        jLabel8.setName("FilteredCatalogueControlPanel.upperStateEnergyTitle");
        this.almaBandLabel.setName("FilteredCatalogueControlPanel.almaBandLabel");
        this.almaBandRangeSlider.setName("FilteredCatalogueControlPanel.almaBandRangeSlider");
        this.autoFilterActive.setName("FilteredCatalogueControlPanel.autoFilterActive");
        this.upperStateEnergyActive.setName("FilteredCatalogueControlPanel.upperStateEnergyActive");
        this.potentiallySelectableLinesRadioButton.setName("FilteredCatalogueControlPanel.autoFilterCheckBox");
        this.environmentComboBox.setName("FilteredCatalogueControlPanel.environmentComboBox");
        this.frequencyRangeSlider.setName("FilteredCatalogueControlPanel.frequencyRangeSlider");
        this.frequencyTitle.setName("FilteredCatalogueControlPanel.frequencyTitle");
        this.maxFrequencyLabel.setName("FilteredCatalogueControlPanel.maxFrequencyLabel");
        this.maxFrequencySpinner.setName("FilteredCatalogueControlPanel.maxFrequencySpinner");
        this.minFrequencyLabel.setName("FilteredCatalogueControlPanel.minFrequencyLabel");
        this.minFrequencySpinner.setName("FilteredCatalogueControlPanel.minFrequencySpinner");
        this.resetFiltersButton.setName("FilteredCatalogueControlPanel.resetButton");
        this.searchOnlineServerButton.setName("FilteredCatalogueControlPanel.searchButton");
        this.searchDescriptionCheckBox.setName("FilteredCatalogueControlPanel.searchDescriptionCheckBox");
        this.speciesFilterTextField.setName("FilteredCatalogueControlPanel.filterTextField");
        this.searchDescriptionCheckBox.setName("FilteredCatalogueControlPanel.searchDescriptionCheckBox");
        if (!Boolean.getBoolean("userSLC")) {
            this.loadButton.setVisible(false);
            jSeparator6.setVisible(false);
        }
        SpinnerNumberModel spinnerNumberModel2 = (SpinnerNumberModel)this.minUpperStateEnergySpinner.getModel();
        spinnerNumberModel2.setMaximum(null);
        spinnerNumberModel2 = (SpinnerNumberModel)this.maxUpperStateEnergySpinner.getModel();
        spinnerNumberModel2.setMaximum(null);
    }

    private void searchOnlineServerButtonActionPerformed(ActionEvent actionEvent) {
        if (this.dialog == null || !this.dialog.isDisplayable()) {
            JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, this);
            Window window = SwingUtilities.getWindowAncestor(this);
            this.dialog = new SearchDialog((Window)jFrame, this.velocity);
            window.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    FilteredCatalogueControlPanel.this.dialog.dispose();
                }
            });
            this.dialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.dialog.setLocationRelativeTo(this.searchOnlineServerButton);
            if ((this.linesInDefinedSPWsRadioButton.isSelected() || this.potentiallySelectableLinesRadioButton.isSelected()) && this.sidebandMatcherEditor.isActive()) {
                Frequency frequency = this.sidebandMatcherEditor.getMinFrequency();
                Frequency frequency2 = this.sidebandMatcherEditor.getMaxFrequency();
                Frequency frequency3 = this.velocity.dopplerShift(frequency);
                Frequency frequency4 = this.velocity.dopplerShift(frequency2);
                this.dialog.setFrequencies(frequency3, frequency4);
            } else if (this.almaBandRangeSlider.getValue() == this.almaBandRangeSlider.getUpperValue()) {
                Frequency frequency = Frequency.createFrequencyGHZ((Double)this.minFrequencySpinner.getValue());
                Frequency frequency5 = Frequency.createFrequencyGHZ((Double)this.maxFrequencySpinner.getValue());
                this.dialog.setFrequencies(frequency, frequency5);
            } else {
                this.dialog.setBand(this.almaBandRangeSlider.getValue());
            }
            this.dialog.setPartialFilter(this.speciesFilterTextField.getText());
            EventQueue.invokeLater(() -> {
                this.dialog.toFront();
                this.dialog.repaint();
            });
            this.dialog.setVisible(true);
        } else {
            EventQueue.invokeLater(() -> {
                this.dialog.toFront();
                this.dialog.repaint();
            });
            this.dialog.toFront();
        }
    }

    private void resetButtonActionPerformed(ActionEvent actionEvent) {
        this.reset();
    }

    private void loadButtonActionPerformed(ActionEvent actionEvent) {
        File file;
        JFileChooser jFileChooser = GuiFactory.getFactory().giveFileChooser(this);
        jFileChooser.setDialogTitle("Load Spectral Line Catalogue");
        int n = jFileChooser.showOpenDialog(this.getParent());
        if (n == 0 && (file = jFileChooser.getSelectedFile()).exists()) {
            try {
                URL uRL = file.toURI().toURL();
                SpectralLineCatalogue.getInstance().load(uRL);
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
        }
    }

    private Dimension getPreferredSize(String string, boolean bl, int n) {
        JLabel jLabel = new JLabel();
        jLabel.setText(string);
        View view = (View)jLabel.getClientProperty("html");
        view.setSize(bl ? (float)n : 0.0f, bl ? 0.0f : (float)n);
        float f = view.getPreferredSpan(0);
        float f2 = view.getPreferredSpan(1);
        return new Dimension((int)Math.ceil(f), (int)Math.ceil(f2));
    }

    public void setLinesInOtherBasebands(Collection<SpectralLine> collection) {
        this.sidebandMatcherEditor.setLinesInOtherBasebands(collection);
    }

    public void setLo1(Frequency frequency) {
        this.sidebandMatcherEditor.setLo1(frequency);
    }

    public void setLo2(Frequency frequency, boolean bl) {
        this.sidebandMatcherEditor.setLo2(frequency, bl);
    }

    public void enableLinesFilters(boolean bl, boolean bl2) {
        this.potentiallySelectableLinesRadioButton.setEnabled(!bl2 && bl);
        this.linesInDefinedSPWsRadioButton.setEnabled(this.isFilteringOnSPWsAllowed && bl);
        this.allLinesRadioButton.setEnabled(!bl2);
    }

    public void setStateNonObservableLineFilters(boolean bl) {
        boolean bl2 = this.getSpectralLinePickerVariation().equals((Object)SpectralLinePickerVariation.RestFrequencyPicker);
        if (bl) {
            boolean bl3 = false;
            if (this.potentiallySelectableLinesRadioButton.isSelected()) {
                if (bl2) {
                    this.linesInDefinedSPWsRadioButton.setSelected(true);
                } else {
                    this.potentiallySelectableLinesRadioButton.doClick();
                }
                bl3 = true;
            }
            if (this.linesInDefinedSPWsRadioButton.isSelected()) {
                this.linesInDefinedSPWsRadioButton.doClick();
                bl3 = true;
            }
            if (this.allLinesRadioButton.isSelected()) {
                this.potentiallySelectableLinesRadioButton.setSelected(true);
                this.potentiallySelectableLinesRadioButton.doClick();
                bl3 = true;
            }
            if (!bl3) {
                this.potentiallySelectableLinesRadioButton.setSelected(true);
                this.potentiallySelectableLinesRadioButton.doClick();
            }
        } else if (!bl && !this.allLinesRadioButton.isSelected()) {
            this.allLinesRadioButton.setSelected(true);
            this.allLinesRadioButton.doClick();
        }
        this.enableLinesFilters(bl, bl2);
    }

    public void registerTable(JTable jTable) {
        jTable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                EventTableModel eventTableModel = (EventTableModel)tableModelEvent.getSource();
                ArrayList<SpectralLine> arrayList = new ArrayList<SpectralLine>();
                int n = eventTableModel.getRowCount();
                for (int i = 0; i < n; ++i) {
                    arrayList.add((SpectralLine)eventTableModel.getElementAt(i));
                }
                FilteredCatalogueControlPanel.this.sidebandMatcherEditor.setLines(arrayList);
            }
        });
    }

    public void setHideObservableLineFilterEnabled(boolean bl) {
        if (!bl) {
            this.allLinesRadioButton.setSelected(true);
            this.allLinesRadioButton.doClick();
            return;
        }
        if (this.linesInDefinedSPWsRadioButton.isSelected() && bl) {
            this.linesInDefinedSPWsRadioButton.setSelected(true);
            this.linesInDefinedSPWsRadioButton.doClick();
            return;
        }
        if (bl) {
            this.potentiallySelectableLinesRadioButton.setSelected(true);
            this.potentiallySelectableLinesRadioButton.doClick();
            return;
        }
    }

    public boolean isHideObservableLineFilterEnabled() {
        return this.linesInDefinedSPWsRadioButton.isSelected() || this.potentiallySelectableLinesRadioButton.isSelected();
    }

    public void clearHideObservableLineFilters() {
        this.sidebandMatcherEditor.clearFilters();
    }

    public void setSpectralLinePicker(LineSelectorDialog lineSelectorDialog) {
        this.lineSelectorDialog = lineSelectorDialog;
    }

    public void setSpectralSetupParameters(Optional<SpectralSetupParameters> optional) {
        this.ssp = optional;
        this.isFilteringOnSPWsAllowed = true;
        if (this.getSpectralLinePickerVariation().equals((Object)SpectralLinePickerVariation.MultiLinePicker)) {
            this.isFilteringOnSPWsAllowed = optional.isPresent() && optional.get().getLOSolutionFound();
        }
        this.enableFilteringOnSPWS(this.isFilteringOnSPWsAllowed);
    }

    private void enableFilteringOnSPWS(boolean bl) {
        if (!bl && this.linesInDefinedSPWsRadioButton.isSelected()) {
            this.allLinesRadioButton.setSelected(true);
            this.allLinesRadioButton.doClick();
        }
        this.linesInDefinedSPWsRadioButton.setEnabled(bl);
    }

    @Override
    public Optional<SpectralSetupParameters> getSSP() {
        return this.ssp;
    }

    @Override
    public NonObservableLinesFilterMethodInterface.ObservableLinesFilterType getFilterType() {
        NonObservableLinesFilterMethodInterface.ObservableLinesFilterType observableLinesFilterType = null;
        switch (this.getSpectralLinePickerVariation()) {
            case MultiLinePicker: {
                MultiLineSelectorDialog multiLineSelectorDialog = (MultiLineSelectorDialog)this.lineSelectorDialog;
                observableLinesFilterType = NonObservableLinesFilterMethodInterface.ObservableLinesFilterType.OVERLAY;
                if (this.linesInDefinedSPWsRadioButton.isSelected()) {
                    observableLinesFilterType = NonObservableLinesFilterMethodInterface.ObservableLinesFilterType.RESTFREQUENCIES;
                    break;
                }
                if (multiLineSelectorDialog.isBasebandUnconstrained() || this.allLinesRadioButton.isSelected()) {
                    observableLinesFilterType = NonObservableLinesFilterMethodInterface.ObservableLinesFilterType.OVERLAY;
                    break;
                }
                if (!this.potentiallySelectableLinesRadioButton.isSelected()) break;
                observableLinesFilterType = NonObservableLinesFilterMethodInterface.ObservableLinesFilterType.SPW;
                break;
            }
            case RestFrequencyPicker: {
                if (this.allLinesRadioButton.isSelected()) {
                    observableLinesFilterType = NonObservableLinesFilterMethodInterface.ObservableLinesFilterType.OVERLAY;
                    break;
                }
                if (this.potentiallySelectableLinesRadioButton.isSelected()) {
                    observableLinesFilterType = NonObservableLinesFilterMethodInterface.ObservableLinesFilterType.SPW;
                    break;
                }
                if (this.linesInDefinedSPWsRadioButton.isSelected()) {
                    observableLinesFilterType = NonObservableLinesFilterMethodInterface.ObservableLinesFilterType.RESTFREQUENCIES;
                    break;
                }
                observableLinesFilterType = NonObservableLinesFilterMethodInterface.ObservableLinesFilterType.RESTFREQUENCIES;
                break;
            }
            case SingleLinePicker: {
                if (this.potentiallySelectableLinesRadioButton.isSelected()) {
                    observableLinesFilterType = NonObservableLinesFilterMethodInterface.ObservableLinesFilterType.SPW;
                    break;
                }
                if (!this.linesInDefinedSPWsRadioButton.isSelected()) break;
                observableLinesFilterType = NonObservableLinesFilterMethodInterface.ObservableLinesFilterType.RESTFREQUENCIES;
                break;
            }
            default: {
                throw new RuntimeException("nonObservableLinesFilterType could not be determined");
            }
        }
        return observableLinesFilterType;
    }

    private SpectralLinePickerVariation getSpectralLinePickerVariation() {
        SpectralLinePickerVariation spectralLinePickerVariation = null;
        if (RestFrequencyMultiLineSelectorDialog.class.isAssignableFrom(this.lineSelectorDialog.getClass())) {
            spectralLinePickerVariation = SpectralLinePickerVariation.RestFrequencyPicker;
        } else if (MultiLineSelectorDialog.class.isAssignableFrom(this.lineSelectorDialog.getClass())) {
            spectralLinePickerVariation = SpectralLinePickerVariation.MultiLinePicker;
        } else if (SingleLineSelectorDialog.class.isAssignableFrom(this.lineSelectorDialog.getClass())) {
            spectralLinePickerVariation = SpectralLinePickerVariation.SingleLinePicker;
        } else {
            throw new RuntimeException("Unable to determine the variation of the spectral line picker");
        }
        return spectralLinePickerVariation;
    }

    public void setLinesFilterType(ObservableLineFilter observableLineFilter) {
        switch (observableLineFilter) {
            case AllLinesFilter: {
                this.allLinesRadioButton.setSelected(true);
                this.allLinesRadioButton.doClick();
                break;
            }
            case LinesDefinedInSPWFilter: {
                this.linesInDefinedSPWsRadioButton.setSelected(true);
                this.linesInDefinedSPWsRadioButton.doClick();
                break;
            }
            case PotentiallySelectableLinesFilter: {
                this.potentiallySelectableLinesRadioButton.setSelected(true);
                this.potentiallySelectableLinesRadioButton.doClick();
                break;
            }
            default: {
                throw new RuntimeException("Unknown filter type " + observableLineFilter);
            }
        }
    }

    public void setHideNonObservableLinesRadioButtonHandler(ItemListener itemListener) {
        this.potentiallySelectableLinesRadioButton.addItemListener(itemListener);
        this.allLinesRadioButton.addItemListener(itemListener);
        this.linesInDefinedSPWsRadioButton.addItemListener(itemListener);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Double d = (Double)this.minUpperStateEnergySpinner.getValue();
        Double d2 = (Double)this.maxUpperStateEnergySpinner.getValue();
        boolean bl = d2 != 0.0 || d != 0.0;
        Icon icon = bl ? Icons.filterEnabled : Icons.filterDisabled;
        this.upperStateEnergyActive.setEnabled(bl);
        this.upperStateEnergyActive.setIcon(icon);
    }

    private void setToolTips() {
        boolean bl = !this.getSpectralLinePickerVariation().equals((Object)SpectralLinePickerVariation.RestFrequencyPicker);
        this.potentiallySelectableLinesRadioButton.setToolTipText(bl ? "Show lines which could be added in new or existing spws" : null);
        this.allLinesRadioButton.setToolTipText(bl ? "Show all lines according to above frequency limits" : null);
    }

    class RegexDocumentFilter
    extends DocumentFilter {
        RegexDocumentFilter() {
        }

        @Override
        public void remove(DocumentFilter.FilterBypass filterBypass, int n, int n2) throws BadLocationException {
            int n3 = filterBypass.getDocument().getStartPosition().getOffset();
            int n4 = filterBypass.getDocument().getEndPosition().getOffset() - 1;
            String string = filterBypass.getDocument().getText(n3, n4);
            Object object = string.substring(0, Math.max(0, 1 + n - n2));
            object = (String)object + string.substring(n + 1);
            if (FilteredCatalogueControlPanel.this.filterMatcher.getMode() == 2 && (!FilteredCatalogueControlPanel.this.isRegex((String)object) || FilteredCatalogueControlPanel.this.isRegex((String)object) && !FilteredCatalogueControlPanel.this.isValidRegex(FilteredCatalogueControlPanel.this.convertToRegex((String)object)))) {
                FilteredCatalogueControlPanel.this.filterMatcher.setMode(1);
            }
            super.remove(filterBypass, n, n2);
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
            int n2 = filterBypass.getDocument().getStartPosition().getOffset();
            int n3 = filterBypass.getDocument().getEndPosition().getOffset() - 1;
            String string2 = filterBypass.getDocument().getText(n2, n3);
            String string3 = string2.substring(0, n) + string;
            string3 = string3 + string2.substring(n);
            if (FilteredCatalogueControlPanel.this.filterMatcher.getMode() == 2 && (!FilteredCatalogueControlPanel.this.isRegex(string3) || FilteredCatalogueControlPanel.this.isRegex(string3) && !FilteredCatalogueControlPanel.this.isValidRegex(FilteredCatalogueControlPanel.this.convertToRegex(string3)))) {
                FilteredCatalogueControlPanel.this.filterMatcher.setMode(1);
            }
            super.insertString(filterBypass, n, string, attributeSet);
        }

        @Override
        public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            int n3 = filterBypass.getDocument().getStartPosition().getOffset();
            int n4 = filterBypass.getDocument().getEndPosition().getOffset() - 1;
            String string2 = filterBypass.getDocument().getText(n3, n4);
            String string3 = string2.substring(0, n) + string;
            string3 = string3 + string2.substring(n + n2);
            if (FilteredCatalogueControlPanel.this.filterMatcher.getMode() == 2 && (!FilteredCatalogueControlPanel.this.isRegex(string3) || FilteredCatalogueControlPanel.this.isRegex(string3) && !FilteredCatalogueControlPanel.this.isValidRegex(FilteredCatalogueControlPanel.this.convertToRegex(string3)))) {
                FilteredCatalogueControlPanel.this.filterMatcher.setMode(1);
            }
            super.replace(filterBypass, n, n2, string, attributeSet);
        }
    }

    public static enum ObservableLineFilter {
        AllLinesFilter,
        PotentiallySelectableLinesFilter,
        LinesDefinedInSPWFilter;

    }

    public static enum SpectralLinePickerVariation {
        RestFrequencyPicker,
        MultiLinePicker,
        SingleLinePicker;

    }
}

