/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts.calibrators;

import alma.common.calibratorCatalogue.calQueryParameters.types.CalibrationUseType;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.obsproject.ICalibratorExpertDocument;
import alma.obsprep.bo.obsproject.IQuerySource;
import alma.obsprep.bo.obsproject.QuerySourceAdapter;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.InvalidCoordException;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.ModelChangeSubscriber;
import alma.obsprep.guiutil.mvc.OutOfRangeException;
import alma.obsprep.ot.editors.obsproject.QuerySourceEditor;
import alma.obsprep.ot.models.valuetypes.ValueUnitPairModel;
import alma.obsprep.services.experts.calibrators.CalibratorExpertEditor;
import alma.obsprep.util.Convert;
import alma.obsprep.util.Convert4dp;
import alma.valuetypes.Time;

public class CalibratorExpertModel
extends Model {
    private final ValueUnitPairModel minFreqModel = new ValueUnitPairModel(null, QuerySourceEditor.freqminFID_value, QuerySourceEditor.freqminFID_unit);
    private final ValueUnitPairModel maxFreqModel = new ValueUnitPairModel(null, QuerySourceEditor.freqmaxFID_value, QuerySourceEditor.freqmaxFID_unit);
    private final ValueUnitPairModel minFluxModel = new ValueUnitPairModel(null, QuerySourceEditor.fluxminFID_value, QuerySourceEditor.fluxminFID_unit);
    private final ValueUnitPairModel maxFluxModel = new ValueUnitPairModel(null, QuerySourceEditor.fluxmaxFID_value, QuerySourceEditor.fluxmaxFID_unit);
    private final ValueUnitPairModel minLastObservedModel = new ValueUnitPairModel(null, QuerySourceEditor.timeminFID_value, QuerySourceEditor.timeminFID_unit);
    private final ValueUnitPairModel maxLastObservedModel = new ValueUnitPairModel(null, QuerySourceEditor.timemaxFID_value, QuerySourceEditor.timemaxFID_unit);

    public CalibratorExpertModel(ICalibratorExpertDocument iCalibratorExpertDocument) {
        super(iCalibratorExpertDocument);
        ModelChangeSubscriber modelChangeSubscriber = (model, fieldID, object) -> this.getController().modelChanged(fieldID, object);
        this.minFreqModel.subscribe(modelChangeSubscriber);
        this.maxFreqModel.subscribe(modelChangeSubscriber);
        this.minFluxModel.subscribe(modelChangeSubscriber);
        this.maxFluxModel.subscribe(modelChangeSubscriber);
        this.minLastObservedModel.subscribe(modelChangeSubscriber);
        this.maxLastObservedModel.subscribe(modelChangeSubscriber);
        this.registerSubModel(this.minFreqModel, this.maxFreqModel, this.minFluxModel, this.maxFluxModel, this.minLastObservedModel, this.maxLastObservedModel);
        this.setDocument(iCalibratorExpertDocument);
    }

    @Override
    public void setDocument(Object object) {
        super.setDocument(object);
        if (object != null && object instanceof ICalibratorExpertDocument) {
            ICalibratorExpertDocument iCalibratorExpertDocument = this.getCalibratorExpertDocument();
            this.minFreqModel.setDocument((Object)iCalibratorExpertDocument.getMinFrequency());
            this.maxFreqModel.setDocument((Object)iCalibratorExpertDocument.getMaxFrequency());
            this.minFluxModel.setDocument((Object)iCalibratorExpertDocument.getMinFlux());
            this.maxFluxModel.setDocument((Object)iCalibratorExpertDocument.getMaxFlux());
            if (object instanceof QuerySourceAdapter) {
                QuerySourceAdapter querySourceAdapter = (QuerySourceAdapter)object;
                IQuerySource iQuerySource = querySourceAdapter.getAdaptee();
                Time time = iQuerySource.getMinTimeSinceObserved();
                time.convertToUnit(Time.UNIT_D);
                this.minLastObservedModel.setDocument(time);
                Time time2 = iQuerySource.getMaxTimeSinceObserved();
                time2.convertToUnit(Time.UNIT_D);
                this.maxLastObservedModel.setDocument(time2);
            }
        }
        this.publish();
    }

    private ICalibratorExpertDocument getCalibratorExpertDocument() {
        return (ICalibratorExpertDocument)this.getDocument();
    }

    @Override
    public void publish() {
        ICalibratorExpertDocument iCalibratorExpertDocument = this.getCalibratorExpertDocument();
        if (iCalibratorExpertDocument == null) {
            return;
        }
        this.publish(QuerySourceEditor.catlocFID, iCalibratorExpertDocument.getCatalogueLocation());
        try {
            long l = iCalibratorExpertDocument.getRa();
            int n = iCalibratorExpertDocument.getDec();
            this.publish(QuerySourceEditor.raFID, Convert4dp.milliarcsecToHHMMSS(l));
            this.publish(QuerySourceEditor.decFID, Convert.milliarcsecToDDMMSS(n));
        }
        catch (OutOfRangeException outOfRangeException) {
            Log.logger((Object)this).warning("Coordinates are out of range");
        }
        catch (InvalidCoordException invalidCoordException) {
            Log.logger((Object)this).warning("Coordinates are invalid");
        }
        double d = iCalibratorExpertDocument.getRadius();
        if (d != -999.0) {
            this.publish(QuerySourceEditor.radiusFID, d);
        }
        if (this.getDocument() instanceof QuerySourceAdapter) {
            QuerySourceAdapter querySourceAdapter = (QuerySourceAdapter)this.getDocument();
            IQuerySource iQuerySource = querySourceAdapter.getAdaptee();
            this.publish(QuerySourceEditor.maxSourcesFID, iQuerySource.getMaxSources());
        }
        this.publishSubmodels();
        this.publish(QuerySourceEditor.caltypeFID, iCalibratorExpertDocument.getCalType());
        this.publish(CalibratorExpertEditor.tableFID, iCalibratorExpertDocument.getCalibList());
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        Object object2;
        Object object3 = this.getSubModels().iterator();
        while (object3.hasNext()) {
            object2 = object3.next();
            ((Model)object2).update(editor, fieldID, object);
        }
        try {
            if (fieldID.equals(QuerySourceEditor.catlocFID)) {
                object3 = (String)object;
                object2 = this.getCalibratorExpertDocument();
                if (object2 != null) {
                    object2.setCatalogueLocation((String)object3);
                }
            } else if (fieldID.equals(QuerySourceEditor.radiusFID)) {
                if (object instanceof String) {
                    object3 = Double.parseDouble((String)object);
                    object2 = this.getCalibratorExpertDocument();
                    if (object2 != null) {
                        object2.setRadius((Double)object3);
                    }
                } else if (object instanceof Double && (object3 = this.getCalibratorExpertDocument()) != null) {
                    object3.setRadius((Double)object);
                }
            } else if (fieldID.equals(QuerySourceEditor.raFID)) {
                object3 = (String)object;
                object2 = this.getCalibratorExpertDocument();
                if (object2 != null) {
                    object2.setRa(Convert4dp.HHMMSSToMilliarcsec((String)object3));
                }
            } else if (fieldID.equals(QuerySourceEditor.decFID)) {
                object3 = (String)object;
                object2 = this.getCalibratorExpertDocument();
                if (object2 != null) {
                    object2.setDec(Convert.DDMMSSToMilliarcsec((String)object3));
                }
            } else if (fieldID.equals(QuerySourceEditor.caltypeFID)) {
                object3 = (String)object;
                object2 = this.getCalibratorExpertDocument();
                if (object2 != null) {
                    object2.setCalType(CalibrationUseType.valueOf((String)object3));
                }
            } else if (fieldID.equals(QuerySourceEditor.maxSourcesFID) && this.getDocument() instanceof QuerySourceAdapter) {
                object3 = (QuerySourceAdapter)this.getDocument();
                object2 = (String)object;
                Integer n = Integer.parseInt((String)object2);
                ((QuerySourceAdapter)object3).setMaxSources(n);
            }
        }
        catch (InvalidCoordException invalidCoordException) {
            Log.logger((Object)this).warning("Coordinates are out of range");
        }
        catch (NumberFormatException numberFormatException) {
            Log.logger((Object)this).warning("Could not convert to internal coordinate format");
        }
        return object;
    }

    public ValueUnitPairModel getMinFreqModel() {
        return this.minFreqModel;
    }

    public ValueUnitPairModel getMaxFreqModel() {
        return this.maxFreqModel;
    }

    public ValueUnitPairModel getMinFluxModel() {
        return this.minFluxModel;
    }

    public ValueUnitPairModel getMaxFluxModel() {
        return this.maxFluxModel;
    }

    public ValueUnitPairModel getMinLastObservedModel() {
        return this.minLastObservedModel;
    }

    public ValueUnitPairModel getMaxLastObservedModel() {
        return this.maxLastObservedModel;
    }
}

