/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts.calibrators;

import alma.common.sourcecatalog.Measurement;
import alma.common.sourcecatalog.SimpleSource;
import alma.common.sourcecatalog.Source;
import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.EntityIDFactory;
import alma.hla.runtime.obsprep.bo.EntityPart;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.FieldSourceCollection;
import alma.obsprep.bo.InstrumentSpecCollection;
import alma.obsprep.bo.ObservingParametersCollection;
import alma.obsprep.bo.SubSBCollection;
import alma.obsprep.bo.TargetCollection;
import alma.obsprep.bo.obsproject.ICalibratorExpertDocument;
import alma.obsprep.bo.schedblock.AmplitudeCalParameters;
import alma.obsprep.bo.schedblock.AtmosphericCalParameters;
import alma.obsprep.bo.schedblock.BandpassCalParameters;
import alma.obsprep.bo.schedblock.CheckSourceCalParameters;
import alma.obsprep.bo.schedblock.DGCReferenceCalParameters;
import alma.obsprep.bo.schedblock.DGCScienceCalParameters;
import alma.obsprep.bo.schedblock.DelayCalParameters;
import alma.obsprep.bo.schedblock.FieldPattern;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.FocusCalParameters;
import alma.obsprep.bo.schedblock.PhaseCalParameters;
import alma.obsprep.bo.schedblock.PointingCalParameters;
import alma.obsprep.bo.schedblock.PointingPattern;
import alma.obsprep.bo.schedblock.PolarizationCalParameters;
import alma.obsprep.bo.schedblock.Reference;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.SidebandRatioCalParameters;
import alma.obsprep.bo.schedblock.SourceProperty;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.guiutil.events.Event;
import alma.obsprep.guiutil.events.EventManager;
import alma.obsprep.guiutil.events.EventReceiver;
import alma.obsprep.guiutil.events.EventTypes;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.editors.obsproject.QuerySourceEditor;
import alma.obsprep.ot.gui.resources.Icons;
import alma.obsprep.ot.project.ProjectTree;
import alma.obsprep.ot.project.ProjectTreeNode;
import alma.obsprep.services.experts.CalibratorExpert;
import alma.obsprep.services.experts.calibrators.CalibratorExpertDialog;
import alma.obsprep.services.experts.calibrators.CalibratorExpertModel;
import alma.obsprep.services.experts.calibrators.CalibratorUtils;
import alma.obsprep.services.experts.calibrators.DeclinationComparator;
import alma.obsprep.services.experts.calibrators.MeasurementTableModel;
import alma.obsprep.services.experts.spectralline.gui.TableCellRendererFactory;
import alma.valuetypes.Angle;
import alma.valuetypes.AngularVelocity;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.SkyCoordinates;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class CalibratorExpertEditor
extends EditorWithGridBagLayout
implements ListSelectionListener,
EventReceiver {
    private final QuerySourceEditor queryEditor;
    public static final String CANCEL_LABEL = "Cancel";
    public static final FieldID bestphFID = new FieldID("Calibrator Expert bestphFID");
    public static final FieldID bestptFID = new FieldID("Calibrator Expert bestptFID");
    public static final FieldID bestamFID = new FieldID("Calibrator Expert bestamFID");
    public static final FieldID bestpoFID = new FieldID("Calibrator Expert bestpoFID");
    public static final FieldID bestfoFID = new FieldID("Calibrator Expert bestfoFID");
    public static final FieldID bestbpFID = new FieldID("Calibrator Expert bestbpFID");
    public static final FieldID selectFID = new FieldID("Calibrator Expert selectFID");
    public static final FieldID closeFID = new FieldID("Calibrator Expert closeFID");
    public static final FieldID tableFID = new FieldID("Calibrator Expert tableFID");
    public static final FieldID planetButtonFID = new FieldID("Calibrator Expert planetButtonFID");
    private JEditorPane errmsg;
    private int selectedType = 6;
    private ProjectTreeNode m_treeNode;
    private BusinessObject m_bo;
    private ProjectTreeNode m_SBNode;
    private ProjectTreeNode m_OTNode;
    private ProjectTree m_ptree;
    private ProjectTreeNode m_currentListNode = null;
    private final MeasurementTableModel tableModel = new MeasurementTableModel();
    private boolean isSolarSystemBody = false;
    private JButton addNonSiderealButton;
    private JPanel buttonPanel;
    private JComboBox catalogue;
    private JLabel catalogueLabel;
    private JButton closeButton;
    private JLabel helpLabel;
    private JLabel infoLabel;
    private JPanel resultsPanel;
    private JScrollPane scrollPane;
    private JButton selectAsButton;
    private JLabel spacer1;
    private JLabel spacer2;
    private JLabel spacer3;
    private JButton submitButton;
    private JTable table;
    private JPanel logPanel;
    private JLabel warningLabel;

    public CalibratorExpertEditor(Model model) {
        this.setModel(model);
        this.queryEditor = new QuerySourceEditor(model);
        this.registerSubView(this.queryEditor);
        this.buildResultsPanel();
        this.buildWarningPanel();
        this.m_treeNode = null;
        this.m_bo = null;
        this.m_SBNode = null;
        this.m_OTNode = null;
        this.m_ptree = null;
        EventManager.subscribeByType(EventTypes.NODESELECTED, this);
        this.build();
        model.publish();
    }

    @Override
    protected void build() {
        super.build("CalibratorTool");
        this.catalogue.setModel(new DefaultComboBoxModel<String>(CalibratorExpert.SourceCatalog.getNames()));
        this.initEvents(this.catalogue, QuerySourceEditor.catlocFID);
        this.makeTableSortable();
        this.table.getSelectionModel().addListSelectionListener(this);
    }

    private void makeTableSortable() {
        TableRowSorter<MeasurementTableModel> tableRowSorter = new TableRowSorter<MeasurementTableModel>(this.tableModel);
        tableRowSorter.setComparator(2, new DeclinationComparator());
        this.table.setRowSorter(tableRowSorter);
    }

    private void buildResultsPanel() {
        this.resultsPanel = new JPanel();
        this.helpLabel = new JLabel();
        this.infoLabel = new JLabel();
        this.scrollPane = new JScrollPane();
        this.table = new JTable();
        this.table.getTableHeader().setReorderingAllowed(false);
        this.buttonPanel = new JPanel();
        this.spacer1 = new JLabel();
        this.spacer2 = new JLabel();
        this.addNonSiderealButton = this.makeButton(planetButtonFID, "Non-Sidereal Calibrators", "Display Non-Sidereal Sources from the Calibrator Catalogue");
        this.selectAsButton = this.makeButton(selectFID, "Select As...", "Use the Selected Source as a Calibrator");
        this.spacer3 = new JLabel();
        this.closeButton = this.makeButton(closeFID, "Close", "Close the Calibrator Tool");
        this.catalogueLabel = new JLabel();
        this.catalogue = new JComboBox();
        this.submitButton = this.makeButton(QuerySourceEditor.filterFID, "Submit Query", "Find Calibrators Matching the Given Constraints");
        this.setLayout(new GridBagLayout());
        this.resultsPanel.setLayout(new GridBagLayout());
        this.helpLabel.setFont(this.helpLabel.getFont().deriveFont(this.helpLabel.getFont().getStyle() & 0xFFFFFFFE));
        this.helpLabel.setText("<html>Find calibrators matching your criteria by clicking the `Submit Query' button. Add matching catalogue entries to your target list using the `Add Selected' and `Add All' buttons.</html>");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.resultsPanel.add((Component)this.helpLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(11, 12, 0, 11);
        this.resultsPanel.add((Component)this.infoLabel, gridBagConstraints);
        this.table.setModel(this.tableModel);
        this.table.setSelectionMode(0);
        TableColumn tableColumn = this.table.getColumnModel().getColumn(3);
        tableColumn.setCellRenderer(TableCellRendererFactory.getTableCellRenderer(TableCellRendererFactory.Units.SEPARATION));
        tableColumn = this.table.getColumnModel().getColumn(4);
        tableColumn.setCellRenderer(TableCellRendererFactory.getTableCellRenderer(TableCellRendererFactory.Units.FREQUENCY));
        tableColumn = this.table.getColumnModel().getColumn(5);
        tableColumn.setCellRenderer(TableCellRendererFactory.getTableCellRenderer(TableCellRendererFactory.Units.FLUX_DENSITY));
        tableColumn = this.table.getColumnModel().getColumn(6);
        tableColumn.setCellRenderer(TableCellRendererFactory.getTableCellRenderer(TableCellRendererFactory.Units.DATE));
        this.scrollPane.setViewportView(this.table);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 6;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 12, 0, 11);
        this.resultsPanel.add((Component)this.scrollPane, gridBagConstraints);
        this.catalogueLabel.setText("to");
        this.selectAsButton.setEnabled(false);
        GroupLayout groupLayout = new GroupLayout(this.buttonPanel);
        this.buttonPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.spacer1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spacer2, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.submitButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.catalogueLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.catalogue, -2, -1, -2).addGap(18, 18, 18).addComponent(this.addNonSiderealButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spacer3, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.selectAsButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton)));
        groupLayout.linkSize(0, this.closeButton, this.spacer1);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.spacer1).addComponent(this.spacer2).addComponent(this.addNonSiderealButton).addComponent(this.catalogueLabel).addComponent(this.catalogue, -2, -1, -2).addComponent(this.submitButton).addComponent(this.spacer3).addComponent(this.selectAsButton).addComponent(this.closeButton)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 12, 11, 11);
        this.resultsPanel.add((Component)this.buttonPanel, gridBagConstraints);
    }

    private void buildWarningPanel() {
        this.logPanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(this.logPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.warningLabel = new JLabel("");
        this.warningLabel.setForeground(Color.RED);
        this.addComponent(this.logPanel, gridBagLayout, gridBagConstraints, this.warningLabel);
        this.logPanel.setBorder(new TitledBorder("Feedback"));
    }

    @Override
    protected void addComponents(String string) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.queryEditor, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.resultsPanel.setBorder(new TitledBorder("Search Results"));
        this.add((Component)this.resultsPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.logPanel, gridBagConstraints);
    }

    @Override
    public Object widgetUpdated(FieldID fieldID, Object object) {
        if (QuerySourceEditor.filterFID.equals(fieldID)) {
            this.submitButton.setEnabled(false);
        }
        return super.widgetUpdated(fieldID, object);
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (fieldID.equals(closeFID)) {
            this.getRootPane().getParent().setVisible(false);
            this.selectedType = 6;
        } else if (fieldID.equals(QuerySourceEditor.filterFID)) {
            this.m_currentListNode = this.m_treeNode;
            this.selectedType = 6;
            this.isSolarSystemBody = false;
        } else if (fieldID.equals(tableFID)) {
            if (object instanceof List) {
                List list = (List)object;
                this.tableModel.setCalibrators(list);
                if (this.infoLabel != null) {
                    this.infoLabel.setText("These results could be different at project execution time");
                    this.infoLabel.setIcon(Icons.warning);
                }
            }
            if (this.submitButton != null) {
                this.submitButton.setEnabled(true);
            }
        } else if (fieldID.equals(selectFID)) {
            this.createCalibrators(this.table, this.selectedType);
        } else if (fieldID.equals(QuerySourceEditor.raFID)) {
            String string = (String)object;
            this.tableModel.setQueryRA(string);
        } else if (fieldID.equals(QuerySourceEditor.decFID)) {
            String string = (String)object;
            this.tableModel.setQueryDec(string);
        } else if (fieldID.equals(planetButtonFID)) {
            this.isSolarSystemBody = true;
        }
    }

    public void setPTree(ProjectTree projectTree) {
        this.m_ptree = projectTree;
    }

    private void createCalibrators(JTable jTable, int n) {
        int[] nArray = this.getRowsFromTable(jTable);
        if (nArray.length == 0) {
            return;
        }
        CalibratorExpertDialog calibratorExpertDialog = new CalibratorExpertDialog(null, "Create Calibrators", this.tableModel, nArray, n, this.isSpectralSpecAvailable());
        if (calibratorExpertDialog.cancelPressed()) {
            return;
        }
        if (!this.isSolarSystemBody) {
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = jTable.convertRowIndexToView(nArray[i]);
            }
            this.createAndAddCalibrators(nArray, calibratorExpertDialog);
        } else {
            this.createAndAddSolarSystemCalibrators(nArray, calibratorExpertDialog);
        }
    }

    private boolean isSpectralSpecAvailable() {
        boolean bl = this.m_OTNode == null ? false : ((Target)this.m_OTNode.getUserObject()).getSpectralSpec() != null;
        return bl;
    }

    private int[] getRowsFromTable(JTable jTable) {
        int n;
        int[] nArray = jTable.getSelectedRows();
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = jTable.convertRowIndexToModel(nArray[n]);
        }
        if (nArray.length == 0 && this.selectedType != 6 && this.tableModel.getRowCount() > 0) {
            nArray = new int[this.tableModel.getRowCount()];
            for (n = 0; n < nArray.length; ++n) {
                nArray[n] = n;
            }
        }
        return nArray;
    }

    private void createAndAddCalibrators(int[] nArray, CalibratorExpertDialog calibratorExpertDialog) {
        SchedBlock schedBlock = (SchedBlock)this.m_SBNode.getUserObject();
        Target target = null;
        if (this.m_OTNode != null) {
            target = (Target)this.m_OTNode.getUserObject();
        }
        Collection<Source> collection = this.getSources(nArray);
        for (Source source : collection) {
            String string = CalibratorExpert.findJ2000NameOrDefault(source.getNames());
            List<SourceProperty> list = CalibratorUtils.getSourceProperties(source);
            FieldSource fieldSource = FieldSource.createFieldSource();
            fieldSource.setSourceName(string);
            fieldSource.setName("Calibrator: ");
            double d = ((Measurement)source.getMeasurements().iterator().next()).getRa();
            double d2 = ((Measurement)source.getMeasurements().iterator().next()).getDec();
            Longitude longitude = Longitude.createLongitude((double)d, (String)Longitude.UNIT_DEG);
            Latitude latitude = Latitude.createLatitude((double)d2, (String)Latitude.UNIT_DEG);
            fieldSource.getSourceCoordinates().setLatitude(latitude);
            fieldSource.getSourceCoordinates().setLongitude(longitude);
            fieldSource.setParallax(Angle.createAngle((double)0.0, (String)Angle.UNIT_ARCSEC));
            fieldSource.setPMDec(AngularVelocity.createAngularVelocity((double)0.0, (String)AngularVelocity.UNIT_MAS_YR));
            fieldSource.setPMRA(AngularVelocity.createAngularVelocity((double)0.0, (String)AngularVelocity.UNIT_MAS_YR));
            PointingPattern pointingPattern = PointingPattern.createPointingPattern();
            SkyCoordinates skyCoordinates = SkyCoordinates.createOffsetCoordinates();
            pointingPattern.addPhaseCenterCoordinates(skyCoordinates);
            fieldSource.setFieldPattern((FieldPattern)((Object)pointingPattern));
            for (Reference reference : fieldSource.getReference()) {
                reference.getReferenceCoordinates().setLatitude(latitude.deepCopy());
                reference.getReferenceCoordinates().setLongitude(longitude.deepCopy());
            }
            Target object = schedBlock.createTarget();
            this.setCalibratorType(object, calibratorExpertDialog, schedBlock);
            if (object.getObservingParametersCount() > 0) {
                schedBlock.addFieldSource(fieldSource);
                this.updateDisplay((BusinessObject)fieldSource);
                this.fillTarget(calibratorExpertDialog, target, list, fieldSource, object);
            }
            Event event = new Event(EventTypes.NODESELECTED, this.m_treeNode, this.m_treeNode.getUserObject());
            EventManager.publish(event);
        }
    }

    private void createAndAddSolarSystemCalibrators(int[] nArray, CalibratorExpertDialog calibratorExpertDialog) {
        SchedBlock schedBlock = (SchedBlock)this.m_SBNode.getUserObject();
        Target target = null;
        if (this.m_OTNode != null) {
            target = (Target)this.m_OTNode.getUserObject();
        }
        Collection<Source> collection = this.getSources(nArray);
        for (Source source : collection) {
            Object object;
            FieldSource fieldSource = FieldSource.createFieldSource();
            String string = source.getFormattedName();
            fieldSource.setSourceName(string);
            fieldSource.setName("Calibrator: ");
            fieldSource.setNonSiderealMotion(true);
            fieldSource.setSolarSystemObject(string);
            PointingPattern pointingPattern = PointingPattern.createPointingPattern();
            SkyCoordinates skyCoordinates = SkyCoordinates.createOffsetCoordinates();
            pointingPattern.addPhaseCenterCoordinates(skyCoordinates);
            fieldSource.setFieldPattern((FieldPattern)((Object)pointingPattern));
            Target target2 = schedBlock.createTarget();
            this.setCalibratorType(target2, calibratorExpertDialog, schedBlock);
            if (target2.getObservingParametersCount() > 0) {
                schedBlock.addFieldSource(fieldSource);
                this.updateDisplay((BusinessObject)fieldSource);
                object = CalibratorUtils.getSourceProperties(source);
                this.fillTarget(calibratorExpertDialog, target, (List<SourceProperty>)object, fieldSource, target2);
            }
            object = new Event(EventTypes.NODESELECTED, this.m_treeNode, this.m_treeNode.getUserObject());
            EventManager.publish((Event)object);
        }
    }

    private void setCalibratorType(Target target, CalibratorExpertDialog calibratorExpertDialog, SchedBlock schedBlock) {
        Object object;
        if (calibratorExpertDialog.getUseAsAmplitude()) {
            object = schedBlock.createAmplitudeCalParameters();
            target.addAmplitudeCalParameters((AmplitudeCalParameters)((Object)object));
            this.updateDisplay((BusinessObject)object);
        }
        if (calibratorExpertDialog.getUseAsPhase()) {
            object = schedBlock.createPhaseCalParameters();
            target.addPhaseCalParameters((PhaseCalParameters)((Object)object));
            this.updateDisplay((BusinessObject)object);
        }
        if (calibratorExpertDialog.getUseAsPointing()) {
            object = schedBlock.createPointingCalParameters();
            target.addPointingCalParameters((PointingCalParameters)((Object)object));
            this.updateDisplay((BusinessObject)object);
        }
        if (calibratorExpertDialog.getUseAsPolarization()) {
            object = schedBlock.createPolarizationCalParameters();
            target.addPolarizationCalParameters((PolarizationCalParameters)((Object)object));
            this.updateDisplay((BusinessObject)object);
        }
        if (calibratorExpertDialog.getUseAsFocus()) {
            object = schedBlock.createFocusCalParameters();
            target.addFocusCalParameters((FocusCalParameters)((Object)object));
            this.updateDisplay((BusinessObject)object);
        }
        if (calibratorExpertDialog.getUseAsBandpass()) {
            object = schedBlock.createBandpassCalParameters();
            target.addBandpassCalParameters((BandpassCalParameters)((Object)object));
            this.updateDisplay((BusinessObject)object);
        }
        if (calibratorExpertDialog.getUseAsAtmospheric()) {
            object = schedBlock.createAtmosphericCalParameters();
            target.addAtmosphericCalParameters((AtmosphericCalParameters)((Object)object));
            this.updateDisplay((BusinessObject)object);
        }
        if (calibratorExpertDialog.getUseAsDelay()) {
            object = schedBlock.createDelayCalParameters();
            target.addDelayCalParameters((DelayCalParameters)((Object)object));
            this.updateDisplay((BusinessObject)object);
        }
        if (calibratorExpertDialog.getUseAsCheckSource()) {
            object = schedBlock.createCheckSourceCalParameters();
            target.addCheckSourceCalParameters((CheckSourceCalParameters)((Object)object));
            this.updateDisplay((BusinessObject)object);
        }
        if (calibratorExpertDialog.getUseAsSidebandRatio()) {
            object = schedBlock.createSidebandRatioCalParameters();
            target.addSidebandRatioCalParameters((SidebandRatioCalParameters)((Object)object));
            this.updateDisplay((BusinessObject)object);
        }
        if (calibratorExpertDialog.getUseAsDGCReference()) {
            object = schedBlock.createDGCReferenceCalParameters();
            target.addDGCReferenceCalParameters((DGCReferenceCalParameters)((Object)object));
            this.updateDisplay((BusinessObject)object);
        }
        if (calibratorExpertDialog.getUseAsDGCScience()) {
            object = schedBlock.createDGCScienceCalParameters();
            target.addDGCScienceCalParameters((DGCScienceCalParameters)((Object)object));
            this.updateDisplay((BusinessObject)object);
        }
    }

    private void fillTarget(CalibratorExpertDialog calibratorExpertDialog, Target target, List<SourceProperty> list, FieldSource fieldSource, Target target2) {
        target2.setFieldSource(fieldSource);
        if (this.isSpectralSpecAvailable()) {
            String string = calibratorExpertDialog.getCopySpectralSpec();
            if (string.equals("Copy to new setup")) {
                this.copySpectralSpec(target2, target);
            } else if (string.equals("Link to same setup")) {
                this.linkSpectralSpec(target2, target);
            }
        }
        this.copySourceProperties(target2, list);
    }

    private void copySpectralSpec(Target target, Target target2) {
        if (target2 == null || target2.getSpectralSpec() == null) {
            return;
        }
        SchedBlock schedBlock = target.getSchedBlock();
        SpectralSpec spectralSpec = target2.getSpectralSpec().deepCopy();
        EntityIDFactory.getFactory().assignEntityPartId((EntityPart)spectralSpec);
        spectralSpec.setName("Copy of " + spectralSpec.getName());
        schedBlock.addSpectralSpec(spectralSpec);
        this.updateDisplay((BusinessObject)spectralSpec);
        target.setSpectralSpec(spectralSpec);
        if (Log.logger((Object)this).info()) {
            Log.logger((Object)this).info("Copied Spectral Spec and Source Velocity from " + target2.toTreeString(2, false, true));
        }
    }

    private void linkSpectralSpec(Target target, Target target2) {
        SpectralSpec spectralSpec = target2.getSpectralSpec();
        target.setSpectralSpec(spectralSpec);
    }

    private void copySourceProperties(Target target, List<SourceProperty> list) {
        for (SourceProperty sourceProperty : list) {
            SourceProperty sourceProperty2 = sourceProperty.deepCopy();
            target.getFieldSource().addSourceProperty(sourceProperty2);
        }
    }

    public void updateDisplay(BusinessObject businessObject) {
        if (this.m_ptree == null) {
            return;
        }
        ProjectTreeNode projectTreeNode = this.m_ptree.makeNode(businessObject);
        Enumeration<TreeNode> enumeration = this.m_SBNode.children();
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        while (enumeration.hasMoreElements()) {
            SubSBCollection subSBCollection;
            ProjectTreeNode projectTreeNode2 = (ProjectTreeNode)enumeration.nextElement();
            BusinessObject businessObject2 = (BusinessObject)projectTreeNode2.getUserObject();
            if (businessObject2 instanceof TargetCollection) {
                subSBCollection = (TargetCollection)businessObject2;
                if (!subSBCollection.isCollectionOf(businessObject.getClass())) continue;
                defaultMutableTreeNode = projectTreeNode2;
                continue;
            }
            if (businessObject2 instanceof FieldSourceCollection) {
                subSBCollection = (FieldSourceCollection)businessObject2;
                if (!subSBCollection.isCollectionOf(businessObject.getClass())) continue;
                defaultMutableTreeNode = projectTreeNode2;
                continue;
            }
            if (businessObject2 instanceof InstrumentSpecCollection) {
                subSBCollection = (InstrumentSpecCollection)businessObject2;
                if (!((InstrumentSpecCollection)subSBCollection).isCollectionOf((Class)businessObject.getClass())) continue;
                defaultMutableTreeNode = projectTreeNode2;
                continue;
            }
            if (!(businessObject2 instanceof ObservingParametersCollection) || !((ObservingParametersCollection)(subSBCollection = (ObservingParametersCollection)businessObject2)).isCollectionOf((Class)businessObject.getClass())) continue;
            defaultMutableTreeNode = projectTreeNode2;
        }
        if (defaultMutableTreeNode != null) {
            this.m_ptree.insertNodeInto(businessObject, (ProjectTreeNode)defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
        }
    }

    public void setErrorMessage(String string) {
        if (this.errmsg == null) {
            return;
        }
        if (string == null) {
            this.errmsg.setText("");
        } else {
            String string2 = "<font color=\"red\" size=\"-1\" face=\"Helvetica\">" + string + "</font>";
            this.errmsg.setText(string2);
        }
    }

    public void clearErrorMessage() {
        this.setErrorMessage(null);
    }

    public void setWarningMessage(String string) {
        this.warningLabel.setText(string);
    }

    public void clearWarningMessage() {
        this.setWarningMessage("");
    }

    public void updateCoordinates() {
        if (this.m_bo instanceof Target && ((Target)this.m_bo).hasScienceParameters()) {
            Target target = (Target)this.m_bo;
            FieldSource fieldSource = target.getFieldSource();
            double d = 0.0;
            double d2 = 0.0;
            if (fieldSource != null) {
                SkyCoordinates skyCoordinates = fieldSource.getSourceCoordinates().getJ2000SkyCoordinates();
                d = skyCoordinates.getLatitude().getContentInUnits(Latitude.UNIT_DEG);
                d2 = skyCoordinates.getLongitude().getContentInUnits(Longitude.UNIT_DEG);
            }
            double d3 = d * 3600.0 * 1000.0;
            double d4 = d2 * 3600.0 * 10000.0;
            ICalibratorExpertDocument iCalibratorExpertDocument = (ICalibratorExpertDocument)this.getCalibratorExpertModel().getDocument();
            iCalibratorExpertDocument.setDec(Math.round(d3));
            iCalibratorExpertDocument.setRa(Math.round(d4));
            this.getCalibratorExpertModel().publish();
            this.clearWarningMessage();
            if (this.m_currentListNode != null && this.m_treeNode != this.m_currentListNode) {
                this.setWarningMessage("New target coordinates selected");
            }
        } else {
            this.setWarningMessage("No target ( with a Science Observing Parameters ) in scope");
        }
    }

    public void setButtons() {
        if (this.m_SBNode == null) {
            this.selectAsButton.setEnabled(false);
        } else if (this.selectedType == 6) {
            this.selectAsButton.setEnabled(this.table.getSelectedRows().length != 0);
        } else {
            this.selectAsButton.setEnabled(true);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.setButtons();
    }

    @Override
    public void receiveEvent(Event event) {
        this.m_treeNode = (ProjectTreeNode)event.getSource();
        this.m_bo = (BusinessObject)this.m_treeNode.getUserObject();
        if (this.m_bo != null) {
            this.updateCoordinates();
        }
        this.m_SBNode = this.findSBNode(this.m_treeNode);
        this.m_OTNode = this.findOTNode(this.m_treeNode);
        this.setButtons();
    }

    private ProjectTreeNode findSBNode(ProjectTreeNode projectTreeNode) {
        if (projectTreeNode == null) {
            return null;
        }
        if (projectTreeNode.getUserObject() instanceof SchedBlock) {
            return projectTreeNode;
        }
        return this.findSBNode((ProjectTreeNode)projectTreeNode.getParent());
    }

    private ProjectTreeNode findOTNode(ProjectTreeNode projectTreeNode) {
        if (projectTreeNode == null) {
            return null;
        }
        if (Target.isTargetWithScienceParameters(projectTreeNode.getUserObject())) {
            return projectTreeNode;
        }
        if (projectTreeNode.getUserObject() instanceof SchedBlock) {
            SchedBlock schedBlock = (SchedBlock)projectTreeNode.getUserObject();
            if (schedBlock.getTargetCountWithScienceParameters() != 1) {
                return null;
            }
            Enumeration<TreeNode> enumeration = projectTreeNode.depthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                ProjectTreeNode projectTreeNode2 = (ProjectTreeNode)enumeration.nextElement();
                if (!Target.isTargetWithScienceParameters(projectTreeNode2.getUserObject())) continue;
                return projectTreeNode2;
            }
            return null;
        }
        return this.findOTNode((ProjectTreeNode)projectTreeNode.getParent());
    }

    private CalibratorExpertModel getCalibratorExpertModel() {
        return (CalibratorExpertModel)this.getModel();
    }

    private Collection<Source> convertToSources(Collection<Measurement> collection) {
        HashMap hashMap = new HashMap();
        for (Measurement object : collection) {
            int collection2 = object.getSourceId();
            if (hashMap.containsKey(collection2)) {
                ((Collection)hashMap.get(collection2)).add(object);
                continue;
            }
            hashMap.put(collection2, new ArrayList());
            ((Collection)hashMap.get(collection2)).add(object);
        }
        ArrayList arrayList = new ArrayList();
        for (Collection collection2 : hashMap.values()) {
            SimpleSource simpleSource = new SimpleSource(collection2);
            arrayList.add(simpleSource);
        }
        return arrayList;
    }

    private Collection<Source> getSources(int[] nArray) {
        ArrayList<Measurement> arrayList = new ArrayList<Measurement>();
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            int n2 = this.table.convertRowIndexToModel(n);
            Measurement measurement = this.tableModel.get(n2);
            arrayList.add(measurement);
        }
        Collection<Source> collection = this.convertToSources(arrayList);
        return collection;
    }
}

