/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts.calibrators;

import alma.common.sourcecatalog.CatalogQueryParameters;
import alma.common.sourcecatalog.Measurement;
import alma.common.sourcecatalog.SimpleMeasurement;
import alma.obsprep.bo.obsproject.ICalibratorExpertDocument;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.ModelChangeSubscriber;
import alma.obsprep.guiutil.mvc.widgets.IndeterminateProgressMonitor;
import alma.obsprep.ot.editors.obsproject.QuerySourceEditor;
import alma.obsprep.ot.gui.toplevel.DialogId;
import alma.obsprep.services.experts.CalibratorExpert;
import alma.obsprep.services.experts.calibrators.CalibratorExpertEditor;
import alma.obsprep.services.experts.calibrators.CalibratorExpertModel;
import alma.obsprep.util.GUIUtilities;
import java.awt.Dialog;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;

public class CalibratorExpertController
implements ModelChangeSubscriber,
PropertyChangeListener {
    private static final DialogId id = new DialogId("CalibratorExpertController.search", "Problem encountered while searching for calibrators");
    private final CalibratorExpert calexp = CalibratorExpert.getInstance();
    private IndeterminateProgressMonitor progressMonitor;
    private QueryTask task;

    private static List<Measurement> getSolarSystemMeasurements() {
        ArrayList<Measurement> arrayList = new ArrayList<Measurement>();
        int n = 1;
        for (String string : FieldSource.getKnownSolarSystemObjectList()) {
            arrayList.add((Measurement)new SimpleMeasurement().name(string).sourceId(Integer.valueOf(n)));
            ++n;
        }
        return arrayList;
    }

    @Override
    public void modelChanged(Model model, FieldID fieldID, Object object) {
        Object object2;
        CalibratorExpertModel calibratorExpertModel = (CalibratorExpertModel)model;
        ICalibratorExpertDocument iCalibratorExpertDocument = (ICalibratorExpertDocument)calibratorExpertModel.getDocument();
        if (QuerySourceEditor.catlocFID.equals(fieldID)) {
            this.calexp.setCatalogueAccess(CalibratorExpert.SourceCatalog.byName(iCalibratorExpertDocument.getCatalogueLocation()));
        }
        if (QuerySourceEditor.filterFID.equals(fieldID)) {
            this.calexp.setCatalogueAccess(CalibratorExpert.SourceCatalog.byName(iCalibratorExpertDocument.getCatalogueLocation()));
            object2 = iCalibratorExpertDocument.getQuery();
            this.task = new QueryTask(calibratorExpertModel, (CatalogQueryParameters)object2);
            this.progressMonitor = new IndeterminateProgressMonitor(null, "Searching ALMA Catalogues", "", Dialog.ModalityType.APPLICATION_MODAL);
            this.progressMonitor.addPropertyChangeListener(this);
            this.task.addPropertyChangeListener(this.progressMonitor);
            this.task.execute();
        }
        if (CalibratorExpertEditor.tableFID.equals(fieldID)) {
            // empty if block
        }
        if (CalibratorExpertEditor.planetButtonFID.equals(fieldID)) {
            object2 = CalibratorExpertController.getSolarSystemMeasurements();
            iCalibratorExpertDocument.setCalibList((List<Measurement>)object2);
            calibratorExpertModel.publish(CalibratorExpertEditor.tableFID, object2);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("IPM_CANCELLED") && this.task != null) {
            this.task.cancel(true);
            this.task.model.publish(CalibratorExpertEditor.tableFID, null);
        }
    }

    private class QueryTask
    extends SwingWorker<List<Measurement>, Void> {
        final CatalogQueryParameters query;
        final CalibratorExpertModel model;

        public QueryTask(CalibratorExpertModel calibratorExpertModel, CatalogQueryParameters catalogQueryParameters) {
            this.model = calibratorExpertModel;
            this.query = catalogQueryParameters;
        }

        @Override
        protected List<Measurement> doInBackground() throws Exception {
            List<Measurement> list = CalibratorExpertController.this.calexp.query(this.query);
            return list;
        }

        @Override
        protected void done() {
            if (this.isCancelled() || !this.getState().equals((Object)SwingWorker.StateValue.DONE)) {
                return;
            }
            try {
                List list = (List)this.get();
                ICalibratorExpertDocument iCalibratorExpertDocument = (ICalibratorExpertDocument)this.model.getDocument();
                iCalibratorExpertDocument.setCalibList(list);
                this.model.publish(CalibratorExpertEditor.tableFID, list);
            }
            catch (Exception exception) {
                if (exception.getCause() instanceof IllegalArgumentException && exception.getCause().getMessage().contains("Connection error")) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GUIUtilities.info(id, "Could not contact catalogue server.\nPlease check your network connection.");
                            QueryTask.this.model.publish(CalibratorExpertEditor.tableFID, null);
                        }
                    });
                }
                exception.printStackTrace();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GUIUtilities.error(id, "Error while searching for calibrators", exception);
                        QueryTask.this.model.publish(CalibratorExpertEditor.tableFID, null);
                    }
                });
            }
        }
    }
}

