/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts;

import alma.observatorycharacteristics.capabilities.AlmaCapabilities;
import alma.obsprep.bo.enumerations.CorrPolarization;
import alma.obsprep.bo.obsproject.CalibratedAbstractScienceGoal;
import alma.obsprep.bo.obsproject.CalibrationSetupParameters;
import alma.obsprep.bo.obsproject.CalibrationTargetParameters;
import alma.obsprep.bo.obsproject.ObservatoryGoal;
import alma.obsprep.bo.obsproject.QuerySource;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.data.ControlBlockData;
import alma.obsprep.bo.schedblock.ObsProcedure;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.services.experts.ObservingModeProperties;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.ssr.observingmodes.Property;
import alma.valuetypes.KeywordValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ObservingModeExpert {
    private static ObservingModeExpert _instance = null;
    private ObservingModeProperties[] modes;
    private static final List<String> CALIBRATOR_SURVEY_CALIBRATOR_INTENTS = new ArrayList<String>();
    private static final List<String> RADIOMETRIC_POINTING_CALIBRATOR_INTENTS = new ArrayList<String>();
    private static final List<String> BASELINE_CALIBRATION_CALIBRATOR_INTENTS = new ArrayList<String>();
    private static final List<String> SCIENCE_GOAL_CALIBRATOR_INTENTS = new ArrayList<String>();
    private static final List<String> POLARIZATION_GOAL_CALIBRATOR_INTENTS = new ArrayList<String>();

    private static List<String> getPolarizationCalibratorIntents(CalibratedAbstractScienceGoal calibratedAbstractScienceGoal) {
        ArrayList<String> arrayList = new ArrayList<String>();
        CorrPolarization corrPolarization = calibratedAbstractScienceGoal.getSpectralSetupParameters().getCorrPolarization();
        if (CorrPolarization.FULL.equals((Object)corrPolarization)) {
            arrayList.addAll(POLARIZATION_GOAL_CALIBRATOR_INTENTS);
        }
        return arrayList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<String> getDefaultCalibratorIntents(CalibratedAbstractScienceGoal calibratedAbstractScienceGoal) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(ObservingModeExpert.getPolarizationCalibratorIntents(calibratedAbstractScienceGoal));
        if (calibratedAbstractScienceGoal instanceof ObservatoryGoal) {
            ObservatoryGoal observatoryGoal = (ObservatoryGoal)calibratedAbstractScienceGoal;
            String string = observatoryGoal.getPurpose();
            if ("Baseline Calibration".equals(string)) {
                arrayList.addAll(BASELINE_CALIBRATION_CALIBRATOR_INTENTS);
                return arrayList;
            } else if ("Calibrator Survey".equals(string)) {
                arrayList.addAll(CALIBRATOR_SURVEY_CALIBRATOR_INTENTS);
                return arrayList;
            } else {
                if (!"Radiometric Pointing".equals(string)) throw new AssertionError((Object)("Unknown ObservatoryGoal purpose: " + string));
                arrayList.addAll(RADIOMETRIC_POINTING_CALIBRATOR_INTENTS);
            }
            return arrayList;
        } else {
            if (!(calibratedAbstractScienceGoal instanceof ScienceGoal)) throw new AssertionError((Object)("CalibrationSetupParameters has unexpected parent type: " + calibratedAbstractScienceGoal.getClass().getName()));
            arrayList.addAll(SCIENCE_GOAL_CALIBRATOR_INTENTS);
        }
        return arrayList;
    }

    private static boolean usesSystemCalibrators(CalibratedAbstractScienceGoal calibratedAbstractScienceGoal) {
        String string = calibratedAbstractScienceGoal.getCalibrationSetupParameters().getSelection();
        return string.equals(CalibrationSetupParameters.SELECTION_SYSTEM) || string.equals(CalibrationSetupParameters.SELECTION_SYSTEMALTERNATE);
    }

    public static Collection<String> getCalibratorQuerySourceIntents(CalibratedAbstractScienceGoal calibratedAbstractScienceGoal) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (ObservingModeExpert.usesSystemCalibrators(calibratedAbstractScienceGoal)) {
            arrayList.addAll(ObservingModeExpert.getDefaultCalibratorIntents(calibratedAbstractScienceGoal));
        } else {
            for (QuerySource querySource : calibratedAbstractScienceGoal.getCalibrationSetupParameters().getQuerySource()) {
                arrayList.add(querySource.getIntendedUse());
            }
            ArrayList arrayList2 = new ArrayList();
            Iterator iterator = arrayList.iterator();
            arrayList2.addAll(ObservingModeExpert.getDefaultCalibratorIntents(calibratedAbstractScienceGoal));
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (!arrayList2.contains(string)) continue;
                arrayList2.remove(string);
            }
            arrayList.addAll(arrayList2);
        }
        return arrayList;
    }

    public static Collection<String> getCalibratorTargetIntents(CalibratedAbstractScienceGoal calibratedAbstractScienceGoal) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!ObservingModeExpert.usesSystemCalibrators(calibratedAbstractScienceGoal)) {
            for (CalibrationTargetParameters calibrationTargetParameters : calibratedAbstractScienceGoal.getCalibrationSetupParameters().getCalibrationTargetParameters()) {
                arrayList.add(calibrationTargetParameters.getIntendedUse());
            }
        }
        return arrayList;
    }

    public static Collection<String> getCalibratorIntents(CalibratedAbstractScienceGoal calibratedAbstractScienceGoal) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(ObservingModeExpert.getCalibratorQuerySourceIntents(calibratedAbstractScienceGoal));
        arrayList.addAll(ObservingModeExpert.getCalibratorTargetIntents(calibratedAbstractScienceGoal));
        return arrayList;
    }

    public static ObservingModeExpert getInstance() {
        if (_instance == null) {
            _instance = new ObservingModeExpert();
        }
        return _instance;
    }

    private ObservingModeExpert() {
        AlmaCapabilities almaCapabilities = AlmaCapabilities.getInstance();
        this.modes = almaCapabilities.getObservingModeList();
    }

    public String getControlScriptForMode(String string) {
        ObservingModeProperties observingModeProperties = this.getObservingModeProperties(string);
        if (observingModeProperties != null) {
            return observingModeProperties.getControlScript();
        }
        return null;
    }

    public String getModeTypeForMode(String string) {
        ObservingModeProperties observingModeProperties = this.getObservingModeProperties(string);
        if (observingModeProperties != null) {
            return observingModeProperties.getModeType();
        }
        return null;
    }

    public String[] getAvailableModes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ObservingModeProperties observingModeProperties : this.modes) {
            arrayList.add(observingModeProperties.getModeName());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private String[] getModes(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ObservingModeProperties observingModeProperties : this.modes) {
            if (!observingModeProperties.getModeType().equals(string)) continue;
            arrayList.add(observingModeProperties.getModeName());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String[] getAvailableObserverModes() {
        return this.getModes("Observer");
    }

    public String[] getAvailableObservatoryModes() {
        return this.getModes("Observatory");
    }

    public String[] getAvailableExpertModes() {
        return this.getModes("Expert");
    }

    public boolean isStandardMode(String string) {
        ObservingModeProperties observingModeProperties = this.getObservingModeProperties(string);
        if (observingModeProperties != null) {
            return observingModeProperties.getStandardMode();
        }
        return false;
    }

    public boolean isRunQuickLook(String string) {
        ObservingModeProperties observingModeProperties = this.getObservingModeProperties(string);
        if (observingModeProperties != null) {
            return observingModeProperties.getRunQuickLook();
        }
        return false;
    }

    public ObservingModeProperties getObservingModeProperties(String string) {
        for (ObservingModeProperties observingModeProperties : this.modes) {
            if (!observingModeProperties.getModeName().equals(string)) continue;
            return observingModeProperties;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean updateSchedBlock(SchedBlock schedBlock, String string) {
        KeywordValue[] keywordValueArray;
        Property[] propertyArray;
        ObservingModeProperties observingModeProperties = this.getObservingModeProperties(string);
        if (observingModeProperties == null) {
            return false;
        }
        schedBlock.setStandardMode(observingModeProperties.getStandardMode());
        schedBlock.setModeType(observingModeProperties.getModeType());
        ObsProcedure obsProcedure = schedBlock.getObsProcedure();
        SBGenerationContext sBGenerationContext = schedBlock.getSbGenerationContext();
        if (sBGenerationContext != null && sBGenerationContext.isVLBI()) {
            obsProcedure.setObsProcScript("StandardVLBI.py");
        } else if (sBGenerationContext != null && sBGenerationContext.getSchemaToUseForSBGeneration().contains((Object)SBGeneratorTemplate.SBGenerationSchema.SOLAR)) {
            propertyArray = schedBlock.getObsUnitControl().getArrayRequested();
            if (propertyArray.equals(ControlBlockData.ARRAYREQUESTED_TWELVE_M)) {
                obsProcedure.setObsProcScript("StandardSolarInterferometry.py");
            } else {
                if (!propertyArray.equals(ControlBlockData.ARRAYREQUESTED_TP_ARRAY)) throw new WizardSBGenerationException("Requested to deduce script type for solar for an array type we are unaware of " + (String)propertyArray);
                schedBlock.getObsProcedure().setObsProcScript("ObsCalSolarFastScan.py");
            }
        } else {
            obsProcedure.setObsProcScript(observingModeProperties.getControlScript());
        }
        schedBlock.getSchedBlockControl().setRunQuicklook(observingModeProperties.getRunQuickLook());
        schedBlock.clearExpertParameter();
        for (Property property : propertyArray = observingModeProperties.getScriptProperties()) {
            KeywordValue keywordValue = KeywordValue.createKeywordValue();
            keywordValue.setKeyword(property.getName());
            keywordValue.setValue(property.getContent());
            schedBlock.addExpertParameter(keywordValue);
        }
        Property[] propertyArray2 = observingModeProperties.getModeProperties();
        for (KeywordValue keywordValue : keywordValueArray = schedBlock.getExpertParameter()) {
            for (Property property : propertyArray2) {
                if (!keywordValue.getKeyword().equals(property.getName())) continue;
                keywordValue.setValue(property.getContent());
            }
        }
        return true;
    }

    static {
        CALIBRATOR_SURVEY_CALIBRATOR_INTENTS.add(QuerySource.INTENDEDUSE_ATMOSPHERIC);
        CALIBRATOR_SURVEY_CALIBRATOR_INTENTS.add(QuerySource.INTENDEDUSE_AMPLITUDE);
        CALIBRATOR_SURVEY_CALIBRATOR_INTENTS.add(QuerySource.INTENDEDUSE_PHASE);
        RADIOMETRIC_POINTING_CALIBRATOR_INTENTS.add(QuerySource.INTENDEDUSE_DELAY);
        BASELINE_CALIBRATION_CALIBRATOR_INTENTS.add(QuerySource.INTENDEDUSE_PHASE);
        SCIENCE_GOAL_CALIBRATOR_INTENTS.add(QuerySource.INTENDEDUSE_ATMOSPHERIC);
        SCIENCE_GOAL_CALIBRATOR_INTENTS.add(QuerySource.INTENDEDUSE_AMPLITUDE);
        SCIENCE_GOAL_CALIBRATOR_INTENTS.add(QuerySource.INTENDEDUSE_BANDPASS);
        SCIENCE_GOAL_CALIBRATOR_INTENTS.add(QuerySource.INTENDEDUSE_BANDPASS);
        SCIENCE_GOAL_CALIBRATOR_INTENTS.add(QuerySource.INTENDEDUSE_PHASE);
        POLARIZATION_GOAL_CALIBRATOR_INTENTS.add(QuerySource.INTENDEDUSE_POLARIZATION);
    }
}

