/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts;

import alma.hla.runtime.obsprep.util.Log;
import alma.observatorycharacteristics.capabilities.AlmaCapabilities;
import alma.observatorycharacteristics.site.SiteCharacteristics;
import alma.obsprep.bo.enumerations.Antenna;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.schedblock.CorrConfigMode;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.services.etc.ExposureTimeCalculator;
import alma.obsprep.services.etc.SourceNeverVisibleException;
import alma.obsprep.services.etc.editor.WaterVaporColumns;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.experts.InvalidFrequencyException;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.valuetypes.Sensitivity;
import alma.valuetypes.SkyCoordinates;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;

public class ACAExpert {
    private static final Log.Logger logger = Log.logger(ACAExpert.class);
    static Map<ScienceGoal, ACAExpert> _cache = new HashMap<ScienceGoal, ACAExpert>();
    private ScienceGoal scienceGoal;

    public static ACAExpert getInstance(ScienceGoal scienceGoal) {
        ACAExpert aCAExpert = _cache.get(scienceGoal);
        if (aCAExpert == null) {
            aCAExpert = new ACAExpert(scienceGoal);
            _cache.put(scienceGoal, aCAExpert);
        }
        return aCAExpert;
    }

    public static void clear() {
        _cache = new HashMap<ScienceGoal, ACAExpert>();
    }

    private ACAExpert(ScienceGoal scienceGoal) {
        Log.logger((Object)this).log(Level.FINER, "ACAExpert: initialising...");
        this.scienceGoal = scienceGoal;
    }

    private double getCorrEfficiency() {
        SpectralSetupParameters spectralSetupParameters = this.scienceGoal.getSpectralSetupParameters();
        ScienceSpectralWindow scienceSpectralWindow = spectralSetupParameters.getRepresentativeSpectralWindow();
        if (scienceSpectralWindow == null) {
            return 0.88;
        }
        CorrConfigMode corrConfigMode = scienceSpectralWindow.getCorrConfigMode();
        return corrConfigMode.getACAEfficiency();
    }

    public double getACA7SensitivityJy() {
        double d;
        double d2 = 0.0;
        PerformanceParameters performanceParameters = this.scienceGoal.getPerformanceParameters();
        try {
            d = performanceParameters.getSensitivityForFinestAR().getContentInUnits(Sensitivity.UNIT_JY);
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            return d2;
        }
        double d3 = performanceParameters.getRepresentativeFrequencyWithSkyOffset().getContentInGHz();
        if (d3 == 0.0) {
            return d2;
        }
        double d4 = performanceParameters.getScienceGoal().getRepresentativeBandwidth().getContentInGHz();
        String string = performanceParameters.getScienceGoal().getSpectralSetupParameters().getPolarisation();
        if (string.equals("DOUBLE")) {
            d4 *= 2.0;
        }
        SkyCoordinates skyCoordinates = performanceParameters.getScienceGoal().getKeyTargetParameters().getSourceCoordinates();
        SpectralSetupParameters spectralSetupParameters = this.scienceGoal.getSpectralSetupParameters();
        int n = AlmaCapabilities.getInstance().getNumAntennas(Array.ARRAY_12M, spectralSetupParameters);
        double d5 = Antenna.ANTENNA_12M.getDiameter();
        double d6 = SiteCharacteristics.getInstance().getObsLatitude().getContentInDeg();
        double d7 = skyCoordinates.getJ2000SkyCoordinates().getLatitude().getContentInDeg();
        double d8 = 0.0;
        ReceiverBand receiverBand = spectralSetupParameters.getReceiverBand();
        int n2 = WaterVaporColumns.wvindexSelector(d3, d7, Optional.ofNullable(receiverBand));
        double d9 = this.getCorrEfficiency();
        try {
            double d10 = Double.NaN;
            if (!spectralSetupParameters.isSpectralScan()) {
                d10 = spectralSetupParameters.getLO1Frequency().getContentInGHz();
            }
            double d11 = Configuration.getShadowMultiplierForArray(Array.ARRAY_12M, this.scienceGoal);
            d8 = ExposureTimeCalculator.pointSourceExposureTime(d, d3, d4, d9, skyCoordinates, n, d5, d6, n2, true, d10, d11, Optional.ofNullable(receiverBand));
        }
        catch (InvalidFrequencyException invalidFrequencyException) {
            Log.logger((Object)this).log(Level.FINE, "ACAExpert: called with invalid frequency");
            return 0.0;
        }
        catch (SourceNeverVisibleException sourceNeverVisibleException) {
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            invalidObsProgramParametersException.printStackTrace();
            return 0.0;
        }
        double d12 = d8 * 3.0;
        int n3 = AlmaCapabilities.getInstance().getNumAntennas(Array.ARRAY_7M, performanceParameters.getScienceGoal().getSpectralSetupParameters());
        double d13 = Antenna.ANTENNA_7M.getDiameter();
        try {
            double d14 = spectralSetupParameters.getLO1Frequency().getContentInGHz();
            if (spectralSetupParameters.isSpectralScan()) {
                d14 = Double.NaN;
            }
            double d15 = Configuration.getShadowMultiplierForArray(Array.ARRAY_7M, performanceParameters.getScienceGoal());
            d2 = ExposureTimeCalculator.pointSourceSensitivity(d12, d3, d4, d9, skyCoordinates, n3, d13, d6, n2, true, d14, d15, Optional.ofNullable(receiverBand));
        }
        catch (InvalidFrequencyException invalidFrequencyException) {
            Log.logger((Object)this).log(Level.FINE, "ACAExpert: called with invalid frequency");
        }
        catch (SourceNeverVisibleException sourceNeverVisibleException) {
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            invalidObsProgramParametersException.printStackTrace();
        }
        return d2;
    }

    public double getTPSensitivityJy() {
        double d;
        double d2;
        double d3 = 0.0;
        double d4 = Double.NaN;
        SpectralSetupParameters spectralSetupParameters = this.scienceGoal.getSpectralSetupParameters();
        if (!spectralSetupParameters.isSpectralScan()) {
            d4 = spectralSetupParameters.getLO1Frequency().getContentInGHz();
        }
        PerformanceParameters performanceParameters = this.scienceGoal.getPerformanceParameters();
        try {
            d2 = performanceParameters.getSensitivityForFinestAR().getContentInUnits(Sensitivity.UNIT_JY);
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            return d3;
        }
        double d5 = performanceParameters.getRepresentativeFrequencyWithSkyOffset().getContentInGHz();
        if (d5 == 0.0) {
            return d3;
        }
        double d6 = performanceParameters.getScienceGoal().getRepresentativeBandwidth().getContentInGHz();
        String string = performanceParameters.getScienceGoal().getSpectralSetupParameters().getPolarisation();
        if (string.equals("DOUBLE")) {
            d6 *= 2.0;
        }
        SkyCoordinates skyCoordinates = performanceParameters.getScienceGoal().getKeyTargetParameters().getSourceCoordinates();
        int n = AlmaCapabilities.getInstance().getNumAntennas(Array.ARRAY_12M, spectralSetupParameters);
        double d7 = Antenna.ANTENNA_12M.getDiameter();
        double d8 = SiteCharacteristics.getInstance().getObsLatitude().getContentInDeg();
        double d9 = skyCoordinates.getJ2000SkyCoordinates().getLatitude().getContentInDeg();
        double d10 = 0.0;
        Optional<ReceiverBand> optional = Optional.ofNullable(spectralSetupParameters.getReceiverBand());
        int n2 = WaterVaporColumns.wvindexSelector(d5, d9, optional);
        double d11 = this.getCorrEfficiency();
        try {
            d = Configuration.getShadowMultiplierForArray(Array.ARRAY_12M, this.scienceGoal);
            d10 = ExposureTimeCalculator.pointSourceExposureTime(d2, d5, d6, d11, skyCoordinates, n, d7, d8, n2, true, d4, d, optional);
        }
        catch (InvalidFrequencyException invalidFrequencyException) {
            Log.logger((Object)this).log(Level.FINE, "ACAExpert: called with invalid frequency");
            return 0.0;
        }
        catch (SourceNeverVisibleException sourceNeverVisibleException) {
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            invalidObsProgramParametersException.printStackTrace();
        }
        d = d10 * 3.0;
        int n3 = AlmaCapabilities.getInstance().getNumAntennas(Array.ARRAY_TP, performanceParameters.getScienceGoal().getSpectralSetupParameters());
        double d12 = Antenna.ANTENNA_12M.getDiameter();
        try {
            double d13 = Configuration.getShadowMultiplierForArray(Array.ARRAY_TP, performanceParameters.getScienceGoal());
            d3 = ExposureTimeCalculator.pointSourceSensitivity(d, d5, d6, d11, skyCoordinates, n3, d12, d8, n2, false, d4, d13, optional);
        }
        catch (InvalidFrequencyException invalidFrequencyException) {
            Log.logger((Object)this).log(Level.FINE, "ACAExpert: called with invalid frequency");
        }
        catch (SourceNeverVisibleException sourceNeverVisibleException) {
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            invalidObsProgramParametersException.printStackTrace();
        }
        return d3;
    }
}

