/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.etc;

import alma.entity.xmlbinding.obsproject.types.PerformanceParametersTTimingConstraintsTypeType;
import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.obsproject.CalibrationSetupParameters;
import alma.obsprep.bo.obsproject.MonitoringConstraint;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralScan;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproject.UnableToFindSolutionException;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.schedblock.CalibratorParameters;
import alma.obsprep.bo.schedblock.DGCReferenceCalParameters;
import alma.obsprep.bo.schedblock.DGCScienceCalParameters;
import alma.obsprep.bo.schedblock.ObservingGroup;
import alma.obsprep.bo.schedblock.OrderedTarget;
import alma.obsprep.bo.schedblock.PhaseCalParameters;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.services.calibration.AmplitudeCalObs;
import alma.obsprep.services.calibration.AtmosphericCalObs;
import alma.obsprep.services.calibration.BandpassCalObs;
import alma.obsprep.services.calibration.CalObs;
import alma.obsprep.services.calibration.CalObsProperties;
import alma.obsprep.services.calibration.CalType;
import alma.obsprep.services.calibration.CheckSourceCalObs;
import alma.obsprep.services.calibration.DGCReferenceCalObs;
import alma.obsprep.services.calibration.DGCScienceCalObs;
import alma.obsprep.services.calibration.DelayCalObs;
import alma.obsprep.services.calibration.PhaseCalObs;
import alma.obsprep.services.calibration.PointingCalObs;
import alma.obsprep.services.calibration.PolarizationCalObs;
import alma.obsprep.services.calibration.SBTimeEstimateHelper;
import alma.obsprep.services.calibration.SidebandRatioCalObs;
import alma.obsprep.services.etc.AtmCalList;
import alma.obsprep.services.etc.AtmCalsForSB;
import alma.obsprep.services.etc.ETCTimeCalculator;
import alma.obsprep.services.etc.ObservingTimeCalculatorInterface;
import alma.obsprep.services.etc.Phase1DataRateCalculator;
import alma.obsprep.services.etc.Phase1DataRateCalculatorInterface;
import alma.obsprep.services.etc.SBRetriever;
import alma.obsprep.services.etc.SolarExecutionTimeCalculator;
import alma.obsprep.services.etc.SourceNeverVisibleException;
import alma.obsprep.services.etc.TimeDataCache;
import alma.obsprep.services.etc.TimeEstimatesPointingCalculatorFactory;
import alma.obsprep.services.etc.TimeEstimatesPointingCalculatorInterface;
import alma.obsprep.services.etc.TimeOnSourceData;
import alma.obsprep.services.etc.TimeSummary;
import alma.obsprep.services.etc.TotalPowerObservingTimeCalculator;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.experts.InvalidConfigurationParametersException;
import alma.obsprep.services.experts.InvalidFrequencyException;
import alma.obsprep.services.experts.RequiredConfigurations;
import alma.obsprep.services.experts.SchedBlockExpert;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.SchedBlockPostProcessor;
import alma.obsprep.services.generator.refactored.ScienceGoalSchedBlockGenerator;
import alma.obsprep.services.generator.refactored.obsparams.AtmosphericTimer;
import alma.valuetypes.DataRate;
import alma.valuetypes.Frequency;
import alma.valuetypes.IntTimeSource;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.StorageVolume;
import alma.valuetypes.Time;
import alma.valuetypes.UserSensitivity;
import com.google.common.collect.ImmutableList;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.commons.jcs.JCS;
import org.apache.commons.jcs.access.CacheAccess;

public class ObservingTimeCalculator
extends ETCTimeCalculator
implements ObservingTimeCalculatorInterface,
Phase1DataRateCalculatorInterface {
    static final int POINTING_CAL_EXECUTION_TIME_S = 120;
    private static CacheAccess<Integer, ObsUnitSet> sbOutputCache = JCS.getInstance((String)"obsUnitSetCache");
    private static CacheAccess<Integer, TimeDataCache> scienceGoalTimeCache = JCS.getInstance((String)"scienceGoalTimeCache");
    private static CacheAccess<Integer, TimeDataCache> requestedTimeCache = JCS.getInstance((String)"requestedTimeCache");
    private static CacheAccess<Integer, Time> calibrationTimeFromSBCache = JCS.getInstance((String)"calibrationTimeFromSBCache");
    private boolean isNoSBGenerationToBePerformed = false;
    private Time OG1ExecutionTime = Time.createTimeSec(0.0);
    static final Time SUBSCAN_LATENCY = Time.createTimeSec(1.5);
    static final Time SCAN_LATENCY = Time.createTimeSec(10.0);
    static Time SB_EXEC_OVERHEAD = Time.createTimeSec(100.0);
    private Time overheadTimeCalObs = Time.createTimeSec(0.0);
    private final Map<CalType, TimeSummary> calibrationSummaryTimeEstimates = new LinkedHashMap<CalType, TimeSummary>();
    private Time totalCalibrationSlewTimes = Time.createTime();
    private Phase1DataRateCalculator phase1DataRateCalculator;
    private static final double FWHM = 2.0 * Math.sqrt(2.0 * Math.log(2.0));
    static final Time ATM_CAL_TIME = CalObsProperties.getInstance().getAtmosphericCalTime();

    public ObservingTimeCalculator(ScienceGoal scienceGoal) {
        this(scienceGoal, 1.13);
        try {
            scienceGoal.setKeyTargetParameters(0);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.phase1DataRateCalculator = new Phase1DataRateCalculator(this, scienceGoal);
    }

    public ObservingTimeCalculator(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.scienceGoal = builder.scienceGoal;
        this.obsUnitSet = builder.obsUnitSet;
        this.isNoSBGenerationToBePerformed = builder.noSBGeneration;
        if (this.isNoSBGenerationToBePerformed && this.obsUnitSet == null) {
            throw new NullPointerException("obsUnitSet must not be null if no SB generation is requested");
        }
        this.beamsizeFactor = builder.beamsize_factor != 0.0 ? builder.beamsize_factor : 1.13;
        this.sigma = this.beamsizeFactor / FWHM;
        this.phase1DataRateCalculator = new Phase1DataRateCalculator(this, builder.scienceGoal);
    }

    ObservingTimeCalculator(@NonNull ScienceGoal scienceGoal, double d) {
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        this.obsUnitSet = null;
        this.scienceGoal = scienceGoal;
        this.beamsizeFactor = d;
        this.sigma = d / FWHM;
        this.phase1DataRateCalculator = new Phase1DataRateCalculator(this, scienceGoal);
    }

    public int getNumberOfAntennaConfigurations(@NonNull RequestedArray requestedArray) throws InvalidObsProgramParametersException {
        RequiredConfigurations requiredConfigurations;
        if (requestedArray == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        int n = 1;
        if (RequestedArray.SEVEN_M.equals((Object)requestedArray)) {
            return 1;
        }
        Frequency frequency = this.scienceGoal.getRepresentativeFrequencyInSky().deepCopy();
        try {
            requiredConfigurations = SchedBlockExpert.getRecommended12mConfigurations(this.scienceGoal, frequency);
        }
        catch (InvalidConfigurationParametersException invalidConfigurationParametersException) {
            throw new InvalidObsProgramParametersException(invalidConfigurationParametersException);
        }
        if (requiredConfigurations.has12mCompactConfiguration()) {
            ++n;
        }
        return n;
    }

    @Override
    public Time getTimeForSecond12mCompactArray(@NonNull Time time, boolean bl) throws InvalidObsProgramParametersException {
        if (time == null) {
            throw new NullPointerException("timeFor12mExtendedArray is marked non-null but is null");
        }
        return this.getTimeForSecond12mCompactArray(time, bl, true);
    }

    @Override
    public Time getTimeForSecond12mCompactArray(@NonNull Time time, boolean bl, boolean bl2) throws InvalidObsProgramParametersException {
        if (time == null) {
            throw new NullPointerException("timeFor12mExtendedArray is marked non-null but is null");
        }
        try {
            if (this.scienceGoal.getObsProposal().isVLBIorPhasedArray()) {
                return Time.createTime();
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            throw new InvalidObsProgramParametersException(unknownEntityException);
        }
        double d = 0.0;
        this.getTotalRequestedTime(Array.ARRAY_12M);
        d = Configuration.getArrayTimeMultiplier(Configuration.MultiplierEnumType.COMPACT12M, this.scienceGoal);
        if (d == 0.0) {
            return Time.createTimeSec(0.0);
        }
        PerformanceParameters performanceParameters = this.scienceGoal.getPerformanceParameters();
        boolean bl3 = performanceParameters.getIsSimultaneous12and7();
        if (bl3) {
            return Time.createTimeSec(0.0);
        }
        boolean bl4 = performanceParameters.getNeedsMoreTime();
        if (bl4 && performanceParameters.getDesiredTime() == null) {
            throw new InvalidObsProgramParametersException("Time override time has not been defined but requested");
        }
        Time time2 = bl4 ? performanceParameters.getDesiredTime().deepCopy() : time.deepCopy();
        Time time3 = (Time)time2.multiply(d);
        if (time3.isLessThan((AbstractDoubleWithUnit)this.OG1ExecutionTime) && !bl4) {
            if (bl) {
                return bl2 ? this.adjustForFullPolarization(this.OG1ExecutionTime) : this.factorInTimeConstrainedObserving(this.adjustForFullPolarization(this.OG1ExecutionTime), Array.ARRAY_12M);
            }
            return bl2 ? this.OG1ExecutionTime : this.factorInTimeConstrainedObserving(this.OG1ExecutionTime, Array.ARRAY_12M);
        }
        if (bl) {
            return bl2 ? this.adjustForFullPolarization(time3) : this.factorInTimeConstrainedObserving(this.adjustForFullPolarization(time3), Array.ARRAY_12M);
        }
        return bl2 ? time3 : this.factorInTimeConstrainedObserving(time3, Array.ARRAY_12M);
    }

    @Override
    public Time getRequestedTimeForAllConfigurations(@NonNull Array array, boolean bl) throws InvalidObsProgramParametersException {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        PerformanceParameters performanceParameters = this.scienceGoal.getPerformanceParameters();
        boolean bl2 = false;
        try {
            bl2 = this.scienceGoal.isSolarScienceGoal();
        }
        catch (UnknownEntityException unknownEntityException) {
            throw new InvalidObsProgramParametersException(unknownEntityException);
        }
        if (array.equals((Object)Array.ARRAY_12M)) {
            Time time = performanceParameters.getNeedsMoreTime() && !bl2 ? performanceParameters.getDesiredTime().deepCopy() : this.getTotalRequestedTime(Array.ARRAY_12M, true, false, bl);
            Time time2 = this.getTimeForSecond12mCompactArray(time, true, true);
            Time time3 = (Time)this.adjustForFullPolarization(time).plus((AbstractDoubleWithUnit)this.adjustForFullPolarization(time2));
            return this.factorInTimeConstrainedObserving(time3, array);
        }
        return this.factorInTimeConstrainedObserving(this.getTotalRequestedTime(array, true, false, bl), array);
    }

    @Override
    public Time adjustForFullPolarization(@NonNull Time time) {
        if (time == null) {
            throw new NullPointerException("requestedTime is marked non-null but is null");
        }
        Time time2 = AlmaPolicies.getInstance().getMinTimeForPolarisationSB();
        if (time.isGreaterThan((AbstractDoubleWithUnit)Time.createTimeSec(0.0)) && this.scienceGoal.getSpectralSetupParameters().isFullPolarisation() && time.isLessThan((AbstractDoubleWithUnit)time2)) {
            return time2.deepCopy();
        }
        return time.deepCopy();
    }

    @Override
    public Time getTheoreticalOnSourceTimeForArray(@NonNull Array array) throws InvalidObsProgramParametersException {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        PerformanceParameters performanceParameters = this.scienceGoal.getPerformanceParameters();
        Time time = performanceParameters.getNeedsMoreTime() ? performanceParameters.getDesiredTime().deepCopy() : this.getTotalOnSourceTime(array, true);
        return this.factorInTimeConstrainedObserving(time, array);
    }

    private Time factorInTimeConstrainedObserving(@NonNull Time time, @NonNull Array array) {
        if (time == null) {
            throw new NullPointerException("userRequestedTime is marked non-null but is null");
        }
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        Time time2 = time.deepCopy();
        PerformanceParameters performanceParameters = this.scienceGoal.getPerformanceParameters();
        int n = 1;
        int n2 = 0;
        Time time3 = Time.createTimeSec(0.0);
        if (performanceParameters.getIsTimeConstrained() && performanceParameters.getTimingConstraintsType() != null) {
            if (performanceParameters.getTimingConstraintsType().equals(PerformanceParametersTTimingConstraintsTypeType.MULTIPLEVISITS.toString())) {
                n = performanceParameters.getVisitConstraintCount();
            } else if (performanceParameters.getTimingConstraintsType().equals(PerformanceParametersTTimingConstraintsTypeType.CONTINUOUSMONITORING.toString())) {
                for (MonitoringConstraint monitoringConstraint : performanceParameters.getMonitoringConstraint()) {
                    time3.aggregate(this.adjustForFullPolarization(monitoringConstraint.getMonitoringLength()));
                }
                n2 = performanceParameters.getMonitoringConstraint().length;
            }
        }
        if (n > 1) {
            time2 = (Time)time2.multiply(n);
        } else if (n2 > 0) {
            time2 = time3;
        }
        return time2;
    }

    @Override
    public ObsUnitSet generateSBs(@NonNull ScienceGoal scienceGoal) throws InvalidObsProgramParametersException {
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        if (this.isNoSBGenerationToBePerformed) {
            if (this.obsUnitSet == null) {
                throw new NullPointerException("Illegal argument. The argument cannot be null: obsUnitSet");
            }
            return this.obsUnitSet;
        }
        Integer n = Objects.hash(scienceGoal.toXml());
        this.obsUnitSet = (ObsUnitSet)sbOutputCache.get((Object)n);
        if (this.obsUnitSet != null) {
            this.logger.fine("Using cached SBs");
            return this.obsUnitSet;
        }
        this.logger.fine("Cache miss - generating SBs");
        this.logger.fine("Generating SBs for " + System.identityHashCode(this));
        this.obsUnitSet = ObsUnitSet.createObsUnitSet();
        ScienceGoalSchedBlockGenerator scienceGoalSchedBlockGenerator = new ScienceGoalSchedBlockGenerator(scienceGoal, this.obsUnitSet, false);
        try {
            scienceGoalSchedBlockGenerator.generate();
        }
        catch (WizardSBGenerationException wizardSBGenerationException) {
            this.logger.warning("Unable to create SBs in OTC: " + wizardSBGenerationException.getMessage());
            StringWriter stringWriter = new StringWriter();
            wizardSBGenerationException.printStackTrace(new PrintWriter(stringWriter));
            String string = stringWriter.toString();
            this.logger.warning(string);
            throw new InvalidObsProgramParametersException(wizardSBGenerationException);
        }
        if (this.logger.fine()) {
            try {
                int n2 = 0;
                this.logger.fine("SBs generated for " + System.identityHashCode(this));
                this.logger.fine("No of sched-blocks created : " + this.obsUnitSet.findSchedBlocks().size());
                for (SchedBlock schedBlock : this.obsUnitSet.findSchedBlocks()) {
                    if (!schedBlock.is12mExtendedArraySB()) continue;
                    ++n2;
                    this.logger.fine("12m schedblock executed : " + schedBlock.getSchedBlockControl().getExecutionCount() + " times");
                }
                this.logger.fine("Total number of 12m sched blocks : " + n2 + "\n---------------------");
            }
            catch (UnknownEntityException unknownEntityException) {
                // empty catch block
            }
        }
        sbOutputCache.put((Object)n, (Object)this.obsUnitSet);
        return this.obsUnitSet;
    }

    @Override
    public Time getOnSourceOverheadsTime(Boolean bl, @NonNull Array array) throws InvalidObsProgramParametersException {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        int n = 0;
        int n2 = 0;
        this.generateSBs(this.scienceGoal);
        Time time = Time.createTimeSec(0.0);
        try {
            block8: for (SchedBlock schedBlock : this.obsUnitSet.findSchedBlocks()) {
                switch (array) {
                    case ARRAY_7M: {
                        if (schedBlock.isACA7mArraySB()) break;
                        continue block8;
                    }
                    case ARRAY_12M: {
                        if (schedBlock.is12mExtendedArraySB()) break;
                        continue block8;
                    }
                    default: {
                        throw new IllegalArgumentException("Can only deal with the ACA 7-m and the 12-m array types");
                    }
                }
                n2 += schedBlock.getSchedBlockControl().getExecutionCount();
                for (ObservingGroup observingGroup : schedBlock.getObservingGroup()) {
                    SBTimeEstimateHelper.GroupType groupType;
                    try {
                        groupType = SBTimeEstimateHelper.getGroupType(observingGroup.getName());
                    }
                    catch (SBTimeEstimateHelper.UnknownObservingGroupTypeException unknownObservingGroupTypeException) {
                        throw new InvalidObsProgramParametersException(unknownObservingGroupTypeException);
                    }
                    if (!groupType.equals((Object)SBTimeEstimateHelper.GroupType.SCIENCE)) continue;
                    for (OrderedTarget orderedTarget : observingGroup.getOrderedTarget()) {
                        Target target = orderedTarget.getTarget();
                        for (ScienceParameters scienceParameters : target.getScienceParametersList()) {
                            double d = scienceParameters.getSubScanDuration().getContentInDefaultUnits();
                            int n3 = schedBlock.getSchedBlockControl().getExecutionCount();
                            n += (int)Math.ceil(((IntTimeSource)((IntTimeSource)scienceParameters.getIntegrationTime().multiply(n3)).divide(d)).getContent());
                            time.aggregate(((IntTimeSource)scienceParameters.getIntegrationTime().multiply(n3)).getTime());
                        }
                    }
                }
                if (!bl.booleanValue()) continue;
                break;
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            throw new InvalidObsProgramParametersException(unknownEntityException);
        }
        this.logger.fine("Total subscan latency overhead time : " + SUBSCAN_LATENCY.multiply(n));
        this.logger.fine("Total SB exec overheads : " + SB_EXEC_OVERHEAD.multiply(n2));
        this.logger.fine("Total onsource overheads : " + ((Time)SUBSCAN_LATENCY.multiply(n)).plus((AbstractDoubleWithUnit)((Time)SB_EXEC_OVERHEAD.multiply(n2))));
        this.logger.fine("Total on source time is : " + time);
        return (Time)((Time)SUBSCAN_LATENCY.multiply(n)).plus((AbstractDoubleWithUnit)((Time)SB_EXEC_OVERHEAD.multiply(n2)));
    }

    private Time getTotalOnSourceTimeForTarget(@NonNull Array array, @NonNull TargetParameters targetParameters, boolean bl) throws InvalidObsProgramParametersException {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (targetParameters == null) {
            throw new NullPointerException("tp is marked non-null but is null");
        }
        Array array2 = array.equals((Object)Array.ARRAY_12M) ? array : Array.ARRAY_7M;
        int n = targetParameters.getNumberOfPointings(array2);
        Time time = this.getSinglePointOnSourceTime(array, targetParameters, bl);
        Time time2 = (Time)time.multiply(n);
        return time2;
    }

    public Time getTotalArraySBScienceIntegrationTime(@NonNull Boolean bl, @NonNull Array array) throws InvalidObsProgramParametersException, UnknownEntityException {
        if (bl == null) {
            throw new NullPointerException("isForFirstVisitOnly is marked non-null but is null");
        }
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        Time time = Time.createTime((double)0.0, (String)Time.UNIT_MIN);
        this.generateSBs(this.scienceGoal);
        ObsUnitSet obsUnitSet = this.obsUnitSet;
        if (bl.booleanValue() && !this.isNoSBGenerationToBePerformed) {
            if (this.obsUnitSet.getObsUnitSetCount() == 0) {
                throw new InvalidObsProgramParametersException("Unable to locate the OUS containing the first visit");
            }
            obsUnitSet = this.obsUnitSet.getObsUnitSet(0);
        }
        this.logger.fine("Number of schedblocks found in OUS : " + obsUnitSet.findSchedBlocks().size());
        block5: for (SchedBlock schedBlock : obsUnitSet.findSchedBlocks()) {
            switch (array) {
                case ARRAY_7M: {
                    if (schedBlock.isACA7mArraySB()) break;
                    continue block5;
                }
                case ARRAY_12M: {
                    if (schedBlock.is12mExtendedArraySB()) break;
                    continue block5;
                }
                case ARRAY_TP: {
                    if (schedBlock.isTotalPowerScienceSB()) break;
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Unknown array specified : " + array);
                }
            }
            int n = schedBlock.getSchedBlockControl().getExecutionCount();
            for (Target target : schedBlock.getScienceTargets()) {
                Time time2 = target.getFirstScienceParameters().orElseThrow(WizardSBGenerationException::new).getIntegrationTime().getTime();
                Time time3 = (Time)time2.multiply(n, true);
                time.aggregate(time3);
            }
        }
        double d = time.getSecs();
        Time time4 = Time.createTimeSec(d);
        return time4;
    }

    @Override
    public Time getTotalOnSourceTime(@NonNull Array array, boolean bl) throws InvalidObsProgramParametersException {
        Object object;
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        Time time = Time.createTime();
        for (TargetParameters targetParameters : this.scienceGoal.getTargetParameters()) {
            time.aggregate(this.getTotalOnSourceTimeForTarget(array, targetParameters, bl));
        }
        if (this.scienceGoal.getSpectralSetupParameters().isSpectralScan()) {
            try {
                object = this.scienceGoal.getSpectralSetupParameters().getSpectralScan().getTunings();
            }
            catch (UnableToFindSolutionException unableToFindSolutionException) {
                throw new InvalidObsProgramParametersException("Cannot determine spectral scan solution", unableToFindSolutionException);
            }
            time = (Time)time.multiply(((SpectralScan.SpectralScanTunings)object).getNumberOfTunings().intValue());
        }
        object = AlmaPolicies.getInstance().getMinTimeOnSourcePerSB();
        if (bl && time.isLessThan((AbstractDoubleWithUnit)object)) {
            time = ((Time)object).convertToFriendlyUnit();
        }
        return time;
    }

    @Override
    public Time getTotalRequestedTime(@NonNull Array array) throws InvalidObsProgramParametersException {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        try {
            boolean bl = this.scienceGoal.isSolarScienceGoal();
            if (!this.scienceGoal.getObsProposal().isVLBIorPhasedArray() && !bl) {
                PerformanceParameters performanceParameters = this.scienceGoal.getPerformanceParameters();
                switch (array) {
                    case ARRAY_12M: {
                        if (!(performanceParameters.getDesiredSensitivity().getContentInUnits(UserSensitivity.UNIT_MJY) <= 0.0)) break;
                        throw new InvalidObsProgramParametersException("Desired sensitivity for a science goal must be a positive value");
                    }
                    case ARRAY_7M: {
                        if (!(performanceParameters.getDesiredACASensitivity().getContentInUnits(UserSensitivity.UNIT_MJY) <= 0.0)) break;
                        throw new InvalidObsProgramParametersException("Desired sensitivity for a science goal must be a positive value");
                    }
                    case ARRAY_TP: {
                        if (!(performanceParameters.getDesiredTPSensitivity().getContentInUnits(UserSensitivity.UNIT_MJY) <= 0.0)) break;
                        throw new InvalidObsProgramParametersException("Desired sensitivity for a science goal must be a positive value");
                    }
                }
            }
        }
        catch (UnknownEntityException | NullPointerException throwable) {
            Log.logger(ObservingTimeCalculator.class).warning("Unable to check that project is a VLBI project ");
            throw new InvalidObsProgramParametersException("Unable to check that project is a VLBI project ");
        }
        return this.getTotalRequestedTime(array, false, false, true);
    }

    @Override
    public Time getOverheadTimes(@NonNull Boolean bl, @NonNull EnumSet<CalibrationOverheads> enumSet, @NonNull Array array, @NonNull TargetParameters targetParameters) throws InvalidObsProgramParametersException {
        if (bl == null) {
            throw new NullPointerException("isForFirstVisitOnly is marked non-null but is null");
        }
        if (enumSet == null) {
            throw new NullPointerException("overHeadsToInclude is marked non-null but is null");
        }
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (targetParameters == null) {
            throw new NullPointerException("tp is marked non-null but is null");
        }
        if (enumSet.isEmpty()) {
            return Time.createTimeSec(0.0);
        }
        if (array.equals((Object)Array.ARRAY_TP)) {
            TotalPowerObservingTimeCalculator totalPowerObservingTimeCalculator = new TotalPowerObservingTimeCalculator(this.scienceGoal, this);
            Time time = Time.createTime();
            try {
                time = totalPowerObservingTimeCalculator.getOverheadTimes(bl, enumSet);
            }
            catch (UnknownEntityException | TotalPowerObservingTimeCalculator.UnableToGenerateTPTimeEstimateException throwable) {
                throw new InvalidObsProgramParametersException(throwable);
            }
            return time;
        }
        Time time = Time.createTime((double)0.0, (String)Time.UNIT_MIN);
        Time time2 = Time.createTime((double)0.0, (String)Time.UNIT_MIN);
        Time time3 = Time.createTime((double)0.0, (String)Time.UNIT_MIN);
        Time time4 = Time.createTime((double)0.0, (String)Time.UNIT_MIN);
        if (enumSet.contains((Object)CalibrationOverheads.CALIBRATIONEXECTIMES)) {
            try {
                time = this.getCalibrationExecutionTimeStats(bl, array, targetParameters, false, this::getSBsViaSBGeneration);
            }
            catch (SourceNeverVisibleException sourceNeverVisibleException) {}
        } else {
            try {
                this.getCalibrationExecutionTimeStats(bl, array, targetParameters, false, this::getSBsViaSBGeneration);
            }
            catch (SourceNeverVisibleException sourceNeverVisibleException) {
                // empty catch block
            }
        }
        if (enumSet.contains((Object)CalibrationOverheads.ONSOURCEOVERHEADS)) {
            time2 = this.getOnSourceOverheadsTime(bl, array);
        }
        if (enumSet.contains((Object)CalibrationOverheads.CALIBRATIONOVERHEADS)) {
            time3 = this.getOverheadTimeForCalObs();
        }
        if (enumSet.contains((Object)CalibrationOverheads.CALIBRATIONSLEWTIME)) {
            time4 = this.getCalibrationSlewTimes();
        }
        Time time5 = Time.createTime((double)0.0, (String)Time.UNIT_MIN);
        time5 = (Time)((Time)((Time)((Time)time5.plus((AbstractDoubleWithUnit)time2)).plus((AbstractDoubleWithUnit)time)).plus((AbstractDoubleWithUnit)time3)).plus((AbstractDoubleWithUnit)time4);
        return time5;
    }

    private Time getCalibrationSlewTimes() {
        return this.totalCalibrationSlewTimes.deepCopy();
    }

    @Override
    public Time getTotalRequestedTime(@NonNull Array array, @NonNull Boolean bl, @NonNull Boolean bl2, @NonNull Boolean bl3) throws InvalidObsProgramParametersException {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (bl == null) {
            throw new NullPointerException("isForFirstVisitOnly is marked non-null but is null");
        }
        if (bl2 == null) {
            throw new NullPointerException("isTM2TimeRequired is marked non-null but is null");
        }
        if (bl3 == null) {
            throw new NullPointerException("isOverheadsToBeIncluded is marked non-null but is null");
        }
        if (!array.equals((Object)Array.ARRAY_12M) && bl2.booleanValue()) {
            throw new IllegalArgumentException("Cannot request the 12-m compact time if the array is not set to 12-m");
        }
        Integer n = Objects.hash(new Object[]{array, bl, bl2, bl3, this.scienceGoal.toXml()});
        TimeDataCache timeDataCache = (TimeDataCache)requestedTimeCache.get((Object)n);
        if (timeDataCache != null && !this.calibrationSummaryTimeEstimates.isEmpty()) {
            timeDataCache.restoreTimeData(this);
            return timeDataCache.getRequestedTime().deepCopy();
        }
        PerformanceParameters performanceParameters = this.scienceGoal.getPerformanceParameters();
        if (performanceParameters == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: performanceParameters");
        }
        boolean bl4 = Array.isTP(array);
        boolean bl5 = this.scienceGoal.isStandAloneACA();
        boolean bl6 = performanceParameters.getUseTP();
        if (bl5 && bl4 && !bl6) {
            return Time.createTime();
        }
        boolean bl7 = false;
        try {
            bl7 = this.scienceGoal.isSolarScienceGoal();
        }
        catch (UnknownEntityException unknownEntityException) {
            throw new InvalidObsProgramParametersException("Unable to determine if a solar science goal" + unknownEntityException.getMessage());
        }
        Time time = Time.createTime();
        if (bl7) {
            time = this.getSolarExecutionTime(this.scienceGoal, bl, array);
        } else {
            boolean bl8 = false;
            try {
                bl8 = ObsProposal.isVLBIRelated();
            }
            catch (UnknownEntityException unknownEntityException) {
                Log.logger(ObservingTimeCalculator.class).warning("Unable to determine if VLBI");
            }
            boolean bl9 = performanceParameters.getNeedsMoreTime();
            if (bl8 && bl9) {
                if (bl4 || Array.is7m(array)) {
                    time = Time.createTime();
                } else {
                    Time time2 = performanceParameters.getDesiredTime();
                    if (time2 == null) {
                        throw new InvalidObsProgramParametersException("Override time is not specified when expected");
                    }
                    time = time2.deepCopy();
                }
            } else {
                Time time3 = time = bl4 ? this.calculateTPTotalTime(bl, bl3) : this.calculateInterferometricTotalTime(bl, bl3, array);
            }
            if (bl2.booleanValue()) {
                time = this.getTimeForSecond12mCompactArray(time, true, true);
            }
            time = this.adjustForFullPolarization(time);
        }
        TimeDataCache.TimeDataCacheBuilder timeDataCacheBuilder = TimeDataCache.builder();
        timeDataCacheBuilder.OG1ExecutionTime(this.OG1ExecutionTime.deepCopy()).overheadTimeCalObs(this.overheadTimeCalObs.deepCopy()).requestedTime(time.deepCopy()).totalCalibrationSlewTime(this.totalCalibrationSlewTimes.deepCopy());
        requestedTimeCache.put((Object)n, (Object)timeDataCacheBuilder.build());
        return time.deepCopy();
    }

    private Time calculateTPTotalTime(boolean bl, boolean bl2) throws InvalidObsProgramParametersException {
        Time time;
        TotalPowerObservingTimeCalculator totalPowerObservingTimeCalculator = new TotalPowerObservingTimeCalculator(this.scienceGoal, this);
        try {
            time = totalPowerObservingTimeCalculator.getTotalTPExecutionTime(bl, bl2);
        }
        catch (UnknownEntityException | TotalPowerObservingTimeCalculator.UnableToGenerateTPTimeEstimateException throwable) {
            throw new InvalidObsProgramParametersException(throwable);
        }
        return time;
    }

    private Time calculateInterferometricTotalTime(boolean bl, boolean bl2, @NonNull Array array) throws InvalidObsProgramParametersException {
        if (array == null) {
            throw new NullPointerException("interferometricArray is marked non-null but is null");
        }
        if (array.equals((Object)Array.ARRAY_TP)) {
            throw new IllegalArgumentException("Illegal argument: interferometricArray.equals(Array.ARRAY_TP) (" + array.equals((Object)Array.ARRAY_TP) + ") did not pass the test: interferometricArray.equals(Array.ARRAY_TP) test");
        }
        Time time = Time.createTime();
        try {
            time = this.getTotalArraySBScienceIntegrationTime(bl, array);
            this.logger.fine("Total time on source from OTC is " + this.getTotalOnSourceTime(array, true) + " - Total time on source from SB generator is " + time);
        }
        catch (UnknownEntityException unknownEntityException) {
            this.logger.warning("Unable to established the TOS for the " + array + " array");
        }
        EnumSet<CalibrationOverheads> enumSet = EnumSet.of(CalibrationOverheads.CALIBRATIONEXECTIMES, CalibrationOverheads.CALIBRATIONOVERHEADS, CalibrationOverheads.ONSOURCEOVERHEADS, CalibrationOverheads.CALIBRATIONSLEWTIME);
        if (!bl2) {
            enumSet = EnumSet.of(CalibrationOverheads.CALIBRATIONEXECTIMES);
        }
        TargetParameters targetParameters = this.scienceGoal.getSoleTargetParameters();
        Time time2 = this.getOverheadTimes(bl, enumSet, array, targetParameters);
        Time time3 = (Time)time.plus((AbstractDoubleWithUnit)time2);
        this.logger.info("For inputs [  requested time : " + time + " , isForFirstVisitOnly : " + bl + " , overheadsToCalculate : " + enumSet + " , interferometricArray : " + array + " , scienceGoal.getSoleTargetParameters() : " + targetParameters + "] Result is : " + time3);
        return time3;
    }

    Time getSolarExecutionTime(@NonNull ScienceGoal scienceGoal, boolean bl, @NonNull Array array) {
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (array.equals((Object)Array.ARRAY_7M)) {
            return Time.createTime();
        }
        Time time = null;
        SolarExecutionTimeCalculator solarExecutionTimeCalculator = new SolarExecutionTimeCalculator();
        Time time2 = scienceGoal.getPerformanceParameters().getDesiredTime().deepCopy();
        SolarExecutionTimeCalculator.SolarExecutionTimeResult solarExecutionTimeResult = solarExecutionTimeCalculator.calculateSolarIntegrationTimes(time2, scienceGoal.getReceiverBand().getNumber(), scienceGoal.getTargetParametersCount());
        if (array.equals((Object)Array.ARRAY_TP)) {
            time = solarExecutionTimeResult.t_tp_SB;
        } else if (array.equals((Object)Array.ARRAY_12M)) {
            time = solarExecutionTimeResult.t_int_SB;
        }
        if (!bl) {
            time = this.factorInTimeConstrainedObserving(time, array);
        }
        return time;
    }

    public Map<CalType, TimeSummary> getCalibrationTimeSummary() {
        return Collections.unmodifiableMap(this.calibrationSummaryTimeEstimates);
    }

    @Override
    public Time getOverheadTimeForCalObs() {
        return this.overheadTimeCalObs.deepCopy();
    }

    private boolean isTMSBToBeProcessed(@NonNull SchedBlock schedBlock, @NonNull List<SchedBlock> list) {
        boolean bl;
        if (schedBlock == null) {
            throw new NullPointerException("schedBlock is marked non-null but is null");
        }
        if (list == null) {
            throw new NullPointerException("schedBlocks is marked non-null but is null");
        }
        if (!schedBlock.is12mExtendedArraySB() && !schedBlock.is12mCompactArraySB()) {
            return false;
        }
        if (schedBlock.is12mExtendedArraySB()) {
            return true;
        }
        boolean bl2 = bl = list.size() == 1 && schedBlock.is12mCompactArraySB();
        return bl;
    }

    List<SBTimeEstimateHelper> getCalibrationObservationListForPrincipalArray(boolean bl, @NonNull Array array, @NonNull SBRetriever sBRetriever) throws InvalidObsProgramParametersException {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (sBRetriever == null) {
            throw new NullPointerException("schedBlockRetriever is marked non-null but is null");
        }
        TimeEstimatesPointingCalculatorInterface timeEstimatesPointingCalculatorInterface = TimeEstimatesPointingCalculatorFactory.getPointingCalculator(this.scienceGoal);
        if (!EnumSet.of(Array.ARRAY_7M, Array.ARRAY_12M).contains((Object)array)) {
            throw new IllegalArgumentException("Array can only be for the 12-m and the ACA 7-m");
        }
        PointingCalObs pointingCalObs = this.getPointingCalibration();
        ArrayList<SBTimeEstimateHelper> arrayList = new ArrayList<SBTimeEstimateHelper>(100);
        int n = this.getNoOfTunings();
        int n2 = 0;
        List<SchedBlock> list = sBRetriever.getSBs();
        block10: for (SchedBlock schedBlock : list) {
            switch (array) {
                case ARRAY_7M: {
                    if (schedBlock.isACA7mArraySB()) break;
                    continue block10;
                }
                case ARRAY_12M: {
                    if (this.isTMSBToBeProcessed(schedBlock, list)) break;
                    continue block10;
                }
                default: {
                    throw new IllegalArgumentException("Can only deal with the ACA 7-m and the 12-m array types");
                }
            }
            ++n2;
            SBTimeEstimateHelper sBTimeEstimateHelper = new SBTimeEstimateHelper(schedBlock);
            arrayList.add(sBTimeEstimateHelper);
            for (ObservingGroup observingGroup : schedBlock.getObservingGroup()) {
                int n3;
                int n4;
                SBTimeEstimateHelper.GroupType groupType;
                String string = observingGroup.getName();
                this.logger.fine("Group > " + string);
                try {
                    groupType = SBTimeEstimateHelper.getGroupType(string);
                }
                catch (SBTimeEstimateHelper.UnknownObservingGroupTypeException unknownObservingGroupTypeException) {
                    this.logger.warning("Unable to determine the OG type for " + string);
                    throw new InvalidObsProgramParametersException(unknownObservingGroupTypeException);
                }
                switch (groupType) {
                    case CALIBRATORS: {
                        int n5 = timeEstimatesPointingCalculatorInterface.getNoOfPointingCalibrations(sBTimeEstimateHelper, this.scienceGoal, SBTimeEstimateHelper.GroupType.CALIBRATORS, n, observingGroup.getIndex());
                        for (n4 = 0; n4 < n5; ++n4) {
                            sBTimeEstimateHelper.addCalibrationToGroup(string, pointingCalObs);
                        }
                        break;
                    }
                    case SCIENCE: {
                        int n6 = timeEstimatesPointingCalculatorInterface.getNoOfPointingCalibrations(sBTimeEstimateHelper, this.scienceGoal, SBTimeEstimateHelper.GroupType.SCIENCE, n, observingGroup.getIndex());
                        for (n3 = 0; n3 < n6; ++n3) {
                            sBTimeEstimateHelper.addCalibrationToGroup(string, pointingCalObs);
                        }
                        break;
                    }
                }
                for (n4 = 0; n4 < 0; ++n4) {
                    SidebandRatioCalObs sidebandRatioCalObs = new SidebandRatioCalObs(this.scienceGoal);
                    sidebandRatioCalObs.setExecutingRepeatedly(false);
                    sBTimeEstimateHelper.addCalibrationToGroup(string, sidebandRatioCalObs);
                }
                OrderedTarget[] orderedTargetArray = observingGroup.getOrderedTarget();
                n3 = orderedTargetArray.length;
                for (int i = 0; i < n3; ++i) {
                    Object object;
                    OrderedTarget orderedTarget2 = orderedTargetArray[i];
                    Target target2 = orderedTarget2.getTarget();
                    this.logger.fine("Target > " + target2.briefDescription());
                    if (target2.hasAmplitudeCalParameters()) {
                        object = target2.getFirstAmplitudeCalParameters().orElseThrow(() -> new InvalidObsProgramParametersException("Cannot find ampcal"));
                        if (target2.isDGCAmplitudeCal()) {
                            this.recordCalibration(string, false, sBTimeEstimateHelper, new AmplitudeCalObs(), (CalibratorParameters)((Object)object), CalObs.CalibratorSecondaryIntentEnum.DGC, Optional.of(CalType.DGCAmplitude));
                            continue;
                        }
                        this.recordCalibration(string, false, sBTimeEstimateHelper, new AmplitudeCalObs(), (CalibratorParameters)((Object)object), CalObs.CalibratorSecondaryIntentEnum.UNDEFINED, Optional.empty());
                        continue;
                    }
                    if (target2.hasBandpassCalParameters()) {
                        object = target2.getFirstBandpassCalParameters().orElseThrow(() -> new InvalidObsProgramParametersException("Unable to find BP cal parameters"));
                        if (target2.isDGCBandpassCal()) {
                            this.recordCalibration(string, false, sBTimeEstimateHelper, new BandpassCalObs(), (CalibratorParameters)((Object)object), CalObs.CalibratorSecondaryIntentEnum.DGC, Optional.of(CalType.DGCBandpass));
                            continue;
                        }
                        this.recordCalibration(string, false, sBTimeEstimateHelper, new BandpassCalObs(), (CalibratorParameters)((Object)object), CalObs.CalibratorSecondaryIntentEnum.UNDEFINED, Optional.empty());
                        continue;
                    }
                    if (target2.hasDelayCalParameters()) {
                        this.recordCalibration(string, true, sBTimeEstimateHelper, new DelayCalObs(), (CalibratorParameters)((Object)target2.getFirstDelayCalParameters().get()), CalObs.CalibratorSecondaryIntentEnum.UNDEFINED, Optional.empty());
                        continue;
                    }
                    if (target2.hasDGCReferenceCalParameters()) {
                        object = this.recordCalibration(string, false, sBTimeEstimateHelper, new DGCReferenceCalObs(), (CalibratorParameters)((Object)target2.getFirstDGCReferenceParameters().get()), CalObs.CalibratorSecondaryIntentEnum.UNDEFINED, Optional.empty());
                        ((CalObs)object).setNoOfScansPerNonRepeatingCal(0);
                        continue;
                    }
                    if (target2.hasDGCScienceCalParameters()) {
                        object = this.recordCalibration(string, false, sBTimeEstimateHelper, new DGCScienceCalObs(), (CalibratorParameters)((Object)target2.getFirstDGCScienceParameters().get()), CalObs.CalibratorSecondaryIntentEnum.UNDEFINED, Optional.empty());
                        ((CalObs)object).setNoOfScansPerNonRepeatingCal(2);
                        Target target3 = Stream.of(observingGroup.getOrderedTarget()).map(orderedTarget -> orderedTarget.getTarget()).filter(target -> target.hasDGCReferenceCalParameters()).findFirst().orElseThrow(() -> new InvalidObsProgramParametersException("Unable to find DGC reference cal"));
                        ((CalObs)object).setPreCalculatedCalTime(Optional.of(this.getDGCCombinedScanTime(target2, target3)));
                        continue;
                    }
                    if (target2.hasCheckSourceCalParameters()) {
                        this.recordCalibration(string, true, sBTimeEstimateHelper, new CheckSourceCalObs(), (CalibratorParameters)((Object)target2.getFirstCheckSourceCalParameters().get()), CalObs.CalibratorSecondaryIntentEnum.UNDEFINED, Optional.empty());
                        continue;
                    }
                    if (target2.hasPhaseCalParameters()) {
                        this.recordCalibration(string, true, sBTimeEstimateHelper, new PhaseCalObs(), (CalibratorParameters)((Object)target2.getFirstPhaseCalParameters().get()), CalObs.CalibratorSecondaryIntentEnum.UNDEFINED, Optional.empty());
                        continue;
                    }
                    if (!target2.hasPolarizationCalParameters()) continue;
                    this.recordCalibration(string, false, sBTimeEstimateHelper, new PolarizationCalObs(), (CalibratorParameters)((Object)target2.getFirstPolarizationCalParameters().get()), CalObs.CalibratorSecondaryIntentEnum.UNDEFINED, Optional.empty());
                }
            }
            if (this.scienceGoal.getCalibrationSetupParameters().getSelection().equals(CalibrationSetupParameters.SELECTION_USER)) {
                int n7;
                int n8 = timeEstimatesPointingCalculatorInterface.getNoOfPointingCalibrationsForUserDefinedStrategy(sBTimeEstimateHelper, SBTimeEstimateHelper.GroupType.CALIBRATORS);
                int n9 = timeEstimatesPointingCalculatorInterface.getNoOfPointingCalibrationsForUserDefinedStrategy(sBTimeEstimateHelper, SBTimeEstimateHelper.GroupType.SCIENCE);
                for (n7 = 0; n7 < n8; ++n7) {
                    sBTimeEstimateHelper.addCalibrationToGroup("Calibrators", pointingCalObs);
                }
                for (n7 = 0; n7 < n9; ++n7) {
                    sBTimeEstimateHelper.addCalibrationToGroup("Science", pointingCalObs);
                }
            }
            if (!bl) continue;
            break;
        }
        this.logger.fine("No of 12m extended SBs processed : " + n2);
        this.logger.finer("Size of generated SB calibs " + arrayList.size());
        return arrayList;
    }

    private Time getDGCCombinedScanTime(@NonNull Target target, @NonNull Target target2) throws InvalidObsProgramParametersException {
        if (target == null) {
            throw new NullPointerException("dgcScienceTarget is marked non-null but is null");
        }
        if (target2 == null) {
            throw new NullPointerException("dgcReferenceTarget is marked non-null but is null");
        }
        if (!target.hasDGCScienceCalParameters()) {
            throw new IllegalArgumentException("Illegal argument: dgc (" + target + ") did not pass the test: dgc test");
        }
        if (!target2.hasDGCReferenceCalParameters()) {
            throw new IllegalArgumentException("Illegal argument: dgc (" + target2 + ") did not pass the test: dgc test");
        }
        DGCScienceCalParameters dGCScienceCalParameters = target.getFirstDGCScienceParameters().get();
        DGCReferenceCalParameters dGCReferenceCalParameters = target2.getFirstDGCReferenceParameters().get();
        int n = dGCScienceCalParameters.getInternalCycleCount();
        double d = dGCReferenceCalParameters.getDefaultIntegrationTime().getSecs();
        double d2 = dGCScienceCalParameters.getDefaultIntegrationTime().getSecs();
        int n2 = n == 5 ? 2 : 20;
        return Time.createTimeSec((double)(n + 1) * d + (double)n * d2 + (double)(2 * n * n2));
    }

    private PointingCalObs getPointingCalibration() {
        PointingCalObs pointingCalObs = new PointingCalObs(this.scienceGoal);
        pointingCalObs.setSBSuggestedDefaultIntegrationTime(Time.createTimeSec(120.0));
        pointingCalObs.setExecutingRepeatedly(false);
        return pointingCalObs;
    }

    @NonNull
    private CalObs recordCalibration(@NonNull String string, @NonNull Boolean bl, @NonNull SBTimeEstimateHelper sBTimeEstimateHelper, @NonNull CalObs calObs, @NonNull CalibratorParameters calibratorParameters, @NonNull CalObs.CalibratorSecondaryIntentEnum calibratorSecondaryIntentEnum, @NonNull Optional<CalType> optional) {
        if (string == null) {
            throw new NullPointerException("observingGroupName is marked non-null but is null");
        }
        if (bl == null) {
            throw new NullPointerException("isCalibrationRepeating is marked non-null but is null");
        }
        if (sBTimeEstimateHelper == null) {
            throw new NullPointerException("sbTimeEstimateHelper is marked non-null but is null");
        }
        if (calObs == null) {
            throw new NullPointerException("calibrationObservation is marked non-null but is null");
        }
        if (calibratorParameters == null) {
            throw new NullPointerException("sbCalibrationParameters is marked non-null but is null");
        }
        if (calibratorSecondaryIntentEnum == null) {
            throw new NullPointerException("calibratorSecondaryIntent is marked non-null but is null");
        }
        if (optional == null) {
            throw new NullPointerException("secondaryIntentCalType is marked non-null but is null");
        }
        calObs.setExecutingRepeatedly(bl);
        calObs.setSBSuggestedDefaultIntegrationTime(calibratorParameters.getDefaultIntegrationTime().deepCopy());
        calObs.setSBSuggestedCycleTime(calibratorParameters.getCycleTime().deepCopy());
        calObs.setCalibratorSecondaryIntent(calibratorSecondaryIntentEnum);
        optional.ifPresent(calType -> calObs.setSecondaryIntentCalType((CalType)((Object)calType)));
        if (calibratorParameters instanceof DGCScienceCalParameters) {
            DGCScienceCalParameters dGCScienceCalParameters = (DGCScienceCalParameters)((Object)calibratorParameters);
            calObs.setInternalCycleCount(Optional.of(dGCScienceCalParameters.getInternalCycleCount()));
        }
        sBTimeEstimateHelper.addCalibrationToGroup(string, calObs);
        return calObs;
    }

    @Override
    public Time getCalibrationExecutionTimeStats(@NonNull Boolean bl, @NonNull Array array, @NonNull TargetParameters targetParameters, boolean bl2, @NonNull SBRetriever sBRetriever) throws InvalidObsProgramParametersException, SourceNeverVisibleException {
        if (bl == null) {
            throw new NullPointerException("isForFirstVisitOnly is marked non-null but is null");
        }
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (targetParameters == null) {
            throw new NullPointerException("targetParameters is marked non-null but is null");
        }
        if (sBRetriever == null) {
            throw new NullPointerException("sbRetriever is marked non-null but is null");
        }
        assert (this.scienceGoal != null);
        SkyCoordinates skyCoordinates = targetParameters.getSourceCoordinates().getJ2000SkyCoordinates();
        CalibrationSetupParameters calibrationSetupParameters = this.scienceGoal.getCalibrationSetupParameters();
        boolean bl3 = !bl2 && this.isSBToBeExecutedUsingSessions();
        Time time = Time.createTime();
        List<TimeOnSourceData> list = this.getSBOnSourceData(array, sBRetriever);
        this.numRetunings = this.getNoOfTunings();
        this.calibrationSummaryTimeEstimates.clear();
        this.overheadTimeCalObs.setContent(0.0);
        this.totalCalibrationSlewTimes.setContent(0.0);
        this.OG1ExecutionTime.setContent(0.0);
        Optional<Time> optional = Optional.empty();
        Time time2 = Time.createTimeSec(0.0);
        long l = 0L;
        boolean bl4 = true;
        for (SBTimeEstimateHelper object2 : this.getCalibrationObservationListForPrincipalArray(bl, array, sBRetriever)) {
            long atmCalList = 1L;
            TimeOnSourceData timeOnSourceData = null;
            for (TimeOnSourceData timeSummary : list) {
                if (!timeSummary.getSchedBlock().getEntityID().equals(object2.getSchedBlock().getEntityID())) continue;
                timeOnSourceData = timeSummary;
                atmCalList = timeSummary.getNoOfSBExecutions().longValue();
                break;
            }
            this.logger.fine("No of SB execs (adjusted) " + atmCalList + " for object " + System.identityHashCode(this));
            for (String string : object2.getObservingGroupNames()) {
                CalObs[] calObsArray;
                SBTimeEstimateHelper.GroupType groupType;
                Time time3 = Time.createTime();
                try {
                    groupType = SBTimeEstimateHelper.getGroupType(string);
                    calObsArray = object2.getCalibrationsForGroup(string);
                }
                catch (SBTimeEstimateHelper.UnknownObservingGroupTypeException unknownObservingGroupTypeException) {
                    throw new InvalidObsProgramParametersException(unknownObservingGroupTypeException);
                }
                for (CalObs calObs : calObsArray) {
                    int n;
                    Time n2;
                    Time time4;
                    if (calObs == null) continue;
                    boolean bl5 = calObs.isIncludedInTimeEstimateAccounting();
                    Time time5 = bl5 ? (Time)calObs.onewayMotionTime().multiply(2.0) : time3;
                    calObs.setSourceCoordinates(skyCoordinates);
                    try {
                        calObs.setWvChoice(-1);
                        time4 = bl5 ? calObs.calTime() : time3;
                    }
                    catch (SourceNeverVisibleException | InvalidFrequencyException exception) {
                        throw new InvalidObsProgramParametersException(exception);
                    }
                    assert (time4 != null);
                    CalType exception = this.mapCalibrationToSecondaryIntent(calObs);
                    long l2 = 0L;
                    Time time6 = calObs.cycleTime().deepCopy();
                    if (calObs.isExecutingRepeatedly()) {
                        n2 = AlmaPolicies.getInstance().getNominalSbLength();
                        if (time6.isGreaterThan((AbstractDoubleWithUnit)n2)) {
                            l2 = bl2 ? 1L : atmCalList;
                        } else {
                            l2 = 1L;
                            if (timeOnSourceData == null) {
                                this.logger.warning("Could not match SB when determining repeating calibrations.");
                                return Time.createTimeSec(0.0);
                            }
                            try {
                                n = (int)timeOnSourceData.getTimeOnSourceForObservingGroup(string).getSecs();
                            }
                            catch (SBTimeEstimateHelper.UnknownObservingGroupTypeException unknownObservingGroupTypeException) {
                                throw new InvalidObsProgramParametersException(unknownObservingGroupTypeException);
                            }
                            l2 = (long)Math.ceil((double)n / time6.getSecs());
                            if (calObs instanceof PhaseCalObs && l2 == 1L) {
                                l2 = 2L;
                            }
                            if (!bl2) {
                                l2 *= atmCalList;
                            }
                            this.logger.fine("onSourceTimeSecsPerOG - " + n + " Calib. type- " + exception + " Cycle time - " + time6 + " Calib Execs - " + l2);
                        }
                    } else {
                        int invalidFrequencyException = calObs.getNoOfScansPerNonRepeatingCal();
                        long l3 = l2 = bl2 ? (long)invalidFrequencyException : atmCalList * (long)invalidFrequencyException;
                    }
                    if (calObs instanceof PhaseCalObs) {
                        try {
                            optional = Optional.of(calObs.calTime());
                        }
                        catch (InvalidFrequencyException invalidFrequencyException) {
                            throw new InvalidObsProgramParametersException(invalidFrequencyException);
                        }
                    } else {
                        n2 = calObs.atmCalTime(object2.getSchedBlock());
                        if (!n2.isZero()) {
                            boolean bl6;
                            n = calObs.getNoOfAtmCalsToBePerformed();
                            long unknownObservingGroupTypeException = l2 * (long)n;
                            boolean bl7 = bl6 = groupType.equals((Object)SBTimeEstimateHelper.GroupType.CALIBRATORS) && bl4 && bl5;
                            if (bl6) {
                                this.OG1ExecutionTime.aggregate((Time)n2.multiply(unknownObservingGroupTypeException));
                            }
                            if (bl5) {
                                time2.aggregate((Time)n2.multiply(unknownObservingGroupTypeException));
                            }
                            l += unknownObservingGroupTypeException;
                        }
                    }
                    Log.logger(ObservingTimeCalculator.class).info("calibrationType" + exception + " calibrationScanTime " + time4 + " calibrationCycleTime" + time6 + " totalNoOfCalibrationExecsPerEB " + l2);
                    if (calObs.getPreCalculatedCalTime().isPresent()) {
                        time4 = calObs.getPreCalculatedCalTime().get();
                    }
                    object2.addCalibrationExecutionStats(exception, time4, time6, l2);
                    n2 = (Time)time4.multiply(l2);
                    this.totalCalibrationSlewTimes.aggregate((Time)time5.multiply(l2));
                    if (groupType.equals((Object)SBTimeEstimateHelper.GroupType.CALIBRATORS)) {
                        this.logger.fine("Group one " + exception + " requires a total scan time of " + n2);
                        if (bl4) {
                            this.OG1ExecutionTime.aggregate(n2);
                            this.OG1ExecutionTime.aggregate((Time)SCAN_LATENCY.multiply(l2));
                            this.OG1ExecutionTime.aggregate((Time)calObs.onewayMotionTime().multiply(l2));
                        }
                        this.overheadTimeCalObs.aggregate((Time)SCAN_LATENCY.multiply(l2));
                        this.logger.fine("Group one : calibration - " + exception + " no of calibration executions - " + l2 + " intrasource overheads : " + SCAN_LATENCY.multiply(l2));
                    } else {
                        this.overheadTimeCalObs.aggregate((Time)((Time)SCAN_LATENCY.multiply(l2)).multiply(2.0));
                        this.logger.fine("Group two : calibration " + exception + " no of calibration executions " + l2 + " scan latency overheads : " + SCAN_LATENCY.multiply(l2));
                    }
                    time.aggregate(n2);
                    if (!this.calibrationSummaryTimeEstimates.containsKey((Object)exception)) {
                        this.calibrationSummaryTimeEstimates.put(exception, new TimeSummary(exception));
                    }
                    TimeSummary n3 = this.calibrationSummaryTimeEstimates.get((Object)exception);
                    n3.setCalibrationStrategyUsed(calibrationSetupParameters.getSelection());
                    n3.addNumExec(l2);
                    n3.addTime(n2);
                    n3.setCalibrationObservation(calObs);
                }
            }
            if (bl3 && atmCalList > 1L) {
                time = (Time)time.minus((AbstractDoubleWithUnit)((Time)((Time)this.OG1ExecutionTime.divide(atmCalList)).multiply(atmCalList - 1L)));
            }
            bl4 = false;
        }
        Log.logger(ObservingTimeCalculator.class).fine("totalCalculatedCalibrationTime (no atm cals) : " + time);
        Object object3 = new AtmosphericCalObs().getCalType();
        AtmCalList atmCalList = this.getNumberOfAtmCalsForScienceTargets(bl, bl2, array, sBRetriever);
        AtmCalList atmCalList2 = this.getNumberOfAtmCalsForPhaseCalibrations(bl, true, array, sBRetriever);
        long l4 = 0L;
        Time time7 = Time.createTimeSec(0.0);
        l4 = atmCalList2.getTotalNumberOfAtmCals() + atmCalList.getTotalNumberOfAtmCals() + l;
        time7.aggregate((Time)atmCalList.getTotalAmountOfTimeForAmtCals().plus((AbstractDoubleWithUnit)time2));
        time7.aggregate(atmCalList2.getTotalAmountOfTimeForAmtCals());
        if (l4 > 0L) {
            time.aggregate(time7);
            if (!this.calibrationSummaryTimeEstimates.containsKey(object3)) {
                this.calibrationSummaryTimeEstimates.put((CalType)((Object)object3), new TimeSummary((CalType)((Object)object3)));
            }
            TimeSummary timeSummary = this.calibrationSummaryTimeEstimates.get(object3);
            timeSummary.addNumExec(l4);
            timeSummary.addTime(time7);
            timeSummary.setCalibrationObservation(new AtmosphericCalObs());
            Log.logger(ObservingTimeCalculator.class).fine(String.format("Number of atmcals is %d and will take %s to execute", l4, time7));
        }
        this.logger.fine("Total amount of time required for the group one calibrations " + this.OG1ExecutionTime);
        this.OG1ExecutionTime = (Time)((Time)this.OG1ExecutionTime.plus((AbstractDoubleWithUnit)Time.createTime((double)5.0, (String)Time.UNIT_MIN))).plus((AbstractDoubleWithUnit)((Time)optional.orElse(Time.createTimeSec(0.0)).multiply(2.0)));
        Log.logger(ObservingTimeCalculator.class).fine("totalCalculatedCalibrationTime (with atm cals) : " + time);
        return time;
    }

    private CalType mapCalibrationToSecondaryIntent(@NonNull CalObs calObs) {
        if (calObs == null) {
            throw new NullPointerException("calibrationObservation is marked non-null but is null");
        }
        if (calObs.getCalibratorSecondaryIntent().equals((Object)CalObs.CalibratorSecondaryIntentEnum.UNDEFINED)) {
            return calObs.getCalType();
        }
        return calObs.getSecondaryIntentCalType();
    }

    @Override
    public boolean isSBToBeExecutedUsingSessions() {
        if (this.scienceGoal == null) {
            throw new NullPointerException("Illegal argument - the argument scienceGoal cannot be null");
        }
        return this.scienceGoal.getSpectralSetupParameters().isFullPolarisation();
    }

    public int getWaterVapourContentUsed() {
        return this.scienceGoal.getRecommendedWVCIndex();
    }

    @Override
    public Time getTotalTimeForScienceGoal(@NonNull Boolean bl) throws UnableToCalculateTimeEstimateException {
        if (bl == null) {
            throw new NullPointerException("isOmitVisits is marked non-null but is null");
        }
        return this.getTotalTimeForScienceGoal(false, bl, false, true);
    }

    @Override
    public Time getTotalTimeForScienceGoal(@NonNull Boolean bl, @NonNull Boolean bl2, @NonNull Boolean bl3, @NonNull Boolean bl4) throws UnableToCalculateTimeEstimateException {
        Object object;
        if (bl == null) {
            throw new NullPointerException("isACAomitted is marked non-null but is null");
        }
        if (bl2 == null) {
            throw new NullPointerException("isVisitsOmitted is marked non-null but is null");
        }
        if (bl3 == null) {
            throw new NullPointerException("isTM2Omitted is marked non-null but is null");
        }
        if (bl4 == null) {
            throw new NullPointerException("isPolarisationMinimumToBeApplied is marked non-null but is null");
        }
        Integer n = Objects.hash(bl, bl2, bl3, bl4, this.scienceGoal.toXml());
        TimeDataCache timeDataCache = (TimeDataCache)scienceGoalTimeCache.get((Object)n);
        if (timeDataCache != null) {
            timeDataCache.restoreTimeData(this);
            return timeDataCache.getRequestedTime().deepCopy();
        }
        Time time = Time.createTimeSec(0.0);
        PerformanceParameters performanceParameters = this.scienceGoal.getPerformanceParameters();
        SpectralSetupParameters spectralSetupParameters = this.scienceGoal.getSpectralSetupParameters();
        if (spectralSetupParameters.getScienceSpectralWindowCount() == 0 && !spectralSetupParameters.isSpectralScan()) {
            throw new UnableToCalculateTimeEstimateException("No Spectral Window/Element is set.");
        }
        if (PerformanceParameters.DESIREDSENSITIVITYFREQUENCYMEASURE_USER.equals(performanceParameters.getDesiredSensitivityFrequencyMeasure()) && performanceParameters.getDesiredSensitivityReferenceFrequencyWidth().getContent() <= 0.0) {
            throw new UnableToCalculateTimeEstimateException("Positive \"Frequency Width\" value must be set in choosing \"User\" type as \"Bandwidth used for Sensitivity\".");
        }
        Time time2 = Time.createTime();
        boolean bl5 = this.scienceGoal.isStandAloneACA();
        boolean bl6 = false;
        try {
            bl6 = this.scienceGoal.isSolarScienceGoal();
        }
        catch (UnknownEntityException unknownEntityException) {
            throw new UnableToCalculateTimeEstimateException((Exception)((Object)unknownEntityException));
        }
        if (!bl5) {
            if (bl6) {
                time2 = this.getSolarExecutionTime(this.scienceGoal, true, Array.ARRAY_12M);
            } else {
                try {
                    time2 = performanceParameters.getNeedsMoreTime() ? performanceParameters.getDesiredTime().deepCopy().convertToFriendlyUnit() : this.getTotalRequestedTime(Array.ARRAY_12M, true, false, true).convertToFriendlyUnit();
                }
                catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                    throw new UnableToCalculateTimeEstimateException(invalidObsProgramParametersException);
                }
            }
        }
        Time time3 = Time.createTime();
        Time time4 = Time.createTime();
        boolean bl7 = performanceParameters.gettrueUseACA();
        boolean bl8 = performanceParameters.gettrueUseTP();
        if (bl5) {
            bl = false;
        }
        if (!bl.booleanValue() && Boolean.TRUE.equals(bl7)) {
            try {
                time3 = this.getTotalRequestedTime(Array.ARRAY_7M, true, false, true).convertToFriendlyUnit().convertToFriendlyUnit();
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                throw new UnableToCalculateTimeEstimateException(invalidObsProgramParametersException);
            }
            if (Boolean.TRUE.equals(bl8)) {
                try {
                    time4 = this.getTotalRequestedTime(Array.ARRAY_TP, true, false, true).convertToFriendlyUnit();
                }
                catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                    throw new UnableToCalculateTimeEstimateException(invalidObsProgramParametersException);
                }
            }
        }
        if (bl4.booleanValue()) {
            time.aggregate(this.adjustForFullPolarization(time2));
        } else {
            time.aggregate(time2);
        }
        try {
            Object object2 = object = time3.isGreaterThan((AbstractDoubleWithUnit)time4) ? time3 : time4;
            if (bl3.booleanValue()) {
                time.aggregate((Time)object);
            } else if (bl5) {
                time.aggregate((Time)object);
            } else {
                time.aggregate((Time)this.getTimeForSecond12mCompactArray(time2, bl4, true).plus((AbstractDoubleWithUnit)object));
            }
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            throw new UnableToCalculateTimeEstimateException(invalidObsProgramParametersException);
        }
        if (!bl2.booleanValue()) {
            time = this.factorInTimeConstrainedObserving(time, bl5 ? Array.ARRAY_7M : Array.ARRAY_12M);
        }
        object = TimeDataCache.builder();
        ((TimeDataCache.TimeDataCacheBuilder)object).OG1ExecutionTime(this.OG1ExecutionTime.deepCopy()).overheadTimeCalObs(this.overheadTimeCalObs.deepCopy()).requestedTime(time.deepCopy()).totalCalibrationSlewTime(this.totalCalibrationSlewTimes.deepCopy());
        scienceGoalTimeCache.put((Object)n, (Object)((TimeDataCache.TimeDataCacheBuilder)object).build());
        return time;
    }

    private List<TimeOnSourceData> getSBOnSourceData(@NonNull Array array, @NonNull SBRetriever sBRetriever) throws InvalidObsProgramParametersException {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (sBRetriever == null) {
            throw new NullPointerException("schedblockRetriever is marked non-null but is null");
        }
        ArrayList<TimeOnSourceData> arrayList = new ArrayList<TimeOnSourceData>(30);
        List<SchedBlock> list = sBRetriever.getSBs();
        for (SchedBlock schedBlock : list) {
            HashMap<String, Time> hashMap = new HashMap<String, Time>(50);
            Time time = Time.createTimeSec(0.0);
            Time time2 = Time.createTimeSec(0.0);
            int n = schedBlock.getSchedBlockControl().getExecutionCount();
            if (array.equals((Object)Array.ARRAY_7M) ? !schedBlock.isACA7mArraySB() : (array.equals((Object)Array.ARRAY_TP) ? !schedBlock.isTotalPowerScienceSB() : array.equals((Object)Array.ARRAY_12M) && !this.isTMSBToBeProcessed(schedBlock, list))) continue;
            for (ObservingGroup observingGroup : schedBlock.getObservingGroup()) {
                SBTimeEstimateHelper.GroupType groupType;
                Time time3 = Time.createTimeSec(0.0);
                try {
                    groupType = SBTimeEstimateHelper.GroupType.getGroupType(observingGroup.getName());
                }
                catch (SBTimeEstimateHelper.UnknownObservingGroupTypeException unknownObservingGroupTypeException) {
                    throw new InvalidObsProgramParametersException(unknownObservingGroupTypeException);
                }
                if (groupType.equals((Object)SBTimeEstimateHelper.GroupType.SCIENCE)) {
                    time2.setContent(0.0);
                    for (OrderedTarget orderedTarget : observingGroup.getOrderedTarget()) {
                        orderedTarget.getTarget().getFirstScienceParameters().ifPresent(scienceParameters -> {
                            Time time3 = scienceParameters.getIntegrationTime().getTime();
                            time2.aggregate(time3);
                            time3.aggregate(time3);
                        });
                    }
                }
                hashMap.put(observingGroup.getName(), time3);
            }
            TimeOnSourceData timeOnSourceData = new TimeOnSourceData(schedBlock, n);
            for (String string : hashMap.keySet()) {
                this.logger.fine("TOS for OG " + string + " is " + hashMap.get(string));
                timeOnSourceData.addTimeOnSourceForObservingGroup(string, (Time)hashMap.get(string));
            }
            arrayList.add(timeOnSourceData);
            this.logger.fine("Total on-source time recorded for SB (including intrascan latencies and " + n + " executions) " + schedBlock.getEntityID() + " is " + time);
        }
        return arrayList;
    }

    private static TimeOnSourceData getSBOnSourceData(@NonNull SchedBlock schedBlock) throws InvalidObsProgramParametersException {
        if (schedBlock == null) {
            throw new NullPointerException("schedBlock is marked non-null but is null");
        }
        HashMap<String, Time> hashMap = new HashMap<String, Time>(40);
        Time time = Time.createTimeSec(0.0);
        int n = schedBlock.getSchedBlockControl().getExecutionCount();
        for (ObservingGroup observingGroup : schedBlock.getObservingGroup()) {
            SBTimeEstimateHelper.GroupType groupType;
            Time time2 = Time.createTimeSec(0.0);
            try {
                groupType = SBTimeEstimateHelper.GroupType.getGroupType(observingGroup.getName());
            }
            catch (SBTimeEstimateHelper.UnknownObservingGroupTypeException unknownObservingGroupTypeException) {
                throw new InvalidObsProgramParametersException(unknownObservingGroupTypeException);
            }
            if (groupType.equals((Object)SBTimeEstimateHelper.GroupType.SCIENCE)) {
                time.setContent(0.0);
                for (OrderedTarget orderedTarget : observingGroup.getOrderedTarget()) {
                    Target target = orderedTarget.getTarget();
                    target.getFirstScienceParameters().ifPresent(scienceParameters -> {
                        Time time3 = scienceParameters.getIntegrationTime().getTime();
                        time.aggregate(time3);
                        time2.aggregate(time3);
                    });
                }
            }
            hashMap.put(observingGroup.getName(), time2);
        }
        TimeOnSourceData timeOnSourceData = new TimeOnSourceData(schedBlock, n);
        for (String string : hashMap.keySet()) {
            timeOnSourceData.addTimeOnSourceForObservingGroup(string, (Time)hashMap.get(string));
        }
        return timeOnSourceData;
    }

    private AtmCalList getNumberOfAtmCalsForPhaseCalibrations(boolean bl, boolean bl2, @NonNull Array array, @NonNull SBRetriever sBRetriever) throws InvalidObsProgramParametersException {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (sBRetriever == null) {
            throw new NullPointerException("sbRetriever is marked non-null but is null");
        }
        AtmCalList atmCalList = new AtmCalList();
        List<SchedBlock> list = sBRetriever.getSBs();
        for (SchedBlock schedBlock : list) {
            if (!array.equals((Object)Array.ARRAY_7M) ? array.equals((Object)Array.ARRAY_12M) && !this.isTMSBToBeProcessed(schedBlock, list) : !schedBlock.isACA7mArraySB()) continue;
            if (schedBlock.getScienceTargets().size() == 1) {
                if (!bl) continue;
                return atmCalList;
            }
            List<Target> list2 = schedBlock.getAllTargets(PhaseCalParameters.phaseCalParametersFilter);
            ObservingTimeCalculator.getAtmCalsOffPhaseCal(bl2, schedBlock, atmCalList, list2);
            if (!bl) continue;
            return atmCalList;
        }
        return atmCalList;
    }

    private static void getAtmCalsOffPhaseCal(boolean bl, @NonNull SchedBlock schedBlock, @NonNull AtmCalList atmCalList, @NonNull List<Target> list) throws InvalidObsProgramParametersException {
        if (schedBlock == null) {
            throw new NullPointerException("schedBlock is marked non-null but is null");
        }
        if (atmCalList == null) {
            throw new NullPointerException("calRelatedAtmCals is marked non-null but is null");
        }
        if (list == null) {
            throw new NullPointerException("phaseCals is marked non-null but is null");
        }
        if (list.isEmpty()) {
            return;
        }
        Time time = ObservingTimeCalculator.getSBOnSourceData(schedBlock).getTimeOnSourcePerSBExecution();
        if (Double.isInfinite(time.getContent())) {
            throw new InvalidObsProgramParametersException("Infinite time on source required - is the sensitivity set to zero?");
        }
        Target target = list.get(0);
        PhaseCalParameters phaseCalParameters = target.getPhaseCalParametersList()[0];
        assert (phaseCalParameters != null);
        long l = (long)AtmosphericTimer.getCycleTime(target.getSpectralSpec().getReceiverBand()).getSecs();
        Log.logger(ObservingTimeCalculator.class).fine("Atm cal cycleTime used: " + l + " for " + target.getSpectralSpec().getReceiverBand());
        long l2 = (long)phaseCalParameters.getCycleTime().getSecs();
        long l3 = 0L;
        long l4 = 0L;
        int n = 0;
        while ((double)n < time.getSecs()) {
            if ((l3 -= l2) <= 0L) {
                ++l4;
                l3 = l;
            }
            n = (int)((long)n + l2);
        }
        AtmCalsForSB atmCalsForSB = new AtmCalsForSB();
        atmCalsForSB.add(l4);
        atmCalsForSB.setSbExecutionCount(bl ? 1 : schedBlock.getSchedBlockControl().getExecutionCount());
        atmCalList.add(atmCalsForSB);
    }

    private AtmCalList getNumberOfAtmCalsForScienceTargets(boolean bl, boolean bl2, @NonNull Array array, @NonNull SBRetriever sBRetriever) throws InvalidObsProgramParametersException {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (sBRetriever == null) {
            throw new NullPointerException("sbRetriever is marked non-null but is null");
        }
        AtmCalList atmCalList = new AtmCalList();
        List<SchedBlock> list = sBRetriever.getSBs();
        for (SchedBlock schedBlock : list) {
            if (!array.equals((Object)Array.ARRAY_7M) ? array.equals((Object)Array.ARRAY_12M) && !this.isTMSBToBeProcessed(schedBlock, list) : !schedBlock.isACA7mArraySB()) continue;
            List<Target> list2 = schedBlock.getScienceTargets();
            if (list2 == null || list2.size() == 0) {
                Log.logger(ObservingTimeCalculator.class).warning("No science targets found in SB");
                continue;
            }
            if (list2.size() > 1) {
                if (!bl) continue;
                return atmCalList;
            }
            ObservingTimeCalculator.getAtmCalsForScienceTargetsForSB(bl2, atmCalList, schedBlock);
            if (!bl) continue;
            return atmCalList;
        }
        return atmCalList;
    }

    private static void getAtmCalsForScienceTargetsForSB(boolean bl, @NonNull AtmCalList atmCalList, @NonNull SchedBlock schedBlock) {
        if (atmCalList == null) {
            throw new NullPointerException("scienceAtmCalsList is marked non-null but is null");
        }
        if (schedBlock == null) {
            throw new NullPointerException("schedBlock is marked non-null but is null");
        }
        AtmCalsForSB atmCalsForSB = new AtmCalsForSB();
        List<Target> list = schedBlock.getScienceTargets();
        for (Target target : list) {
            ScienceParameters scienceParameters = target.getScienceParametersList()[0];
            assert (scienceParameters != null);
            Time time = AtmosphericTimer.getCycleTime(target.getSpectralSpec().getReceiverBand());
            Log.logger(ObservingTimeCalculator.class).fine("Atm cal cycleTime used: " + time + " for " + target.getSpectralSpec().getReceiverBand());
            assert (time != null && !time.isZero());
            long l = (long)Math.ceil(scienceParameters.getIntegrationTime().getSecs() / time.getSecs());
            atmCalsForSB.add(l);
            atmCalsForSB.setSbExecutionCount(bl ? 1 : schedBlock.getSchedBlockControl().getExecutionCount());
        }
        atmCalList.add(atmCalsForSB);
    }

    private static Time getCalibrationTimesEstimateFromSB(@NonNull SchedBlock schedBlock, @NonNull ScienceGoal scienceGoal) throws InvalidObsProgramParametersException, SBTimeEstimateHelper.UnknownObservingGroupTypeException, SourceNeverVisibleException {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        Integer n = Objects.hash(schedBlock, scienceGoal.toXml());
        Time time = (Time)calibrationTimeFromSBCache.get((Object)n);
        if (time != null) {
            // empty if block
        }
        ObservingTimeCalculator observingTimeCalculator = new ObservingTimeCalculator(scienceGoal);
        Array array = schedBlock.getSbGenerationContext().getArray().getArray();
        SBRetriever sBRetriever = () -> ImmutableList.of((Object)schedBlock);
        Time time2 = observingTimeCalculator.getCalibrationExecutionTimeStats(true, array, scienceGoal.getKeyTargetParameters(), false, sBRetriever);
        Time time3 = observingTimeCalculator.getCalibrationSlewTimes();
        Time time4 = observingTimeCalculator.getOverheadTimeForCalObs();
        Time time5 = (Time)((Time)time2.plus((AbstractDoubleWithUnit)time3)).plus((AbstractDoubleWithUnit)time4);
        calibrationTimeFromSBCache.put((Object)n, (Object)time5);
        return time5;
    }

    private static Time getOnSourceOverheadsTime(@NonNull SchedBlock schedBlock) throws InvalidObsProgramParametersException {
        if (schedBlock == null) {
            throw new NullPointerException("schedBlock is marked non-null but is null");
        }
        int n = 0;
        for (ObservingGroup observingGroup : schedBlock.getObservingGroup()) {
            SBTimeEstimateHelper.GroupType groupType;
            try {
                groupType = SBTimeEstimateHelper.getGroupType(observingGroup.getName());
            }
            catch (SBTimeEstimateHelper.UnknownObservingGroupTypeException unknownObservingGroupTypeException) {
                throw new InvalidObsProgramParametersException(unknownObservingGroupTypeException);
            }
            if (!groupType.equals((Object)SBTimeEstimateHelper.GroupType.SCIENCE)) continue;
            for (OrderedTarget orderedTarget : observingGroup.getOrderedTarget()) {
                Target target = orderedTarget.getTarget();
                for (ScienceParameters scienceParameters : target.getScienceParametersList()) {
                    double d = scienceParameters.getSubScanDuration().getContentInDefaultUnits();
                    n += (int)Math.ceil(((IntTimeSource)scienceParameters.getIntegrationTime().divide(d)).getContent());
                }
            }
        }
        return (Time)((Time)SUBSCAN_LATENCY.multiply(n)).plus((AbstractDoubleWithUnit)SB_EXEC_OVERHEAD);
    }

    public static Time getTotalTOSTimeForSB(@NonNull SchedBlock schedBlock, boolean bl) throws InvalidObsProgramParametersException, SBTimeEstimateHelper.UnknownObservingGroupTypeException {
        if (schedBlock == null) {
            throw new NullPointerException("schedBlock is marked non-null but is null");
        }
        Time time = Time.createTimeSec(0.0);
        time.aggregate(ObservingTimeCalculator.getSBOnSourceData(schedBlock).getTimeOnSourcePerSBExecution());
        if (!bl) {
            time = (Time)time.multiply(schedBlock.getSchedBlockControl().getExecutionCount());
        }
        return time;
    }

    public static Time getExecutionTimeForSB(@NonNull SchedBlock schedBlock, @NonNull ScienceGoal scienceGoal) throws InvalidObsProgramParametersException, SBTimeEstimateHelper.UnknownObservingGroupTypeException {
        Time time;
        if (schedBlock == null) {
            throw new NullPointerException("schedBlock is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        try {
            SchedBlockPostProcessor.reviseCheckSourceObservingParameters(schedBlock, scienceGoal);
        }
        catch (SchedBlock.UnableToFindParentScienceGoalException unableToFindParentScienceGoalException) {
            throw new InvalidObsProgramParametersException(unableToFindParentScienceGoalException);
        }
        Time time2 = Time.createTimeSec(0.0);
        try {
            time = ObservingTimeCalculator.getCalibrationTimesEstimateFromSB(schedBlock, scienceGoal);
        }
        catch (SourceNeverVisibleException sourceNeverVisibleException) {
            throw new InvalidObsProgramParametersException(sourceNeverVisibleException);
        }
        time2.aggregate(ObservingTimeCalculator.getSBOnSourceData(schedBlock).getTimeOnSourcePerSBExecution());
        time2.aggregate(ObservingTimeCalculator.getOnSourceOverheadsTime(schedBlock));
        if (Log.logger(ObservingTimeCalculator.class).fine()) {
            Log.logger(ObservingTimeCalculator.class).fine("Execution time (mins) for a single SB execution is : " + time2.getContentInUnits(Time.UNIT_MIN));
            Log.logger(ObservingTimeCalculator.class).fine("Calibration times : " + time);
            Log.logger(ObservingTimeCalculator.class).fine("On-source time : " + ObservingTimeCalculator.getSBOnSourceData(schedBlock).getTimeOnSourcePerSBExecution());
            Log.logger(ObservingTimeCalculator.class).fine("Total on source time : " + ObservingTimeCalculator.getSBOnSourceData(schedBlock).getTimeOnSourcePerSBExecution().multiply(schedBlock.getSchedBlockControl().getExecutionCount()));
            Log.logger(ObservingTimeCalculator.class).fine("On-source overheads : " + ObservingTimeCalculator.getOnSourceOverheadsTime(schedBlock));
            Log.logger(ObservingTimeCalculator.class).fine("Total calculated SB execution time is : " + time2.multiply(schedBlock.getSchedBlockControl().getExecutionCount()));
        }
        return (Time)((Time)time2.multiply(schedBlock.getSchedBlockControl().getExecutionCount())).plus((AbstractDoubleWithUnit)time);
    }

    public int getSBExecutionCount(@NonNull Array array) throws InvalidObsProgramParametersException, UnknownEntityException {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        this.generateSBs(this.scienceGoal);
        ObsUnitSet obsUnitSet = this.obsUnitSet.getObsUnitSet(0).getObsUnitSet(0);
        block4: for (SchedBlock schedBlock : obsUnitSet.findSchedBlocks()) {
            switch (array) {
                case ARRAY_12M: {
                    if (!schedBlock.is12mExtendedArraySB()) continue block4;
                    return schedBlock.getSchedBlockControl().getExecutionCount();
                }
                case ARRAY_7M: {
                    if (!schedBlock.isACA7mArraySB()) continue block4;
                    return schedBlock.getSchedBlockControl().getExecutionCount();
                }
            }
            throw new RuntimeException("Unable to process array type " + array);
        }
        return 0;
    }

    @Override
    public List<Phase1DataRateCalculator.SpectralSpecDataRate> getInstantaneousBaseBandBasedDataRates(@NonNull RequestedArray requestedArray) throws Phase1DataRateCalculator.UnableToDetermineInstantaneousDataRateException {
        if (requestedArray == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return this.phase1DataRateCalculator.getInstantaneousBaseBandBasedDataRates(requestedArray);
    }

    @Override
    public DataRate getAverageDataRate(@NonNull Array array) throws Phase1DataRateCalculator.UnableToDetermineInstantaneousDataRateException {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return this.phase1DataRateCalculator.getAverageDataRate(array);
    }

    @Override
    public Map<SpectralSpec, DataRate> getInstantaneousSpectralSpecBasedDataRates(RequestedArray requestedArray) throws Phase1DataRateCalculator.UnableToDetermineInstantaneousDataRateException {
        return this.phase1DataRateCalculator.getInstantaneousSpectralSpecBasedDataRates(requestedArray);
    }

    @Override
    public DataRate getPeakDataRate(@NonNull Array array, boolean bl) throws Phase1DataRateCalculator.UnableToDetermineInstantaneousDataRateException {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return this.phase1DataRateCalculator.getPeakDataRate(array, bl);
    }

    @Override
    public StorageVolume getDataVolume(@NonNull Array array) throws InvalidObsProgramParametersException {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return this.phase1DataRateCalculator.getDataVolume(array);
    }

    public List<SchedBlock> getSBsViaSBGeneration() {
        List<SchedBlock> list;
        try {
            this.obsUnitSet = this.generateSBs(this.scienceGoal);
            list = this.obsUnitSet.findSchedBlocks();
        }
        catch (UnknownEntityException | InvalidObsProgramParametersException throwable) {
            throw new WizardSBGenerationException("Unable to get SBs " + throwable.getMessage());
        }
        return list;
    }

    public boolean isNoSBGenerationToBePerformed() {
        return this.isNoSBGenerationToBePerformed;
    }

    public void setOG1ExecutionTime(Time time) {
        this.OG1ExecutionTime = time;
    }

    public void setOverheadTimeCalObs(Time time) {
        this.overheadTimeCalObs = time;
    }

    public void setTotalCalibrationSlewTimes(Time time) {
        this.totalCalibrationSlewTimes = time;
    }

    public static class Builder {
        private ScienceGoal scienceGoal;
        private double beamsize_factor = 0.0;
        private ObsUnitSet obsUnitSet;
        private boolean noSBGeneration = false;

        public Builder scienceGoal(ScienceGoal scienceGoal) {
            this.scienceGoal = scienceGoal;
            return this;
        }

        public Builder noSBGeneration(boolean bl) {
            this.noSBGeneration = bl;
            return this;
        }

        public Builder beamsize_factor(double d) {
            this.beamsize_factor = d;
            return this;
        }

        public Builder obsUnitSet(ObsUnitSet obsUnitSet) {
            this.obsUnitSet = obsUnitSet;
            return this;
        }

        public ObservingTimeCalculator build() {
            return new ObservingTimeCalculator(this);
        }
    }

    public static class UnableToCalculateTimeEstimateException
    extends Exception {
        private static final long serialVersionUID = -1772549598515572045L;

        private UnableToCalculateTimeEstimateException(String string) {
            super(string);
        }

        private UnableToCalculateTimeEstimateException(Exception exception) {
            super(exception);
        }
    }

    public static enum CalibrationOverheads {
        CALIBRATIONEXECTIMES,
        ONSOURCEOVERHEADS,
        CALIBRATIONOVERHEADS,
        CALIBRATIONSLEWTIME;

    }
}

