/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.calibration;

import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.services.calibration.CalObs;
import alma.obsprep.services.calibration.CalTimeEditor;
import alma.obsprep.services.calibration.CalType;
import alma.obsprep.services.calibration.CalibrationTimeEstimaterTest;
import alma.obsprep.services.calibration.CalibrationTimeModel;
import alma.obsprep.services.calibration.CycleTimeEditor;
import alma.obsprep.services.calibration.PhaseCalObs;
import alma.obsprep.util.TextUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class CalibrationTimeEstimater
extends EditorWithGridBagLayout {
    public static final FieldID calTypeFid = new FieldID("CalibrationTimeEstimater.calType");
    public static final FieldID timePanelFid = new FieldID("CalibrationTimeEstimater.timePanel");
    public static final FieldID cyclePanelFid = new FieldID("CalibrationTimeEstimater.cyclePanel");
    public static final FieldID closeBtnFid = new FieldID("CalibrationTimeEstimater.closeBtn");
    private CalObsCollection collection = new CalObsCollection();

    public CalibrationTimeEstimater(Model model) {
        this.setModel(model);
        this.build();
        model.publish();
    }

    @Override
    public CalibrationTimeModel getModel() {
        return (CalibrationTimeModel)super.getModel();
    }

    @Override
    protected void build() {
        super.build("");
        this.register(this, CalibrationTimeModel.documentFid);
    }

    @Override
    protected void addComponents(String string) {
        this.constraints.anchor = 18;
        this.constraints.weighty = 0.0;
        EditorWithGridBagLayout.ComponentCollection componentCollection = new EditorWithGridBagLayout.ComponentCollection(this);
        JComboBox jComboBox = this.makeComboBox(calTypeFid, TextUtils.enumsToStringArray(CalObs.supportedCal), "Select calibration type to estimate");
        componentCollection.remember(this.makeLabel("Calibration Type"));
        componentCollection.remember(this.makeLabel(" "));
        componentCollection.remember(jComboBox);
        this.addComponentArray(this, this.layout, this.constraints, componentCollection);
        this.addVerticalSpace(this, this.layout, this.constraints);
        EditorWithGridBagLayout editorWithGridBagLayout = new CalTimeEditor(this.getModel());
        this.register(editorWithGridBagLayout, timePanelFid);
        this.addComponent(editorWithGridBagLayout);
        editorWithGridBagLayout = new CycleTimeEditor(this.getModel());
        this.register(editorWithGridBagLayout, cyclePanelFid);
        this.addComponent(editorWithGridBagLayout);
        this.constraints.weighty = 1.0;
        this.addVerticalSpace(this, this.layout, this.constraints);
        this.constraints.weighty = 0.0;
        this.addControlButtonBox();
    }

    private void addControlButtonBox() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.makeButton(closeBtnFid, "Close", "Close this window"), "East");
        this.addComponent(jPanel);
    }

    public void updatePanelView(CalObs calObs) {
        if (calObs == null) {
            return;
        }
        JComboBox jComboBox = (JComboBox)this.retrieve(calTypeFid);
        this.set((JComponent)jComboBox, (Object)calObs.getCalType());
        JPanel jPanel = (JPanel)this.retrieve(cyclePanelFid);
        boolean bl = calObs instanceof PhaseCalObs;
        jPanel.setVisible(bl);
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (fieldID.equals(CalibrationTimeModel.documentFid)) {
            this.updatePanelView((CalObs)object);
            return;
        }
        if (fieldID.equals(timePanelFid) || fieldID.equals(cyclePanelFid)) {
            return;
        }
        if (fieldID.equals(calTypeFid)) {
            super.update(fieldID, (String)object);
            CalType calType = CalType.getCalType((String)object);
            this.getModel().setDocument(this.collection.get(calType));
            return;
        }
        if (fieldID.equals(closeBtnFid)) {
            this.getRootPane().getParent().setVisible(false);
            return;
        }
        super.update(fieldID, object);
    }

    public CalObsCollection getCalObsCollection() {
        return this.collection;
    }

    public static void main(String[] stringArray) {
        InitServices.initModelSupportClasses();
        System.setProperty("Telescope", "Cycle8");
        System.setProperty("otData.dir", "config/otData");
        CalibrationTimeEstimaterTest calibrationTimeEstimaterTest = new CalibrationTimeEstimaterTest();
        calibrationTimeEstimaterTest.testBandpass();
    }

    public class CalObsCollection
    extends HashMap<CalType, CalObs> {
        private ScienceGoal scienceGoal;

        public CalObsCollection() {
        }

        public CalObsCollection(ScienceGoal scienceGoal) {
            this();
            this.setScienceGoal(scienceGoal);
        }

        public void setScienceGoal(ScienceGoal scienceGoal) {
            this.clear();
            this.scienceGoal = scienceGoal;
        }

        public CalObs get(CalType calType) {
            CalObs calObs = (CalObs)super.get((Object)calType);
            if (calObs == null) {
                calObs = CalObs.createCalObs(calType, this.scienceGoal);
                this.put(calType, calObs);
            }
            return calObs;
        }
    }
}

