/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.calibration;

import alma.obsprep.bo.enumerations.CorrFilter;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.schedblock.CorrConfigMode;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.services.calibration.CalObs;
import alma.obsprep.services.calibration.CalType;
import alma.obsprep.services.experts.InvalidFrequencyException;
import alma.valuetypes.Flux;
import alma.valuetypes.Frequency;
import alma.valuetypes.Time;

public class BandpassCalObs
extends CalObs {
    public BandpassCalObs() {
        this.setCalType(CalType.Bandpass);
    }

    public BandpassCalObs(ScienceGoal scienceGoal) {
        this();
        this.scienceGoal = scienceGoal;
        this.configure();
    }

    public static int getBinSize(CorrFilter corrFilter) {
        switch (corrFilter) {
            case TDM: {
                return BandpassCalObs.getCalObsProperties().getBandpassCalBinsizeTDM();
            }
            case TFB: {
                return BandpassCalObs.getCalObsProperties().getBandpassCalBinsizeFDM();
            }
        }
        throw new IllegalArgumentException("Unexpected filter : " + corrFilter);
    }

    @Override
    public boolean atmCalRequired(SchedBlock schedBlock) {
        return true;
    }

    @Override
    public Frequency getDefaultChannelWidth() {
        if (this.scienceGoal == null || this.scienceGoal.getSpectralSetupParameters().getAbstractScienceSpectralWindowCount() == 0) {
            return Frequency.createFrequencyMHZ(0.48828125);
        }
        ScienceSpectralWindow scienceSpectralWindow = this.scienceGoal.getSpectralSetupParameters().getStringentSpectralWindow();
        CorrConfigMode corrConfigMode = scienceSpectralWindow.getCorrConfigMode();
        CorrFilter corrFilter = corrConfigMode.getFilter();
        int n = BandpassCalObs.getBinSize(corrFilter);
        Frequency frequency = (Frequency)scienceSpectralWindow.getSpectralResolution().multiply(n);
        return frequency;
    }

    @Override
    public double getDefaultSNR() {
        return BandpassCalObs.getCalObsProperties().getBandpassCalSNR();
    }

    @Override
    public Flux getDefaultFlux() {
        Flux flux = BandpassCalObs.getCalObsProperties().getBandpassFlux();
        try {
            ReceiverBand receiverBand = this.getCalibrationReceiverBand();
            if (receiverBand.getNumber() >= 7) {
                return BandpassCalObs.getCalObsProperties().getBandpassStrongFlux();
            }
            return flux;
        }
        catch (InvalidFrequencyException invalidFrequencyException) {
            return flux;
        }
    }

    @Override
    public Time rawCycleTime() {
        if (this.SBSuggestedCalibrationCycleTime != null) {
            return this.SBSuggestedCalibrationCycleTime;
        }
        return BandpassCalObs.getCalObsProperties().getBandpassCycleTime();
    }
}

