/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.valdef.schedblock;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.OpticalCameraSpec;
import alma.obsprep.bo.schedblock.Reference;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.ot.valdef.AbstractValidator;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.ot.valdef.schedblock.ValidatorUtils;
import alma.obsprep.problems.DefaultProblem;
import alma.obsprep.problems.Problem;
import alma.valuetypes.Time;

public class ReferenceValidator
extends AbstractValidator {
    public ReferenceValidator() {
        this.setValidatorThreadSafe(true);
    }

    @Override
    protected void localValidate(BusinessObject businessObject, ProblemListModel problemListModel) {
        double d;
        Problem problem;
        Reference reference = (Reference)businessObject;
        double d2 = reference.getCycleTime().getContentInUnits(Time.UNIT_S);
        if (d2 <= 0.0) {
            problem = DefaultProblem.createError("Reference position cycle time is invalid", "Set the time to a sensible value", (IBusinessObject)reference);
            problemListModel.add(problem);
        }
        if ((d = reference.getIntegrationTime().getContentInUnits(Time.UNIT_S)) <= 0.0) {
            problem = DefaultProblem.createError("Reference position integration time is invalid", "Set the time to a sensible value", (IBusinessObject)reference);
            problemListModel.add(problem);
        }
        if (reference.getSubScanDuration().getContentInDefaultUnits() <= 0.0) {
            problem = DefaultProblem.createError("Reference Position subscan duration is invalid", "Set the time to a sensible value", (IBusinessObject)reference);
            problemListModel.add(problem);
        }
        FieldSource fieldSource = (FieldSource)reference.getParent();
        Target[] targetArray = fieldSource.getTargetList();
        for (int i = 0; i < targetArray.length; ++i) {
            Time time;
            if (targetArray[i].getAbstractInstrumentSpec() == null || targetArray[i].getAbstractInstrumentSpec() instanceof OpticalCameraSpec || targetArray[i].hasScienceParameters()) continue;
            Time time2 = reference.getSubScanDuration();
            if (!ValidatorUtils.isIntegralMultipleTime(time2, time = ((SpectralSpec)((Object)targetArray[i].getAbstractInstrumentSpec())).getCorrelatorConfiguration().getIntegrationDuration())) {
                problem = DefaultProblem.createError("Subscan duration in reference position is not a multiple of the integration duration in the associated instrument setup", "Correct the value of the subscan duration", (IBusinessObject)businessObject);
                problemListModel.add(problem);
            }
            if (ValidatorUtils.isIntegralMultipleControlRequiredBase(time2)) continue;
            problem = DefaultProblem.createError("Subscan duration in reference position is not a multiple of 48.0 ms", "Correct the value of the subscan duration", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
    }
}

