/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.valdef.obsproject;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.enumerations.Antenna;
import alma.obsprep.bo.obsproject.MonitoringConstraint;
import alma.obsprep.bo.obsproject.NonOverlappingBandwidthCalculator;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.Rectangle;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproject.TemporalParameters;
import alma.obsprep.bo.obsproject.VisitConstraint;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.ot.models.sciencegoals.AngularResolutionMode;
import alma.obsprep.ot.models.sciencegoals.SfiControlParameterModel;
import alma.obsprep.ot.valdef.AbstractValidator;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.ot.valdef.obsproject.LoopingTimeConstraintsException;
import alma.obsprep.problems.DefaultProblem;
import alma.obsprep.problems.Problem;
import alma.obsprep.services.etc.ObservingTimeCalculator;
import alma.obsprep.services.etc.SourceClusterDetector;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.experts.ConfigurationHelper;
import alma.obsprep.services.experts.ConfigurationSet;
import alma.obsprep.services.experts.InvalidConfigurationParametersException;
import alma.obsprep.services.experts.MinBoundingBoxExpert;
import alma.obsprep.services.experts.VLBIExpert;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.Sensitivity;
import alma.valuetypes.Time;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import lombok.NonNull;

public class PerformanceParametersValidator
extends AbstractValidator {
    private static final AlmaPolicies almaPolicies = AlmaPolicies.getInstance();
    private static final double MAX_PROP_TIME_HOURS = almaPolicies.getMaxStandardProposalTime().getContentInUnits(Time.UNIT_H);
    private static final double FWHM_MULTIPLIER = 1.54;

    public PerformanceParametersValidator() {
        this.setValidatorThreadSafe(false);
    }

    @Override
    protected void localValidate(BusinessObject businessObject, ProblemListModel problemListModel) {
        PerformanceParameters performanceParameters = (PerformanceParameters)businessObject;
        BusinessObject businessObject2 = businessObject.getParent();
        assert (businessObject2 instanceof ScienceGoal);
        ScienceGoal scienceGoal = (ScienceGoal)businessObject2;
        ScienceGoal.ScienceGoalMode scienceGoalMode = null;
        try {
            scienceGoalMode = scienceGoal.getScienceGoalMode();
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(PerformanceParametersValidator.class).info("Unable to determine the science goal mode  : " + unknownEntityException.getMessage());
        }
        assert (scienceGoalMode != null);
        boolean bl = false;
        try {
            bl = scienceGoal.getObsProposal().isVLBIorPhasedArray();
        }
        catch (UnknownEntityException | NullPointerException throwable) {
            Log.logger(PerformanceParametersValidator.class).warning("Unable to determine whether proposal is a VLBI proposal");
            bl = false;
        }
        if (bl) {
            this.performVLBISpecificValidations(businessObject, problemListModel, performanceParameters, scienceGoalMode);
        } else {
            try {
                this.performStandardValidations(businessObject, problemListModel, performanceParameters, scienceGoalMode);
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                problemListModel.addProblemToBuffer(DefaultProblem.createError("Unable to execute performance parameters validation", "Revise your setup.", (IBusinessObject)performanceParameters));
            }
        }
        if (performanceParameters.getDesiredDynamicRange() <= 0.0) {
            performanceParameters.setDesiredDynamicRange(10.0);
        }
        try {
            this.validateExtraTimeRequested(problemListModel, performanceParameters, scienceGoal, bl);
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(PerformanceParametersValidator.class).warning("Unable to perform extra time validation " + unknownEntityException.getMessage());
        }
        this.validateLASAgainstAllSources(businessObject, problemListModel, scienceGoal, performanceParameters);
    }

    private void validateLASAgainstAllSources(@NonNull BusinessObject businessObject, @NonNull ProblemListModel problemListModel, @NonNull ScienceGoal scienceGoal, @NonNull PerformanceParameters performanceParameters) {
        if (businessObject == null) {
            throw new NullPointerException("bo is marked non-null but is null");
        }
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("userDefinedSG is marked non-null but is null");
        }
        if (performanceParameters == null) {
            throw new NullPointerException("performanceParameters is marked non-null but is null");
        }
        Frequency frequency = performanceParameters.getRepresentativeFrequencyWithSkyOffset();
        Antenna antenna = performanceParameters.isAngularResolutionModeSACA() ? Antenna.ANTENNA_7M : Antenna.ANTENNA_12M;
        Angle angle = (Angle)antenna.getBeamSize(frequency).multiply(1.54);
        Angle angle2 = performanceParameters.getDesiredLargestScale();
        boolean bl = false;
        for (TargetParameters targetParameters : scienceGoal.getTargetParameters()) {
            boolean bl2;
            boolean bl3 = targetParameters.isPointingPattern();
            boolean bl4 = bl3 && targetParameters.getNumberOfPointings() == 1;
            boolean bl5 = bl2 = bl3 && targetParameters.getNumberOfPointings() > 1;
            if (bl4 && angle2.isGreaterThan((AbstractDoubleWithUnit)angle)) {
                bl = true;
            }
            if (targetParameters.isRectanglePattern() && this.isLASTooBigForRectangle(targetParameters, angle2, angle)) {
                bl = true;
            }
            if (bl2 && this.isLASTooBigForCustomMosaic(targetParameters, angle2, angle)) {
                bl = true;
            }
            if (bl) break;
        }
        if (bl) {
            problemListModel.addProblemToBuffer(DefaultProblem.createError("One or more sources in this Science Goal do not achieve adequate sky coverage for the requested LAS", "Reduce the LAS or increase the size of your mapping area(s).", (IBusinessObject)performanceParameters));
        }
    }

    private boolean isLASTooBigForRectangle(@NonNull TargetParameters targetParameters, @NonNull Angle angle, @NonNull Angle angle2) {
        if (targetParameters == null) {
            throw new NullPointerException("targetParameters is marked non-null but is null");
        }
        if (angle == null) {
            throw new NullPointerException("las is marked non-null but is null");
        }
        if (angle2 == null) {
            throw new NullPointerException("fwhmPlusTolerance is marked non-null but is null");
        }
        if (!targetParameters.isRectanglePattern()) {
            throw new IllegalArgumentException("Illegal argument: targetParameters.isRectanglePattern() (" + targetParameters.isRectanglePattern() + ") did not pass the test: targetParameters.isRectanglePattern() ");
        }
        Rectangle rectangle = targetParameters.getFieldRectangle()[0];
        double d = rectangle.getLong().getArcsec();
        double d2 = rectangle.getShort().getArcsec();
        Angle angle3 = (Angle)Angle.createAngleArcsec(Math.sqrt(Math.pow(d, 2.0) + Math.pow(d2, 2.0))).plus((AbstractDoubleWithUnit)angle2);
        return angle.isGreaterThan((AbstractDoubleWithUnit)angle3);
    }

    private boolean isLASTooBigForCustomMosaic(@NonNull TargetParameters targetParameters, @NonNull Angle angle, @NonNull Angle angle2) {
        if (targetParameters == null) {
            throw new NullPointerException("targetParameters is marked non-null but is null");
        }
        if (angle == null) {
            throw new NullPointerException("las is marked non-null but is null");
        }
        if (angle2 == null) {
            throw new NullPointerException("fwhmPlusTolerance is marked non-null but is null");
        }
        Rectangle rectangle = MinBoundingBoxExpert.getBoundingRectangle(targetParameters);
        double d = rectangle.getLong().getArcsec();
        double d2 = rectangle.getShort().getArcsec();
        Angle angle3 = (Angle)Angle.createAngleArcsec(Math.sqrt(Math.pow(d, 2.0) + Math.pow(d2, 2.0))).plus((AbstractDoubleWithUnit)angle2);
        return angle.isGreaterThan((AbstractDoubleWithUnit)angle3);
    }

    private void performVLBISpecificValidations(@NonNull BusinessObject businessObject, @NonNull ProblemListModel problemListModel, @NonNull PerformanceParameters performanceParameters, @NonNull ScienceGoal.ScienceGoalMode scienceGoalMode) {
        if (businessObject == null) {
            throw new NullPointerException("bo is marked non-null but is null");
        }
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (performanceParameters == null) {
            throw new NullPointerException("performanceParameters is marked non-null but is null");
        }
        if (scienceGoalMode == null) {
            throw new NullPointerException("scienceGoalMode is marked non-null but is null");
        }
        if (performanceParameters.getUseACA()) {
            Problem problem = DefaultProblem.createError("The ACA cannot be scheduled when the proposal type is VLBI", "Deselect the ACA or change the proposal type.", (IBusinessObject)performanceParameters);
            problemListModel.addProblemToBuffer(problem);
        }
        this.validateTimeConstrainedConfiguration(problemListModel, performanceParameters, false, businessObject, scienceGoalMode);
        this.validateVLBISpectralLineMode(problemListModel, performanceParameters);
    }

    private void validateVLBISpectralLineMode(@NonNull ProblemListModel problemListModel, @NonNull PerformanceParameters performanceParameters) {
        boolean bl;
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (performanceParameters == null) {
            throw new NullPointerException("pp is marked non-null but is null");
        }
        SpectralSetupParameters spectralSetupParameters = performanceParameters.getScienceGoal().getSpectralSetupParameters();
        boolean bl2 = false;
        try {
            if (VLBIExpert.IS_VLBI_SPECTRALLINE_ENABLED && ObsProposal.isProposalVLBI() && spectralSetupParameters.isSpectralLine()) {
                bl2 = true;
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(PerformanceParametersValidator.class).warning("Unable to determine if the project type is VLBI");
        }
        if (!bl2) {
            return;
        }
        boolean bl3 = bl = performanceParameters.getIsTimeConstrained() && performanceParameters.getTemporalParametersCount() == 1;
        if (!bl) {
            Problem problem = DefaultProblem.createError("A date for the observation should be entered using the time-constraint interface", "Enter a single visit on the Control & Performance editor.", (IBusinessObject)performanceParameters);
            problemListModel.addProblemToBuffer(problem);
        }
    }

    private void performStandardValidations(BusinessObject businessObject, ProblemListModel problemListModel, PerformanceParameters performanceParameters, ScienceGoal.ScienceGoalMode scienceGoalMode) throws InvalidObsProgramParametersException {
        Problem problem;
        Object object;
        Object object2;
        Collection<ScienceGoal> collection;
        ScienceGoal scienceGoal = performanceParameters.getScienceGoal();
        SourceClusterDetector sourceClusterDetector = new SourceClusterDetector(scienceGoal);
        try {
            collection = sourceClusterDetector.splitScienceGoalIntoSourceClusters();
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            throw new WizardSBGenerationException(invalidObsProgramParametersException);
        }
        for (ScienceGoal scienceGoal2 : collection) {
            this.validateTPNotUsedWithFPAndSACA(scienceGoal2, problemListModel, businessObject, scienceGoal);
            boolean bl = false;
            object2 = scienceGoal2.getPerformanceParameters();
            double d = object2.getDesiredAngularResolution().getContentInUnits(Angle.UNIT_ARCSEC);
            Frequency frequency = ((PerformanceParameters)object2).getRepresentativeFrequencyWithSkyOffset();
            double d2 = frequency.getContentInGHz();
            double d3 = object2.getDesiredLargestScale().getContentInUnits(Angle.UNIT_ARCSEC);
            RequestedArray requestedArray = scienceGoal2.isStandAloneACA() ? RequestedArray.SEVEN_M : RequestedArray.TWELVE_M;
            try {
                Object object3;
                TargetParameters[] targetParametersArray = scienceGoal2.getTargetParameters();
                Configuration configuration = Configuration.getBestConfiguration(d2, requestedArray, scienceGoal2);
                if (!scienceGoalMode.equals((Object)ScienceGoal.ScienceGoalMode.SOLAR) && Configuration.getIsSecondConfigurationRequired(configuration, d3, d2, scienceGoal2, requestedArray, false)) {
                    try {
                        object = Configuration.getSecondCompactConfiguration(configuration);
                        bl = true;
                    }
                    catch (InvalidConfigurationParametersException invalidConfigurationParametersException) {
                        object = configuration;
                    }
                } else {
                    object = configuration;
                }
                double d4 = ((Configuration)object).getRecoverableScale(d2, targetParametersArray, requestedArray);
                if (!((Configuration)object).acaAllowed() && object2.getUseACA()) {
                    problem = DefaultProblem.createWarning("It is not possible to use the ACA with the 12-m array configurations required", "Select the Control Parameters in the Science Goal and deselect the ACA", (IBusinessObject)businessObject);
                    problemListModel.addProblemToBuffer(problem);
                } else if (d3 > d4 && !object2.getUseACA()) {
                    object3 = scienceGoal2.getSpectralSetupParameters();
                    Set<Configuration> set = Configuration.getLongBaseLineConfigurations();
                    if (!set.contains(configuration)) {
                        problem = DefaultProblem.createWarning("Largest scale is not achievable with the 12-m array configurations required for the resolution", "Select the Control Parameters in the Science Goal and reduce the value", (IBusinessObject)businessObject);
                        problemListModel.addProblemToBuffer(problem);
                    }
                    if (((SpectralSetupParameters)((Object)object3)).isFullPolarisation()) {
                        problem = DefaultProblem.createError("LAS cannot be achieved as the ACA cannot be used with full-polarization setups", "Reduce requested source angular size", (IBusinessObject)businessObject);
                        problemListModel.addProblemToBuffer(problem);
                    }
                    if (((SpectralSetupParameters)((Object)object3)).isSpectralScan()) {
                        problem = DefaultProblem.createError("LAS cannot be achieved as the ACA cannot be used with spectral scans", "Reduce requested source angular size", (IBusinessObject)businessObject);
                        problemListModel.addProblemToBuffer(problem);
                    }
                    if (((SpectralSetupParameters)((Object)object3)).isSingleContinuum()) {
                        problem = DefaultProblem.createError("LAS cannot be achieved as the TP array cannot be used with single continuum setups", "Reduce requested source angular size", (IBusinessObject)businessObject);
                        problemListModel.addProblemToBuffer(problem);
                    }
                    if (object2.getIsTimeConstrained() && object2.getTimingConstraintsType() != null) {
                        problem = DefaultProblem.createError("LAS cannot be achieved as the TP array cannot be used with time constrained setups", "Reduce requested source angular size", (IBusinessObject)businessObject);
                        problemListModel.addProblemToBuffer(problem);
                    }
                }
                this.validateACANotSelectedWithLongBaselineConfigurations(problemListModel, (PerformanceParameters)object2, configuration, businessObject);
                object3 = ((PerformanceParameters)object2).getAngularResolutionMode();
                if (AngularResolutionMode.Single.equals(object3)) {
                    this.validateDesiredAngularResolutionIsWithinLimits(problemListModel, (PerformanceParameters)object2, d, d2, businessObject);
                } else if (AngularResolutionMode.Range.equals(object3)) {
                    double d5 = object2.getAcceptableAngularResolution().getContentInUnits(Angle.UNIT_ARCSEC);
                    this.validateDesiredAngularResolutionRangeIsWithinLimits(problemListModel, (PerformanceParameters)object2, d, d5, d2, businessObject);
                }
            }
            catch (UnknownEntityException | Configuration.UnableToDetermineConfigurationException | InvalidConfigurationParametersException throwable) {
                problem = DefaultProblem.createError("Desired angular resolution is outside the range of possible resolutions for the representative frequency and configurations available.", "Select the Control Parameters in the Science Goal and enter a valid value", (IBusinessObject)businessObject);
                problemListModel.addProblemToBuffer(problem);
            }
            if (!scienceGoalMode.equals((Object)ScienceGoal.ScienceGoalMode.SOLAR)) {
                try {
                    this.validateLASCanBeRecoveredBy7mWhenTPNotSelected(problemListModel, (PerformanceParameters)object2, scienceGoal2, businessObject);
                }
                catch (InvalidConfigurationParametersException invalidConfigurationParametersException) {
                    // empty catch block
                }
            }
            this.validateTimeConstrainedConfiguration(problemListModel, (PerformanceParameters)object2, bl, businessObject, scienceGoalMode);
        }
        if (!scienceGoalMode.equals((Object)ScienceGoal.ScienceGoalMode.SOLAR)) {
            this.validateDesiredLargestScaleIsDefined(problemListModel, performanceParameters);
            this.validateDesiredSensitivityIsDefined(problemListModel, performanceParameters);
        }
        this.validateBWForSensitivity(businessObject, problemListModel, scienceGoal);
        if (performanceParameters.hasIsSimultaneous12and7() && performanceParameters.getIsSimultaneous12and7()) {
            ScienceGoal scienceGoal3 = performanceParameters.getScienceGoal().getParentScienceGoal() != null ? performanceParameters.getScienceGoal().getParentScienceGoal() : performanceParameters.getScienceGoal();
            boolean bl = false;
            boolean bl2 = false;
            try {
                object = Configuration.getConfigurationsToBeScheduled(scienceGoal3, RequestedArray.TWELVE_M);
                Iterator iterator = ((ArrayList)object).iterator();
                while (iterator.hasNext()) {
                    object2 = (ConfigurationSet)iterator.next();
                    boolean bl3 = ((ConfigurationSet)object2).getNoOfArrayRequired() == 2;
                    boolean bl4 = ((ConfigurationSet)object2).getTM1Configuration().isPresent();
                    boolean bl5 = ((ConfigurationSet)object2).getTM2Configuration().isPresent();
                    if (!bl3 || !bl4) continue;
                    if (bl5) {
                        bl2 = true;
                        continue;
                    }
                    bl = true;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (!bl && bl2) {
                problem = DefaultProblem.createError("Simultaneous observing is only available if the 7-m array is paired with a single 12-m configuration.", "Change the desired angular resolution and/or LAS until this is the case.", (IBusinessObject)businessObject);
                problemListModel.addProblemToBuffer(problem);
            }
        }
        this.validateUserDefinedBW(problemListModel, scienceGoal, performanceParameters, businessObject);
    }

    private void validateTPNotUsedWithFPAndSACA(@NonNull ScienceGoal scienceGoal, @NonNull ProblemListModel problemListModel, @NonNull BusinessObject businessObject, @NonNull ScienceGoal scienceGoal2) {
        if (scienceGoal == null) {
            throw new NullPointerException("clusteredScienceGoal is marked non-null but is null");
        }
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (businessObject == null) {
            throw new NullPointerException("bo is marked non-null but is null");
        }
        if (scienceGoal2 == null) {
            throw new NullPointerException("userDefinedScienceGoal is marked non-null but is null");
        }
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        if (performanceParameters.gettrueUseACA() && performanceParameters.gettrueUseTP() && scienceGoal.isStandAloneACA() && scienceGoal.isPolarizationObservation()) {
            Problem problem = DefaultProblem.createError("LAS cannot be achieved as the TP Array cannot be used with full-polarization setups.", "Reduce requested source angular size.", (IBusinessObject)scienceGoal2);
            problemListModel.addProblemToBuffer(problem);
        }
    }

    private void validateBWForSensitivity(BusinessObject businessObject, ProblemListModel problemListModel, ScienceGoal scienceGoal) {
        int n;
        double d;
        Object object;
        SpectralSetupParameters spectralSetupParameters = scienceGoal.getSpectralSetupParameters();
        if (spectralSetupParameters.isSpectralScan()) {
            object = spectralSetupParameters.getSpectralScan();
            d = object.getBandWidth().getContentInMHz();
            n = object.getAdvancedWindowSetup().getSmoothingFactor();
        } else {
            object = spectralSetupParameters.getRepresentativeSpectralWindow();
            d = object.getBandWidth().getContentInMHz();
            n = object.getAdvancedWindowSetup().getSmoothingFactor();
        }
        double d2 = spectralSetupParameters.getDesiredSensitivityFrequencyWidth().getContentInMHz();
        double d3 = (double)n * d / 4096.0;
        if (d2 < d3) {
            Problem problem = DefaultProblem.createError("The bandwidth for sensitivity is less than the channel spacing of the Representative Window", "RepresentativeWindowResolution (twice the channel spacing ) is usually selected.", (IBusinessObject)businessObject);
            problemListModel.addProblemToBuffer(problem);
        }
    }

    private void validateDesiredAngularResolutionRangeIsWithinLimits(ProblemListModel problemListModel, PerformanceParameters performanceParameters, double d, double d2, double d3, BusinessObject businessObject) throws Configuration.UnableToDetermineConfigurationException, InvalidConfigurationParametersException, InvalidObsProgramParametersException {
        if (performanceParameters.getAngularResolutionMode().equals(AngularResolutionMode.Range)) {
            ScienceGoal scienceGoal = performanceParameters.getScienceGoal();
            if (scienceGoal.getParent() instanceof ScienceGoal) {
                scienceGoal = (ScienceGoal)scienceGoal.getParent();
            }
            boolean bl = true;
            if (!PerformanceParametersValidator.isDesiredAngularResolutionAchievableWith12mConfigs(performanceParameters, d, d3)) {
                bl = false;
            }
            if (!PerformanceParametersValidator.isDesiredAngularResolutionAchievableWith12mConfigs(performanceParameters, d2, d3)) {
                bl = false;
            }
            if (!bl) {
                Problem problem = DefaultProblem.createError("Desired angular resolution is outside the range allowed by the available arrays and configurations.", "Select the Control Parameters in the Science Goal and enter a valid value", (IBusinessObject)businessObject);
                problemListModel.addProblemToBuffer(problem);
            }
        }
    }

    private void validateDesiredAngularResolutionIsWithinLimits(ProblemListModel problemListModel, PerformanceParameters performanceParameters, double d, double d2, BusinessObject businessObject) throws InvalidConfigurationParametersException, Configuration.UnableToDetermineConfigurationException, UnknownEntityException, InvalidObsProgramParametersException {
        if (!(performanceParameters.isAngularResolutionModeSACA() || performanceParameters.isAngularResolutionModeAny() || PerformanceParametersValidator.isDesiredAngularResolutionAchievableWith12mConfigs(performanceParameters, d, d2))) {
            Problem problem = DefaultProblem.createError("Desired angular resolution is outside the range allowed by the available arrays and configurations.", "Select the Control Parameters in the Science Goal and enter a valid value", (IBusinessObject)businessObject);
            problemListModel.addProblemToBuffer(problem);
        }
    }

    public static boolean isDesiredAngularResolutionAchievableWith12mConfigs(PerformanceParameters performanceParameters, double d, double d2) throws Configuration.UnableToDetermineConfigurationException, InvalidObsProgramParametersException, InvalidConfigurationParametersException {
        Configuration configuration = null;
        Configuration configuration2 = null;
        try {
            configuration = Configuration.getMostCompactConfiguration(RequestedArray.TWELVE_M);
        }
        catch (Configuration.UnableToDetermineConfigurationException unableToDetermineConfigurationException) {
            Log.logger(PerformanceParametersValidator.class).warning("Unable to find the most compact 12m configuration");
            throw unableToDetermineConfigurationException;
        }
        ScienceGoal scienceGoal = performanceParameters.getScienceGoal();
        ScienceGoal scienceGoal2 = scienceGoal.getParentScienceGoal();
        if (scienceGoal2 != null) {
            scienceGoal = scienceGoal2;
        }
        configuration2 = Configuration.getMostExtendedCompatibleConfiguration(RequestedArray.TWELVE_M, scienceGoal);
        assert (configuration != null && configuration2 != null);
        double d3 = ConfigurationHelper.getAchievableAngularResolutionForAllClusters(scienceGoal2, SfiControlParameterModel.RequestAngularResolutionEnum.COARSEST, Configuration.ConfigurationExtent.COMPACT, Frequency.createFrequencyGHZ(d2), RequestedArray.TWELVE_M).getContentInUnits(Angle.UNIT_ARCSEC);
        double d4 = ConfigurationHelper.getAchievableAngularResolutionForAllClusters(scienceGoal2, SfiControlParameterModel.RequestAngularResolutionEnum.FINEST, Configuration.ConfigurationExtent.EXTENDED, Frequency.createFrequencyGHZ(d2), RequestedArray.TWELVE_M).getContentInUnits(Angle.UNIT_ARCSEC);
        assert (d4 <= d3);
        return !(d > d3 + 0.001) && !(d < d4 - 0.001);
    }

    private void validateACANotSelectedWithLongBaselineConfigurations(ProblemListModel problemListModel, PerformanceParameters performanceParameters, Configuration configuration, BusinessObject businessObject) {
        for (Configuration configuration2 : Configuration.getLongBaseLineConfigurations()) {
            if (!performanceParameters.getUseACA() || !configuration.getName().equals(configuration2.getName())) continue;
            Problem problem = DefaultProblem.createError("The LAS cannot be achieved as only two 12-m configurations are allowed.", "Reduce the desired LAS and/or the desired angular resolution.", (IBusinessObject)businessObject);
            problemListModel.addProblemToBuffer(problem);
            break;
        }
    }

    private void validateDesiredSensitivityIsDefined(ProblemListModel problemListModel, PerformanceParameters performanceParameters) {
        if (!performanceParameters.gettrueDesiredSensitivity().hasContent()) {
            Problem problem = DefaultProblem.createError("There is no value for the desired sensitivity", "Select the Control Parameters in the Science Goal and enter a valid value", (IBusinessObject)performanceParameters);
            problemListModel.addProblemToBuffer(problem);
        } else if (performanceParameters.getDesiredSensitivity().getContentInUnits(Sensitivity.UNIT_JY) <= 0.0) {
            Problem problem = DefaultProblem.createError("Desired sensitivity is too small", "Select the Control Parameters in the Science Goal and enter a valid value", (IBusinessObject)performanceParameters);
            problemListModel.addProblemToBuffer(problem);
        }
    }

    private void validateDesiredLargestScaleIsDefined(ProblemListModel problemListModel, PerformanceParameters performanceParameters) {
        if (!performanceParameters.getDesiredLargestScale().hasContent()) {
            Problem problem = DefaultProblem.createError("There is no value for the largest scale", "Select the Control Parameters in the Science Goal and enter a valid value", (IBusinessObject)performanceParameters);
            problemListModel.addProblemToBuffer(problem);
        } else if (performanceParameters.getDesiredLargestScale().getContentInUnits(Angle.UNIT_ARCSEC) < 0.0) {
            Problem problem = DefaultProblem.createError("Desired largest scale must be a positive number", "Select the Control Parameters in the Science Goal and enter a valid value", (IBusinessObject)performanceParameters);
            problemListModel.addProblemToBuffer(problem);
        }
    }

    private void validateExtraTimeRequested(ProblemListModel problemListModel, PerformanceParameters performanceParameters, ScienceGoal scienceGoal, boolean bl) throws UnknownEntityException {
        if (performanceParameters.getNeedsMoreTime()) {
            Problem problem;
            if (!ScienceGoal.ScienceGoalMode.SOLAR.equals((Object)scienceGoal.getScienceGoalMode()) && !bl) {
                problem = DefaultProblem.createWarning("You have entered your own time for this setup", "Please ensure this is your intention and justify if this the case.", (IBusinessObject)performanceParameters);
                problemListModel.addProblemToBuffer(problem);
            }
            if (performanceParameters.getDesiredTime().getContentInUnits(Time.UNIT_MIN) <= 0.0) {
                problem = DefaultProblem.createError("Desired time must be a positive number", "Select the Control Parameters in the Science Goal and enter a valid value", (IBusinessObject)performanceParameters);
                problemListModel.addProblemToBuffer(problem);
            }
        }
    }

    private void validateLASCanBeRecoveredBy7mWhenTPNotSelected(@NonNull ProblemListModel problemListModel, @NonNull PerformanceParameters performanceParameters, @NonNull ScienceGoal scienceGoal, BusinessObject businessObject) throws InvalidConfigurationParametersException {
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (performanceParameters == null) {
            throw new NullPointerException("clusterPerformanceParameters is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        if (performanceParameters.gettrueUseACA() && !performanceParameters.gettrueUseTP()) {
            TargetParameters[] targetParametersArray = scienceGoal.getTargetParameters();
            Configuration configuration = null;
            configuration = Configuration.getKnownConfigurations(RequestedArray.SEVEN_M).get(0);
            assert (configuration != null);
            try {
                if (performanceParameters.getDesiredLargestScale().getContentInUnits(Angle.UNIT_ARCSEC) > configuration.getRecoverableScale(performanceParameters.getRepresentativeFrequency().getContentInGHz(), targetParametersArray, RequestedArray.SEVEN_M)) {
                    Problem problem;
                    SpectralSetupParameters spectralSetupParameters = scienceGoal.getSpectralSetupParameters();
                    if (ReceiverBand.getReceiverBands(9, 10).contains(spectralSetupParameters.getReceiverBand())) {
                        problem = DefaultProblem.createError("LAS cannot be achieved as the TP array cannot be used in Bands 9 or 10.", "Reduce requested source angular size.", (IBusinessObject)businessObject);
                        problemListModel.addProblemToBuffer(problem);
                    }
                    if (spectralSetupParameters.isSingleContinuum()) {
                        problem = DefaultProblem.createError("LAS cannot be achieved as the TP array cannot be used with single continuum setups.", "Reduce requested source angular size.", (IBusinessObject)businessObject);
                        problemListModel.addProblemToBuffer(problem);
                    }
                    if (spectralSetupParameters.isSpectralScan()) {
                        problem = DefaultProblem.createError("LAS cannot be achieved as the TP array cannot be used with spectral scan setups.", "Reduce requested source angular size.", (IBusinessObject)businessObject);
                        problemListModel.addProblemToBuffer(problem);
                    }
                }
            }
            catch (InvalidConfigurationParametersException invalidConfigurationParametersException) {
                Problem problem = DefaultProblem.createError("Unable to determine the ACA 7m recoverable scale", "Please revise the performance parameters.", (IBusinessObject)businessObject);
                problemListModel.addProblemToBuffer(problem);
                throw invalidConfigurationParametersException;
            }
        }
    }

    private void validateUserDefinedBW(@NonNull ProblemListModel problemListModel, @NonNull ScienceGoal scienceGoal, @NonNull PerformanceParameters performanceParameters, @NonNull BusinessObject businessObject) {
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        if (performanceParameters == null) {
            throw new NullPointerException("performanceParameters is marked non-null but is null");
        }
        if (businessObject == null) {
            throw new NullPointerException("bo is marked non-null but is null");
        }
        if (!performanceParameters.getDesiredSensitivityFrequencyMeasure().equals(PerformanceParameters.DESIREDSENSITIVITYFREQUENCYMEASURE_USER)) {
            return;
        }
        NonOverlappingBandwidthCalculator nonOverlappingBandwidthCalculator = NonOverlappingBandwidthCalculator.getCalculator(scienceGoal.getSpectralSetupParameters(), scienceGoal.getKeyTargetParameters());
        Frequency frequency = nonOverlappingBandwidthCalculator.calculatePerPoln();
        if (frequency.getContentInGHz() < performanceParameters.getDesiredSensitivityReferenceFrequencyWidth().getContentInGHz()) {
            Problem problem = DefaultProblem.createError(String.format("The user-defined bandwidth for sensitivity exceeds the non-overlapping bandwidth (%g GHz) in the spectral setup.", frequency.getContentInGHz()), "Adjust the user-defined bandwidth for sensitivity", (IBusinessObject)performanceParameters);
            problemListModel.addProblemToBuffer(problem);
        }
    }

    private void validateTimeConstrainedConfiguration(ProblemListModel problemListModel, PerformanceParameters performanceParameters, boolean bl, BusinessObject businessObject, ScienceGoal.ScienceGoalMode scienceGoalMode) {
        if (performanceParameters.getIsTimeConstrained()) {
            Problem problem = DefaultProblem.createError("Time-constrained observing with multiple arrays is not permitted.", "Select the Control Parameters in the Science Goal and trying reducing the largest scale, or de-select time constrained.", (IBusinessObject)businessObject);
            if (!EnumSet.of(ScienceGoal.ScienceGoalMode.SOLAR, ScienceGoal.ScienceGoalMode.STANDALONEACA).contains((Object)scienceGoalMode)) {
                if (performanceParameters.hasIsSimultaneous12and7() && performanceParameters.getIsSimultaneous12and7()) {
                    if (bl) {
                        problemListModel.addProblemToBuffer(problem);
                    }
                } else if (performanceParameters.getUseACA()) {
                    problemListModel.addProblemToBuffer(problem);
                }
            } else if (ScienceGoal.ScienceGoalMode.STANDALONEACA.equals((Object)scienceGoalMode) && performanceParameters.getUseTP()) {
                problemListModel.addProblemToBuffer(problem);
            }
            if (performanceParameters.getTemporalParametersCount() > 0) {
                boolean bl2 = true;
                for (TemporalParameters temporalParameters : performanceParameters.getTemporalParameters()) {
                    if (!bl2 || !temporalParameters.getEndTimeInDate().isAfter(TemporalParameters.nowInUTC())) continue;
                    bl2 = false;
                }
                if (bl2) {
                    problem = DefaultProblem.createWarning("All of the time intervals selected are in the past.", "Please add at least one time interval in the future", (IBusinessObject)businessObject);
                    problemListModel.addProblemToBuffer(problem);
                }
            } else if (performanceParameters.getMonitoringConstraintCount() > 0) {
                if (performanceParameters.getNeedsMoreTime()) {
                    problem = DefaultProblem.createError("You have specified your own time for this setup, this is not allowed with continuous monitoring", "Please choose either continuous monitoring or entering your own time estimate.", (IBusinessObject)businessObject);
                    problemListModel.addProblemToBuffer(problem);
                }
                double d = 0.0;
                for (MonitoringConstraint object : performanceParameters.getMonitoringConstraint()) {
                    Time object2 = object.getMonitoringLength();
                    d += object2.getContentInUnits(Time.UNIT_H);
                }
                if (d > MAX_PROP_TIME_HOURS) {
                    String string = String.format("The  total time for all monitoring is greater than limit (max %.2f hrs, current estimate %.2f hours )", MAX_PROP_TIME_HOURS, d);
                    problem = DefaultProblem.createWarning(string, "Select the Control Parameters in the Science Goal and modify the length of your monitoring constraints", (IBusinessObject)businessObject);
                    problemListModel.addProblemToBuffer(problem);
                }
            } else if (performanceParameters.getVisitConstraintCount() > 0) {
                Time time = this.estimateTotalTime(performanceParameters);
                if (performanceParameters.getVisitConstraintCount() == 1) {
                    problem = DefaultProblem.createError("Only a single multiple visit has been defined.", "Add more visits or use the Single Visit interface.", (IBusinessObject)businessObject);
                    problemListModel.addProblemToBuffer(problem);
                }
                if (time == null) {
                    problem = DefaultProblem.createWarning("Unable to calculate estimated time for goal to validate time constraints)", "Please check other validation errors and warnings for specific details", (IBusinessObject)businessObject);
                    problemListModel.addProblemToBuffer(problem);
                } else {
                    Object object;
                    double d = time.getContentInUnits(Time.UNIT_S);
                    double d2 = d * (double)performanceParameters.getVisitConstraintCount() / 3600.0;
                    if (d2 > MAX_PROP_TIME_HOURS) {
                        object = String.format("The estimated total time for all visits is greater than limit (max %.2f hrs, current estimate %.2f hours )", MAX_PROP_TIME_HOURS, d2);
                        problem = DefaultProblem.createWarning((String)object, "Select the Control Parameters in the Science Goal and modify the start time  for your multiple visit constraints", (IBusinessObject)businessObject);
                        problemListModel.addProblemToBuffer(problem);
                    }
                    object = null;
                    Object object2 = VisitConstraint.nowInUTC().toInstant();
                    try {
                        boolean loopingTimeConstraintsException = false;
                        for (VisitConstraint visitConstraint : performanceParameters.getVisitConstraint()) {
                            Instant instant = this.getNominalStartTime(performanceParameters, visitConstraint);
                            double d3 = visitConstraint.getAllowedMargin().getContentInUnits(Time.UNIT_S);
                            if (object != null) {
                                double d4 = d3;
                                double d5 = instant.getEpochSecond() - ((Instant)object2).getEpochSecond();
                                if (d4 > d5) {
                                    problem = DefaultProblem.createWarning("Two visits are closer in time than the sum of their margins - the second might happen before the first!", "Reduce the margin or increase the spacing", (IBusinessObject)businessObject);
                                    problemListModel.addProblemToBuffer(problem);
                                }
                                Log.logger((Object)this).info("Start Time :" + instant.toString());
                                Log.logger((Object)this).info("End of minimum boundry :" + ((Instant)object2).toString());
                                Log.logger((Object)this).info("Gap :" + d5);
                                if (d5 < d) {
                                    String string = String.format("There is not sufficient time between visits (Estimated time for each observation is %.2f %s )", time.getContent(), time.getUnit());
                                    problem = DefaultProblem.createError(string, "Select the Control Parameters in the Science Goal and modify the start time  for your multiple visit constraints", (IBusinessObject)businessObject);
                                    problemListModel.addProblemToBuffer(problem);
                                }
                            }
                            if (null == (object = this.getNominalStartTime(performanceParameters, visitConstraint))) {
                                object = VisitConstraint.nowInUTC().toInstant();
                            }
                            if (((Instant)(object2 = object)).isBefore(VisitConstraint.nowInUTC().toInstant())) {
                                loopingTimeConstraintsException = true;
                            }
                            object2 = ((Instant)object2).plus((long)visitConstraint.getAllowedMargin().getContentInUnits(Time.UNIT_MIN), ChronoUnit.MINUTES);
                        }
                        if (loopingTimeConstraintsException) {
                            String string = String.format("The dates for at least one visit are in the past.", new Object[0]);
                            problem = DefaultProblem.createWarning(string, "Select the Control Parameters in the Science Goal and confirm the details", (IBusinessObject)businessObject);
                            problemListModel.addProblemToBuffer(problem);
                        }
                    }
                    catch (LoopingTimeConstraintsException loopingTimeConstraintsException) {
                        problem = DefaultProblem.createError("The dependencies between your time constraints are not possible", "Select the Control Parameters in the Science Goal and fix the dependencies between your multiple visits so there is a clear start and no loops", (IBusinessObject)businessObject);
                        problemListModel.addProblemToBuffer(problem);
                    }
                }
            } else {
                problem = DefaultProblem.createError("Time-constrained observing is selected but no constraints have been entered.", "Enter a time constraint or deselect time-constrained observing.", (IBusinessObject)businessObject);
                problemListModel.addProblemToBuffer(problem);
            }
        }
    }

    private Time estimateTotalTime(PerformanceParameters performanceParameters) {
        ScienceGoal scienceGoal = performanceParameters.getScienceGoal();
        ObservingTimeCalculator observingTimeCalculator = new ObservingTimeCalculator(scienceGoal);
        Time time = null;
        try {
            time = observingTimeCalculator.getTotalTimeForScienceGoal(true);
        }
        catch (ObservingTimeCalculator.UnableToCalculateTimeEstimateException unableToCalculateTimeEstimateException) {
            time = null;
        }
        return time;
    }

    private Instant getNominalStartTime(PerformanceParameters performanceParameters, VisitConstraint visitConstraint) throws LoopingTimeConstraintsException {
        if (visitConstraint == null) {
            return null;
        }
        if (visitConstraint.getIsFixedStart()) {
            return visitConstraint.getStartTimeInDate().toInstant();
        }
        if (visitConstraint.getPreviousVisitId() > 0) {
            Instant instant = this.getNominalStartTime(performanceParameters, visitConstraint.getPreviousVisitId(), visitConstraint.getVisitId());
            instant = instant.plus(Math.round(visitConstraint.getRequiredDelay().getContentInUnits(Time.UNIT_MIN)), ChronoUnit.MINUTES);
            return instant;
        }
        return ZonedDateTime.now(ZoneOffset.UTC).withNano(0).toInstant();
    }

    private Instant getNominalStartTime(PerformanceParameters performanceParameters, int n, int n2) throws LoopingTimeConstraintsException {
        VisitConstraint visitConstraint;
        if ((visitConstraint = performanceParameters.getVisitConstraint(--n)) == null) {
            return null;
        }
        if (visitConstraint.getIsFixedStart()) {
            return visitConstraint.getStartTimeInDate().toInstant();
        }
        if (visitConstraint.getPreviousVisitId() > 0) {
            if (visitConstraint.getPreviousVisitId() == n2) {
                throw new LoopingTimeConstraintsException();
            }
            Instant instant = this.getNominalStartTime(performanceParameters, visitConstraint.getPreviousVisitId(), n2);
            instant = instant.plus(Math.round(visitConstraint.getRequiredDelay().getContentInUnits(Time.UNIT_MIN)), ChronoUnit.MINUTES);
            return instant;
        }
        return ZonedDateTime.now(ZoneOffset.UTC).withNano(0).toInstant();
    }
}

