/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.valdef.obsproject;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.ObsProgram;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsreview.ObsReview;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.ot.valdef.AbstractValidator;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.problems.DefaultProblem;
import alma.obsprep.problems.Problem;
import alma.obsprep.services.network.roledirectory.RoleDirectoryServiceHelper;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class ObsProjectValidator
extends AbstractValidator {
    public ObsProjectValidator() {
        this.setValidatorThreadSafe(true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void localValidate(BusinessObject businessObject, ProblemListModel problemListModel) {
        String string;
        Problem problem;
        ObsProject obsProject = (ObsProject)businessObject;
        if (obsProject.getPI().equals("")) {
            problem = DefaultProblem.createError("No Principal Investigator specified", "Select the top level Project node in the tree and fill in the Principal Investigator field", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if (obsProject.getProjectName().equals("")) {
            problem = DefaultProblem.createError("No Project Name specified", "Select the top level Project node in the tree and fill in the Project Name field", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if (obsProject.getVersion().equals("")) {
            problem = DefaultProblem.createError("No Project Version specified", "Select the top level Project node in the tree and fill in the Project Version field", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if ((string = obsProject.getStatus()) != ObsProject.STATUS_NEWPHASE1 && string != ObsProject.STATUS_PHASE1SUBMITTED && string != ObsProject.STATUS_REJECTED) {
            Object object;
            Collection<Object> collection;
            ObsProgram obsProgram = obsProject.getObsProgram();
            if (obsProgram != null) {
                void schedBlock;
                collection = new HashSet();
                object = obsProgram.getAbstractScienceGoal();
                int n = ((AbstractScienceGoal[])object).length;
                boolean bl = false;
                while (schedBlock < n) {
                    AbstractScienceGoal string3 = object[schedBlock];
                    if (string3 instanceof ScienceGoal) {
                        try {
                            ScienceGoal scienceGoal2 = (ScienceGoal)((Object)string3);
                            String string2 = scienceGoal2.getName().trim();
                            if (collection.contains(string2)) {
                                problemListModel.add(DefaultProblem.createError("This program already contains a science goal labelled " + string2, "Please change the name of the science goal.", (IBusinessObject)businessObject));
                            } else {
                                collection.add(string2);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    ++schedBlock;
                }
            }
            try {
                collection = obsProject.getObsProgram().getObsPlan().findSchedBlocks();
                if (collection.isEmpty()) {
                    if (RoleDirectoryServiceHelper.isUserP2G()) {
                        problem = DefaultProblem.createWarning("The Project contains no SchedBlocks", "Without SBs the project cannot take data.", (IBusinessObject)businessObject);
                        problemListModel.add(problem);
                    }
                } else {
                    object = new HashSet();
                    for (SchedBlock schedBlock : collection) {
                        String string3 = schedBlock.getName();
                        if (object.contains(string3)) {
                            problem = DefaultProblem.createError("Scheduling block name " + string3 + " is used more than once", "Scheduling block names must be unique. Please edit the name of this scheduling block", schedBlock);
                            problemListModel.add(problem);
                            continue;
                        }
                        object.add(string3);
                    }
                }
                object = Arrays.asList(obsProject.getObsProgram().getAbstractScienceGoalScienceGoal());
                object.stream().filter(scienceGoal -> !scienceGoal.getIsDescoped()).forEach(scienceGoal -> {
                    ObsUnitSet obsUnitSet = scienceGoal.getObsUnitSet();
                    try {
                        boolean bl;
                        boolean bl2 = bl = obsUnitSet == null || obsUnitSet.findSchedBlocks().isEmpty();
                        if (RoleDirectoryServiceHelper.isUserP2G() && bl) {
                            problemListModel.add(DefaultProblem.createWarning(String.format("Science goal (%s) has no SBs attached to it", scienceGoal.getName()), "Please ensure that you generate SBs for this science goal.", (IBusinessObject)scienceGoal));
                        }
                    }
                    catch (Exception exception) {
                        problemListModel.add(DefaultProblem.createError("Internal validation error: expecting UnknownEntityException in ObsProjectValidator", "Contact your support agent", (IBusinessObject)businessObject));
                    }
                });
            }
            catch (UnknownEntityException unknownEntityException) {
                problemListModel.add(DefaultProblem.createError("Internal validation error: expecting UnknownEntityException in ObsProjectValidator", "Contact your support agent", (IBusinessObject)businessObject));
            }
        } else if (string != ObsProject.STATUS_REJECTED) {
            try {
                List<SchedBlock> list;
                ObsReview obsReview = obsProject.gettrueObsReview();
                if (obsReview != null && !(list = obsReview.getObsPlan().findSchedBlocks()).isEmpty()) {
                    HashSet<String> hashSet = new HashSet<String>();
                    for (SchedBlock schedBlock : list) {
                        String string4 = schedBlock.getName();
                        if (hashSet.contains(string4)) {
                            problem = DefaultProblem.createError("Scheduling block name " + string4 + " is used more than once", "Scheduling block names must be unique. Please edit the name of this scheduling block", schedBlock);
                            problemListModel.add(problem);
                            continue;
                        }
                        hashSet.add(string4);
                    }
                }
            }
            catch (UnknownEntityException unknownEntityException) {
                problem = DefaultProblem.createWarning("Phase 1 SBs were expected but could not be retrieved", "Either regenerate the Phase 1 SBs through the OT or contact your support agent", (IBusinessObject)businessObject);
                problemListModel.add(problem);
            }
        }
    }
}

