/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.persistence;

import alma.entity.xmlbinding.obsattachment.ObsAttachment;
import alma.entity.xmlbinding.schedblock.SchedBlock;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.hla.runtime.obsprep.util.XmlConversionException;
import alma.obsprep.bo.obsproject.CalibrationSetupParameters;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.obsreview.ObsReview;
import alma.obsprep.ot.editors.misc.UserEditRestrictionController;
import alma.obsprep.ot.gui.toplevel.DialogId;
import alma.obsprep.ot.persistence.Apdm_to_BO;
import alma.obsprep.ot.persistence.MendMyStruct;
import alma.obsprep.ot.persistence.PersistenceException;
import alma.obsprep.ot.persistence.ProjectResetListener;
import alma.obsprep.services.generator.refactored.StaleSBDetector;
import alma.obsprep.util.DatamodelInstanceChecker;
import alma.obsprep.util.FileUtilities;
import alma.obsprep.util.GUIUtilities;
import alma.obsprep.util.MiscUtils;
import alma.obsprep.util.ZipSupport;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import org.apache.commons.lang3.SerializationException;
import org.apache.commons.lang3.SerializationUtils;
import org.exolab.castor.xml.XMLException;
import uk.ac.roe.ukatc.xsltchain.ConvertZip;

public class ImpexFactory {
    private static final String UTF8 = "UTF-8";
    private static ImpexFactory impexFactorySingleton = null;
    private final Queue<ProjectResetListener> projectImportListeners = new ConcurrentLinkedQueue<ProjectResetListener>();
    public static final DialogId confirmConversionOnImport = new DialogId("Import.ConfirmConversion");
    private final Log.Logger logger = Log.logger(ImpexFactory.class);
    private ObsProject lastObsProjectLoaded = null;
    private Optional<URL> urlOfLastProjectFileImported = Optional.empty();
    ImpPrj impPrj = new ImpPrj();

    public void addProjectImportListener(ProjectResetListener projectResetListener) {
        if (this.projectImportListeners.contains(projectResetListener)) {
            return;
        }
        this.projectImportListeners.add(projectResetListener);
    }

    public void removeImportListener(ProjectResetListener projectResetListener) {
        if (this.projectImportListeners.contains(projectResetListener)) {
            this.projectImportListeners.remove(projectResetListener);
        }
    }

    public void exportProject(ObsProject obsProject, OutputStream outputStream) throws XmlConversionException, IOException, UnknownEntityException {
        this.exportProject(obsProject, outputStream, true, true);
    }

    public void exportProject(ObsProject obsProject, OutputStream outputStream, boolean bl, boolean bl2) throws XmlConversionException, IOException, UnknownEntityException {
        Apdm_to_BO.BoBundle boBundle = Apdm_to_BO.decomposeIncludingFiles(obsProject);
        Apdm_to_BO.SoBundle soBundle = Apdm_to_BO.down(boBundle);
        if (bl2) {
            ImpexFactory.updateRevisionNumbersOfDocuments(boBundle);
        }
        this.exportRaw(soBundle, boBundle.documents, outputStream, bl);
    }

    public static boolean isRevisionNumberOfDocumentToBeUpdated(ObsProject obsProject) {
        if (!obsProject.isRevisionNumberOfProjectCurrent()) {
            return GUIUtilities.confirm(null, "You are attempting to save a project using a version of the OT from a more recent cycle than that used to create the original proposal. Do you wish to proceed?", GUIUtilities.DefaultResponse.NO);
        }
        return true;
    }

    public static void updateRevisionNumbersOfDocuments(Apdm_to_BO.BoBundle boBundle) {
        try {
            List<alma.obsprep.bo.schedblock.SchedBlock> list;
            ObsReview obsReview;
            alma.obsprep.bo.obsattachment.ObsAttachment obsAttachment;
            boBundle.boProject.updateRevisionNumberToCurrent();
            ObsProposal obsProposal = boBundle.boProposal;
            if (obsProposal != null) {
                obsProposal.updateRevisionNumberToCurrent();
            }
            if ((obsAttachment = boBundle.boDocuments) != null) {
                obsAttachment.updateRevisionNumberToCurrent();
            }
            if ((obsReview = boBundle.boReview) != null) {
                obsReview.updateRevisionNumberToCurrent();
            }
            if ((list = boBundle.boSchedblocks) != null && !list.isEmpty()) {
                for (alma.obsprep.bo.schedblock.SchedBlock schedBlock : list) {
                    schedBlock.updateRevisionNumberToCurrent();
                }
            }
        }
        catch (ObsProject.UnableToGetDocumentRevisionNumberException unableToGetDocumentRevisionNumberException) {
            Log.logger(ImpexFactory.class).warning("Unable to update the revision numbers of the documents: " + unableToGetDocumentRevisionNumberException.getMessage());
            throw new XmlConversionException("Unable to update the revision numbers in the documents: ", (Throwable)unableToGetDocumentRevisionNumberException);
        }
    }

    public void exportRaw(Apdm_to_BO.SoBundle soBundle, List<File> list, OutputStream outputStream) throws IOException {
        this.exportRaw(soBundle, list, outputStream, true);
    }

    public void exportRaw(Apdm_to_BO.SoBundle soBundle, List<File> list, OutputStream outputStream, boolean bl) throws IOException {
        Apdm_to_BO.XmlBundle xmlBundle = Apdm_to_BO.down(soBundle);
        this.impPrj.writeAot(xmlBundle, list, outputStream, bl);
    }

    public ObsProject importObsProject(URL uRL, boolean bl) throws XMLException, IOException, PersistenceException {
        MiscUtils.resetJCSCache();
        URL uRL2 = this.impPrj.checkAndUpgradeSchemaVersion(uRL, bl);
        InputStream inputStream = uRL2.openStream();
        Apdm_to_BO.SoBundle soBundle = this.impPrj.readAot(inputStream);
        Apdm_to_BO.BoBundle boBundle = Apdm_to_BO.getInstance().adopt(soBundle);
        if (boBundle.boProject == null) {
            throw new ZipException("no project found in input");
        }
        this.projectImportListeners.stream().forEach(projectResetListener -> projectResetListener.projectDocumentReset(boBundle.boProject, this.impPrj.workingPersistenceData));
        WorkingPersistenceData workingPersistenceData = this.impPrj.workingPersistenceData;
        if (workingPersistenceData == null || workingPersistenceData.schedBlockFreshnessMap.isEmpty()) {
            StaleSBDetector.getInstance().resetSBFreshnessMap(boBundle.boProject);
        }
        try {
            if (boBundle.boProject.getStatus().equals(ObsProject.STATUS_NEWPHASE1) || boBundle.boProject.getStatus().equals(ObsProject.STATUS_PHASE1SUBMITTED)) {
                MendMyStruct.setIndividualPointingPatternsToCustomMosaic(boBundle.boProject.getObsProposal());
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(ImpexFactory.class).info("Unable to change pointing patterns to mosaic : " + unknownEntityException.getMessage());
        }
        this.urlOfLastProjectFileImported = Optional.of(uRL);
        boBundle.boProject.resetAfterImport();
        this.lastObsProjectLoaded = boBundle.boProject;
        try {
            PerformanceParameters.setAttributesForHistoricalProjects(this.lastObsProjectLoaded);
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(ImpexFactory.class).warning("Unable to check if ACA supplemental call proposal needs revising: " + unknownEntityException.getMessage());
        }
        try {
            SpectralSetupParameters.setAttributesForHistoricalProjects(this.lastObsProjectLoaded);
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(ImpexFactory.class).warning("Unable to check if default single continuum correlator mode has been set : " + unknownEntityException.getMessage());
        }
        try {
            CalibrationSetupParameters.setAttributesForHistoricalProjects(this.lastObsProjectLoaded);
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(ImpexFactory.class).warning("Unable to check if default astrometry mode has been set");
        }
        return boBundle.boProject;
    }

    public ObsProject importObsProject(URL uRL) throws XMLException, IOException, PersistenceException {
        return this.importObsProject(uRL, true);
    }

    public ObsProject importProject(InputStream inputStream) throws XMLException, IOException {
        this.urlOfLastProjectFileImported = Optional.empty();
        Apdm_to_BO.SoBundle soBundle = this.impPrj.readAot(inputStream);
        Apdm_to_BO.BoBundle boBundle = Apdm_to_BO.getInstance().adopt(soBundle);
        if (boBundle.boProject == null) {
            throw new ZipException("no project found in input");
        }
        this.lastObsProjectLoaded = boBundle.boProject;
        try {
            PerformanceParameters.setAttributesForHistoricalProjects(this.lastObsProjectLoaded);
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(ImpexFactory.class).warning("Unable to check if ACA supplemental call proposal needs revising: " + unknownEntityException.getMessage());
        }
        try {
            SpectralSetupParameters.setAttributesForHistoricalProjects(this.lastObsProjectLoaded);
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(ImpexFactory.class).warning("Unable to check if default single continuum correlator mode has been set : " + unknownEntityException.getMessage());
        }
        try {
            CalibrationSetupParameters.setAttributesForHistoricalProjects(this.lastObsProjectLoaded);
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(ImpexFactory.class).warning("Unable to set up calibration setup defaut values: " + unknownEntityException.getMessage());
        }
        return boBundle.boProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ImpexFactory getInstance() {
        if (MiscUtils.isOTRunningInServletContainer()) {
            return new ImpexFactory();
        }
        if (impexFactorySingleton != null) return impexFactorySingleton;
        Class<ImpexFactory> clazz = ImpexFactory.class;
        synchronized (ImpexFactory.class) {
            if (impexFactorySingleton != null) return impexFactorySingleton;
            impexFactorySingleton = new ImpexFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return impexFactorySingleton;
        }
    }

    public String toString() {
        return "ImpexFactory(projectImportListeners=" + this.projectImportListeners + ", logger=" + this.logger + ", lastObsProjectLoaded=" + this.getLastObsProjectLoaded() + ", urlOfLastProjectFileImported=" + this.getUrlOfLastProjectFileImported() + ", impPrj=" + this.impPrj + ")";
    }

    public ObsProject getLastObsProjectLoaded() {
        return this.lastObsProjectLoaded;
    }

    public Optional<URL> getUrlOfLastProjectFileImported() {
        return this.urlOfLastProjectFileImported;
    }

    class ImpPrj {
        static final String PROJECT = "ObsProject";
        static final String PROPOSAL = "ObsProposal";
        static final String SCHEDBLOCK = "SchedBlock";
        static final String STATUS = "ProjectStatus";
        static final String REVIEW = "ObsReview";
        static final String ATTACHMENT = "ObsAttachment";
        static final String DOCUMENT = "Document_";
        static final String EXT = ".xml";
        static final String P2USERCHANGEPERSISTENCEFILE = "UserChangePersistence";
        static final String SBSTALENESSPERSISTENCEFILE = "SBStalenessPersistence";
        final WorkingPersistenceData workingPersistenceData = new WorkingPersistenceData();

        ImpPrj() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        URL checkAndUpgradeSchemaVersion(URL uRL, boolean bl) throws IOException {
            Object object;
            Object object2;
            String string;
            String string2;
            StringBuilder stringBuilder = new StringBuilder("Checking data model versions...");
            String string3 = "This message should never be seen! Please report this";
            try {
                Object object3;
                string2 = System.getProperty("OTDataModelVersion");
                string = System.getProperty("SupportedDataModelVersions");
                if (string == null) {
                    string = string2;
                }
                stringBuilder.append(" This OT produces version ").append(string2);
                stringBuilder.append(". It can read version(s) ").append(string).append(". ");
                if (string == null) {
                    ImpexFactory.this.logger.severe("Failed to find OT version info");
                    stringBuilder.append("Failed to find OT version. Update or remove your ObservingTool.properties").append("Failed to find OT data model version!");
                    GUIUtilities.error(null, "Failed to find OT version. Update or remove your ObservingTool.properties");
                    throw new IOException("Failed to find OT version. Update or remove your ObservingTool.properties");
                }
                stringBuilder.append("Processed data contains:");
                object2 = uRL.openStream();
                object = new ZipSupport.ZipReader((InputStream)object2);
                boolean bl2 = false;
                boolean bl3 = false;
                while ((object3 = ((ZipSupport.ZipReader)object).getZipEntry()) != null) {
                    Object object4;
                    String string4 = ((ZipEntry)object3).getName();
                    byte[] byArray = ((ZipSupport.ZipNtry)object3).getData();
                    StringReader stringReader = new StringReader(new String(byArray));
                    DatamodelInstanceChecker datamodelInstanceChecker = new DatamodelInstanceChecker();
                    if (string4.startsWith(PROJECT)) {
                        object4 = datamodelInstanceChecker.getDatamodelVersion(stringReader);
                        String string5 = ((DatamodelInstanceChecker.ModelVersioning)object4).getDatamodelVersion().orElseThrow(datamodelInstanceChecker.dataModelNotFoundException);
                        stringBuilder.append(" Project=").append(string5);
                        bl2 |= !string.contains(string5);
                        bl3 |= !string2.contains(string5);
                        continue;
                    }
                    if (string4.startsWith(PROPOSAL)) {
                        object4 = datamodelInstanceChecker.getDatamodelVersion(stringReader).getDatamodelVersion().orElseThrow(datamodelInstanceChecker.dataModelNotFoundException);
                        stringBuilder.append(" Proposal=").append((String)object4);
                        bl2 |= !string.contains((CharSequence)object4);
                        bl3 |= !string2.contains((CharSequence)object4);
                        continue;
                    }
                    if (string4.startsWith(ATTACHMENT)) {
                        object4 = datamodelInstanceChecker.getDatamodelVersion(stringReader).getDatamodelVersion().orElseThrow(datamodelInstanceChecker.dataModelNotFoundException);
                        stringBuilder.append(" Documents=").append((String)object4);
                        bl2 |= !string.contains((CharSequence)object4);
                        bl3 |= !string2.contains((CharSequence)object4);
                        continue;
                    }
                    if (string4.startsWith(REVIEW)) {
                        object4 = datamodelInstanceChecker.getDatamodelVersion(stringReader).getDatamodelVersion().orElseThrow(datamodelInstanceChecker.dataModelNotFoundException);
                        stringBuilder.append(" Review=").append((String)object4);
                        bl2 |= !string.contains((CharSequence)object4);
                        bl3 |= !string2.contains((CharSequence)object4);
                        continue;
                    }
                    if (string4.startsWith(STATUS)) {
                        object4 = datamodelInstanceChecker.getDatamodelVersion(stringReader).getDatamodelVersion().orElseThrow(datamodelInstanceChecker.dataModelNotFoundException);
                        stringBuilder.append(" ProjectStatus=").append((String)object4);
                        bl2 |= !string.contains((CharSequence)object4);
                        bl3 |= !string2.contains((CharSequence)object4);
                        continue;
                    }
                    if (!string4.startsWith(SCHEDBLOCK)) continue;
                    object4 = datamodelInstanceChecker.getDatamodelVersion(stringReader).getDatamodelVersion().orElseThrow(datamodelInstanceChecker.dataModelNotFoundException);
                    stringBuilder.append(" SB=").append((String)object4);
                    bl2 |= !string.contains((CharSequence)object4);
                    bl3 |= !string2.contains((CharSequence)object4);
                }
                ((ZipSupport.ZipReader)object).close();
                ((InputStream)object2).close();
                if (!bl2 && !bl3) {
                    object3 = uRL;
                    return object3;
                }
                if (bl2) {
                    stringBuilder.append(" Project requires upgrade.\n");
                    string3 = "This is a project for which upgrading is required.\nYes to upgrade and import, no to ignore and attempt input (may fail)";
                } else if (bl3) {
                    stringBuilder.append(" Upgrade is recommended.\n");
                    string3 = "This is a project for which upgrading is strongly recommended, but not required.\nYes to upgrade and import, no to ignore and attempt input";
                }
            }
            finally {
                ImpexFactory.this.logger.info(stringBuilder.toString());
            }
            if (bl && !GUIUtilities.confirm(confirmConversionOnImport, string3)) {
                return uRL;
            }
            string = uRL.getPath();
            object2 = string.substring(string.lastIndexOf("/") + 1, string.lastIndexOf(".aot"));
            object2 = (String)object2 + "000";
            ConvertZip.load_defaults();
            ConvertZip.setBaseURL((String)System.getProperty("ConverterBaseUrl"));
            try {
                object = File.createTempFile((String)object2, ".aot");
                String string6 = ((File)object).getPath();
                ConvertZip.Converter((String)string, (String)"versionmap.txt", (String)"versiontable.txt", (String)string2, (String)string6);
                GUIUtilities.info(confirmConversionOnImport, "Project converted OK");
                return ((File)object).toURI().toURL();
            }
            catch (Exception exception) {
                ImpexFactory.this.logger.log(Level.INFO, "Could not convert project", (Throwable)exception);
                GUIUtilities.error(null, "Could not convert Project - will try original, but expect problems", exception);
                return uRL;
            }
        }

        Apdm_to_BO.SoBundle readAot(InputStream inputStream) throws XMLException, IOException {
            ZipSupport.ZipNtry zipNtry;
            Apdm_to_BO.SoBundle soBundle = new Apdm_to_BO.SoBundle();
            ImpexFactory.this.impPrj.workingPersistenceData.clear();
            ZipSupport.ZipReader zipReader = new ZipSupport.ZipReader(inputStream);
            while ((zipNtry = zipReader.getZipEntry()) != null) {
                Object object;
                String string = zipNtry.getName();
                byte[] byArray = zipNtry.getData();
                if (string.startsWith(PROJECT)) {
                    object = new StringReader(new String(byArray, ImpexFactory.UTF8));
                    soBundle.soProject = alma.entity.xmlbinding.obsproject.ObsProject.unmarshalObsProject((Reader)object);
                    continue;
                }
                if (string.startsWith(PROPOSAL)) {
                    object = new StringReader(new String(byArray, ImpexFactory.UTF8));
                    soBundle.soProposal = alma.entity.xmlbinding.obsproposal.ObsProposal.unmarshalObsProposal((Reader)object);
                    continue;
                }
                if (string.startsWith(ATTACHMENT)) {
                    object = new StringReader(new String(byArray, ImpexFactory.UTF8));
                    soBundle.soDocuments = ObsAttachment.unmarshalObsAttachment((Reader)object);
                    continue;
                }
                if (string.startsWith(REVIEW)) {
                    object = new StringReader(new String(byArray, ImpexFactory.UTF8));
                    soBundle.soReview = alma.entity.xmlbinding.obsreview.ObsReview.unmarshalObsReview((Reader)object);
                    continue;
                }
                if (string.startsWith(STATUS)) continue;
                if (string.startsWith(SCHEDBLOCK)) {
                    object = new StringReader(new String(byArray, ImpexFactory.UTF8));
                    soBundle.soSchedblocks.add(SchedBlock.unmarshalSchedBlock((Reader)object));
                    continue;
                }
                if (string.startsWith(DOCUMENT)) {
                    object = string.substring(DOCUMENT.length());
                    File file = FileUtilities.getTmpDir();
                    File file2 = new File(file, (String)object);
                    file2.deleteOnExit();
                    FileUtilities.bytesToFile(byArray, file2);
                    continue;
                }
                if (string.startsWith(P2USERCHANGEPERSISTENCEFILE)) {
                    this.workingPersistenceData.setMajorChangePersistenceData((ArrayList)SerializationUtils.deserialize((byte[])byArray));
                    continue;
                }
                if (string.startsWith(SBSTALENESSPERSISTENCEFILE)) {
                    try {
                        this.workingPersistenceData.setSchedBlockFreshnessMap((ConcurrentHashMap)SerializationUtils.deserialize((byte[])byArray));
                    }
                    catch (SerializationException serializationException) {
                        Log.logger(ImpPrj.class).info("Unable to deserialize SB stale information : " + serializationException.getMessage());
                    }
                    continue;
                }
                throw new ZipException("Unknown entry in Zip file: " + string);
            }
            zipReader.close();
            inputStream.close();
            return soBundle;
        }

        void writeAot(Apdm_to_BO.XmlBundle xmlBundle, List<File> list, OutputStream outputStream, boolean bl) throws IOException {
            ConcurrentHashMap<String, Integer> concurrentHashMap;
            ZipSupport.ZipWriter zipWriter = new ZipSupport.ZipWriter(outputStream);
            if (xmlBundle.xmlProj != null) {
                zipWriter.putZipEntry("ObsProject.xml", xmlBundle.xmlProj.getBytes(ImpexFactory.UTF8));
            }
            if (xmlBundle.xmlProp != null) {
                zipWriter.putZipEntry("ObsProposal.xml", xmlBundle.xmlProp.getBytes(ImpexFactory.UTF8));
            }
            if (xmlBundle.xmlDocs != null) {
                zipWriter.putZipEntry("ObsAttachment.xml", xmlBundle.xmlDocs.getBytes(ImpexFactory.UTF8));
            }
            if (xmlBundle.xmlReview != null) {
                zipWriter.putZipEntry("ObsReview.xml", xmlBundle.xmlReview.getBytes(ImpexFactory.UTF8));
            }
            for (int i = 0; i < xmlBundle.xmlSBs.size(); ++i) {
                zipWriter.putZipEntry(SCHEDBLOCK + i + EXT, xmlBundle.xmlSBs.get(i).getBytes(ImpexFactory.UTF8));
            }
            for (File serializable2 : list) {
                byte[] byArray = FileUtilities.fileToBytes(serializable2);
                zipWriter.putZipEntry(DOCUMENT + serializable2.getName(), byArray);
            }
            ArrayList<UserEditRestrictionController.MajorChangePersistence> arrayList = UserEditRestrictionController.getInstance().getMajorChangePersistenceData();
            if (!arrayList.isEmpty() && bl) {
                zipWriter.putZipEntry(P2USERCHANGEPERSISTENCEFILE, SerializationUtils.serialize((Serializable)arrayList));
            }
            if (!(concurrentHashMap = StaleSBDetector.getInstance().getSchedBlockFreshnessMap()).isEmpty() && bl) {
                zipWriter.putZipEntry(SBSTALENESSPERSISTENCEFILE, SerializationUtils.serialize(concurrentHashMap));
            }
            zipWriter.close();
        }
    }

    public static class WorkingPersistenceData {
        private ArrayList<UserEditRestrictionController.MajorChangePersistence> majorChangePersistenceData = new ArrayList();
        private ConcurrentHashMap<String, Integer> schedBlockFreshnessMap = new ConcurrentHashMap(50);

        public ArrayList<UserEditRestrictionController.MajorChangePersistence> getMajorChangePersistenceData() {
            return this.majorChangePersistenceData;
        }

        public void setMajorChangePersistenceData(ArrayList<UserEditRestrictionController.MajorChangePersistence> arrayList) {
            this.majorChangePersistenceData = arrayList;
        }

        public ConcurrentHashMap<String, Integer> getSchedBlockFreshnessMap() {
            return this.schedBlockFreshnessMap;
        }

        public void setSchedBlockFreshnessMap(ConcurrentHashMap<String, Integer> concurrentHashMap) {
            this.schedBlockFreshnessMap = concurrentHashMap;
        }

        public void clear() {
            this.schedBlockFreshnessMap.clear();
            this.majorChangePersistenceData.clear();
        }
    }
}

