/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.sciencegoals;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.enumerations.CorrPolarization;
import alma.obsprep.bo.obsproject.CalibrationSetupParameters;
import alma.obsprep.bo.obsproject.ExpectedPropertiesElements;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproject.TechnicalJustification;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.editors.sciencegoals.TJEditorEnum;
import alma.obsprep.ot.editors.sciencegoals.TechnicalJustificationEditor;
import alma.obsprep.ot.models.sciencegoals.AngularResolutionMode;
import alma.obsprep.ot.models.sciencegoals.SfiControlParameterModel;
import alma.obsprep.ot.models.sciencegoals.TechnicalJustificationFormatters;
import alma.obsprep.ot.models.sciencegoals.TechnicalJustificationListHelper;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.experts.ConfigurationHelper;
import alma.obsprep.services.experts.InvalidConfigurationParametersException;
import alma.obsprep.services.experts.TechnicalJustificationExpert;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.valuetypes.Angle;
import alma.valuetypes.Flux;
import alma.valuetypes.Frequency;
import alma.valuetypes.Sensitivity;
import alma.valuetypes.Speed;
import alma.valuetypes.UserAngle;
import alma.valuetypes.UserFrequency;
import alma.valuetypes.UserSensitivity;
import java.util.Arrays;
import java.util.Optional;
import lombok.NonNull;

public class TechnicalJustificationModel
extends Model {
    private UserSensitivity continuumRms;
    private Frequency representativeFrequency;
    private TechnicalJustificationListHelper tjeList;
    protected UserAngle desiredResolution;
    protected Angle desiredLargestStructure;
    public static final String SENSITIVITY_CALC_UNIT = Sensitivity.UNIT_MJY;
    public static final String FLUX_CALC_UNIT = Flux.UNIT_MJY;
    public static final String FREQUENCY_CALC_UNIT = UserFrequency.USERUNIT_KM_S;
    public static final String SPEED_CALC_UNIT = Speed.UNIT_KM_S;

    public TechnicalJustificationModel(ScienceGoal scienceGoal) {
        super(scienceGoal);
        ScienceGoal scienceGoal2 = scienceGoal;
        this.tjeList = null != scienceGoal2 ? new TechnicalJustificationListHelper(scienceGoal2) : null;
        this.setParametersWhenDocumentChanges();
    }

    @Override
    public void setDocument(Object object) {
        Log.logger((Object)this).info("Set Document Called on TJ Node");
        super.setDocument(object);
        if (this.document != null) {
            this.tjeList = new TechnicalJustificationListHelper(this.getScienceGoal());
        }
    }

    private void setParametersWhenDocumentChanges() {
        this.representativeFrequency = Frequency.createFrequency();
        this.continuumRms = this.createUserSensitivityWithDefinedBeamsizeAndObsFreq();
    }

    public ScienceGoal getScienceGoal() {
        if (null == this.document) {
            return null;
        }
        return (ScienceGoal)this.document;
    }

    private void recalculateTJsRequired(ScienceGoal scienceGoal, @NonNull Optional<Boolean> optional) {
        boolean bl;
        if (optional == null) {
            throw new NullPointerException("isJustifyChoicesPanelDisplayOverride is marked non-null but is null");
        }
        if (scienceGoal == null) {
            return;
        }
        Log.logger((Object)this).finest("Recalculating TJ Flags");
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        try {
            bl5 = ObsProposal.isVLBIRelated();
            bl4 = scienceGoal.isSolarScienceGoal();
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(TechnicalJustificationModel.class).warning("Unable to determine if solar/VLBI is in effect: " + unknownEntityException.getMessage());
        }
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        SpectralSetupParameters spectralSetupParameters = scienceGoal.getSpectralSetupParameters();
        TargetParameters[] targetParametersArray = scienceGoal.getTargetParameters();
        for (bl = false; bl < targetParametersArray.length; bl += 1) {
            TargetParameters targetParameters = targetParametersArray[bl];
            if (!bl2) {
                bl2 = targetParameters.isMaxElevationNeedingJustification();
            }
            if (!targetParameters.isRectanglePattern()) continue;
            double d = this.getNyquistSpacing();
            double d2 = targetParameters.getSingleRectangle().getSpacing().getContentInUnits(UserAngle.USERUNIT_FRACTION_OF_MAIN_BEAM);
            double d3 = Math.abs(d2 - d);
            if (!(d3 > 5.0E-6)) continue;
            bl3 = true;
        }
        this.createTJEditorAndBO(scienceGoal, TJEditorEnum.ED_LOW_MAX_ELEVATION, bl2);
        this.createTJEditorAndBO(scienceGoal, TJEditorEnum.ED_NON_NYQUIST, bl3);
        bl = spectralSetupParameters.getPolarisation().equals(CorrPolarization.SINGLE_X.toString()) || spectralSetupParameters.getPolarisation().equals(CorrPolarization.SINGLE_Y.toString());
        this.createTJEditorAndBO(scienceGoal, TJEditorEnum.ED_SINGLE_POLARISATION, bl);
        boolean bl6 = scienceGoal.getCalibrationSetupParameters().isUserDefinedCalibration() && !bl5;
        this.createTJEditorAndBO(scienceGoal, TJEditorEnum.ED_USER_DEFINED_CALIB, bl6);
        boolean bl7 = performanceParameters.getNeedsMoreTime() && !bl4 && !bl5;
        this.createTJEditorAndBO(scienceGoal, TJEditorEnum.ED_ADDITIONAL_TIME, bl7);
        boolean bl8 = spectralSetupParameters.isNonStandardContinuumFrequency() && !bl4 && !bl5;
        this.createTJEditorAndBO(scienceGoal, TJEditorEnum.ED_NON_STD_CONT_FREQ, bl8);
        boolean bl9 = performanceParameters.getIsTimeConstrained();
        this.createTJEditorAndBO(scienceGoal, TJEditorEnum.ED_TIME_CONSTRAINT, bl9);
        boolean bl10 = scienceGoal.getCalibrationSetupParameters().getPositionalAccuracy().equals(CalibrationSetupParameters.POSITIONALACCURACY_ENHANCED);
        this.createTJEditorAndBO(scienceGoal, TJEditorEnum.ED_ASTROMETRY, bl10 && !bl4);
        boolean bl11 = bl6 || bl7 || bl8 || bl || bl9 || bl2 || bl10 || bl3;
        this.publish(TechnicalJustificationEditor.DISPLAY_NON_STD_SECTION, optional.orElseGet(() -> bl11));
    }

    private void createTJEditorAndBO(@NonNull ScienceGoal scienceGoal, @NonNull TJEditorEnum tJEditorEnum, boolean bl) {
        if (scienceGoal == null) {
            throw new NullPointerException("sg is marked non-null but is null");
        }
        if (tJEditorEnum == null) {
            throw new NullPointerException("tjEditor is marked non-null but is null");
        }
        FieldID fieldID = tJEditorEnum.getId();
        String string = tJEditorEnum.name();
        if (bl) {
            TechnicalJustification technicalJustification = this.tjeList.getTechnicalJustification(scienceGoal, string);
            String string2 = technicalJustification.getJustificationText();
            this.publish(fieldID, string2);
        } else {
            this.publish(fieldID, null);
            this.tjeList.removeTechnicalJustification(scienceGoal, string);
        }
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        this.updateRelevantTechnicalJustificationText(fieldID, object);
        return object;
    }

    public void updateRelevantTechnicalJustificationText(FieldID fieldID, Object object) {
        TJEditorEnum tJEditorEnum = TJEditorEnum.getEditor(fieldID);
        if (null != tJEditorEnum) {
            String string = (String)object;
            ScienceGoal scienceGoal = this.getScienceGoal();
            if (null != scienceGoal) {
                this.tjeList.updateTechnicalJustification(scienceGoal, tJEditorEnum.name(), string);
            }
        }
    }

    @Override
    public void publish() {
        ScienceGoal scienceGoal = this.getScienceGoal();
        if (scienceGoal == null) {
            return;
        }
        this.tjeList = new TechnicalJustificationListHelper(scienceGoal);
        for (TJEditorEnum tJEditorEnum : TJEditorEnum.values()) {
            TechnicalJustification technicalJustification = this.tjeList.getTechnicalJustification(scienceGoal, tJEditorEnum.name());
            String string = technicalJustification.getJustificationText();
            this.publish(tJEditorEnum.getId(), string);
        }
        try {
            ObsProposal obsProposal = scienceGoal.getObsProposal();
            if (null != obsProposal && obsProposal.isVLBI()) {
                this.publishForVLBI(scienceGoal);
            } else if (null != obsProposal && obsProposal.isPhasedArray()) {
                this.publishForPhasedArray(scienceGoal);
            } else if (scienceGoal.isSolarScienceGoal()) {
                this.publishForSolar(scienceGoal);
            } else {
                this.publishForDefaultObsMode(scienceGoal);
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            // empty catch block
        }
    }

    private void publishForVLBI(@NonNull ScienceGoal scienceGoal) {
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        this.publish(TechnicalJustificationEditor.FID_LINE_ACHIEVED_SNR, false);
        this.publish(TechnicalJustificationEditor.FID_ACHIEVED_CONTINUUM_RMS, "");
        this.publish(TechnicalJustificationEditor.FID_AGGREGATE_BANDWIDTH_ALL_SPW, "");
        this.publish(TechnicalJustificationEditor.FID_ANGULAR_RES, "");
        this.publish(TechnicalJustificationEditor.FID_BANDWIDTH_FOR_SENSITIVITY, "");
        this.publish(TechnicalJustificationEditor.FID_BANDWIDTH_FOR_SENSITIVITY_CALC, "");
        this.publish(TechnicalJustificationEditor.FID_BAND_CALC_RESULT, "");
        this.publish(TechnicalJustificationEditor.FID_CONT_PEAK_FLUX_DENSITY, "");
        this.publish(TechnicalJustificationEditor.FID_CONT_PEAK_FLUX_SNR, "");
        this.publish(TechnicalJustificationEditor.FID_ANY_FLUX_SET, false);
        this.publish(TechnicalJustificationEditor.FID_DESIRED_SENSITIVITY, "");
        this.publish(TechnicalJustificationEditor.FID_DYNAMIC_RANGE, "");
        this.publish(TechnicalJustificationEditor.FID_LARGEST_ANGULAR_SCALE, 0);
        this.publish(TechnicalJustificationEditor.FID_LINEWIDTH_SET, false);
        this.publish(TechnicalJustificationEditor.FID_LINE_FLUX_SET, false);
        this.publish(TechnicalJustificationEditor.FID_LINE_RESOLUTIONS, "");
        this.publish(TechnicalJustificationEditor.FID_LINE_WIDTH, "");
        this.publish(TechnicalJustificationEditor.FID_MIN_ANGULAR_RES, "");
        this.publish(TechnicalJustificationEditor.FID_PEAK_FLUX_DENSITY, "");
        this.publish(TechnicalJustificationEditor.FID_PEAK_FLUX_SNR, "");
        this.publish(TechnicalJustificationEditor.FID_PEAK_LINE_FLUX, "");
        this.publish(TechnicalJustificationEditor.FID_REPRESENTATIVE_SPEC_WIDTH, "");
        this.publish(TechnicalJustificationEditor.FID_RESOLUTION_VELOCITY, "");
        this.publish(TechnicalJustificationEditor.FID_THIRD_OF_WIDTH, "");
        this.publish(TechnicalJustificationEditor.FID_LINEWIDTH_GREATER_THAN_SPW_WARNING, false);
        this.publish(TechnicalJustificationEditor.FID_SHOW_CONT_RMS_CALC, false);
        this.publish(TechnicalJustificationEditor.FID_SHOW_DYNAMIC_RANGE, false);
        this.publish(TechnicalJustificationEditor.FID_SHOW_MAX_DR_WARNING, false);
        this.publish(TechnicalJustificationEditor.FID_SHOW_MAY_NOT_RESOLVE_WARNING, false);
        this.publish(TechnicalJustificationEditor.FID_SHOW_SNR_LOW_WARNING, false);
        this.publish(TechnicalJustificationEditor.FID_SHOW_WIDE_BANDWIDTH_WARNING, false);
        this.publish(TechnicalJustificationEditor.FID_IS_VLBI, true);
        this.createTJEditorAndBO(scienceGoal, TJEditorEnum.ED_SENSITIVITY_COMMENTS, false);
        this.createTJEditorAndBO(scienceGoal, TJEditorEnum.ED_SENSITIVITY, false);
        this.createTJEditorAndBO(scienceGoal, TJEditorEnum.ED_ANGULAR_RESOLUTION, false);
        this.createTJEditorAndBO(scienceGoal, TJEditorEnum.ED_CORR_COMMENTS, false);
        this.createTJEditorAndBO(scienceGoal, TJEditorEnum.ED_CORRELATOR, false);
        this.createTJEditorAndBO(scienceGoal, TJEditorEnum.ED_USER_DEFINED_CALIB, false);
        this.createTJEditorAndBO(scienceGoal, TJEditorEnum.ED_ADDITIONAL_TIME, false);
        this.createTJEditorAndBO(scienceGoal, TJEditorEnum.ED_NON_STD_CONT_FREQ, false);
        this.createTJEditorAndBO(scienceGoal, TJEditorEnum.ED_ASTROMETRY, false);
        this.publish(TechnicalJustificationEditor.DISPLAY_NON_STD_SECTION, true);
        this.createTJEditorAndBO(scienceGoal, TJEditorEnum.ED_VLBI, true);
        this.createTJEditorAndBO(scienceGoal, TJEditorEnum.ED_SOLAR, false);
        boolean bl = Arrays.asList(scienceGoal.getTargetParameters()).stream().anyMatch(targetParameters -> targetParameters.getExpectedProperties().getIsPassivePhasing());
        this.createTJEditorAndBO(scienceGoal, TJEditorEnum.ED_VLBI_PASSIVE_PHASING, bl);
        this.createTJEditorAndBO(scienceGoal, TJEditorEnum.ED_VLBI_PHASED_ARRAY, false);
        this.recalculateTJsRequired(scienceGoal, Optional.of(Boolean.TRUE));
    }

    private void publishForPhasedArray(@NonNull ScienceGoal scienceGoal) {
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        this.publish(TechnicalJustificationEditor.FID_LINE_ACHIEVED_SNR, false);
        this.publish(TechnicalJustificationEditor.FID_ACHIEVED_CONTINUUM_RMS, "");
        this.publish(TechnicalJustificationEditor.FID_AGGREGATE_BANDWIDTH_ALL_SPW, "");
        this.publish(TechnicalJustificationEditor.FID_ANGULAR_RES, "");
        this.publish(TechnicalJustificationEditor.FID_BANDWIDTH_FOR_SENSITIVITY, "");
        this.publish(TechnicalJustificationEditor.FID_BANDWIDTH_FOR_SENSITIVITY_CALC, "");
        this.publish(TechnicalJustificationEditor.FID_BAND_CALC_RESULT, "");
        this.publish(TechnicalJustificationEditor.FID_CONT_PEAK_FLUX_DENSITY, "");
        this.publish(TechnicalJustificationEditor.FID_CONT_PEAK_FLUX_SNR, "");
        this.publish(TechnicalJustificationEditor.FID_ANY_FLUX_SET, false);
        this.publish(TechnicalJustificationEditor.FID_DESIRED_SENSITIVITY, "");
        this.publish(TechnicalJustificationEditor.FID_DYNAMIC_RANGE, "");
        this.publish(TechnicalJustificationEditor.FID_LARGEST_ANGULAR_SCALE, 0);
        this.publish(TechnicalJustificationEditor.FID_LINEWIDTH_SET, false);
        this.publish(TechnicalJustificationEditor.FID_LINE_FLUX_SET, false);
        this.publish(TechnicalJustificationEditor.FID_LINE_RESOLUTIONS, "");
        this.publish(TechnicalJustificationEditor.FID_LINE_WIDTH, "");
        this.publish(TechnicalJustificationEditor.FID_MIN_ANGULAR_RES, "");
        this.publish(TechnicalJustificationEditor.FID_PEAK_FLUX_DENSITY, "");
        this.publish(TechnicalJustificationEditor.FID_PEAK_FLUX_SNR, "");
        this.publish(TechnicalJustificationEditor.FID_PEAK_LINE_FLUX, "");
        this.publish(TechnicalJustificationEditor.FID_REPRESENTATIVE_SPEC_WIDTH, "");
        this.publish(TechnicalJustificationEditor.FID_RESOLUTION_VELOCITY, "");
        this.publish(TechnicalJustificationEditor.FID_THIRD_OF_WIDTH, "");
        this.publish(TechnicalJustificationEditor.FID_LINEWIDTH_GREATER_THAN_SPW_WARNING, false);
        this.publish(TechnicalJustificationEditor.FID_SHOW_CONT_RMS_CALC, false);
        this.publish(TechnicalJustificationEditor.FID_SHOW_DYNAMIC_RANGE, false);
        this.publish(TechnicalJustificationEditor.FID_SHOW_MAX_DR_WARNING, false);
        this.publish(TechnicalJustificationEditor.FID_SHOW_MAY_NOT_RESOLVE_WARNING, false);
        this.publish(TechnicalJustificationEditor.FID_SHOW_SNR_LOW_WARNING, false);
        this.publish(TechnicalJustificationEditor.FID_SHOW_WIDE_BANDWIDTH_WARNING, false);
        this.publish(TechnicalJustificationEditor.FID_IS_VLBI, true);
        this.createTJEditorAndBO(scienceGoal, TJEditorEnum.ED_SENSITIVITY_COMMENTS, false);
        this.createTJEditorAndBO(scienceGoal, TJEditorEnum.ED_SENSITIVITY, false);
        this.createTJEditorAndBO(scienceGoal, TJEditorEnum.ED_ANGULAR_RESOLUTION, false);
        this.createTJEditorAndBO(scienceGoal, TJEditorEnum.ED_CORR_COMMENTS, false);
        this.createTJEditorAndBO(scienceGoal, TJEditorEnum.ED_CORRELATOR, false);
        this.createTJEditorAndBO(scienceGoal, TJEditorEnum.ED_USER_DEFINED_CALIB, false);
        this.createTJEditorAndBO(scienceGoal, TJEditorEnum.ED_ADDITIONAL_TIME, false);
        this.createTJEditorAndBO(scienceGoal, TJEditorEnum.ED_NON_STD_CONT_FREQ, false);
        this.createTJEditorAndBO(scienceGoal, TJEditorEnum.ED_ASTROMETRY, false);
        this.publish(TechnicalJustificationEditor.DISPLAY_NON_STD_SECTION, true);
        this.createTJEditorAndBO(scienceGoal, TJEditorEnum.ED_VLBI, false);
        this.createTJEditorAndBO(scienceGoal, TJEditorEnum.ED_SOLAR, false);
        boolean bl = Arrays.asList(scienceGoal.getTargetParameters()).stream().anyMatch(targetParameters -> targetParameters.getExpectedProperties().getIsPassivePhasing());
        this.createTJEditorAndBO(scienceGoal, TJEditorEnum.ED_VLBI_PASSIVE_PHASING, bl);
        this.createTJEditorAndBO(scienceGoal, TJEditorEnum.ED_VLBI_PHASED_ARRAY, true);
        this.recalculateTJsRequired(scienceGoal, Optional.of(Boolean.TRUE));
    }

    private void publishForSolar(@NonNull ScienceGoal scienceGoal) {
        if (scienceGoal == null) {
            throw new NullPointerException("sg is marked non-null but is null");
        }
        this.publish(TechnicalJustificationEditor.FID_LINE_ACHIEVED_SNR, false);
        this.publish(TechnicalJustificationEditor.FID_ACHIEVED_CONTINUUM_RMS, "");
        this.publish(TechnicalJustificationEditor.FID_AGGREGATE_BANDWIDTH_ALL_SPW, "");
        this.publish(TechnicalJustificationEditor.FID_ANGULAR_RES, "");
        this.publish(TechnicalJustificationEditor.FID_BANDWIDTH_FOR_SENSITIVITY, "");
        this.publish(TechnicalJustificationEditor.FID_BANDWIDTH_FOR_SENSITIVITY_CALC, "");
        this.publish(TechnicalJustificationEditor.FID_BAND_CALC_RESULT, "");
        this.publish(TechnicalJustificationEditor.FID_CONT_PEAK_FLUX_DENSITY, "");
        this.publish(TechnicalJustificationEditor.FID_CONT_PEAK_FLUX_SNR, "");
        this.publish(TechnicalJustificationEditor.FID_ANY_FLUX_SET, false);
        this.publish(TechnicalJustificationEditor.FID_DESIRED_SENSITIVITY, "");
        this.publish(TechnicalJustificationEditor.FID_DYNAMIC_RANGE, "");
        this.publish(TechnicalJustificationEditor.FID_LARGEST_ANGULAR_SCALE, 0);
        this.publish(TechnicalJustificationEditor.FID_LINEWIDTH_SET, false);
        this.publish(TechnicalJustificationEditor.FID_LINE_FLUX_SET, false);
        this.publish(TechnicalJustificationEditor.FID_LINE_RESOLUTIONS, "");
        this.publish(TechnicalJustificationEditor.FID_LINE_WIDTH, "");
        this.publish(TechnicalJustificationEditor.FID_PEAK_FLUX_DENSITY, "");
        this.publish(TechnicalJustificationEditor.FID_PEAK_FLUX_SNR, "");
        this.publish(TechnicalJustificationEditor.FID_PEAK_LINE_FLUX, "");
        this.publish(TechnicalJustificationEditor.FID_REPRESENTATIVE_SPEC_WIDTH, "");
        this.publish(TechnicalJustificationEditor.FID_RESOLUTION_VELOCITY, "");
        this.publish(TechnicalJustificationEditor.FID_THIRD_OF_WIDTH, "");
        this.publish(TechnicalJustificationEditor.FID_LINEWIDTH_GREATER_THAN_SPW_WARNING, false);
        this.publish(TechnicalJustificationEditor.FID_SHOW_CONT_RMS_CALC, false);
        this.publish(TechnicalJustificationEditor.FID_SHOW_DYNAMIC_RANGE, false);
        this.publish(TechnicalJustificationEditor.FID_SHOW_MAX_DR_WARNING, false);
        this.publish(TechnicalJustificationEditor.FID_SHOW_MAY_NOT_RESOLVE_WARNING, false);
        this.publish(TechnicalJustificationEditor.FID_SHOW_SNR_LOW_WARNING, false);
        this.publish(TechnicalJustificationEditor.FID_SHOW_WIDE_BANDWIDTH_WARNING, false);
        this.publish(TechnicalJustificationEditor.FID_IS_SOLAR, true);
        this.createTJEditorAndBO(scienceGoal, TJEditorEnum.ED_SENSITIVITY_COMMENTS, false);
        this.createTJEditorAndBO(scienceGoal, TJEditorEnum.ED_SENSITIVITY, false);
        this.createTJEditorAndBO(scienceGoal, TJEditorEnum.ED_ANGULAR_RESOLUTION, false);
        this.createTJEditorAndBO(scienceGoal, TJEditorEnum.ED_ADDITIONAL_TIME, false);
        this.createTJEditorAndBO(scienceGoal, TJEditorEnum.ED_NON_STD_CONT_FREQ, false);
        this.createTJEditorAndBO(scienceGoal, TJEditorEnum.ED_CORR_COMMENTS, false);
        this.createTJEditorAndBO(scienceGoal, TJEditorEnum.ED_CORRELATOR, false);
        this.publish(TechnicalJustificationEditor.DISPLAY_NON_STD_SECTION, true);
        this.createTJEditorAndBO(scienceGoal, TJEditorEnum.ED_SOLAR, true);
        this.createTJEditorAndBO(scienceGoal, TJEditorEnum.ED_VLBI, false);
        this.createTJEditorAndBO(scienceGoal, TJEditorEnum.ED_VLBI_PASSIVE_PHASING, false);
        this.createTJEditorAndBO(scienceGoal, TJEditorEnum.ED_VLBI_PHASED_ARRAY, false);
        this.createTJEditorAndBO(scienceGoal, TJEditorEnum.ED_ASTROMETRY, false);
        this.recalculateTJsRequired(scienceGoal, Optional.of(Boolean.TRUE));
    }

    private void publishForDefaultObsMode(@NonNull ScienceGoal scienceGoal) {
        if (scienceGoal == null) {
            throw new NullPointerException("sg is marked non-null but is null");
        }
        this.createTJEditorAndBO(scienceGoal, TJEditorEnum.ED_VLBI, false);
        this.createTJEditorAndBO(scienceGoal, TJEditorEnum.ED_VLBI_PASSIVE_PHASING, false);
        this.createTJEditorAndBO(scienceGoal, TJEditorEnum.ED_VLBI_PHASED_ARRAY, false);
        this.createTJEditorAndBO(scienceGoal, TJEditorEnum.ED_SOLAR, false);
        this.publish(TechnicalJustificationEditor.FID_IS_VLBI, false);
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        SpectralSetupParameters spectralSetupParameters = scienceGoal.getSpectralSetupParameters();
        ExpectedPropertiesElements expectedPropertiesElements = scienceGoal.getConsolidatedExpectedProperties();
        if (expectedPropertiesElements == null) {
            return;
        }
        TechnicalJustificationExpert.TechnicalJustificationCalculations technicalJustificationCalculations = TechnicalJustificationExpert.builder().scienceGoal(scienceGoal).build().calculateTJValuesForStandardObsmode();
        UserSensitivity userSensitivity = technicalJustificationCalculations.getDesiredSensitivity();
        this.publish(TechnicalJustificationEditor.FID_DESIRED_SENSITIVITY, TechnicalJustificationFormatters.formattedFriendlyFluxUnits(userSensitivity));
        double d = technicalJustificationCalculations.getLineWidthInKMS();
        this.publish(TechnicalJustificationEditor.FID_LINE_WIDTH, TechnicalJustificationFormatters.formattedFriendlySpeedUnits(d));
        double d2 = technicalJustificationCalculations.getBandwidthSensitivityInKMS();
        if (d2 < d * 2.0) {
            this.publish(TechnicalJustificationEditor.FID_BANDWIDTH_FOR_SENSITIVITY, TechnicalJustificationFormatters.formattedFriendlySpeedUnits(d2, "%.3f %s"));
        } else {
            this.publish(TechnicalJustificationEditor.FID_BANDWIDTH_FOR_SENSITIVITY, TechnicalJustificationFormatters.formattedValueWithUnit(technicalJustificationCalculations.getBandwidthSensitivityUser(), "%.3f %s"));
        }
        this.publish(TechnicalJustificationEditor.FID_BANDWIDTH_FOR_SENSITIVITY_CALC, TechnicalJustificationFormatters.formattedFriendlySpeedUnits(d2));
        this.publish(TechnicalJustificationEditor.FID_BAND_CALC_RESULT, TechnicalJustificationFormatters.formatDisplaySignificantDigitWhenSmall(technicalJustificationCalculations.getFBWCalculationResult()));
        this.representativeFrequency = spectralSetupParameters.getRepresentativeFrequencyWithSkyOffset();
        UserSensitivity userSensitivity2 = technicalJustificationCalculations.getPeakLineFlux();
        UserSensitivity userSensitivity3 = technicalJustificationCalculations.getPeakContFlux();
        Frequency frequency = expectedPropertiesElements.aggregateBandwidth;
        this.publish(TechnicalJustificationEditor.FID_AGGREGATE_BANDWIDTH_ALL_SPW, TechnicalJustificationFormatters.formattedValueWithUnit(frequency, "%.3f %s"));
        this.publishRMSSensitivity(scienceGoal, expectedPropertiesElements);
        boolean bl = technicalJustificationCalculations.isLineFluxSet();
        boolean bl2 = technicalJustificationCalculations.isContFluxSet();
        boolean bl3 = technicalJustificationCalculations.isContinuumFluxToBeUsed();
        this.publish(TechnicalJustificationEditor.FID_SHOW_CONT_RMS_CALC, technicalJustificationCalculations.isShowContRMSCalc());
        this.publish(TechnicalJustificationEditor.FID_LINE_FLUX_SET, bl);
        this.publish(TechnicalJustificationEditor.FID_ANY_FLUX_SET, bl2 || bl);
        if (bl3) {
            this.publish(TechnicalJustificationEditor.FID_PEAK_FLUX_DENSITY, TechnicalJustificationFormatters.formattedFriendlyFluxUnits(userSensitivity3));
        } else {
            this.publish(TechnicalJustificationEditor.FID_PEAK_FLUX_DENSITY, TechnicalJustificationFormatters.formattedFriendlyFluxUnits(userSensitivity2));
        }
        double d3 = technicalJustificationCalculations.getPeakFluxSNR();
        this.publish(TechnicalJustificationEditor.FID_PEAK_FLUX_SNR, this.snrFormattedValue(d3));
        this.publish(TechnicalJustificationEditor.FID_LINE_ACHIEVED_SNR, this.snrFormattedValue(technicalJustificationCalculations.getLineFluxSNR()));
        this.publish(TechnicalJustificationEditor.FID_PEAK_LINE_FLUX, TechnicalJustificationFormatters.formattedFriendlyFluxUnits(userSensitivity2));
        this.publish(TechnicalJustificationEditor.FID_THIRD_OF_WIDTH, TechnicalJustificationFormatters.formattedFriendlySpeedUnits(technicalJustificationCalculations.getThirdOfLineWidth()));
        this.publish(TechnicalJustificationEditor.FID_LINEWIDTH_SET, technicalJustificationCalculations.isLineWidthSet());
        Optional<Speed> optional = technicalJustificationCalculations.getRepresentativeWidthAsSpeed();
        optional.ifPresent(speed -> this.publish(TechnicalJustificationEditor.FID_REPRESENTATIVE_SPEC_WIDTH, TechnicalJustificationFormatters.formattedFriendlySpeedUnits(speed.getContentInUnits(Speed.UNIT_KM_S))));
        this.publish(TechnicalJustificationEditor.FID_LINEWIDTH_GREATER_THAN_SPW_WARNING, technicalJustificationCalculations.isLineWidthGreaterThanSPWWarningShown());
        this.publishContinuumFlux(userSensitivity3, scienceGoal);
        this.publish(TechnicalJustificationEditor.FID_CONT_PEAK_FLUX_SNR, this.snrFormattedValue(technicalJustificationCalculations.getContSNR()));
        this.publish(TechnicalJustificationEditor.FID_SHOW_SNR_LOW_WARNING, technicalJustificationCalculations.isShowSNRLowWarning());
        this.publishAngularResolution(scienceGoal);
        this.desiredLargestStructure = performanceParameters.getDesiredLargestScale();
        if (this.desiredLargestStructure.getContentInDefaultUnits() < 0.0) {
            this.publish(TechnicalJustificationEditor.FID_LARGEST_ANGULAR_SCALE, "Undefined");
        } else {
            this.publish(TechnicalJustificationEditor.FID_LARGEST_ANGULAR_SCALE, this.formattedValueWithUnit((AbstractDoubleWithUnit<?>)this.desiredLargestStructure));
        }
        this.publish(TechnicalJustificationEditor.FID_SHOW_WIDE_BANDWIDTH_WARNING, technicalJustificationCalculations.isWideBandwidthWarningRequired());
        String string = String.format("%.2f", technicalJustificationCalculations.getSpectralDynamicRange());
        this.publish(TechnicalJustificationEditor.FID_DYNAMIC_RANGE, string);
        this.publish(TechnicalJustificationEditor.FID_SHOW_DYNAMIC_RANGE, technicalJustificationCalculations.isDynamicRangeShown());
        this.publish(TechnicalJustificationEditor.FID_SHOW_MAX_DR_WARNING, technicalJustificationCalculations.isDynamicRangeWarningShown());
        this.publish(TechnicalJustificationEditor.FID_RESOLUTION_VELOCITY, TechnicalJustificationFormatters.formattedFriendlySpeedUnits(expectedPropertiesElements.resolvedVelocity));
        double d4 = expectedPropertiesElements.getResPerLineWidth();
        String string2 = TechnicalJustificationFormatters.formatDisplaySignificantDigitWhenSmall(d4);
        this.publish(TechnicalJustificationEditor.FID_LINE_RESOLUTIONS, string2);
        this.publish(TechnicalJustificationEditor.FID_SHOW_MAY_NOT_RESOLVE_WARNING, technicalJustificationCalculations.isMayNotResolve());
        this.recalculateTJsRequired(scienceGoal, Optional.empty());
    }

    public static UserSensitivity getContinuumSensitivity(@NonNull PerformanceParameters performanceParameters) {
        if (performanceParameters == null) {
            throw new NullPointerException("pp is marked non-null but is null");
        }
        UserSensitivity userSensitivity = performanceParameters.getDesiredSensitivity().deepCopy();
        userSensitivity.setBeamsize(performanceParameters.getDesiredSensitivity().getBeamsize());
        userSensitivity.setObservingFrequency(performanceParameters.getDesiredSensitivity().getObservingFrequency().deepCopy());
        return userSensitivity;
    }

    private void publishContinuumFlux(@NonNull UserSensitivity userSensitivity, @NonNull ScienceGoal scienceGoal) {
        if (userSensitivity == null) {
            throw new NullPointerException("peakContFlux is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("piScienceGoal is marked non-null but is null");
        }
        String string = TechnicalJustificationFormatters.formattedFriendlyFluxUnits(userSensitivity);
        String string2 = TechnicalJustificationFormatters.getKSensitivityEquivalents(userSensitivity, scienceGoal);
        this.publish(TechnicalJustificationEditor.FID_CONT_PEAK_FLUX_DENSITY, string + string2);
    }

    private void publishAngularResolution(ScienceGoal scienceGoal) {
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        AngularResolutionMode angularResolutionMode = performanceParameters.getAngularResolutionMode();
        this.desiredResolution = performanceParameters.getDesiredAngularResolution();
        switch (angularResolutionMode) {
            case Any: {
                this.setAnyAngularResolutionTJField(scienceGoal);
                break;
            }
            case Range: {
                UserAngle userAngle = scienceGoal.getPerformanceParameters().getPISpecifiedAR(SfiControlParameterModel.RequestAngularResolutionEnum.COARSEST);
                UserAngle userAngle2 = scienceGoal.getPerformanceParameters().getPISpecifiedAR(SfiControlParameterModel.RequestAngularResolutionEnum.FINEST);
                this.publish(TechnicalJustificationEditor.FID_ANGULAR_RES, TechnicalJustificationFormatters.formattedRangeValueWithUnit(userAngle, userAngle2));
                break;
            }
            case SACA: {
                try {
                    Configuration configuration = Configuration.MOST_COMPACT.get((Object)RequestedArray.SEVEN_M);
                    this.desiredResolution = UserAngle.createUserAngle(configuration.getAchievableResolution(this.representativeFrequency.getContentInGHz(), scienceGoal, RequestedArray.SEVEN_M), Angle.UNIT_ARCSEC);
                    this.desiredResolution.setObservingFrequency(this.representativeFrequency);
                }
                catch (InvalidConfigurationParametersException invalidConfigurationParametersException) {
                    Log.logger(TechnicalJustificationModel.class).info("Unable to determine configuration for ACA 7-m : " + invalidConfigurationParametersException.getMessage());
                    return;
                }
                this.publish(TechnicalJustificationEditor.FID_ANGULAR_RES, this.formattedValueWithUnit((AbstractDoubleWithUnit<?>)this.desiredResolution));
                break;
            }
            case Single: {
                this.publish(TechnicalJustificationEditor.FID_ANGULAR_RES, this.formattedValueWithUnit((AbstractDoubleWithUnit<?>)this.desiredResolution));
                break;
            }
            default: {
                throw new RuntimeException("Unknown AR mode " + angularResolutionMode);
            }
        }
    }

    private void publishRMSSensitivity(@NonNull ScienceGoal scienceGoal, @NonNull ExpectedPropertiesElements expectedPropertiesElements) {
        if (scienceGoal == null) {
            throw new NullPointerException("piScienceGoal is marked non-null but is null");
        }
        if (expectedPropertiesElements == null) {
            throw new NullPointerException("ep is marked non-null but is null");
        }
        UserSensitivity userSensitivity = expectedPropertiesElements.sensitivityForBW;
        this.continuumRms.setContentAndUnit(userSensitivity);
        this.continuumRms.convertToUnit(this.continuumRms.getFriendlyUnit());
        String string = TechnicalJustificationFormatters.formattedFriendlyFluxUnits(this.continuumRms);
        try {
            String string2 = TechnicalJustificationFormatters.getKSensitivityEquivalents(userSensitivity, scienceGoal);
            this.publish(TechnicalJustificationEditor.FID_ACHIEVED_CONTINUUM_RMS, string + string2);
        }
        catch (Exception exception) {
            Log.logger(TechnicalJustificationModel.class).warning("Unable to determine K sensitivity " + exception.getMessage());
        }
    }

    private void setAnyAngularResolutionTJField(ScienceGoal scienceGoal) {
        UserAngle[] userAngleArray = ConfigurationHelper.determineARRangeForARModeAny(scienceGoal);
        assert (userAngleArray.length == 2);
        this.publish(TechnicalJustificationEditor.FID_ANGULAR_RES, TechnicalJustificationFormatters.formattedRangeValueWithUnit(userAngleArray[0], userAngleArray[1]));
    }

    public UserSensitivity createUserSensitivityWithDefinedBeamsizeAndObsFreq() {
        UserSensitivity userSensitivity = UserSensitivity.createUserSensitivity();
        userSensitivity.setBeamsize((Angle)((Object)this.desiredResolution));
        userSensitivity.setObservingFrequency(this.representativeFrequency);
        return userSensitivity;
    }

    private String snrFormattedValue(double d) {
        return String.format("%.1f", d);
    }

    public String formattedValueWithUnit(AbstractDoubleWithUnit<?> abstractDoubleWithUnit) {
        return TechnicalJustificationFormatters.formattedValueWithUnit(abstractDoubleWithUnit, "%.2f %s");
    }

    public double getNyquistSpacing() {
        return 1.0 / Math.sqrt(3.0) / 1.13;
    }
}

