/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.sciencegoals;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.annotations.SpatialDocument;
import alma.obsprep.bo.annotations.SpatialPartOfSpatialDocument;
import alma.obsprep.bo.obsproject.AbstractTargetParameters;
import alma.obsprep.bo.obsproject.Field;
import alma.obsprep.bo.obsproject.FieldTypeInfo;
import alma.obsprep.bo.obsproject.Rectangle;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SinglePoint;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.schedblock.FieldPattern;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.ModelChangeSubscriber;
import alma.obsprep.ot.editors.sciencegoals.AbstractTargetEditor;
import alma.obsprep.ot.editors.sciencegoals.SfiControlParameterEditor;
import alma.obsprep.ot.editors.sciencegoals.TargetParametersEditor;
import alma.obsprep.ot.editors.spatialvisual.SpatialPartModel;
import alma.obsprep.ot.editors.spatialvisual.SpatialVisualParameters;
import alma.obsprep.ot.models.schedblock.FieldPatternChangeListener;
import alma.obsprep.ot.models.sciencegoals.AbstractTargetModel;
import alma.obsprep.ot.models.sciencegoals.AngularResolutionMode;
import alma.obsprep.ot.models.sciencegoals.FieldModel;
import alma.obsprep.ot.models.valuetypes.SkyCoordsModel;
import alma.valuetypes.SkyCoordinates;
import java.util.ArrayList;
import java.util.List;

public class TargetParametersModel
extends AbstractTargetModel
implements SpatialPartModel,
ModelChangeSubscriber {
    private final FieldModel fieldModel;
    private final List<FieldPatternChangeListener> listeners = new ArrayList<FieldPatternChangeListener>();

    public TargetParametersModel(TargetParameters targetParameters) {
        super((AbstractTargetParameters)((Object)targetParameters));
        this.fieldModel = new FieldModel(null);
        this.registerSubModel(this.fieldModel);
        this.setDocument(targetParameters);
        this.getSourceCoordinatesModel().subscribe((Model model, FieldID fieldID, Object object) -> {
            if (fieldID.equals(SkyCoordsModel.FID_SYS)) {
                this.sourceCoordinatesSystemUpdated((String)object);
            }
        });
    }

    public TargetParameters getTargetParameters() {
        TargetParameters targetParameters;
        if (this.document == null) {
            return null;
        }
        try {
            targetParameters = (TargetParameters)((SpatialDocument)this.document).getSpatialPartOfSpatialDocument();
        }
        catch (ClassCastException classCastException) {
            Log.logger((Object)this).warning("Unexpected document : " + this.document.getClass().getSimpleName());
            return null;
        }
        return targetParameters;
    }

    public int getTargetParametersIndex() {
        TargetParameters targetParameters = this.getTargetParameters();
        if (targetParameters == null) {
            return -1;
        }
        return targetParameters.getIndex();
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        if (fieldID.equals(TargetParametersEditor.FID_TARGETTYPE)) {
            String string = FieldTypeInfo.getValueFromLabel((String)object);
            this.changeFieldType(string);
            return object;
        }
        if (fieldID.equals(TargetParametersEditor.FID_NONSIDEREALMOTION)) {
            this.fieldModel.pointingPatternModel.update(editor, fieldID, object);
            this.fieldModel.rectangleModel.update(editor, fieldID, object);
        }
        return super.update(editor, fieldID, object);
    }

    public void changeFieldType(String string) {
        TargetParameters targetParameters = this.getTargetParameters();
        if (targetParameters == null) {
            return;
        }
        if (string.equals(TargetParameters.TYPE_F_MULTIPLEPOINTS)) {
            for (Rectangle rectangle : targetParameters.getFieldRectangle()) {
                targetParameters.removeField((Field)((Object)rectangle));
            }
            if (targetParameters.getFieldSinglePointCount() == 0) {
                SinglePoint object = SinglePoint.createSinglePoint();
                object.getCentre().setType(SkyCoordinates.TYPE_RELATIVE);
                targetParameters.addField((Field)((Object)object));
                targetParameters.setType(TargetParameters.TYPE_F_MULTIPLEPOINTS);
            }
            this.fieldPatternChange(FieldPattern.FieldPatternType.POINT);
        } else if (string.equals(TargetParameters.TYPE_F_SINGLERECTANGLE)) {
            for (SinglePoint singlePoint : targetParameters.getFieldSinglePoint()) {
                targetParameters.removeField((Field)((Object)singlePoint));
            }
            if (targetParameters.getFieldRectangleCount() == 0) {
                Rectangle rectangle = Rectangle.createRectangle();
                rectangle.getCentre().setType(SkyCoordinates.TYPE_RELATIVE);
                targetParameters.addField((Field)((Object)rectangle));
                targetParameters.setType(TargetParameters.TYPE_F_SINGLERECTANGLE);
                targetParameters.setIsMosaic(true);
            }
            this.fieldPatternChange(FieldPattern.FieldPatternType.RECTANGLE);
        }
        this.setDocument(targetParameters);
    }

    private void sourceCoordinatesSystemUpdated(String string) {
        this.getFieldModel().originCoordinatesSystemUpdated(string);
    }

    @Override
    public void publish() {
        TargetParameters targetParameters;
        super.publish();
        if (this.fieldModel != null) {
            this.fieldModel.publish();
        }
        if ((targetParameters = this.getTargetParameters()) != null) {
            String string = FieldTypeInfo.getLabelFromValue(targetParameters.getType());
            this.publish(TargetParametersEditor.FID_TARGETTYPE, string);
        }
    }

    @Override
    public void setDocument(Object object) {
        this.document = object;
        this.setDocumentToSubModels(object);
        TargetParameters targetParameters = (TargetParameters)this.document;
        if (targetParameters != null) {
            SpatialVisualParameters spatialVisualParameters = targetParameters.getSpatialVisualParameters();
            ScienceGoal scienceGoal = targetParameters.getScienceGoal();
            spatialVisualParameters.setContextDocument(scienceGoal);
        }
        this.publish();
    }

    @Override
    protected void setDocumentToSubModels(Object object) {
        TargetParameters targetParameters = this.getTargetParameters();
        super.setDocumentToSubModels(targetParameters);
        if (targetParameters != null) {
            this.fieldModel.setonlyDocument(targetParameters);
        }
    }

    @Override
    public SpatialPartOfSpatialDocument getSpatialPart() {
        return this.getTargetParameters();
    }

    private void fieldPatternChange(FieldPattern.FieldPatternType fieldPatternType) {
        for (FieldPatternChangeListener fieldPatternChangeListener : this.listeners) {
            fieldPatternChangeListener.fieldPatternChanged(fieldPatternType);
        }
    }

    public void addFieldPatternChangeListener(FieldPatternChangeListener fieldPatternChangeListener) {
        this.listeners.add(fieldPatternChangeListener);
    }

    public boolean removeFieldPatternChangeListener(FieldPatternChangeListener fieldPatternChangeListener) {
        return this.listeners.remove(fieldPatternChangeListener);
    }

    @Override
    public void modelChanged(Model model, FieldID fieldID, Object object) {
        if (fieldID.equals(SfiControlParameterEditor.FID_ANGULARRESOLUTIONMODE) && object != null) {
            String string = (String)object;
            boolean bl = !string.equals(AngularResolutionMode.SACA.getBOMapping());
            this.publish(AbstractTargetEditor.FID_SUN_IS_SELECTABLE, bl);
        }
    }

    public FieldModel getFieldModel() {
        return this.fieldModel;
    }
}

