/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.sciencegoals;

import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.enumerations.CorrPolarization;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproject.TechnicalJustification;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.editors.sciencegoals.NonStandardChoicesEditor;
import alma.obsprep.services.experts.ACANecessityEstimator;
import alma.valuetypes.Angle;
import alma.valuetypes.DataRate;
import alma.valuetypes.Frequency;
import alma.valuetypes.UserAngle;
import alma.valuetypes.UserFrequency;
import alma.valuetypes.UserSensitivity;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class NonStandardChoiceModel
extends Model {
    protected Frequency continuumBandwidth;
    protected UserAngle desiredResolution;
    protected Angle desiredLargestStructure;
    protected UserSensitivity desiredSensitivity;
    protected Frequency sensitivityFrequencyWidth;
    protected UserFrequency frequencyResolution;

    public NonStandardChoiceModel(ScienceGoal scienceGoal) {
        super(scienceGoal);
    }

    @Override
    public void setDocument(Object object) {
        super.setDocument(object);
    }

    public ScienceGoal getScienceGoal() {
        if (null == this.document) {
            return null;
        }
        return (ScienceGoal)this.document;
    }

    public TechnicalJustification getTechnicalJustification() {
        if (null == this.document) {
            return null;
        }
        TechnicalJustification[] technicalJustificationArray = this.getScienceGoal().getTechnicalJustification();
        if (technicalJustificationArray instanceof TechnicalJustification[]) {
            TechnicalJustification[] technicalJustificationArray2 = technicalJustificationArray;
            if (technicalJustificationArray2.length > 0) {
                return technicalJustificationArray2[0];
            }
            TechnicalJustification technicalJustification = TechnicalJustification.createTechnicalJustification();
            try {
                Method method = ScienceGoal.class.getMethod("addTechnicalJustification", TechnicalJustification.class);
                method.invoke((Object)this.getScienceGoal(), new Object[]{technicalJustification});
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            return technicalJustification;
        }
        if (technicalJustificationArray instanceof TechnicalJustification) {
            return (TechnicalJustification)technicalJustificationArray;
        }
        return null;
    }

    public void recalculateFlagging(ScienceGoal scienceGoal) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        if (null != scienceGoal) {
            Object object;
            PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
            SpectralSetupParameters spectralSetupParameters = scienceGoal.getSpectralSetupParameters();
            TargetParameters[] targetParametersArray = scienceGoal.getTargetParameters();
            for (int i = 0; i < targetParametersArray.length; ++i) {
                object = targetParametersArray[i];
                bl = ((TargetParameters)object).isMaxElevationTooLow();
                if (!((TargetParameters)object).isRectanglePattern()) continue;
                double d = this.getNyquistSpacing();
                double d2 = ((TargetParameters)object).getSingleRectangle().getSpacing().getContentInUnits(UserAngle.USERUNIT_FRACTION_OF_MAIN_BEAM);
                double d3 = Math.abs(d2 - d);
                if (!(d3 > 5.0E-6)) continue;
                bl2 = true;
            }
            bl3 = spectralSetupParameters.getPolarisation().equals(CorrPolarization.SINGLE_X.toString()) || spectralSetupParameters.getPolarisation().equals(CorrPolarization.SINGLE_Y.toString());
            bl4 = scienceGoal.getCalibrationSetupParameters().isUserDefinedCalibration();
            Frequency frequency = performanceParameters.getRepresentativeFrequencyWithSkyOffset();
            object = null;
            if (object == null) {
                object = new ACANecessityEstimator();
            }
            ((ACANecessityEstimator)object).setParameters(performanceParameters.getDesiredLargestScale(), (Angle)((Object)performanceParameters.getDesiredAngularResolution()), frequency);
            if (((ACANecessityEstimator)object).acaNecessity(performanceParameters.getScienceGoal()) != performanceParameters.getUseACA()) {
                // empty if block
            }
            boolean bl6 = performanceParameters.getIsTimeConstrained();
            boolean bl7 = spectralSetupParameters.isNonStandardContinuumFrequency();
            AlmaPolicies almaPolicies = AlmaPolicies.getInstance();
            boolean bl8 = scienceGoal.getAverageDataRate(scienceGoal.isStandAloneACA() ? Array.ARRAY_7M : Array.ARRAY_12M).getContentInUnits(DataRate.UNIT_MB_S) > almaPolicies.getWarning12mDataRateMBPS();
            bl5 = performanceParameters.getNeedsMoreTime();
            this.publish(NonStandardChoicesEditor.FID_TARGET_MAX_EL_LOW, bl);
            this.publish(NonStandardChoicesEditor.FID_NYQUIST_SEP, bl2);
            this.publish(NonStandardChoicesEditor.FID_SINGLE_POL, bl3);
            this.publish(NonStandardChoicesEditor.FID_ANY_USER_CAL, bl4);
            this.publish(NonStandardChoicesEditor.FID_EXTRA_TIME, bl5);
            this.publish(NonStandardChoicesEditor.FID_NON_STD_CONT, bl7);
            this.publish(NonStandardChoicesEditor.FID_TIME_CONSTRAINED, bl6);
            this.publish(NonStandardChoicesEditor.FID_HIGH_DATARATE, bl8);
        }
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        return object;
    }

    @Override
    public void publish() {
        ScienceGoal scienceGoal = this.getScienceGoal();
        if (null != scienceGoal) {
            this.recalculateFlagging(scienceGoal);
        }
    }

    protected UserFrequency getFrequencyResolution(ScienceGoal scienceGoal) {
        UserFrequency userFrequency = scienceGoal.getSpectralSetupParameters().getCriticalResolutionPerPolnSmoothed();
        if (userFrequency == null) {
            return null;
        }
        userFrequency.getObservingFrequency().setContentAndUnit((ValueUnitPair)scienceGoal.getRepresentativeFrequency());
        return userFrequency;
    }

    private double getNyquistSpacing() {
        return 1.0 / Math.sqrt(3.0) / 1.13;
    }
}

